/* $Id: Main.java,v 1.2 1998/12/22 21:27:53 raif Exp $
 *
 * Copyright (c) 1997, 1998 Systemics Ltd on behalf of
 * the Cryptix Development Team.  All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General License along with this library; if
 * not, you can download a copy from <http://www.cryptix.org/>.
 */

/**
 * An interface that defines the basic encode and decode operations of
 * any ASN.1 coder.
 *
 * <b>Copyright</b> &copy; 1997, 1998
 * <a href="http://www.systemics.com/">Systemics Ltd</a> on behalf of the
 * <a href="http://www.systemics.com/docs/cryptix/">Cryptix Development Team</a>.
 * <br>All rights reserved.<p>
 *
 * <b>$Revision: 1.1 $</b>
 * @author  Raif S. Naffah
 */

package cryptix.asn1.encoding;

import cryptix.asn1.lang.*;

import java.io.InputStream;
import java.io.IOException;
import java.io.OutputStream;


public interface CoderOperations
extends ParserVisitor // generated by jjtree
{
// Constants and vars
//...........................................................................

    public static final int UNINITIALIZED = 0;
    public static final int DECODING = 1;
    public static final int ENCODING = 2;


// Encode primitives
//.............................................................................

    void init(OutputStream os);
    void encode(ASNBoolean obj, OutputStream out) throws IOException;
    void encode(ASNInteger obj, OutputStream out) throws IOException;
    void encode(ASNBitString obj, OutputStream out) throws IOException;
    void encode(ASNOctetString obj, OutputStream out) throws IOException;
    void encode(ASNNull obj, OutputStream out) throws IOException;
    void encode(ASNObjectIdentifier obj, OutputStream out) throws IOException;
    void encode(ASNSequence obj, OutputStream out) throws IOException;
    void encode(ASNSequenceOf obj, OutputStream out) throws IOException;
    void encode(ASNSet obj, OutputStream out) throws IOException;
    void encode(ASNSetOf obj, OutputStream out) throws IOException;
    void encode(ASNTaggedType obj, OutputStream out) throws IOException;
    void encode(ASNAny obj, OutputStream out) throws IOException;
    void encode(ASNPrintableString obj, OutputStream out) throws IOException;
    void encode(ASNTime obj, OutputStream out) throws IOException;


// Decode primitives
//.............................................................................

    void init(InputStream is);
    void decode(ASNBoolean obj, InputStream in) throws IOException;
    void decode(ASNInteger obj, InputStream in) throws IOException;
    void decode(ASNBitString obj, InputStream in) throws IOException;
    void decode(ASNOctetString obj, InputStream in) throws IOException;
    void decode(ASNNull obj, InputStream in) throws IOException;
    void decode(ASNObjectIdentifier obj, InputStream in) throws IOException;
    void decode(ASNSequence obj, InputStream in) throws IOException;
    void decode(ASNSequenceOf obj, InputStream in) throws IOException;
    void decode(ASNSet obj, InputStream in) throws IOException;
    void decode(ASNSetOf obj, InputStream in) throws IOException;
    void decode(ASNTaggedType obj, InputStream in) throws IOException;
    void decode(ASNAny obj, InputStream in) throws IOException;
    void decode(ASNPrintableString obj, InputStream in) throws IOException;
    void decode(ASNTime obj, InputStream in) throws IOException;
}