/* $Id: $
 *
 * Copyright (c) 1997, 1998, 1999 Systemics Ltd on behalf of
 * the Cryptix Development Team.  All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General License along with this library; if
 * not, you can download a copy from <http://www.cryptix.org/>.
 */

 /**
 * An interface that acts as the visible superclass of all
 * components in parsed input files written in ASN.1.<p>
 *
 * This interface extends <code>cryptix.asn1.lang.node</code>
 * which is generated by the <code>JavaCC</code> tool.
 *
 * @see  cryptix.asn1.lang.Node
 *
 * <b>Copyright</b> &copy;1997, 1998, 1999
 * <a href="http://www.systemics.com/">Systemics Ltd</a> on behalf of the
 * <a href="http://www.systemics.com/docs/cryptix/">Cryptix Development Team</a>.
 * <br>All rights reserved.<p>
 *
 * <b>$Revision: 1.1 $</b>
 * @author  Raif S. Naffah
 */

package cryptix.asn1.lang;

import java.io.IOException;

public interface ASNObject
extends Node
{
    public ASNObject getParent();
    public ASNObject[] getChildren();
    public int getID();

    /** @return The name associated with this ASN.1 object. */
    public String getName();

    /**
     * Returns a child component of an ASN.1 construct given its
     * full name. The name can be a sequence of strings separated
     * by the character '.' to denote their hierarchy within the
     * ASN.1 object; eg: for an X.509 encoded Certificate, one can
     * get to the OID (the "algorithm") of the AlgorithmIdentifier
     * (the "signature") included in the CertificateInfo part
     * (the "certificateInfo") by passing the following as an
     * argument to an X.509 <code>ASNObject</code> instance:
     * <pre>
     *    "certificateInfo.signature.algorithm"
     * </pre>
     *
     * @return A child component of this ASN.1 object given its
     *        dotted name.
     */
    public ASNObject getComponent(String aName);

    /**
     * Sets the tag of this ASN.1 object to be the designated
     * <Tag> instance.
     *
     * param tag A reference to an instance of <code>Tag</code>.
     * @see  cryptix.asn1.lang.Tag
     */
    public void setTag(Tag tag);

    /**
     * Returns a reference to an instance of this ASN.1 object's
     * <code>Tag</code>.
     *
     * @return A reference to an instance of this ASN.1 object's
     *        <code>Tag</code>.
     * @see  cryptix.asn1.lang.Tag
     */
    public Tag getTag();

    /**
     * Returns true if this ASN.1 object is optional, false
     * otherwise.
     *
     * @return True if this ASN.1 object is optional, false
     *        otherwise.
     */
    public boolean isOptional();

    /**
     * Sets the optional flag for this ASN.1 object to the
     * designated value.
     *
     * param flag The new value of the optional flag.
     */
    public void setOptional(boolean flag);

    /**
     * Sets the value of this component to a native Java instance.<p>
     *
     * The mapping between ASN.1 types and Java types is given below:
     * <ol>
     *    <li>BOOLEAN: java.lang.Boolean;
     *    <li>INTEGER: java.math.BigInteger;
     *    <li>BIT STRING: byte[];
     *    <li>OCTET STRING: byte[];
     *    <li>NULL: null;
     *    <li>OID: A java.lang.String containing numeric digits and
     *            the character '.';
     *    <li>SEQUENCE, SEQUENCE OF, SET and SET OF: cryptix.asn1.lang.ASNObject[];
     *    <li>PrintableString: java.lang.String.
     * </ol>
     */
    public void setValue(Object value);

    /**
     * Returns the Java Object containing the current value of this
     * ASN.1 object. For the mapping between ASN.1 values and Java
     * types, see the <code>setValue()</code> method.
     *
     * @return The value of this component as a native Java object.
     * @see  cryptix.asn1.lang.ASNObject#setValue
     */
    public Object getValue();

    /**
     * Similar to setValue() but operates on the default value
     * of this ASN.1 object if such a value is/was defined in
     * the specifications.
     *
     * @param defaultValue The Java object instance representing
     *        the default value of this ASN.1 object.
     */
    public void setDefaultValue(Object defaultValue);

    /**
     * Similar to getValue() but operates on the default value
     * of this ASN.1 object if such a value is/was defined in
     * the specifications. If no such default value was defnied
     * in the specifications then this method returns a null.
     */
    public Object getDefaultValue();

    /** Dumps this object's specification to System.out. */
    public void dump();

    /**
     * Dumps this object's specification to System.out prefixing
     * each line with the given string.
     *
     * @param prefix A string that will prefix each new line
     *        of the output.
     */
    public void dump(String prefix);

    /**
     * Accepts a visitor.
     *
     * @param visitor An instance that implements the ParserVisitor
     *        interface.
     * @exception IOException If an exception occurs during
     *        the application of the Visitor method.
     * @see  cryptix.asn1.lang.ParserVisitor
     */
    public Object accept(ParserVisitor visitor, Object data)
    throws IOException;
}