/* Generated By:JJTree&JavaCC: Do not edit this line. Parser.java */
package cryptix.asn1.lang;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;


public class Parser/*@bgen(jjtree)*/implements ParserTreeConstants, ParserConstants {/*@bgen(jjtree)*/
  protected JJTParserState jjtree = new JJTParserState();// Debugging methods and fields
//...........................................................................

    private static final String NAME = "Parser";

    private static final boolean IN = true, OUT = false;
    private static final boolean DEBUG =
        PackageProperties.GLOBAL_DEBUG;
    private static final int debuglevel =
        DEBUG ? PackageProperties.getLevel(NAME) : 0;
    private static final PrintWriter err =
        DEBUG ? PackageProperties.getOutput() : null;
    private static final boolean TRACE =
        PackageProperties.isTraceable(NAME);

    private static void debug(String s) {
        err.println(">>> "+NAME+": "+s);
    }

    private static void trace(boolean in, String s) {
        if (TRACE) err.println((in?"==> ":"<== ")+NAME+"."+s);
    }

    private static void trace(String s) {
        if (TRACE) err.println("<=> "+NAME+"."+s);
    }


// Constants and variables
//...........................................................................

    static Hashtable sTable; // Current symbol table
    static final boolean DEFAULT_TAG_TYPE = false;
    boolean isTagExplicit = DEFAULT_TAG_TYPE;

    /** Stack for runtime interpretation of OID values. */
    static Object[] stack = new Object[64];
    static int top = -1;

    /** Dump symbol table. */
    public static void dumpSymbolTable() {
        Enumeration symbols = sTable.keys();
        int i = 1;
        Object obj;
        while (symbols.hasMoreElements()) {
            String id = (String) symbols.nextElement();
            obj = sTable.get(id);
            System.out.println("\t"+(i++)+". "+id+" = "+obj);
        }

        System.out.println();
    }

    private void define(String name, Object type) {
        Object obj = sTable.get(name);
        if (obj == null)
            obj = type;
        else {
            if (DEBUG)
                debug("Re-definition of: "+name+", was: "+obj);
            if (obj instanceof String) {
                if (type instanceof SimpleNode) {
                    SimpleNode n = (SimpleNode) type;
                    if (n.getName() == null)
                        n.name = (String) obj;
                    else
                        throw new RuntimeException("unable to re-assign names...");
                } else
                    throw new RuntimeException("Unhandled 1");
                obj = type;
            } else if (obj instanceof ASNAny || obj instanceof ASNType) {
                if (type instanceof SimpleNode) {
                    SimpleNode n = (SimpleNode) type;
                    ((SimpleNode) obj).setOptional(n.optional);
                    ((SimpleNode) obj).setDefaultValue(n.defaultValue);
                } else
                    throw new RuntimeException("Unhandled 2");
            } else {
                if ((obj instanceof ASNObject) && (type instanceof ASNType)) {
                    // defining a default value
                    ((ASNObject) obj).setDefaultValue(((ASNObject) type).getDefaultValue());
                } else
                    throw new RuntimeException("Unhandled 3: "+obj+", type: "+type);
            }
        }

        if (DEBUG)
            debug("Definition of: "+name+", becomes: "+obj);
        sTable.put(name, obj);
    }

    /** @return An ASN.1 parsed object given its name. */
    public static Object resolve(String aName) {
        if (DEBUG) trace(IN, "resolve");
        if (DEBUG && debuglevel > 8) debug(" IN: name=\""+aName+"\"");

        Object result = sTable.get(aName);
//        if (result instanceof String)
        while (result instanceof String)
            result = sTable.get((String) result);

        if (DEBUG && debuglevel > 8) debug("OUT: "+result);
        if (DEBUG) trace(OUT, "resolve");
        return result;
    }

    /** @return True iff all Types are defined. */
    public static int countUnresolvedReferences() {
        int it = 0;
        Object result;
        Enumeration symbols = sTable.keys();
        while (symbols.hasMoreElements()) {
            result = sTable.get((String) symbols.nextElement());
            if (result instanceof SimpleNode) {
                ASNObject[] theChildren = ((SimpleNode) result).children;
                if (theChildren != null)
                    for (int i = 0; i < theChildren.length; ++i) {
                        result = theChildren[i];
                        if (result instanceof ASNTypeAlias) {
                            String aName = ((ASNObject) result).getName();
                            if (resolve(aName) == null) {
                                if (DEBUG && debuglevel > 8)
                                    debug("Unresolved reference for: "+
                                            aName+" in "+result+"...");
                                it++;
                            }
                        }
                    }
            }
        }

        return it;
    }

// FILE / MODULE SPECIFICATION
//===========================================================================
  final public ASNSpecification Specification(boolean tracing) throws ParseException {
    trace_call("Specification");
    try {
                                                                 /*@bgen(jjtree) Specification */
    ASNSpecification jjtn000 = new ASNSpecification(JJTSPECIFICATION);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);sTable = new Hashtable();
      try {
            if (tracing)
                enable_tracing();
            else
                disable_tracing();
        label_1:
        while (true) {
          Assignment();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case UPPER:
          case LOWER:
            ;
            break;
          default:
            jj_la1[0] = jj_gen;
            break label_1;
          }
        }
        jj_consume_token(0);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            {if (true) return jjtn000;}
      } catch (Throwable jjte000) {
          if (jjtc000) {
            jjtree.clearNodeScope(jjtn000);
            jjtc000 = false;
          } else {
            jjtree.popNode();
          }
          if (jjte000 instanceof ParseException) {
            {if (true) throw (ParseException)jjte000;}
          }
          if (jjte000 instanceof RuntimeException) {
            {if (true) throw (RuntimeException)jjte000;}
          }
          {if (true) throw (Error)jjte000;}
      } finally {
          if (jjtc000) {
            jjtree.closeNodeScope(jjtn000, true);
          }
      }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("Specification");
    }
  }

// --------------------------------------------------------------------------
  final public void Assignment() throws ParseException {
    trace_call("Assignment");
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UPPER:
        TypeAssignment();
        break;
      case LOWER:
        OIDAssignment();
        break;
      default:
        jj_la1[1] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
      trace_return("Assignment");
    }
  }

  final public void TypeAssignment() throws ParseException {
    trace_call("TypeAssignment");
    try {
    String id;
      id = TypeReference();
            Object obj = sTable.get(id);
            if (obj != null)
                if (DEBUG) debug("Re-definition of: "+id+", was: "+obj);
      jj_consume_token(50);
      Type(id, true);
    } finally {
      trace_return("TypeAssignment");
    }
  }

  final public void OIDAssignment() throws ParseException {
    trace_call("OIDAssignment");
    try {
    String id, oid;
      id = ValueReference();
      jj_consume_token(OBJECT);
      jj_consume_token(IDENTIFIER);
      jj_consume_token(50);
      oid = ObjectIdentifier();
            sTable.put(id, oid);
    } finally {
      trace_return("OIDAssignment");
    }
  }

// TYPES
//===========================================================================
  final public ASNType Type(String name, boolean topLevel) throws ParseException {
    trace_call("Type");
    try {
                                                    /*@bgen(jjtree) Type */
    ASNType jjtn000 = new ASNType(JJTTYPE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);String id;
      try {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case UPPER:
      ASNTypeAlias jjtn001 = new ASNTypeAlias(JJTTYPEALIAS);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
          try {
            id = TypeReference();
          jjtree.closeNodeScope(jjtn001, true);
          jjtc001 = false;
            if (DEBUG) trace(IN, "Type()");
            if (DEBUG && debuglevel > 7) {
                debug(" IN: name=\""+name+"\"");
                debug(" IN: toplevel=\""+topLevel+"\"");
            }
            jjtn001.name = name;
            if (topLevel)
                define(name, id);

            if (DEBUG) trace(OUT, "Type()");
          } catch (Throwable jjte001) {
      if (jjtc001) {
        jjtree.clearNodeScope(jjtn001);
        jjtc001 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte001 instanceof ParseException) {
        {if (true) throw (ParseException)jjte001;}
      }
      if (jjte001 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte001;}
      }
      {if (true) throw (Error)jjte001;}
          } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001, true);
      }
          }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            {if (true) return jjtn000;}
          break;
        case ANY:
        case BIT:
        case SET:
        case NULL:
        case OCTET:
        case OBJECT:
        case BOOLEAN:
        case INTEGER:
        case UTC_TIME:
        case SEQUENCE:
        case T61_STRING:
        case IA5_STRING:
        case ISO646_STRING:
        case NUMERIC_STRING:
        case TELETEX_STRING:
        case VISIBLE_STRING:
        case GRAPHIC_STRING:
        case GENERAL_STRING:
        case VIDEOTEX_STRING:
        case GENERALIZED_TIME:
        case PRINTABLE_STRING:
        case 57:
          BuiltInType(name, topLevel);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            {if (true) return jjtn000;}
          break;
        default:
          jj_la1[2] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
      } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
      }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("Type");
    }
  }

// --------------------------------------------------------------------------
  final public void BuiltInType(String name, boolean topLevel) throws ParseException {
    trace_call("BuiltInType");
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BOOLEAN:
        BooleanType(name, topLevel);
        break;
      case INTEGER:
        IntegerType(name, topLevel);
        break;
      case BIT:
        BitStringType(name, topLevel);
        break;
      case OCTET:
        OctetStringType(name, topLevel);
        break;
      case NULL:
        NullType(name, topLevel);
        break;
      case OBJECT:
        ObjectIdentifierType(name, topLevel);
        break;
      default:
        jj_la1[3] = jj_gen;
        if (jj_2_1(2)) {
          SequenceType(name, topLevel);
        } else if (jj_2_2(2)) {
          SequenceOfType(name, topLevel);
        } else if (jj_2_3(2)) {
          SetType(name, topLevel);
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SET:
            SetOfType(name, topLevel);
            break;
          case 57:
            TaggedType(name, topLevel);
            break;
          case ANY:
            AnyType(name, topLevel);
            break;
          case T61_STRING:
          case IA5_STRING:
          case ISO646_STRING:
          case NUMERIC_STRING:
          case TELETEX_STRING:
          case VISIBLE_STRING:
          case GRAPHIC_STRING:
          case GENERAL_STRING:
          case VIDEOTEX_STRING:
          case PRINTABLE_STRING:
            CharacterStringType(name, topLevel);
            break;
          case UTC_TIME:
          case GENERALIZED_TIME:
            UsefulType(name, topLevel);
            break;
          default:
            jj_la1[4] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    } finally {
      trace_return("BuiltInType");
    }
  }

// --------------------------------------------------------------------------
  final public ASNBoolean BooleanType(String name, boolean topLevel) throws ParseException {
    trace_call("BooleanType");
    try {
                                                                 /*@bgen(jjtree) Boolean */
  ASNBoolean jjtn000 = new ASNBoolean(JJTBOOLEAN);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
      try {
        jj_consume_token(BOOLEAN);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.name = name;
            jjtn000.tag = new Tag(Tag.BOOLEAN, isTagExplicit );
            if (topLevel)
                define(name, jjtn000);
            {if (true) return jjtn000;}
      } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
      }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("BooleanType");
    }
  }

// --------------------------------------------------------------------------
  final public ASNInteger IntegerType(String name, boolean topLevel) throws ParseException {
    trace_call("IntegerType");
    try {
                                                                 /*@bgen(jjtree) Integer */
  ASNInteger jjtn000 = new ASNInteger(JJTINTEGER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
      try {
        jj_consume_token(INTEGER);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 51:
          jj_consume_token(51);
          NamedNumberList();
          jj_consume_token(52);
          break;
        default:
          jj_la1[5] = jj_gen;
          ;
        }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.name = name;
            jjtn000.tag = new Tag(Tag.INTEGER, isTagExplicit );
            if (topLevel)
                define(name, jjtn000);
            {if (true) return jjtn000;}
      } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
      } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
      }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("IntegerType");
    }
  }

  final public void NamedNumberList() throws ParseException {
    trace_call("NamedNumberList");
    try {
      NamedNumber();
      label_2:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 53:
          ;
          break;
        default:
          jj_la1[6] = jj_gen;
          break label_2;
        }
        jj_consume_token(53);
        NamedNumber();
      }
    } finally {
      trace_return("NamedNumberList");
    }
  }

  final public void NamedNumber() throws ParseException {
    trace_call("NamedNumber");
    try {
    String id;
    BigInteger val;
      id = Identifier();
      jj_consume_token(54);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NUMBER:
      case 56:
        val = SignedNumber();
        break;
      case LOWER:
        DefinedValue();
            val = (BigInteger) stack[top--];
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
            sTable.put(id, val);
      jj_consume_token(55);
    } finally {
      trace_return("NamedNumber");
    }
  }

  final public BigInteger SignedNumber() throws ParseException {
    trace_call("SignedNumber");
    try {
    Token t;
    String image = "";
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case 56:
        jj_consume_token(56);
            image = "-";
        break;
      default:
        jj_la1[8] = jj_gen;
        ;
      }
      t = jj_consume_token(NUMBER);
            image += t.image;
            {if (true) return new BigInteger(image);}
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("SignedNumber");
    }
  }

// --------------------------------------------------------------------------
  final public ASNBitString BitStringType(String name, boolean topLevel) throws ParseException {
    trace_call("BitStringType");
    try {
                                                                       /*@bgen(jjtree) BitString */
  ASNBitString jjtn000 = new ASNBitString(JJTBITSTRING);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
      try {
        jj_consume_token(BIT);
        jj_consume_token(STRING);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.name = name;
            jjtn000.tag = new Tag(Tag.BIT_STRING, isTagExplicit );
            if (topLevel)
                define(name, jjtn000);
            {if (true) return jjtn000;}
      } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
      }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("BitStringType");
    }
  }

// --------------------------------------------------------------------------
  final public ASNOctetString OctetStringType(String name, boolean topLevel) throws ParseException {
    trace_call("OctetStringType");
    try {
                                                                             /*@bgen(jjtree) OctetString */
  ASNOctetString jjtn000 = new ASNOctetString(JJTOCTETSTRING);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
      try {
        jj_consume_token(OCTET);
        jj_consume_token(STRING);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.name = name;
            jjtn000.tag = new Tag(Tag.OCTET_STRING, isTagExplicit );
            if (topLevel)
                define(name, jjtn000);
            {if (true) return jjtn000;}
      } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
      }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("OctetStringType");
    }
  }

// --------------------------------------------------------------------------
  final public ASNNull NullType(String name, boolean topLevel) throws ParseException {
    trace_call("NullType");
    try {
                                                        /*@bgen(jjtree) Null */
  ASNNull jjtn000 = new ASNNull(JJTNULL);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
      try {
        jj_consume_token(NULL);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.name = name;
            jjtn000.tag = new Tag(Tag.NULL, isTagExplicit );
            if (topLevel)
                define(name, jjtn000);
            {if (true) return jjtn000;}
      } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
      }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("NullType");
    }
  }

// --------------------------------------------------------------------------
  final public ASNObjectIdentifier ObjectIdentifierType(String name, boolean topLevel) throws ParseException {
    trace_call("ObjectIdentifierType");
    try {
                                                                                            /*@bgen(jjtree) ObjectIdentifier */
  ASNObjectIdentifier jjtn000 = new ASNObjectIdentifier(JJTOBJECTIDENTIFIER);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
      try {
        jj_consume_token(OBJECT);
        jj_consume_token(IDENTIFIER);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.name = name;
            jjtn000.tag = new Tag(Tag.OBJECT_IDENTIFIER, isTagExplicit );
            if (topLevel)
                define(name, jjtn000);
            {if (true) return jjtn000;}
      } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
      }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("ObjectIdentifierType");
    }
  }

// --------------------------------------------------------------------------
  final public ASNSequence SequenceType(String name, boolean topLevel) throws ParseException {
    trace_call("SequenceType");
    try {
                                                                    /*@bgen(jjtree) Sequence */
  ASNSequence jjtn000 = new ASNSequence(JJTSEQUENCE);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
      try {
        jj_consume_token(SEQUENCE);
        jj_consume_token(51);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ANY:
        case BIT:
        case SET:
        case NULL:
        case OCTET:
        case OBJECT:
        case BOOLEAN:
        case INTEGER:
        case UTC_TIME:
        case SEQUENCE:
        case T61_STRING:
        case IA5_STRING:
        case ISO646_STRING:
        case NUMERIC_STRING:
        case TELETEX_STRING:
        case VISIBLE_STRING:
        case GRAPHIC_STRING:
        case GENERAL_STRING:
        case VIDEOTEX_STRING:
        case GENERALIZED_TIME:
        case PRINTABLE_STRING:
        case UPPER:
        case LOWER:
        case 57:
          ElementTypeList(name);
          break;
        default:
          jj_la1[9] = jj_gen;
          ;
        }
        jj_consume_token(52);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.name = name;
            jjtn000.tag = new Tag(Tag.SEQUENCE, isTagExplicit );
            if (topLevel)
                define(name, jjtn000);
            {if (true) return jjtn000;}
      } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
      } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
      }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("SequenceType");
    }
  }

  final public void ElementTypeList(String structure) throws ParseException {
    trace_call("ElementTypeList");
    try {
      ElementType(structure);
      label_3:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 53:
          ;
          break;
        default:
          jj_la1[10] = jj_gen;
          break label_3;
        }
        jj_consume_token(53);
        ElementType(structure);
      }
    } finally {
      trace_return("ElementTypeList");
    }
  }

  final public void ElementType(String structure) throws ParseException {
    trace_call("ElementType");
    try {
    String id = "__LOCAL__";
    ASNObject type = null;
    Object defaultValue = null;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LOWER:
        id = Identifier();
        break;
      default:
        jj_la1[11] = jj_gen;
        ;
      }
      type = Type(structure+"."+id, true);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DEFAULT_TYPE:
      case OPTIONAL:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OPTIONAL:
          jj_consume_token(OPTIONAL);
                    type.setOptional(true);
          break;
        case DEFAULT_TYPE:
          jj_consume_token(DEFAULT_TYPE);
          defaultValue = Value();
                    type.setDefaultValue(defaultValue);
          break;
        default:
          jj_la1[12] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                define(structure+"."+id, type);
        break;
      default:
        jj_la1[13] = jj_gen;
        ;
      }
    } finally {
      trace_return("ElementType");
    }
  }

// --------------------------------------------------------------------------
  final public ASNSequenceOf SequenceOfType(String name, boolean topLevel) throws ParseException {
    trace_call("SequenceOfType");
    try {
                                                                          /*@bgen(jjtree) SequenceOf */
  ASNSequenceOf jjtn000 = new ASNSequenceOf(JJTSEQUENCEOF);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
      try {
        jj_consume_token(SEQUENCE);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OF:
          jj_consume_token(OF);
          Type(name+".element.<o>", topLevel);
          break;
        default:
          jj_la1[14] = jj_gen;
          ;
        }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.name = name;
            jjtn000.tag = new Tag(Tag.SEQUENCE_OF, isTagExplicit );
            if (topLevel)
                define(name, jjtn000);
            {if (true) return jjtn000;}
      } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
      } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
      }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("SequenceOfType");
    }
  }

// --------------------------------------------------------------------------
  final public ASNSet SetType(String name, boolean topLevel) throws ParseException {
    trace_call("SetType");
    try {
                                                     /*@bgen(jjtree) Set */
  ASNSet jjtn000 = new ASNSet(JJTSET);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
      try {
        jj_consume_token(SET);
        jj_consume_token(51);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ANY:
        case BIT:
        case SET:
        case NULL:
        case OCTET:
        case OBJECT:
        case BOOLEAN:
        case INTEGER:
        case UTC_TIME:
        case SEQUENCE:
        case T61_STRING:
        case IA5_STRING:
        case ISO646_STRING:
        case NUMERIC_STRING:
        case TELETEX_STRING:
        case VISIBLE_STRING:
        case GRAPHIC_STRING:
        case GENERAL_STRING:
        case VIDEOTEX_STRING:
        case GENERALIZED_TIME:
        case PRINTABLE_STRING:
        case UPPER:
        case LOWER:
        case 57:
          ElementTypeList(name);
          break;
        default:
          jj_la1[15] = jj_gen;
          ;
        }
        jj_consume_token(52);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.name = name;
            jjtn000.tag = new Tag(Tag.SET, isTagExplicit );
            if (topLevel)
                define(name, jjtn000);
            {if (true) return jjtn000;}
      } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
      } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
      }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("SetType");
    }
  }

// --------------------------------------------------------------------------
  final public ASNSetOf SetOfType(String name, boolean topLevel) throws ParseException {
    trace_call("SetOfType");
    try {
                                                           /*@bgen(jjtree) SetOf */
  ASNSetOf jjtn000 = new ASNSetOf(JJTSETOF);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
      try {
        jj_consume_token(SET);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case OF:
          jj_consume_token(OF);
          Type(name+".element.<u>", topLevel);
          break;
        default:
          jj_la1[16] = jj_gen;
          ;
        }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.name = name;
            jjtn000.tag = new Tag(Tag.SET_OF, isTagExplicit );
            if (topLevel)
                define(name, jjtn000);
            {if (true) return jjtn000;}
      } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
      } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
      }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("SetOfType");
    }
  }

// --------------------------------------------------------------------------
  final public ASNTaggedType TaggedType(String name, boolean topLevel) throws ParseException {
    trace_call("TaggedType");
    try {
                                                                      /*@bgen(jjtree) TaggedType */
    ASNTaggedType jjtn000 = new ASNTaggedType(JJTTAGGEDTYPE);
    boolean jjtc000 = true;
    jjtree.openNodeScope(jjtn000);int clazz = Tag.CONTEXT;
    int n;
    boolean explicit = DEFAULT_TAG_TYPE;
    ASNType type;
      try {
        jj_consume_token(57);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PRIVATE:
        case UNIVERSAL:
        case APPLICATION:
          clazz = Clazz();
          break;
        default:
          jj_la1[17] = jj_gen;
          ;
        }
        n = ClassNumber();
        jj_consume_token(58);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EXPLICIT:
        case IMPLICIT:
          explicit = Tagging();
          break;
        default:
          jj_la1[18] = jj_gen;
          ;
        }
        type = Type(name, topLevel);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.name = name;
            jjtn000.tag = new Tag(clazz, n, explicit);
            if (topLevel)
                define(name, type);
            {if (true) return jjtn000;}
      } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
      } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
      }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("TaggedType");
    }
  }

  final public int Clazz() throws ParseException {
    trace_call("Clazz");
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UNIVERSAL:
        jj_consume_token(UNIVERSAL);
            {if (true) return Tag.UNIVERSAL;}
        break;
      case APPLICATION:
        jj_consume_token(APPLICATION);
            {if (true) return Tag.APPLICATION;}
        break;
      case PRIVATE:
        jj_consume_token(PRIVATE);
            {if (true) return Tag.PRIVATE;}
        break;
      default:
        jj_la1[19] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("Clazz");
    }
  }

  final public int ClassNumber() throws ParseException {
    trace_call("ClassNumber");
    try {
    Token t;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NUMBER:
        t = jj_consume_token(NUMBER);
            {if (true) return Integer.parseInt(t.image);}
        break;
      case LOWER:
        DefinedValue();
            {if (true) return Integer.parseInt((String) stack[top--]);}
        break;
      default:
        jj_la1[20] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("ClassNumber");
    }
  }

  final public boolean Tagging() throws ParseException {
    trace_call("Tagging");
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXPLICIT:
        jj_consume_token(EXPLICIT);
            {if (true) return true;}
        break;
      case IMPLICIT:
        jj_consume_token(IMPLICIT);
            {if (true) return false;}
        break;
      default:
        jj_la1[21] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("Tagging");
    }
  }

// --------------------------------------------------------------------------
  final public ASNAny AnyType(String name, boolean topLevel) throws ParseException {
    trace_call("AnyType");
    try {
                                                     /*@bgen(jjtree) Any */
  ASNAny jjtn000 = new ASNAny(JJTANY);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
      try {
        jj_consume_token(ANY);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DEFINED:
          jj_consume_token(DEFINED);
          jj_consume_token(BY);
          Identifier();
          break;
        default:
          jj_la1[22] = jj_gen;
          ;
        }
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.name = name;
            jjtn000.tag = new Tag(Tag.NULL, isTagExplicit );
            if (topLevel)
                define(name, jjtn000);
            {if (true) return jjtn000;}
      } catch (Throwable jjte000) {
      if (jjtc000) {
        jjtree.clearNodeScope(jjtn000);
        jjtc000 = false;
      } else {
        jjtree.popNode();
      }
      if (jjte000 instanceof ParseException) {
        {if (true) throw (ParseException)jjte000;}
      }
      if (jjte000 instanceof RuntimeException) {
        {if (true) throw (RuntimeException)jjte000;}
      }
      {if (true) throw (Error)jjte000;}
      } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
      }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("AnyType");
    }
  }

// --------------------------------------------------------------------------
  final public void CharacterStringType(String name, boolean topLevel) throws ParseException {
    trace_call("CharacterStringType");
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NUMERIC_STRING:
        jj_consume_token(NUMERIC_STRING);
        break;
      case PRINTABLE_STRING:
      ASNPrintableString jjtn001 = new ASNPrintableString(JJTPRINTABLESTRING);
      boolean jjtc001 = true;
      jjtree.openNodeScope(jjtn001);
        try {
          jj_consume_token(PRINTABLE_STRING);
          jjtree.closeNodeScope(jjtn001, true);
          jjtc001 = false;
            jjtn001.name = name;
            jjtn001.tag = new Tag(Tag.PRINT_STRING, isTagExplicit );
            if (topLevel)
                define(name, jjtn001);
        } finally {
      if (jjtc001) {
        jjtree.closeNodeScope(jjtn001, true);
      }
        }
        break;
      case TELETEX_STRING:
        jj_consume_token(TELETEX_STRING);
        break;
      case T61_STRING:
        jj_consume_token(T61_STRING);
        break;
      case VIDEOTEX_STRING:
        jj_consume_token(VIDEOTEX_STRING);
        break;
      case VISIBLE_STRING:
        jj_consume_token(VISIBLE_STRING);
        break;
      case ISO646_STRING:
        jj_consume_token(ISO646_STRING);
        break;
      case IA5_STRING:
        jj_consume_token(IA5_STRING);
        break;
      case GRAPHIC_STRING:
        jj_consume_token(GRAPHIC_STRING);
        break;
      case GENERAL_STRING:
        jj_consume_token(GENERAL_STRING);
        break;
      default:
        jj_la1[23] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
      trace_return("CharacterStringType");
    }
  }

// --------------------------------------------------------------------------
  final public void UsefulType(String name, boolean topLevel) throws ParseException {
    trace_call("UsefulType");
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case UTC_TIME:
        UTCTime(name, topLevel);
        break;
      case GENERALIZED_TIME:
        jj_consume_token(GENERALIZED_TIME);
        break;
      default:
        jj_la1[24] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
      trace_return("UsefulType");
    }
  }

// --------------------------------------------------------------------------
  final public ASNTime UTCTime(String name, boolean topLevel) throws ParseException {
    trace_call("UTCTime");
    try {
                                                       /*@bgen(jjtree) Time */
  ASNTime jjtn000 = new ASNTime(JJTTIME);
  boolean jjtc000 = true;
  jjtree.openNodeScope(jjtn000);
      try {
        jj_consume_token(UTC_TIME);
          jjtree.closeNodeScope(jjtn000, true);
          jjtc000 = false;
            jjtn000.name = name;
            jjtn000.tag = new Tag(Tag.UTC_TIME, isTagExplicit );
            if (topLevel)
                define(name, jjtn000);
            {if (true) return jjtn000;}
      } finally {
      if (jjtc000) {
        jjtree.closeNodeScope(jjtn000, true);
      }
      }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("UTCTime");
    }
  }

// VALUES
//===========================================================================

//void Value(): {
  final public Object Value() throws ParseException {
    trace_call("Value");
    try {
    Object result = null;
      if (jj_2_4(2)) {
        result = BuiltInValue();
            {if (true) return result;}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LOWER:
          result = DefinedValue();
            {if (true) return result;}
          break;
        default:
          jj_la1[25] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("Value");
    }
  }

//void BuiltInValue(): {
  final public Object BuiltInValue() throws ParseException {
    trace_call("BuiltInValue");
    try {
    boolean b;
    BigInteger bi;
    byte[] ba;
    String s;
    Vector v;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
      case FALSE:
        b = Boolean();
            {if (true) return new Boolean(b);}
        break;
      default:
        jj_la1[26] = jj_gen;
        if (jj_2_5(2)) {
          bi = Integer();
            {if (true) return bi;}
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case H_STRING:
          case B_STRING:
            ba = OctetString();
            {if (true) return ba;}
            break;
          case NULL:
            Null();
            {if (true) return null;}
            break;
          default:
            jj_la1[27] = jj_gen;
            if (jj_2_6(2)) {
              s = ObjectIdentifier();
            {if (true) return s;}
            } else {
              switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
              case 51:
                v = Sequence();
            {if (true) return v;}
                break;
              case C_STRING:
                s = CharacterString();
            {if (true) return s;}
                break;
              default:
                jj_la1[28] = jj_gen;
                jj_consume_token(-1);
                throw new ParseException();
              }
            }
          }
        }
      }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("BuiltInValue");
    }
  }

  final public Object DefinedValue() throws ParseException {
    trace_call("DefinedValue");
    try {
    String id;
      id = ValueReference();
            if (!sTable.containsKey(id)) // look it up in active symtable
                {if (true) throw new ParseException("Undefined Value: "+id);}
            Object result = sTable.get(id);
            stack[++top] = result;
            {if (true) return result;}
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("DefinedValue");
    }
  }

// --------------------------------------------------------------------------
  final public boolean Boolean() throws ParseException {
    trace_call("Boolean");
    try {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
        jj_consume_token(TRUE);
            {if (true) return true;}
        break;
      case FALSE:
        jj_consume_token(FALSE);
            {if (true) return false;}
        break;
      default:
        jj_la1[29] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("Boolean");
    }
  }

// --------------------------------------------------------------------------
  final public BigInteger Integer() throws ParseException {
    trace_call("Integer");
    try {
    BigInteger result;
    String id;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NUMBER:
      case 56:
        result = SignedNumber();
            {if (true) return result;}
        break;
      case LOWER:
        id = Identifier();
            if (!sTable.containsKey(id))
                {if (true) throw new ParseException("Undefined Identifer: "+id);}
            {if (true) return (BigInteger) sTable.get(id);}
        break;
      default:
        jj_la1[30] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("Integer");
    }
  }

// --------------------------------------------------------------------------
  final public byte[] OctetString() throws ParseException {
    trace_call("OctetString");
    try {
    Token t;
    String image;
    BigInteger result;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case B_STRING:
        t = jj_consume_token(B_STRING);
            // bit strings start with ' and end with 'B
            image = t.image.substring(1, t.image.length() - 2);
            result = new BigInteger(image, 2);
            {if (true) return result.toByteArray();}
        break;
      case H_STRING:
        t = jj_consume_token(H_STRING);
            // bit strings start with ' and end with 'H
            image = t.image.substring(1, t.image.length() - 2);
            result = new BigInteger(image, 16);
            {if (true) return result.toByteArray();}
        break;
      default:
        jj_la1[31] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("OctetString");
    }
  }

// --------------------------------------------------------------------------
  final public void Null() throws ParseException {
    trace_call("Null");
    try {
      jj_consume_token(NULL);
    } finally {
      trace_return("Null");
    }
  }

// --------------------------------------------------------------------------
  final public String ObjectIdentifier() throws ParseException {
    trace_call("ObjectIdentifier");
    try {
    int m = top;
      jj_consume_token(51);
      if (jj_2_7(2)) {
        DefinedValue();
        ObjIdComponent();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NUMBER:
        case LOWER:
          ObjIdComponent();
          break;
        default:
          jj_la1[32] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      label_4:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NUMBER:
        case LOWER:
          ;
          break;
        default:
          jj_la1[33] = jj_gen;
          break label_4;
        }
        ObjIdComponent();
      }
      jj_consume_token(52);
            // pop the runtime stack building the OID data as a
            // dot-separated-String
            int limit = top;
            String it = "";
            boolean virgin = true;
            while (m < limit) {
                it += (virgin ? "" : ".") + (String) stack[++m];
                virgin = false;
            }
            top = m;
            {if (true) return it;}
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("ObjectIdentifier");
    }
  }

  final public void ObjIdComponent() throws ParseException {
    trace_call("ObjIdComponent");
    try {
    String id;
      if (jj_2_8(2)) {
        id = Identifier();
        jj_consume_token(54);
        NumberForm();
        jj_consume_token(55);
            // install this id in the current symtable but leave its
            // value on the stack.
            sTable.put(id, (String) stack[top]);
      } else if (jj_2_9(2)) {
        id = Identifier();
            // assume we already defined the Identifier. get its value
            // from the symtable and push it on the stack. should test
            // if value exists, otherwise user is referring to an
            // undefined id.
            if (!sTable.containsKey(id))
                {if (true) throw new ParseException("Undefined Identifer: "+id);}
            stack[++top] = (String) sTable.get(id);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NUMBER:
        case LOWER:
          NumberForm();
          break;
        default:
          jj_la1[34] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } finally {
      trace_return("ObjIdComponent");
    }
  }

  final public void NumberForm() throws ParseException {
    trace_call("NumberForm");
    try {
        Token t;
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NUMBER:
        t = jj_consume_token(NUMBER);
            stack[++top] = t.image; // just push it on the stack

        break;
      case LOWER:
        DefinedValue();
        break;
      default:
        jj_la1[35] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } finally {
      trace_return("NumberForm");
    }
  }

// --------------------------------------------------------------------------

//void Sequence(): {
  final public Vector Sequence() throws ParseException {
    trace_call("Sequence");
    try {
    Vector result = new Vector();
      jj_consume_token(51);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TRUE:
      case NULL:
      case FALSE:
      case NUMBER:
      case H_STRING:
      case B_STRING:
      case C_STRING:
      case LOWER:
      case 51:
      case 56:
        ElementValueList(result);
        break;
      default:
        jj_la1[36] = jj_gen;
        ;
      }
      jj_consume_token(52);
            {if (true) return result;}
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("Sequence");
    }
  }

  final public void ElementValueList(Vector sequence) throws ParseException {
    trace_call("ElementValueList");
    try {
      NamedValue(sequence);
      label_5:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case 53:
          ;
          break;
        default:
          jj_la1[37] = jj_gen;
          break label_5;
        }
        jj_consume_token(53);
        NamedValue(sequence);
      }
    } finally {
      trace_return("ElementValueList");
    }
  }

  final public void NamedValue(Vector container) throws ParseException {
    trace_call("NamedValue");
    try {
    Object val;
      if (jj_2_10(2)) {
        Identifier();
        val = Value();
            container.addElement(val);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case TRUE:
        case NULL:
        case FALSE:
        case NUMBER:
        case H_STRING:
        case B_STRING:
        case C_STRING:
        case LOWER:
        case 51:
        case 56:
          val = Value();
            container.addElement(val);
          break;
        default:
          jj_la1[38] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } finally {
      trace_return("NamedValue");
    }
  }

// --------------------------------------------------------------------------
  final public String CharacterString() throws ParseException {
    trace_call("CharacterString");
    try {
    Token t;
      t = jj_consume_token(C_STRING);
            // bit strings start and end with '
            {if (true) return t.image.substring(1, t.image.length() - 1);}
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("CharacterString");
    }
  }

// ==========================================================================
  final public String TypeReference() throws ParseException {
    trace_call("TypeReference");
    try {
    Token t;
      t = jj_consume_token(UPPER);
            {if (true) return t.image;}
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("TypeReference");
    }
  }

  final public String Identifier() throws ParseException {
    trace_call("Identifier");
    try {
    Token t;
      t = jj_consume_token(LOWER);
            {if (true) return t.image;}
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("Identifier");
    }
  }

  final public String ValueReference() throws ParseException {
    trace_call("ValueReference");
    try {
    Token t;
      t = jj_consume_token(LOWER);
            {if (true) return t.image;}
    throw new Error("Missing return statement in function");
    } finally {
      trace_return("ValueReference");
    }
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_1();
    jj_save(0, xla);
    return retval;
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_2();
    jj_save(1, xla);
    return retval;
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_3();
    jj_save(2, xla);
    return retval;
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_4();
    jj_save(3, xla);
    return retval;
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_5();
    jj_save(4, xla);
    return retval;
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_6();
    jj_save(5, xla);
    return retval;
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_7();
    jj_save(6, xla);
    return retval;
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_8();
    jj_save(7, xla);
    return retval;
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_9();
    jj_save(8, xla);
    return retval;
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_10();
    jj_save(9, xla);
    return retval;
  }

  final private boolean jj_3R_44() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_10()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_10() {
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_15()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_15() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_4()) {
    jj_scanpos = xsp;
    if (jj_3R_27()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_3R_9()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_37() {
    if (jj_scan_token(B_STRING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_29() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_37()) {
    jj_scanpos = xsp;
    if (jj_3R_38()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_43() {
    if (jj_3R_44()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_39() {
    if (jj_3R_43()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_6() {
    if (jj_scan_token(SEQUENCE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(51)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_31() {
    if (jj_scan_token(51)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_39()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(52)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_23() {
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_22() {
    if (jj_3R_33()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_10() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_22()) {
    jj_scanpos = xsp;
    if (jj_3R_23()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_42() {
    if (jj_3R_12()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_41() {
    if (jj_scan_token(NUMBER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_34() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_41()) {
    jj_scanpos = xsp;
    if (jj_3R_42()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_36() {
    if (jj_scan_token(FALSE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_26() {
    if (jj_3R_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_35() {
    if (jj_scan_token(TRUE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_28() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_35()) {
    jj_scanpos = xsp;
    if (jj_3R_36()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_3R_8()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_7()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_6()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_13() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_8()) {
    jj_scanpos = xsp;
    if (jj_3_9()) {
    jj_scanpos = xsp;
    if (jj_3R_26()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(54)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_12() {
    if (jj_3R_25()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_25() {
    if (jj_scan_token(LOWER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_8() {
    if (jj_scan_token(SET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(51)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_16() {
    if (jj_scan_token(OF)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_21() {
    if (jj_3R_32()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_20() {
    if (jj_3R_31()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_14() {
    if (jj_scan_token(LOWER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_24() {
    if (jj_3R_13()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_3R_11()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_7() {
    if (jj_scan_token(SEQUENCE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_16()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_3R_12()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_13()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_19() {
    if (jj_3R_30()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_11() {
    if (jj_scan_token(51)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_7()) {
    jj_scanpos = xsp;
    if (jj_3R_24()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_18() {
    if (jj_3R_29()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_40() {
    if (jj_scan_token(56)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_3R_10()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_33() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_40()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(NUMBER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_30() {
    if (jj_scan_token(NULL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_17() {
    if (jj_3R_28()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_9() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_17()) {
    jj_scanpos = xsp;
    if (jj_3_5()) {
    jj_scanpos = xsp;
    if (jj_3R_18()) {
    jj_scanpos = xsp;
    if (jj_3R_19()) {
    jj_scanpos = xsp;
    if (jj_3_6()) {
    jj_scanpos = xsp;
    if (jj_3R_20()) {
    jj_scanpos = xsp;
    if (jj_3R_21()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_32() {
    if (jj_scan_token(C_STRING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_45() {
    if (jj_3R_15()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_38() {
    if (jj_scan_token(H_STRING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_27() {
    if (jj_3R_12()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  public ParserTokenManager token_source;
  ASCII_CharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[39];
  final private int[] jj_la1_0 = {0x0,0x0,0x38666e00,0x266400,0x30400a00,0x0,0x0,0x0,0x0,0x38666e00,0x0,0x0,0x4080000,0x4080000,0x100,0x38666e00,0x100,0x40800000,0x3000000,0x40800000,0x0,0x3000000,0x100000,0x30000000,0x400000,0x0,0x9000,0x2000,0x0,0x9000,0x0,0x0,0x0,0x0,0x0,0x0,0xb000,0x0,0xb000,};
  final private int[] jj_la1_1 = {0xc000,0xc000,0x20043fe,0x0,0x20003fe,0x80000,0x200000,0x1008400,0x1000000,0x200c3fe,0x200000,0x8000,0x0,0x0,0x0,0x200c3fe,0x0,0x1,0x0,0x1,0x8400,0x0,0x0,0x2fe,0x100,0x8000,0x0,0x1800,0x82000,0x0,0x1008400,0x1800,0x8400,0x8400,0x8400,0x8400,0x108bc00,0x200000,0x108bc00,};
  final private JJCalls[] jj_2_rtns = new JJCalls[10];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public Parser(java.io.InputStream stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 39; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 39; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public Parser(java.io.Reader stream) {
    jj_input_stream = new ASCII_CharStream(stream, 1, 1);
    token_source = new ParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 39; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 39; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public Parser(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 39; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(ParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jjtree.reset();
    jj_gen = 0;
    for (int i = 0; i < 39; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      trace_token(token, "");
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    return (jj_scanpos.kind != kind);
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
      trace_token(token, " (in getNextToken)");
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration enum = jj_expentries.elements(); enum.hasMoreElements();) {
        int[] oldentry = (int[])(enum.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[59];
    for (int i = 0; i < 59; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 39; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 59; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  private int trace_indent = 0;
  private boolean trace_enabled = true;

  final public void enable_tracing() {
    trace_enabled = true;
  }

  final public void disable_tracing() {
    trace_enabled = false;
  }

  final private void trace_call(String s) {
    if (trace_enabled) {
      for (int i = 0; i < trace_indent; i++) { System.out.print(" "); }
      System.out.println("Call:   " + s);
    }
    trace_indent = trace_indent + 2;
  }

  final private void trace_return(String s) {
    trace_indent = trace_indent - 2;
    if (trace_enabled) {
      for (int i = 0; i < trace_indent; i++) { System.out.print(" "); }
      System.out.println("Return: " + s);
    }
  }

  final private void trace_token(Token t, String where) {
    if (trace_enabled) {
      for (int i = 0; i < trace_indent; i++) { System.out.print(" "); }
      System.out.print("Consumed token: <" + tokenImage[t.kind]);
      if (t.kind != 0 && !tokenImage[t.kind].equals("\"" + t.image + "\"")) {
        System.out.print(": \"" + t.image + "\"");
      }
      System.out.println(">" + where);
    }
  }

  final private void trace_scan(Token t1, int t2) {
    if (trace_enabled) {
      for (int i = 0; i < trace_indent; i++) { System.out.print(" "); }
      System.out.print("Visited token: <" + tokenImage[t1.kind]);
      if (t1.kind != 0 && !tokenImage[t1.kind].equals("\"" + t1.image + "\"")) {
        System.out.print(": \"" + t1.image + "\"");
      }
      System.out.println(">; Expected token: <" + tokenImage[t2] + ">");
    }
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 10; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
