/* $Id: Main.java,v 1.2 1998/12/22 21:27:53 raif Exp $
 *
 * Copyright (c) 1997, 1998, 1999 Systemics Ltd on behalf of
 * the Cryptix Development Team.  All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General License along with this library; if
 * not, you can download a copy from <http://www.cryptix.org/>.
 */

package cryptix.asn1.test;

import cryptix.asn1.lang.ASNObject;
import cryptix.asn1.lang.ASNSpecification;
import cryptix.asn1.lang.Parser;
import cryptix.asn1.lang.ParseException;
import cryptix.asn1.encoding.BaseCoder;
import cryptix.asn1.encoding.CoderOperations;
import cryptix.asn1.encoding.DER;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

/**
 * A test class for reduced ASN.1 syntax and DER decoding.<p>
 *
 * <b>Copyright</b> &copy;1997, 1998, 1999
 * <a href="http://www.systemics.com/">Systemics Ltd</a> on behalf of the
 * <a href="http://www.systemics.com/docs/cryptix/">Cryptix Development Team</a>.
 * <br>All rights reserved.<p>
 *
 * <b>$Revision: 1.2 $</b>
 * @author  Raif S. Naffah
 */
public class Main
{
    public static void main(String[] args) {
        args = new String[] { "x509.asn", "1eecert.x509" };
/*
        if (args.length != 2) {
            System.out.println("Usage:");
            System.out.println("  java cryptix.asn1.test.Main <definitions> <data>");
            System.out.println();
            System.out.println("Where <definitions> is a file containing ASN.1 definitions,");
            System.out.println("and <data> is a file containing a DER encoding of an instance");
            System.out.println("of an object which definition is given in <data>; eg.");
            System.out.println();
            System.out.println("  java cryptix.asn1.test.Main cryptix.asn Duke.x509");
            System.out.println();
            return;
        }
*/
        String definitions = args[0];
        String data = args[1];

        Parser parser;

        System.out.println();
        System.out.println("1. Parsing \""+definitions+"\"...");
        try {
            parser = new Parser(new FileInputStream(definitions));
        } catch (FileNotFoundException e) {
            System.out.println(
                  "*** \""+definitions+"\" not found in work directory..." );
            return ;
        }

        // first compile some definitions in ASN.1 syntax
        ASNSpecification x = null;
        try {
            x = parser.Specification(false); // without tracing

            System.out.println();
            System.out.println("2. Result of compilation: ");
            x.dump();

            System.out.println();
            System.out.println("3. Current symbol table:");
            parser.dumpSymbolTable();

            System.out.println();
            int it = parser.countUnresolvedReferences();
            System.out.println("4. Number of unresolved references: "+it);
        } catch (ParseException e) {
            System.out.println("*** Failed parsing...");
            System.out.println("*** "+e.getMessage()+"...");
            e.printStackTrace(System.out);
        }

        System.out.println();
        System.out.println("5. Can we access a \"Certificate\" from an x509 struct?");
        ASNObject x509 = x.getComponent("Certificate");
        x509.dump("Certificate --> ");

        System.out.println();
        System.out.println("6. Can we access \""+data+"\" ?");
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(data);
        } catch (FileNotFoundException e) {
            System.out.println("*** \""+data+"\" not found in work directory...");
            return;
        }

        System.out.println("Yes...");
        System.out.println();
        System.out.println("7. Can we access the x509 instance present inside?");

        CoderOperations der = BaseCoder.getInstance("DER");
        if (der == null)
            return;

        der.init(fis);

        try {
            x509.accept(der, null);
            x509.dump();

            System.out.println();
            System.out.println("8. Can we identify its signature algorithm?");
            System.out.println();
            ASNObject result = null;

            ASNObject tbsCertificate = x509.getComponent("Certificate.tbsCertificate");
            tbsCertificate.dump("8.1. Certificate.tbsCertificate --> ");
            System.out.println();
            ASNObject signature = tbsCertificate.getComponent("TBSCertificate.signature");
            signature.dump("8.2. TBSCertificate.signature --> ");
            System.out.println();
            result = signature.getComponent("AlgorithmIdentifier.algorithm");
            result.dump("8.3. AlgorithmIdentifier.algorithm --> ");
            System.out.println();

            System.out.println("Issuer's signature algorithm OID (#1) is: "+
                result.getValue());

            System.out.println();
        } catch (Exception e) {
            e.printStackTrace(System.out);
        }

        System.out.println();
        System.out.println("Done all tests...");
    }
}