/**
   Main2.java

   Copyright (C) 1999, RTFM, Inc.
   All Rights Reserved.

   ekr@rtfm.com  Thu May 20 09:58:16 1999
*/

/* $Id: $
 *
 * Copyright (c) 1997, 1998, 1999 Systemics Ltd on behalf of
 * the Cryptix Development Team.  All rights reserved.
 *
 * Use, modification, copying and distribution of this software is subject to
 * the terms and conditions of the Cryptix General Licence. You should have
 * received a copy of the Cryptix General License along with this library; if
 * not, you can download a copy from <http://www.cryptix.org/>.
 */

package cryptix.asn1.test;

import cryptix.asn1.lang.ASNObject;
import cryptix.asn1.lang.ASNSpecification;
import cryptix.asn1.lang.Parser;
import cryptix.asn1.lang.ParseException;
import cryptix.asn1.encoding.BaseCoder;
import cryptix.asn1.encoding.CoderOperations;
import cryptix.asn1.encoding.DER;

import cryptix.util.core.Hex;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.Vector;

/**
 * A test class for reduced ASN.1 syntax and DER decoding.<p>
 *
 * <b>Copyright</b> &copy;1997, 1998, 1999
 * <a href="http://www.systemics.com/">Systemics Ltd</a> on behalf of the
 * <a href="http://www.systemics.com/docs/cryptix/">Cryptix Development Team</a>.
 * <br>All rights reserved.<p>
 *
 * <b>$Revision: 1.2 $</b>
 * @author  Raif S. Naffah
 */
public class Main2
{
    // see first statement in main for desired value
//    private static final boolean CRYPTIX_ASN = true;
    private static final boolean CRYPTIX_ASN = false;


    public static void main(String[] args) {
        // initialise defaults
        String definitions = "cryptix.asn";
        String data = "Duke.x509";
        String CERTIFICATE = "Certificate";
        String CERTIFICATE_INFO = "certificateInfo";
        if (args.length != 2){
            if (!CRYPTIX_ASN) {
                definitions = "x509useful.asn";
                data = "1eecert.x509";
                CERTIFICATE = "UsefulCertificate";
                CERTIFICATE_INFO = "tbsCertificate";
            }
        } else {
            definitions = args[0];
            data = args[1];
        }
/*
}
        if (args.length != 2) {
            System.out.println("Usage:");
            System.out.println("  java cryptix.asn1.test.Main <definitions> <data>");
            System.out.println();
            System.out.println("Where <definitions> is a file containing ASN.1 definitions,");
            System.out.println("and <data> is a file containing a DER encoding of an instance");
            System.out.println("of an object which definition is given in <data>; eg.");
            System.out.println();
            System.out.println("  java cryptix.asn1.test.Main cryptix.asn Duke.x509");
            System.out.println();
            return;
        }
*/

        Parser parser;

        System.out.println();
        System.out.println("1. Parsing \""+definitions+"\"...");
        try {
            parser = new Parser(new FileInputStream(definitions));
        } catch (FileNotFoundException e) {
            System.out.println(
                  "*** \""+definitions+"\" not found in work directory..." );
            return ;
        }

        // first compile some definitions in ASN.1 syntax
        ASNSpecification x = null;
        try {
            x = parser.Specification(false); // without tracing

            System.out.println();
            System.out.println("2. Result of compilation: ");
            x.dump();

            System.out.println();
            System.out.println("3. Current symbol table:");
            parser.dumpSymbolTable();

            System.out.println();
            int it = parser.countUnresolvedReferences();
            System.out.println("4. Number of unresolved references: "+it);
        } catch (ParseException e) {
            System.out.println("*** Failed parsing...");
            System.out.println("*** "+e.getMessage()+"...");
            e.printStackTrace(System.out);
        }

        System.out.println();
        System.out.println("5. Can we access a \"Certificate\" from an x509 struct?");
        ASNObject x509 = x.getComponent(CERTIFICATE);
        x509.dump("Certificate --> ");

        System.out.println();
        System.out.println("6. Can we access \""+data+"\" ?");
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(data);
        } catch (FileNotFoundException e) {
            System.out.println("*** \""+data+"\" not found in work directory...");
            return;
        }

        System.out.println("Yes...");
        System.out.println();
        System.out.println("7. Can we access the x509 instance present inside?");
	
        CoderOperations der = BaseCoder.getInstance("DER");
        if (der == null)
            return;

        der.init(fis);
        try {
            x509.accept(der, null);
            x509.dump();

        } catch (Exception e) {
            e.printStackTrace(System.out);
        }

        ASNObject tbsCert = x509.getComponent(CERTIFICATE+"."+CERTIFICATE_INFO);
        byte[] ob = null;
        if (CRYPTIX_ASN) {
            System.out.println(CERTIFICATE+" encoding: \""+tbsCert.getValue()+"\"");
        } else {
            ob = (byte[]) tbsCert.getValue();
            System.out.println(CERTIFICATE+" encoding: \""+Hex.toString(ob)+"\"");
        }

        // EKR specific
        if (!CRYPTIX_ASN)
            try {
                tbsCert = x.getComponent("UsefulTBSCertificate");
                ByteArrayInputStream is = new ByteArrayInputStream(ob);
//                der = BaseCoder.getInstance("DER"); // we already have one
                der.init(is);
                tbsCert.dump("UsefulTBSCertificate--> ");
                tbsCert.accept(der, null);
                tbsCert.dump();

		ASNObject issuer=x.getComponent("UsefulTBSCertificate.issuer");
		byte[] issuer_bytes=(byte[])issuer.getValue();
		System.out.println("Issuer encoding: " + Hex.toString
		  (issuer_bytes));

		ASNObject subject=x.getComponent("UsefulTBSCertificate.subject");
		byte[] subject_bytes=(byte[])subject.getValue();
		System.out.println("Subject encoding: " + Hex.toString
		  (subject_bytes));
		
		ASNObject a=(ASNObject)x.getComponent("UsefulTBSCertificate.extensions");
		Vector v=(Vector)a.getValue();
		
		for(int i=0;i<v.size();i++){
		  Vector v2=(Vector)v.elementAt(i);
		  byte[] extnval=(byte [])v2.elementAt(0);
		  System.out.println("Extn encoding: " + Hex.toString
		    (extnval));
		}
		

            } catch (Exception e) {
                e.printStackTrace(System.out);
            }

        ASNObject sig = x509.getComponent(CERTIFICATE+".signature");
        ob = (byte[]) sig.getValue();
        System.out.println("Signature encoding: \""+Hex.toString(ob)+"\"");
	
        System.out.println();
        System.out.println("Done all tests...");
    }
}
