DBNAME=sepstore
HEAPSIZE=8196

#create database DBNAME
echo "Create the '"$DBNAME"' database."
db2 create database $DBNAME

echo "Connect to '"$DBNAME"' database ..."
db2 connect to $DBNAME

echo "Create tables ..."
db2 "CREATE TABLE dssequences( seq_name VARCHAR(30) NOT NULL, next_id INTEGER NOT NULL, PRIMARY KEY( seq_name ) )"
db2 "CREATE TABLE dsusers( user_id INTEGER NOT NULL, user_name VARCHAR(30) NOT NULL, user_passwd VARCHAR(30), home_dir_id INTEGER, blocked VARCHAR(1) NOT NULL, PRIMARY KEY( user_id ) )"
db2 "CREATE TABLE dsgroups( group_id INTEGER NOT NULL, group_name VARCHAR(30) NOT NULL, PRIMARY KEY( group_id ) )"
db2 "CREATE TABLE dsug_relation( user_id INTEGER NOT NULL, group_id INTEGER NOT NULL )"
db2 "CREATE TABLE dsdockeys( tree_id INTEGER NOT NULL, next_id INTEGER NOT NULL )"
db2 "CREATE TABLE dstrees( tree_id INTEGER NOT NULL, tree_name VARCHAR(30) NOT NULL, tree_parent INTEGER NOT NULL, store_mode VARCHAR(10) NOT NULL, naming VARCHAR(1) NOT NULL, user_id INTEGER NOT NULL, group_id INTEGER NOT NULL, modify_time TIMESTAMP NOT NULL, user_read VARCHAR(1) NOT NULL, user_write VARCHAR(1) NOT NULL, group_read VARCHAR(1) NOT NULL, group_write VARCHAR(1) NOT NULL, other_read VARCHAR(1) NOT NULL, other_write VARCHAR(1) NOT NULL, PRIMARY KEY( tree_id ) )"
db2 "CREATE TABLE dsstructs( struct_id INTEGER NOT NULL, struct_name VARCHAR(50) NOT NULL, tree_id INTEGER NOT NULL, struct_parent INTEGER NOT NULL, struct_type VARCHAR(15) NOT NULL, PRIMARY KEY( struct_id ) )"
db2 "CREATE TABLE dsrepository( doc_id INTEGER NOT NULL, doc_name VARCHAR(255) NOT NULL, tree_id INTEGER NOT NULL, order_nr INTEGER NOT NULL, block LONG VARCHAR, status VARCHAR(1) NOT NULL, user_id INTEGER NOT NULL, group_id INTEGER NOT NULL, modify_time TIMESTAMP NOT NULL, user_read VARCHAR(1) NOT NULL, user_write VARCHAR(1) NOT NULL, group_read VARCHAR(1) NOT NULL, group_write VARCHAR(1) NOT NULL, other_read VARCHAR(1) NOT NULL, other_write VARCHAR(1) NOT NULL )"
db2 "CREATE TABLE dslexicon( word_id INTEGER NOT NULL, word_name VARCHAR(255), word_hit INTEGER NOT NULL, PRIMARY KEY( word_id ) )"
db2 "CREATE TABLE dsbarrels( tree_id INTEGER NOT NULL, doc_id INTEGER NOT NULL, struct_id INTEGER NOT NULL, word_id INTEGER NOT NULL, pozition INTEGER NOT NULL )"
echo "Tables has created."

echo "Insert deafult values to tables."
db2 "INSERT INTO dssequences VALUES('lex_id', 1), ('struct_id', 1), ('tree_id', 1), ('user_id', 2), ('group_id', 2)"
db2 "INSERT INTO dsusers VALUES(0, 'root', '64bfd643ad7df3dc', 0, 'f'), (1, 'guest', '5d7edc2fd014e444', 0, 'f')"
db2 "INSERT INTO dsgroups VALUES(0, 'root'), (1, 'guest')"
db2 "INSERT INTO dsug_relation VALUES(0, 0), (1, 1)"
db2 "INSERT INTO dsdockeys VALUES(0, 1)"
db2 "INSERT INTO dstrees VALUES(0, 'root', -1, 'flexible', 'A', 0, 0, CURRENT TIMESTAMP, 't', 't', 't', 't', 't', 't')"
echo "Deafult values added to tables."

echo "Create indexes ..."
db2 "CREATE UNIQUE INDEX lexicon_word_name ON dslexicon( word_name )"
db2 "CREATE UNIQUE INDEX users_user_name   ON dsusers( user_name )"
db2 "CREATE UNIQUE INDEX groups_group_name ON dsgroups( group_name )"
db2 "CREATE UNIQUE INDEX dockeys_tree_id   ON dsdockeys( tree_id )"
db2 "CREATE INDEX sequences_next_id ON dssequences( next_id )"
db2 "CREATE INDEX users_user_passwd ON dsusers( user_passwd )"
db2 "CREATE INDEX ug_rel_user_id    ON dsug_relation( user_id )"
db2 "CREATE INDEX ug_rel_group_id   ON dsug_relation( group_id )" 
db2 "CREATE INDEX dockeys_next_id   ON dsdockeys( next_id )"
db2 "CREATE INDEX trees_tree_name   ON dstrees( tree_name )"
db2 "CREATE INDEX trees_tree_parent ON dstrees( tree_parent )"
db2 "CREATE INDEX trees_store_mode  ON dstrees( store_mode )"
db2 "CREATE INDEX trees_naming      ON dstrees( naming )"
db2 "CREATE INDEX trees_user_id     ON dstrees( user_id )"
db2 "CREATE INDEX trees_group_id    ON dstrees( group_id )"
db2 "CREATE INDEX trees_user_read   ON dstrees( user_read )" 
db2 "CREATE INDEX trees_user_write  ON dstrees( user_write )"
db2 "CREATE INDEX trees_group_read  ON dstrees( group_read )"
db2 "CREATE INDEX trees_group_write ON dstrees( group_write )"
db2 "CREATE INDEX trees_other_read  ON dstrees( other_read )"
db2 "CREATE INDEX trees_other_write ON dstrees( other_write )"
db2 "CREATE INDEX str_struct_name   ON dsstructs( struct_name )"
db2 "CREATE INDEX str_tree_id       ON dsstructs( tree_id )"
db2 "CREATE INDEX str_struct_parent ON dsstructs( struct_parent )"
db2 "CREATE INDEX str_struct_type   ON dsstructs( struct_type )"
db2 "CREATE INDEX rep_doc_id        ON dsrepository ( doc_id )"
db2 "CREATE INDEX rep_tree_id       ON dsrepository ( tree_id )"
db2 "CREATE INDEX rep_order_nr      ON dsrepository ( order_nr )"
db2 "CREATE INDEX rep_status        ON dsrepository ( status )"
db2 "CREATE INDEX rep_user_id       ON dsrepository ( user_id )"
db2 "CREATE INDEX rep_group_id      ON dsrepository ( group_id )"
db2 "CREATE INDEX rep_user_read     ON dsrepository ( user_read )"
db2 "CREATE INDEX rep_user_write    ON dsrepository ( user_write )"
db2 "CREATE INDEX rep_group_read    ON dsrepository ( group_read )"
db2 "CREATE INDEX rep_group_write   ON dsrepository ( group_write )"
db2 "CREATE INDEX rep_other_read    ON dsrepository ( other_read )"
db2 "CREATE INDEX rep_other_write   ON dsrepository ( other_write )"
db2 "CREATE INDEX barrels_tree_id   ON dsbarrels( tree_id )"
db2 "CREATE INDEX barrels_doc_id    ON dsbarrels( doc_id )"
db2 "CREATE INDEX barrels_struct_id ON dsbarrels( struct_id )"
db2 "CREATE INDEX barrels_word_id   ON dsbarrels( word_id )"
db2 "CREATE INDEX barrels_pozition  ON dsbarrels( pozition )"
echo "Indexes has created."			   			       

echo "Increment application heap size for "$DBNAME "(" $HEAPSIZE ")"  
db2 update db config for $DBNAME using applheapsz $HEAPSIZE

echo "Database installation finished."
