#!/bin/sh
##########################################################
#   dont start script as root!
#   --------------------------
#
# create XML based database SEPSTORE 
#   - 20 MB data devspace and 8 MB log devspace
#   - SEPSTORE database user admin (with password adminp)
#########################################################


id=`id | sed s/\(.*// | sed s/uid=//`

if [ "$id" = "0" ]; then
    echo "dont start script as root"
    exit 1
fi 

export PATH=/opt/sapdb/indep_prog/bin:$PATH
#set -x

# name of the database
DBNAME=SEPSTORE

# start remote communication server
echo "start communication server..."
x_server start >/dev/null 2>&1

# stop and drop probably existing XML based database
echo "stop and drop existing $DBNAME..."
dbmcli -d $DBNAME -u dbm,dbm db_offline >/dev/null 2>&1
dbmcli -d $DBNAME -u dbm,dbm db_drop >/dev/null 2>&1

# create new SEPSTORE database
echo "create database $DBNAME..."
_o=`/opt/sapdb/depend/bin/dbmcli -s -R /opt/sapdb/depend db_create $DBNAME dbm,dbm 2>&1`
_test=`echo $_o | grep OK`
if [ "$_test" = "" ]; then
	echo "create $DBNAME failed: $_o"
	exit 1
fi

# create directory where to put the database files
mkdir -p $HOME/$DBNAME

# setup database parameters
echo "set parameters for $DBNAME..."
_o=`cat <<EOF | dbmcli -d $DBNAME -u dbm,dbm 2>&1
param_rmfile
param_startsession
param_init OLTP
param_put LOG_MODE SINGLE
param_put CAT_CACHE_SUPPLY 300
param_put DATA_CACHE 2500
param_put MAXDATADEVSPACES 5
param_put MAXDATAPAGES 1024000
param_checkall
param_commitsession
param_adddevspace 1 SYS  $HOME/$DBNAME/DISKS01   F
param_adddevspace 1 DATA $HOME/$DBNAME/DISKD0001 F 2560
param_adddevspace 1 LOG  $HOME/$DBNAME/DISKL001  F 1024
quit
EOF`
_test=`echo $_o | grep OK`
if [ "$_test" = "" ]; then
        echo "set parameters failed: $_o"
        exit 1
fi


# startup database
echo "start $DBNAME..."
_o=`dbmcli -d $DBNAME -u dbm,dbm db_start 2>&1`
_test=`echo $_o | grep OK`
if [ "$_test" = "" ]; then
        echo "start $DBNAME failed: $_o"
        exit 1
fi


# initialize database files
echo "initializing $DBNAME..."
_o=`cat <<EOF | dbmcli -d $DBNAME -u dbm,dbm 2>&1
util_connect dbm,dbm
util_execute init config
util_activate dba,dba
quit
EOF`
_test=`echo $_o | grep OK`
if [ "$_test" = "" ]; then
        echo "initialize $DBNAME failed: $_o"
        exit 1
fi

# load database system tables
echo "load system tables..."
_o=`dbmcli -d $DBNAME -u dbm,dbm load_systab -u dba,dba -ud domain 2>&1`
_test=`echo $_o | grep OK`
if [ "$_test" = "" ]; then
        echo "load system tables failed: $_o"
        exit 1
fi

# create XML based database user
echo "create XML based database user..."
_o=`cat <<EOF | dbmcli -d $DBNAME -u dba,dba 2>&1
sql_connect dba,dba
sql_execute CREATE USER admin PASSWORD adminp DBA NOT EXCLUSIVE
EOF`
_test=`echo $_o | grep OK`
if [ "$_test" = "" ]; then
        echo "create db user failed: $_o"
        exit 1
fi

# create XML based database tables and indexes
echo "create XML based database tables and indexes..."
_o=`dbmcli -d $DBNAME -u dbm,dbm -i sepstore.dump.sap 2>&1`
_test=`echo $_o | grep OK`
if [ "$_test" = "" ]; then
        echo "create db tables and indexes failed: $_o"
        exit 1
fi

echo "set backup parameters..."
_o=`cat <<EOF | dbmcli -d $DBNAME -u dbm,dbm 2>&1
backup_media_put data $HOME/$DBNAME/datasave FILE DATA 0 8 YES
backup_media_put auto $HOME/$DBNAME/autosave FILE AUTO
util_connect dbm,dbm
backup_save data
autosave_on
quit
EOF`
_test=`echo $_o | grep OK`
if [ "$_test" = "" ]; then
        echo "set backup parameters failed: $_o"
        exit 1
fi

exit 0
