/*
 * $COPYRIGHT$
 * $Id: ArgParser.java,v 1.8 2001/10/23 10:27:26 crow Exp $
 *
 * Date         Author          Changes
 * JUL 11 2001  Szabo Csaba     Created
 */
       
package org.media.datastore;

import java.util.Properties;
import java.util.Enumeration;
import java.util.Vector;
import java.util.StringTokenizer;

/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.8 $ $Date: 2001/08/15 15:00:00
 * @see java.lang.String
 * @see java.util.Vector
 */
    
public class ArgParser {

    private static Properties prop = new Properties();
    private static Vector unparsed = new Vector();
    

    public ArgParser( String keys, String delim ) {
        StringTokenizer st = new StringTokenizer(keys, delim);
        while ( st.hasMoreTokens() ) {
            prop.setProperty(st.nextToken(), "" );
        } 
    }


    public ArgParser( String keys ) {
        StringTokenizer st = new StringTokenizer( keys );

        while ( st.hasMoreTokens() ) {
            prop.setProperty(st.nextToken(), "" );
        } 
    }

    
    public boolean parse( String[] argv ) {
        if ( !isValid( argv ) ) return false;
        for ( Enumeration e = prop.propertyNames(); e.hasMoreElements(); ) {
            String key = (String)e.nextElement();
            prop.setProperty(key, getArgs(argv, key) );
        }
        return true;
    } 

    
    public String getValue( String key ) {
        String value = prop.getProperty( key );
        if ( value == null ) return null;
        if ( value.trim().length() < 1 ) return null;
        if ( value.equals(" - ") ) return "";
        return value;
    }

    
    public Vector getUnparsedArg() {
        return unparsed; 
    }

    
    private boolean isValid( String[] argv ) {
        for ( int i = 0; i < argv.length; i++ ) {
            String arg = argv[i];

            if ( prop.getProperty( arg ) != null ) continue;
            if ( prop.getProperty( arg + ":" ) != null ) {
                i++;
                continue;
            }
            unparsed.addElement( arg );
        }
        return true;
    }


    private String getArgs( String argx[], String key ) {
        for ( int i = 0; i < argx.length; i++ ) {
            String arg = argx[i];
            
            if ( key.equals( arg ) ) return " - ";
            else {
                if ( key.equals( arg + ":" ) ) 
                    if ( ( i + 1 ) < argx.length &&
			 prop.getProperty( argx [ i + 1 ] ) == null &&
                         prop.getProperty( argx [ i + 1 ] + ":" ) == null ) 
                        return argx [ i + 1 ];
                    else
                        return " - ";
            }
        }
        return "";
    } 
}
