/*
 * $COPYRIGHT$
 * $Id: ResultParser.java,v 1.3 2002/06/03 11:18:05 crow Exp $
 *
 * Date         Author            Changes
 * Oct 19 2001  Szabo Csaba       Created
 */                                                                                                                                                             
package org.media.datastore;

import java.util.Vector;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.io.InputStream;

import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.SAXParser;                                                                                                                             
import org.xml.sax.*;
import org.xml.sax.helpers.*;

/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.3 $ $Date: 2001/10/19 15:00:00
 * @see java.lang.String
 * @see java.io.InputStream
 */
    
public class ResultParser extends DefaultHandler {

    private StringBuffer parents;
    private boolean      nextBlock;


    protected ResultParser( ) {
        parents   = new StringBuffer();
        nextBlock = false;
    }


    public String write( InputStream istream ) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(istream, new ResultParser() );
            return null;
        } 
        catch ( Exception _ex ) {
            return "The response XML is not valid, please contact your system administrator!";
        }
    } 


    public void startDocument() 
        throws SAXException {
        parents = new StringBuffer();
    } 


    public void endElement( String uri, String name, String qname )
        throws SAXException {
        String pName = getParentName();

        nextBlock = false; 
        if ( !qname.equals( pName ) ) 
            throw new SAXException( "Invalid end element: " + pName + "\n");
        else 
            parents.delete( parents.toString().lastIndexOf( "," ), parents.length() );
    }


    public void endDocument() 
        throws SAXException{
        System.out.print("\n");
    }


    public void startElement( String uri, String name, String qname, Attributes attrs )
        throws SAXException  {
        String pName = getParentName();

        parents.append( ", " + qname );
    
        if ( qname.equalsIgnoreCase( "block" ) && 
             pName.equalsIgnoreCase( "additional" ) && attrs != null ) {
            for ( int i = 0; i < attrs.getLength(); i++ )
                System.out.print( "\n" + attrs.getValue(i).trim() );
        }
    } 
  
  
    public void characters( char ch[], int start, int length ) 
        throws SAXException  {
        String pName = getParentName();
        String str   = new String(ch, start, length);
        
        if ( str.trim().length() < 1 ) return;

        if ( pName.equalsIgnoreCase( "warning" ) )
            System.err.print( nextBlock ? str : "\nWARNING: " + removeFrontSpace( str ) ); 
        else if ( pName.equalsIgnoreCase( "error" ) )
            System.err.print( nextBlock ? str : "\nERROR: " + removeFrontSpace( str ) );
        else if ( pName.equalsIgnoreCase( "info" ) )
            System.out.print( str );
        else     
            System.out.print( str );
        nextBlock = true;
    }


    public void ignorableWhitespace( char ch[], int start, int length ) 
        throws SAXException  {
        characters(ch, start, length);
    }

    
    private String getParentName( ) {
        String pName = parents.toString().trim();
        int     _poz = pName.lastIndexOf( "," );
        if ( _poz != -1 ) pName = pName.substring( _poz + 1 ).trim();
        return pName;
    }


    private String removeFrontSpace( String str ) {                             
        str += ";";                                                             
        str  = str.trim();                                                      
        return str.substring( 0, str.lastIndexOf(";") );                        
    }
} 
