/*
 * $COPYRIGHT$
 * $Id: SmChown.java,v 1.8 2001/11/19 12:04:31 crow Exp $
 *
 * Date         Author          Changes
 * May 28 2001  Szabo Csaba     Created
 */

package org.media.datastore;

import java.util.StringTokenizer;

/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.8 $ $Date: 2001/04/21 15:00:00
 * @see java.lang.String
 */

public class SmChown extends SmClient {
  
    private boolean  recursive = false;
    private boolean    verbose = false;
    private String       owner = null;
    private String         doc = null;

    protected final String usage = getUsage("res/smchownHelp_EN.txt");
    protected final String args  = opArg + "-R;--recursive;-v;--verbose;--owner:;--doc:;";
    

    protected void setArgs(ArgParser parser) {
        super.setArgs(parser);
        String arg;
        
        if ( "".equals( parser.getValue("-R") ) || 
             "".equals( parser.getValue("--recursive") ) ) recursive = true;
        if ( "".equals( parser.getValue("-v") ) || 
             "".equals( parser.getValue("--verbose") ) )   verbose = true;
        if ( parser.getUnparsedArg().size() > 1 ) {
            owner = (String)parser.getUnparsedArg().elementAt(0);
            doc   = (String)parser.getUnparsedArg().elementAt(1); 
        }
    }

    
    protected String validate() {
        String ret = super.validate( usage );
        
        if ( ret != "" ) return ret;
        if ( owner == null && doc == null ) return usage;
        
        if ( owner == "" || owner == null ) 
            ret += getMessage("smchown", "invalid_owner");
        if ( "".equals( doc ) || doc == null ) 
            ret += getMessage("smchmod", "invalid_doc");

        return ret;
    }


    protected String parseArgs( String[] argv ) {
        ArgParser parser = new ArgParser(args, ";");
        if ( argv.length == 1 ) argv = getArguments( argv[0] ); 
        if ( !parser.parse( argv ) ) 
            return getMessage("smclient", "invalid_arg");
        setArgs( parser );
        
        String ret = validate().trim();    
        if ( ret.length() > 0 ) return ret;  
         
        return "";
    }

    
    protected void openConnection() throws Exception {
        super.openConnection();
    }


    protected void closeConnection() throws Exception {
        super.closeConnection();
    }

    
    private void changeOwner() {
        StringBuffer xml = new StringBuffer( getHeader("update", "_admin.trees.owner") );
            
        xml.append("<chown recursive='");
        if ( recursive ) xml.append("true"); else xml.append("false");
        xml.append("' verbose='");
        if ( verbose ) xml.append("true"); else xml.append("false");
        xml.append("'>\n");     
        xml.append("  <owner>" + owner + "</owner>\n");
        xml.append("  <doc>" + doc + "</doc>\n");
        xml.append("</chown>\n" + getFooter() );
        executeSEP( xml.toString() );
    }


    public static void main( String[] argv ) {
        SmChown so = new SmChown();
        String pag = so.parseArgs( argv );
        
        if ( pag != "" ) {
            System.out.println( pag );
            System.exit(0);
        }
        
        try {
            so.openConnection();
            so.changeOwner();
            so.closeConnection();
        }
        catch ( Exception e ) {
            System.err.println( "Error: " + e.getMessage() ); 
        }
    }
}
