/*
 * $COPYRIGHT$
 * $Id: SmClient.java,v 1.23 2002/06/03 11:01:57 crow Exp $
 *
 * Date         Author          Changes
 * May 28 2001  Szabo Csaba     Created
 */
       
package org.media.datastore;

import java.util.Properties;
import java.util.StringTokenizer;
import java.io.InputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader; 
import java.io.IOException;
import java.io.Writer;
import java.io.OutputStreamWriter;

import org.media.datastore.sepengine.driver.*;
import org.media.datastore.sepengine.SepInterpreter;
import org.media.datastore.sepengine.util.StringInputStream; 

/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.23 $ $Date: 2001/04/21 15:00:00
 * @see java.lang.String
 */
    
public class SmClient {

    private static final String MESSAGES_RESOURCE_FILE = "res/clientmessages.properties";
    
    protected boolean           help = false;
    protected String            host = "localhost";
    protected String           sport = null;
    protected int               port = 10288;
    protected String          dbname = null;
    protected String            user = "guest";
    protected String          passwd = "guest";
    protected String           stype = null;
    protected SepStoreConnection con = null;
    protected static Properties prop = null;
        
    protected final String opArg = "-?;--help;-h:;--host:;-p:;--port:;-d:;--dbname:;"+
        "-u:;--user:;-P:;--passwd:;-s:;--security:;";
    

    protected SmClient() {
        try {
            InputStream is = null;

            prop = new Properties();
            if ( ( is = getInputStream( MESSAGES_RESOURCE_FILE ) ) == null )
                throw new RuntimeException( "Unable to load resource file: " + 
                                            MESSAGES_RESOURCE_FILE );
            prop.load( is );
        }
        catch ( Exception _e ) {
            prop = null;
            System.err.println( "Error: " + _e.getMessage() );
        } 
        System.setProperty( "sep.drivers", "org.media.datastore.sepengine.driver.beepDriver.BeepDriver");
    }

    
    private InputStream getInputStream( String fileName ) throws Exception {
        Class  _class = Class.forName("org.media.datastore.SmClient");
        return _class.getResourceAsStream( fileName );
    }

    
    protected String getUsage( String fileName ) {
        StringBuffer       sb = new StringBuffer();
        BufferedReader reader = null;
        
        try {
            reader = new BufferedReader( new InputStreamReader( 
							       getInputStream ( fileName ) ) );
            String line;
            while ( ( line = reader.readLine() ) != null ) 
                sb.append ( line + "\n" );
            reader.close();
        }
        catch ( Exception e ) {
            System.err.println( "Unable to load help file : " + fileName );
        }
        
        return sb.toString();
    }

    
    protected String[] getArguments( String str ) {
        StringTokenizer st = new StringTokenizer( str.replace('"', ' ').replace('\'', ' ') );   
        String       arg[] = new String [ st.countTokens() ];
        int          count = 0;
        
        while ( st.hasMoreTokens() ) arg[ count++ ] = st.nextToken();
        
        return arg;
    }

    
    protected void openConnection() throws Exception {
        try {
            String url = "sep:beep://"+host+":"+port+"/"+dbname;
            if ( stype != null ) url += ";security=" + stype;

            con = SepStoreDriverManager.getConnection(url, user, passwd);
        }
        catch ( Exception e ) {
            throw e;
        }
    }

    
    protected void closeConnection() throws Exception {
        try {
            con.close();
        }
        catch ( Exception e ) {
            throw e;
        }

    }

    
    protected void setArgs( ArgParser parser ) {
        String    arg;
            
        arg = parser.getValue("-?");
        if ( ( arg != null && "".equals( arg ) ) ) help = true;
        arg = parser.getValue("--help");
        if ( ( arg != null && "".equals( arg ) )  ) help = true;
        if ( ( arg = parser.getValue("-h:") ) != null || 
             ( arg = parser.getValue("--host:") ) != null ) host   = arg;
        if ( ( arg = parser.getValue("-p:") ) != null || 
             ( arg = parser.getValue("--port:") ) != null ) sport  = arg;
        if ( ( arg = parser.getValue("-u:") ) != null || 
             ( arg = parser.getValue("--user:") ) != null ) user   = arg;
        if ( ( arg = parser.getValue("-P:") ) != null || 
             ( arg = parser.getValue("--passwd:") ) != null ) passwd = arg;
        if ( ( arg = parser.getValue("-d:") ) != null || 
             ( arg = parser.getValue("--dbname:") ) != null ) dbname = arg;
        if ( ( arg = parser.getValue("-s:") ) != null || 
             ( arg = parser.getValue("--security:") ) != null ) stype  = arg;
    }

    
    protected String validate( String usage ) {
        String    ret = "";
            
        if ( stype != null && !stype.equals("jsse") && !stype.equals("ptls") )
            ret += getMessage("smclient", "invalid_security");
        if ( help || dbname == null ) return usage;
        if ( sport != null ) {
            try {
                port = new Integer(sport).intValue();
            } 
            catch (Exception e) {
                ret += getMessage("smclient", "invalid_port") + sport;
            }
        }
        if ( "".equals( host ) )   ret += getMessage("smclient", "invalid_host");
        if ( "".equals( dbname ) ) ret += getMessage("smclient", "invalid_dbname");
        if ( "".equals( user ) )   ret += getMessage("smclient", "invalid_uname");
        if ( "".equals( passwd ) ) ret += getMessage("smclient", "invalid_passwd");
        
                                                                                        
        return ret;
    }

     
    protected void printResult( InputStream is ) {
        StringInputStream toParser = null;
        StringInputStream toWriter = null;
        String    tag = null, root = null;
	
        do {
            tag = getValidToken( _nextToken( is ) );
            if ( tag != null ) tag = tag.replace('<', ' ').trim();
        } while ( tag != null && !tag.toLowerCase().startsWith("response") );
        if ( tag == null ) return;
	
        do {
            tag = getValidToken( _nextToken( is ) );
            if ( tag != null ) tag = tag.replace('<', ' ').trim();
        } while ( tag != null && 
                  !tag.toLowerCase().startsWith("additional") &&
                  !tag.toLowerCase().startsWith("error") && 
                  !tag.toLowerCase().startsWith("block") );
	
        if ( tag.toLowerCase().startsWith("error") ||
             tag.toLowerCase().startsWith("additional") ) {
            if ( tag.indexOf( ' ' ) != -1 ) 
                root = tag.substring(0, tag.indexOf( ' ' ) ).trim();
            else root = tag;
            toParser = new StringInputStream();
            toParser.write ( "<" + tag + ">");
            do {
                tag = _nextToken( is );
                if ( tag == null ) break;
                toParser.write( tag );
                tag = getValidToken( tag ).replace('<', ' ').replace('>', ' ').replace('/', ' ').trim();
            } while ( !tag.equalsIgnoreCase( root ) );

    	    String error =  ( new ResultParser() ).write( toParser.getInputStream() );
    	    if ( error != null ) System.out.println( error );
	    	    
          do {
              tag = getValidToken( _nextToken( is ) );
              if ( tag == null ) return;
              tag = tag.replace('<', ' ').trim();
          } while ( !tag.toLowerCase().startsWith("block") );
        } 
	     
        if ( tag.toLowerCase().startsWith("block") ) {
            toWriter = new StringInputStream();
            boolean firstTag = true;
            boolean freeMode = false;
	    
            do {
                tag = _nextToken( is );
                if ( firstTag && tag.toUpperCase().trim().startsWith("<![CDATA[") ) {
                    System.out.print( tag.trim().substring(9, tag.length() - 3) );
                    freeMode = true;
                    break;
                }
                firstTag = false;
                toWriter.write( tag );
                if ( tag == null ) return;
            } while ( tag.trim().startsWith("<!") || tag.trim().startsWith("<?") );
            
            if ( !freeMode ) {
                root = tag.replace('<', ' ').replace('>', ' ').replace('/', ' ').trim();
                if ( root.indexOf(" ") != -1 ) root = root.substring( 0, root.indexOf(" ") );
                do {
                    tag = _nextToken( is );
                    if ( tag == null ) break;
                    toWriter.write( tag );
                    tag = getValidToken( tag ).replace('<', ' ').replace('>', ' ').replace('/', ' ').trim();
                } while ( !tag.equalsIgnoreCase( root ) );
                printIS( toWriter.getInputStream() );
            }	    
            System.out.print("\n");
        }
    }

    
    protected void executeSEP( String xml ) {
        try {
            printResult( con.executeSEP( xml ) );
        }
        catch ( Exception e ) {
            System.err.println( 
			       getMessage("smclient", "transmission_error") + 
			       e.getMessage() );
        }
    }

    
    protected String getHeader( String action, String subtree ) {
        return "<request reqno='1'>\n<store action='" + action + "'>\n<block name='" + subtree + "'>\n";
    }


    protected String getFooter() {
        return "</block>\n</store>\n</request>";
    }

    
    protected String getMessage( String client_id, String message_id ) {
        if ( prop.getProperty( client_id + "." + message_id ) == null ) {
            System.err.println ("Unable to find " + client_id + "." + message_id  + 
                                " in resource file : " + MESSAGES_RESOURCE_FILE );
            return null;
        }
        else return prop.getProperty(client_id + "." + message_id);    
    }

    
    private String getValidToken ( String token ) {
        if ( token == null ) return null;
	
        int end = token.length(), start = 0;
	
        if ( token.lastIndexOf( '>' ) != -1 ) end = token.lastIndexOf( '>' );
        if ( token.lastIndexOf( '<' , end ) != -1 ) start = token.lastIndexOf( '<' , end );
	
        return token.substring( start, end );
    }
    
    
    private String _nextToken( InputStream is ) {
        StringBuffer result = new StringBuffer();
	
        try {
            int ch = 0;
            
            while( ( ch = is.read() ) != -1 ) {
                result.append( (char)ch );
                if ( ch == '>') {
                    if ( result.toString().trim().startsWith("<!--") ) {
                        if ( result.toString().trim().endsWith("-->") )  
                            return result.toString();
                        else 
                            continue;
                    }
                    else {
                        if ( result.toString().trim().startsWith("<!") )
                            if ( result.toString().indexOf("[") == -1 ) return result.toString();
                            else
                                if ( result.toString().indexOf("[") != -1 &&
                                     result.toString().indexOf("]") != -1) return result.toString();
                                else continue;
                    }
                    return result.toString();
                }
            }
            return null;
        }
        catch ( IOException ioex ) {
            return null;
        }
    }
    
    
    private void printIS( InputStream is ) {
        try {
            BufferedReader reader = new BufferedReader( new InputStreamReader( is ) );
            String           line;
            while ( ( line = reader.readLine() ) != null ) System.out.println( line );
            reader.close();
        }
        catch ( Exception e ) {}
    }
}
