/*
 * $COPYRIGHT$
 * $Id: SmGroup.java,v 1.9 2001/11/19 12:04:31 crow Exp $
 *
 * Date         Author          Changes
 * May 28 2001  Szabo Csaba     Created
 */

package org.media.datastore;

import java.util.StringTokenizer;

/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.9 $ $Date: 2001/04/21 15:00:00
 * @see java.lang.String
 */

public class SmGroup extends SmClient {

    private boolean  addGroup = false;
    private boolean  modGroup = false;
    private boolean  delGroup = false;
    private boolean listGroup = false;
    private String       gname = null;
    private String      ngname = null;
    private String       uname = null;

    protected final String usage = getUsage( "res/smgroupHelp_EN.txt" );
    protected final String  args = opArg + "-add;-mod;-del;-list;--name:;--uname:;";

    
    protected void setArgs( ArgParser parser ) {
        super.setArgs( parser );
        String arg;
        
        if ( "".equals( parser.getValue("-add") ) ) addGroup  = true;
        if ( "".equals( parser.getValue("-mod") ) ) modGroup  = true;
        if ( "".equals( parser.getValue("-del") ) ) delGroup  = true;
        if ( "".equals( parser.getValue("-list") ) ) listGroup = true;
        if ( ( arg = parser.getValue("--uname:") ) != null )  uname = arg;
        if ( parser.getUnparsedArg().size() > 0 ) 
            gname = (String)parser.getUnparsedArg().elementAt(0);
        if ( ( arg = parser.getValue("--name:")  ) != null ) ngname = arg;
    }

    
    protected String validate() {
        String ret = super.validate(usage);
        
        if ( ret != "" ) return ret;
        if ( !( addGroup || modGroup || delGroup || listGroup ) ) return usage;

        if ( "".equals( uname ) ) ret += getMessage("smgroup", "invalid_username");
        if ( "".equals( gname ) ) ret += getMessage("smgroup", "invalid_groupname");
        if ( "".equals( ngname ) ) ret += getMessage("smgroup", "invalid_ngname");

        if ( ( addGroup  && ( modGroup || delGroup || listGroup ) ) ||
             ( modGroup  && ( addGroup || delGroup || listGroup ) ) || 
             ( delGroup  && ( modGroup || addGroup || listGroup ) ) || 
             ( listGroup && ( modGroup || delGroup || addGroup  ) ) ) 
	    ret += getMessage("smgroup", "bad_command");
           
        if ( addGroup && gname == null ) 
            ret += getMessage("smgroup", "gname_needed") + " 'add'.\n";
        if ( modGroup && ( gname == null || ngname == null ) ) 
            ret += getMessage("smgroup", "ngname_needed");
        if ( delGroup && gname == null ) 
            ret += getMessage("smgroup", "gname_needed") + " 'del'.\n";
          
        return ret;
    }


    protected String parseArgs( String[] argv ) {
        ArgParser parser = new ArgParser(args, ";");
        if ( argv.length == 1 ) argv = getArguments( argv[0] ); 
        if ( !parser.parse(argv) ) 
            return getMessage("smclient", "invalid_arg");
        setArgs(parser);
        
        String ret = validate().trim();    
        if ( ret.length() > 0 ) return ret;  
         
        return "";
    }

    
    protected void openConnection() throws Exception {
        super.openConnection();
    }


    protected void closeConnection() throws Exception {
        super.closeConnection();
    }

    
    private void addGroup() {
        StringBuffer xml = new StringBuffer( getHeader("write", "_admin.groups") );
        
        xml.append("<group action='add'>\n");
        xml.append("  <name>" + gname + "</name>\n");
        xml.append("</group>\n" + getFooter() );
        executeSEP( xml.toString() );
    }


    private void modGroup() {
        StringBuffer xml = new StringBuffer( getHeader("update", "_admin.groups") );
            
        xml.append("<group action='mod'>\n");
        xml.append("  <name>" + gname +  "</name>\n");
        xml.append("  <newname>" + ngname + "</newname>\n");
        xml.append("</group>\n" + getFooter() );
        executeSEP( xml.toString() );
    }


    private void delGroup() {
        StringBuffer xml = new StringBuffer( getHeader("delete", "_admin.groups") );
            
        xml.append("<group action='del'>\n");
        xml.append("  <name>" + gname + "</name>\n");
        xml.append("</group>\n" + getFooter() );
        executeSEP( xml.toString() );
    }


    private void listGroup() {
        StringBuffer xml = new StringBuffer( "<request reqno='1'><fetch><union><intersect>" );
        
        xml.append("  <compare subtree='_admin.groups");
        if ( uname != null ) xml.append(".user." + uname);
        if ( gname != null ) xml.append(".group." + gname);
        xml.append("'><path /><value></value></compare>");
        xml.append("</intersect></union></fetch></request>");
        executeSEP( xml.toString() );
    }


    public static void main( String[] argv ) {
        SmGroup sg = new SmGroup();
        String pag = sg.parseArgs( argv );
        
        if ( pag != "" ) {
            System.out.println( pag );
            System.exit(0);
        }
        
        try {
            sg.openConnection();
            if ( sg.addGroup ) sg.addGroup();
            else
                if ( sg.modGroup ) sg.modGroup();
                else 
                    if ( sg.delGroup ) 
                        sg.delGroup();
                    else
                        sg.listGroup();
            sg.closeConnection();
        }
        catch ( Exception e ) {
            System.err.println( "Error: " + e.getMessage() ); 
        }
    }
}
