/*
 * $COPYRIGHT$
 * $Id: SmQuery.java,v 1.22 2001/12/06 14:22:58 crow Exp $
 *
 * Date         Author          Changes
 * May 28 2001  Antal Attila    Created
 */

package org.media.datastore;

import java.io.*;
import java.io.FileReader;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

import org.media.datastore.sepengine.util.StringInputStream;
import org.media.datastore.sepengine.driver.beepDriver.*;

/**
 * @author <a href="mailto:atech@nolimits.ro">Antal Attila </a>
 * @version $Revision: 1.22 $ $Date: 2001/04/21 15:00:00
 * @see java.lang.String
 */

public class SmQuery extends SmClient {

    private int transmitBufferSize = 1024;

    private int         mode = 0;
    private String   sepfile = null;
    private boolean    fetch = false;
    private String   subtree = null;
    private String      path = null;
    private String     value = null;
    private boolean    store = false;
    private String    action = "write";
    private String     block = null;
    private String      file = null;

    protected final String usage = getUsage("res/smqueryHelp_EN.txt");
    protected final String args  = opArg + 
	"-f:;--sepfile:;-fetch;--subtree:;" +
	"--path:;--value:;-store;--action:;" +
	"--block:;--file:";
    

    protected void setArgs( ArgParser parser ) {
        String    arg;
        super.setArgs(parser);

        if ( ( arg = parser.getValue("-f:") ) != null || 
             ( arg = parser.getValue("--sepfile:") ) != null ) sepfile = arg;
        if ( "".equals( parser.getValue("-fetch") ) ) fetch = true;
        if ( ( arg = parser.getValue("--subtree:") ) != null ) subtree = arg;
        if ( ( arg = parser.getValue("--path:") ) != null ) path = arg;
        if ( ( arg = parser.getValue("--value:") ) != null ) value = arg;
        if ( "".equals( parser.getValue("-store") ) ) store = true;
        if ( ( arg = parser.getValue("--action:") ) != null ) action = arg;
        if ( ( arg = parser.getValue("--block:") ) != null ) block = arg;
        if ( ( arg = parser.getValue("--file:") ) != null ) file = arg;
    }
    

    protected String validate() {
        String    ret = super.validate(usage);
        if ( ret != "" ) return ret;
        if ( "".equals( sepfile ) ) ret += getMessage("smquery", "invalid_sepfile");
        if ( "".equals( subtree ) ) ret += getMessage("smquery", "invalid_subtree");
        if ( "".equals( path ) )    ret += getMessage("smquery", "invalid_path");
        if ( "".equals( value ) )   ret += getMessage("smquery", "invalid_value");
        if ( "".equals( action ) )  ret += getMessage("smquery", "invalid_action");
        if ( "".equals( block ) )   ret += getMessage("smquery", "invalid_block");
        if ( "".equals( file ) )    ret += getMessage("smquery", "invalid_file");
        if ( ( fetch || store ) && ( sepfile != null ) ) 
            ret += getMessage("smquery", "sepfile_not_required");
        if ( fetch && store ) ret += getMessage("smquery", "many_command");
        if ( fetch && ( subtree == null ) ) 
            ret += getMessage("smquery", "subtree_needed");
        if ( store && ( block == null) )
            ret += getMessage("smquery", "block_needed");
        if ( !fetch && ( subtree != null || path != null || value != null ) ) 
            ret += getMessage("smquery", "fetch_arg_missing");
        if ( !store && ( block != null || file != null ) )
            ret += getMessage("smquery", "store_arg_missing");

        return ret;
    }


    protected int getMode() {
        int mode = 0;
        
        if ( sepfile == null && !fetch && !store ) mode = 1;
        if ( sepfile != null && !fetch && !store ) mode = 2;
        if ( sepfile == null && fetch ) mode = 3;
        if ( sepfile == null && store ) mode = 4;

        return mode;
    }


    protected String parseArgs( String[] argv ) {
        ArgParser parser = new ArgParser(args, ";");
        if ( argv.length == 1 ) argv = getArguments( argv[0] ); 
        if ( !parser.parse( argv ) ) 
            return getMessage("smclient", "invalid_arg");
        setArgs( parser );
        
        String ret = validate().trim();    
        if ( ret.length() > 0 ) return ret;  
        if ( ( mode = getMode() ) == 0 ) 
            return getMessage("smclient", "invalid_arg");
         
        return "";
    }


    protected void openConnection() throws Exception {
        super.openConnection();
    }
                 

    protected void closeConnection() throws Exception {
        super.closeConnection();
    }


    private void consolMode() {
        sendFromConsol("", "");
    }


    private void fileMode() {
        sendFile(sepfile, "", "");
    }


    private void fetchMode() {
        String   elem = "";
        String attrib = "";
        int     index = 0;
        
        if ( path != null ) {
            index = path.indexOf( "@" );
            if ( index >= 0 ) attrib = path.substring(index+1);
            if ( index >= 0 )   path = path.substring(0,index);
            StringTokenizer t = new StringTokenizer(path, "/");
            while ( t.hasMoreTokens() )
                elem += "<element property='" + t.nextToken() + "'/>";
        }
        if ( attrib.length() > 0 ) 
            attrib = "<path attribute='" + attrib + "'>" + elem + "</path>";
        else {
            if ( elem.length() > 0 )
                attrib = "<path>" + elem + "</path>";
            else 
                attrib = "<path />";
        }
        if ( value == null )   value = "";
        if ( subtree == null ) value = "";
        
        StringBuffer _fetch  = new StringBuffer("<request reqno='1'><fetch><union><intersect>");
        _fetch.append("<compare subtree='" + subtree.trim() + "' operator='contains'>" + attrib);
        _fetch.append("<value>" + value + "</value>");
        _fetch.append("</compare></intersect></union></fetch></request>");
        
        System.err.println( getMessage("smquery", "send_fetch") );
        
        executeSEP( _fetch.toString() );
    }


    private void storeMode() {
        String header = "<request reqno='1'><store action='" + action + "'>\n" + 
	    "<block name='" + block + "'>\n";
        String footer = "</block>\n</store></request>";
        try {
	    if ( action.equalsIgnoreCase("delete") )
	        printResult( ((BeepConnection)con).executeSEP( header + footer ) );
            else if ( file == null ) 
                sendFromConsol(header, footer); 
            else 
                sendFile(file, header, footer);
        }
        catch (Exception e){
            System.err.println( getMessage("smquery", "store_error") );
            System.exit(1);
        }
    }


    private void sendFromConsol( String head, String foot ) {
        StringInputStream sis = new StringInputStream();
        BufferedReader     in = new BufferedReader( new InputStreamReader( System.in ) );
        String line;    
        
        System.err.println( getMessage("smquery", "read_block") );
        
        try {
            sis.write( head );
            while ( ( line = in.readLine() ) != null ) sis.write( line +"\n" );
            sis.write( foot );
            System.err.println( getMessage("smquery", "send_command") );
            printResult( ((BeepConnection)con).executeSEP( sis.getInputStream()) );
        } 
        catch ( Exception e ) {
            System.err.println( getMessage("smquery", "read_error") );
            System.exit(1);
        }
    }


    private void sendFile( String _file , String head, String foot) {
        StringInputStream sis = new StringInputStream();        
        File         fl = new File( _file );
        int        size = 0;
        char[]   buffer = new char[ transmitBufferSize ];
        
        System.err.println("Uploading file " + _file + "..." );
            
        try {
            sis.write( head +"\n");
            BufferedReader in = new BufferedReader( new FileReader(fl) );
            while ( true ) {
                if ( ( size = in.read( buffer, 0, transmitBufferSize ) ) == -1 ) break; 
                sis.write( new String( buffer, 0, size ) );
            }
            sis.write( "\n" + foot );
	    
            printResult( ((BeepConnection)con).executeSEP( sis.getInputStream()) );
        } 
        catch ( Exception e ) {
            System.err.println( getMessage("smquery", "read_error") );
            System.exit(1);
        }
    }


    public static void main( String[] argv ) {
        SmQuery sq = new SmQuery();
        String pag = sq.parseArgs( argv );
        
        if ( pag != "" ) {
            System.err.println( pag );
            System.exit( 0 );
        }
        
        try {
            sq.openConnection();
            switch ( sq.mode ) {
	    case 1:
		sq.consolMode(); 
		break;
	    case 2:
		sq.fileMode(); 
		break;
	    case 3:
		sq.fetchMode(); 
		break;
	    case 4:
		sq.storeMode(); 
		break;
            }
            sq.closeConnection();
        }
        catch ( Exception e ) {
            System.err.println( "Error: " + e.getMessage() ); 
        }
    }
}
