/*
 * $COPYRIGHT$
 * $Id: SmTree.java,v 1.15 2002/05/20 14:03:21 crow Exp $
 *
 * Date         Author          Changes
 * JUL 26 2001  Szabo Csaba     Created
 */

package org.media.datastore;

import java.util.StringTokenizer;

import org.media.datastore.sepengine.SepInterpreter;

/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.15 $ $Date: 2001/07/26 20:00:00
 * @see java.lang.String
 */

public class SmTree extends SmClient {

    private boolean    create = false;
    private boolean    remove = false;
    private boolean      list = false;
    private boolean      copy = false;
    private boolean      move = false;
    private boolean    chType = false;
    private boolean    naming = false;

    private boolean     force = false;
    private boolean    isLong = false;
    private boolean      tree = false;
    private boolean recursive = false;
    private boolean   verbose = false;
    
    private String    subtree = null;
    private String       mode = null;
    private String       flag = null;
    private String        src = null;
    private String       dest = null;

    protected final String usage = getUsage("res/smtreeHelp_EN.txt");
    protected final String args  = opArg + 
        "-create;-remove;-list;-naming;-f;--force;-l;--long;" + 
        "-t;--tree;-copy;-chtype;-R;--recursive;" +
        "-v;--verbose;";
    

    protected void setArgs( ArgParser parser ) {
        super.setArgs( parser );
        String arg;
        
        if ( "".equals( parser.getValue("-create") ) ) create = true;
        if ( "".equals( parser.getValue("-remove") ) ) remove = true;
        if ( "".equals( parser.getValue("-list")   ) ) list = true;
        if ( "".equals( parser.getValue("-copy")   ) ) copy = true;
        if ( "".equals( parser.getValue("-chtype") ) ) chType = true;
        if ( "".equals( parser.getValue("-naming") ) ) naming = true;
 
        if ( "".equals( parser.getValue("-f") ) || 
             "".equals( parser.getValue("--force") ) ) force = true;
        if ( "".equals( parser.getValue("-l") ) || 
             "".equals( parser.getValue("--long") ) ) isLong = true;
        if ( "".equals( parser.getValue("-t") ) || 
             "".equals( parser.getValue("--tree") ) ) tree = true;
        if ( "".equals( parser.getValue("-R") ) || 
             "".equals( parser.getValue("--recursive") ) ) recursive = true;
        if ( "".equals( parser.getValue("-v") ) || 
             "".equals( parser.getValue("--verbose") ) ) verbose = true;
        
        if ( parser.getUnparsedArg().size() == 1 ) {
            subtree = (String)parser.getUnparsedArg().elementAt(0); 
        }
        else if ( parser.getUnparsedArg().size() > 1 ) {
            if ( chType ) {
                mode    = (String)parser.getUnparsedArg().elementAt(0); 
                subtree = (String)parser.getUnparsedArg().elementAt(1); 
            }
            else if ( naming ) {
                flag    = (String)parser.getUnparsedArg().elementAt(0); 
                subtree = (String)parser.getUnparsedArg().elementAt(1); 
            }
            else {
                src  = (String)parser.getUnparsedArg().elementAt(0); 
                dest = (String)parser.getUnparsedArg().elementAt(1); 
            }
        }
    }
    

    protected String validate() {
        String ret = super.validate( usage );
        
        if ( ret != "" ) return ret;
        if ( !( create || remove || list || copy || chType || naming ) ) 
            return usage;

        if ( "".equals( subtree ) ) ret += getMessage("smtree", "invalid_subtree");
        if ( "".equals( src     ) ) ret += getMessage("smtree", "invalid_src");
        if ( "".equals( dest    ) ) ret += getMessage("smtree", "invalid_dest");
        if ( "".equals( mode    ) ) ret += getMessage("smtree", "invalid_mode");
        if ( "".equals( flag    ) ) ret += getMessage("smtree", "invalid_flag");
        
        if ( ( create && ( remove || list   || copy   || chType || naming ) ) ||
             ( remove && ( create || list   || copy   || chType || naming ) ) || 
             ( list   && ( remove || create || copy   || chType || naming ) ) || 
             ( copy   && ( remove || list   || create || chType || naming ) ) ||
             ( chType && ( remove || list   || copy   || create || naming ) ) ||
             ( naming && ( remove || list   || copy   || create || chType ) )  
	     ) ret += getMessage("smtree", "many_command");

        if ( create && subtree == null ) 
            ret += getMessage("smtree", "subtree_needed") + " 'create'.\n";
        if ( remove && subtree == null ) 
            ret += getMessage("smtree", "subtree_needed") + " 'remove'.\n";
        if ( list && subtree == null ) subtree = "/";
        if ( copy && ( src == null || dest == null ) ) 
            ret += getMessage("smtree", "src_dest_missing") + " 'copy'.\n";
        if ( chType && ( subtree == null || mode == null ) ) 
            ret += getMessage("smtree", "subtree_mode_missing");
        if ( naming && ( subtree == null || flag == null ) ) 
            ret += getMessage("smtree", "subtree_flag_missing");
        if ( mode != null && 
             ( !mode.equals("flexible") && !mode.equals("strict") && 
               !mode.equals("free") && !mode.equals("free_tag") )
             ) ret += getMessage("smtree", "mode_unknown");
        if ( flag != null && ( !flag.equals("auto") && !flag.equals("manual") ) ) 
            ret += getMessage("smtree", "flag_unknown");
          
        return ret;
    }


    protected String parseArgs( String[] argv ) {
        ArgParser parser = new ArgParser(args, ";");
        if ( argv.length == 1 ) argv = getArguments( argv[0] ); 
        if ( !parser.parse( argv ) ) 
            return getMessage("smclient", "invalid_arg");
        setArgs( parser );
        
        String ret = validate().trim();    
        if ( ret.length() > 0 ) return ret;  
         
        return "";
    }
    

    protected void openConnection() throws Exception {
        super.openConnection();
    }


    protected void closeConnection() throws Exception {
        super.closeConnection();
    }
    

    private void createSubtree() {
        StringBuffer xml = new StringBuffer( getHeader("write", "_admin.trees") );
            
        xml.append("<tree action='create'>\n");
        xml.append("  <subtree>" + subtree + "</subtree>\n");
        xml.append("</tree>\n" + getFooter() );
        executeSEP( xml.toString() );
    }


    private void removeSubtree() {
        StringBuffer xml = new StringBuffer( getHeader("delete", "_admin.trees") );
            
        xml.append("<tree action='delete' force='" + 
                   (new Boolean( force )).toString() + "'>\n");
        xml.append("  <subtree>" + subtree + "</subtree>\n");
        xml.append("</tree>\n" + getFooter() );
        executeSEP( xml.toString() );
    }


    private void listSubtree() {
        StringBuffer xml = new StringBuffer( getHeader("update", "_admin.trees") );
            
        xml.append("<tree action='list'"+
		   " long='" + (new Boolean( isLong )).toString() + "'" + 
		   " tree='" + (new Boolean( tree )).toString() + "'>\n");
        xml.append("  <subtree>" + subtree + "</subtree>\n");
        xml.append("</tree>\n" + getFooter() );
        executeSEP( xml.toString() );
    }


    private void copySubtree() {
        StringBuffer xml = new StringBuffer( getHeader("write", "_admin.trees") );
        
        xml.append("<tree action='copy'"+ 
		   " recursive='" + (new Boolean( recursive )).toString() + "'" +
		   " verbose='" + (new Boolean( verbose )).toString() + "'>\n");
        xml.append("  <src>" + src + "</src>\n");
        xml.append("  <dest>" + dest + "</dest>\n");
        xml.append("</tree>\n" + getFooter() );
        executeSEP( xml.toString() );
    }


    private void moveSubtree() {
        StringBuffer xml = new StringBuffer( getHeader("write", "_admin.trees") );
        
        xml.append("<tree action='move'"+ 
		   " verbose='" + (new Boolean( verbose )).toString() + "'>\n");
        xml.append("  <src>" + src + "</src>\n");
        xml.append("  <dest>" + dest + "</dest>\n");
        xml.append("</tree>\n" + getFooter() );
        executeSEP( xml.toString() );
    }
    

    private void changeStoreMode() {
        StringBuffer xml = new StringBuffer( getHeader("write", "_admin.trees") );
            
        xml.append("<tree action='chtype'" +
		   " recursive='" + (new Boolean( recursive )).toString() + "'" +
		   " verbose='" + (new Boolean( verbose )).toString() + "'>\n");
        xml.append("  <subtree>" + subtree + "</subtree>\n");
        xml.append("  <src>" + mode + "</src>\n");
        xml.append("</tree>\n" + getFooter() );
        executeSEP( xml.toString() );
    }


    private void setNamingFlag() {
        StringBuffer xml = new StringBuffer( getHeader("write", "_admin.trees") );
            
        xml.append("<tree action='naming'" +
		   " recursive='" + (new Boolean( recursive )).toString() + "'" +
		   " verbose='" + (new Boolean( verbose )).toString() + "'>\n");
        xml.append("  <subtree>" + subtree + "</subtree>\n");
        xml.append("  <src>" + flag + "</src>\n");
        xml.append("</tree>\n" + getFooter() );
        executeSEP( xml.toString() );
    }
    

    public static void main( String[] argv ) {
        SmTree st = new SmTree();
        String pag = st.parseArgs( argv );
        
        if ( pag != "" ) {
            System.err.println( pag );
            System.exit(0);
        }
        
        try {
            st.openConnection();
            
            if ( st.create )      st.createSubtree();
            else if ( st.remove ) st.removeSubtree();
            else if ( st.list )   st.listSubtree();
            else if ( st.copy )   st.copySubtree();
            else if ( st.move )   st.moveSubtree();
            else if ( st.chType ) st.changeStoreMode();
            else st.setNamingFlag();
                            
            st.closeConnection();
        }
        catch ( Exception e ) {
            System.err.println( "Error: " + e.getMessage() );
        }
    }
}
