/*
 * $COPYRIGHT$
 * $Id: SmUser.java,v 1.17 2001/11/19 12:04:31 crow Exp $
 *
 * Date         Author          Changes
 * May 28 2001  Szabo Csaba     Created
 */

package org.media.datastore;

import java.util.StringTokenizer;

import org.media.datastore.sepengine.SepInterpreter;

/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.17 $ $Date: 2001/04/21 15:00:00
 * @see java.lang.String
 */

public class SmUser extends SmClient {

    private boolean  addUser = false;
    private boolean  modUser = false;
    private boolean  delUser = false;
    private boolean listUser = false;
    private boolean   blUser = false;
    private boolean  ublUser = false;
    private String     uname = null;
    private String     lname = null;
    private String      upwd = null;
    private String      home = null;
    private String     group = null;
    private String    groups = null;  

    protected final String usage = getUsage("res/smuserHelp_EN.txt");
    protected final String args  = opArg + 
	"-add;-mod;-del;-list;-block;-ublock;" +
	"--lname:;--pwd:;--home:;--group:;--groups:;";
    

    protected void setArgs( ArgParser parser ) {
        super.setArgs(parser);
        String arg;
        
        if ( "".equals( parser.getValue("-add")    ) ) addUser  = true;
        if ( "".equals( parser.getValue("-mod")    ) ) modUser  = true;
        if ( "".equals( parser.getValue("-del")    ) ) delUser  = true;
        if ( "".equals( parser.getValue("-list")   ) ) listUser = true;
        if ( "".equals( parser.getValue("-block")  ) ) blUser   = true;
        if ( "".equals( parser.getValue("-ublock") ) ) ublUser  = true;
        if ( parser.getUnparsedArg().size() > 0 )
            uname = (String)(parser.getUnparsedArg().elementAt(0));
        if ( ( arg = parser.getValue("--lname:") ) != null )   lname = arg;
        if ( ( arg = parser.getValue("--pwd:") ) != null )      upwd = arg;
        if ( ( arg = parser.getValue("--home:") ) != null )     home = arg;
        if ( ( arg = parser.getValue("--group:") ) != null )   group = arg;
        if ( ( arg = parser.getValue("--groups:") ) != null ) groups = arg;
        if ( group == null && uname != null && !modUser ) group = uname;
    }
    

    protected String validate() {
        String ret = super.validate(usage);
        boolean changed = uname != null || upwd != null || 
	    home != null || group != null || groups != null; 
        
        if ( ret != "" ) return ret;
        if ( !( addUser || modUser || delUser || listUser || blUser || ublUser ) ) 
            return usage;

        if ( "".equals( uname  ) ) ret += getMessage("smuser", "invalid_username");
        if ( "".equals( lname  ) ) ret += getMessage("smuser", "invalid_username");
        if ( "".equals( upwd   ) ) ret += getMessage("smuser", "invalid_passwd");
        if ( "".equals( home   ) ) ret += getMessage("smuser", "invalid_home");
        if ( "".equals( group  ) ) ret += getMessage("smuser", "invalid_group");
        if ( "".equals( groups ) ) ret += getMessage("smuser", "invalid_groups");
        if ( ( addUser  && ( modUser || delUser || listUser || blUser  || ublUser ) ) ||
             ( modUser  && ( addUser || delUser || listUser || blUser  || ublUser ) ) || 
             ( delUser  && ( modUser || addUser || listUser || blUser  || ublUser ) ) || 
             ( listUser && ( modUser || delUser || addUser  || blUser  || ublUser ) ) ||
             ( blUser   && ( modUser || delUser || listUser || addUser || ublUser ) ) ||
             ( ublUser  && ( modUser || delUser || listUser || blUser  || addUser ) ) 
	     ) ret +=  getMessage("smuser", "many_command");
        if ( addUser && uname == null ) 
            ret += getMessage("smuser", "username_missing") + " 'add'.\n";
        if ( modUser && uname == null ) 
            ret += getMessage("smuser", "username_missing") + " 'mod'.\n";
        if ( delUser && uname == null ) 
            ret += getMessage("smuser", "username_missing") + " 'del'.\n";
        if ( blUser  && uname == null ) 
            ret += getMessage("smuser", "username_missing") + " 'block'.\n";    
        if ( ublUser && uname == null )
            ret += getMessage("smuser", "username_missing") + " 'ublock'.\n";    
        if ( modUser && lname != null && !changed  ) 
            ret += getMessage("smuser", "update_data_missing");
          
        return ret;
    }


    protected String parseArgs( String[] argv ) {
        ArgParser parser = new ArgParser(args, ";");
        if ( argv.length == 1 ) argv = getArguments( argv[0] );
        if ( !parser.parse( argv ) ) 
            return getMessage("smclient", "invalid_arg");
        setArgs( parser );
        
        String ret = validate().trim();    
        if ( ret.length() > 0 ) return ret;  
         
        return "";
    }
    

    protected void openConnection() throws Exception {
        super.openConnection();
    }


    protected void closeConnection() throws Exception {
        super.closeConnection();
    }
    

    private void addUser() {
        StringBuffer xml = new StringBuffer( getHeader("write", "_admin.users") );
        
        xml.append("<user action='add'>\n");
        xml.append("  <username>" + uname + "</username>\n");
        if ( upwd != null ) 
            xml.append("  <password>" + upwd + "</password>\n");
        if ( home != null ) 
            xml.append("  <homedir>" + home + "</homedir>\n");
        xml.append("  <group>" + group + "</group>\n");
        if ( groups != null ) {
            xml.append("  <groups>\n");
            StringTokenizer st = new StringTokenizer(groups, ",");
            while ( st.hasMoreTokens() ) 
                xml.append("    <group name='" + st.nextToken() + "' />\n");
	    xml.append("  </groups>\n");
        }
        xml.append("</user>\n" + getFooter() );
        executeSEP( xml.toString() );
    }


    private void modUser() {
        StringBuffer xml = new StringBuffer( getHeader("update", "_admin.users") );
        
        xml.append("<user action='mod'>\n");
        xml.append("  <loginname>" + uname + "</loginname>\n");
        if ( lname != null )    
            xml.append("  <username>" + lname + "</username>\n");
        if ( upwd != null ) 
            xml.append("  <password>" + upwd + "</password>\n");
        if ( home != null ) 
            xml.append("  <homedir>" + home + "</homedir>\n");
        if ( group != null )    
            xml.append("  <group>" + group + "</group>\n");
        if ( groups != null ) {
            xml.append("  <groups>\n");
            StringTokenizer st = new StringTokenizer(groups, ",");
            while ( st.hasMoreTokens() ) 
                xml.append("    <group name='" + st.nextToken() + "' />\n");
	    xml.append("  </groups>\n");
        }
        xml.append("</user>\n" + getFooter() );
        executeSEP( xml.toString() );
    }


    private void delUser() {
        StringBuffer xml = new StringBuffer( getHeader("delete", "_admin.users") );
        
        xml.append("<user action='del'>\n");
        xml.append("  <username>" + uname + "</username>\n");
        xml.append("</user>\n" + getFooter() );
        executeSEP( xml.toString() );
    }


    private void listUser() {
        StringBuffer xml = new StringBuffer( "<request reqno='1'><fetch><union><intersect>\n" );
        
        xml.append("  <compare subtree='_admin.users");
        if ( uname != null ) xml.append("." + uname);
        xml.append("'><path /><value></value></compare>\n");
        xml.append("</intersect></union></fetch></request>\n");
        executeSEP( xml.toString() );
    }


    private void blockUser() {
        StringBuffer xml = new StringBuffer( getHeader("update", "_admin.users") );
        
        xml.append("<user action='block'>\n");
        xml.append("  <username>" + uname + "</username>\n");
        xml.append("</user>\n" + getFooter() );
        executeSEP( xml.toString() );
    }


    private void unblockUser() {
        StringBuffer xml = new StringBuffer( getHeader("update", "_admin.users") );
        
        xml.append("<user action='ublock'>\n");
        xml.append("  <username>" + uname + "</username>\n");
        xml.append("</user>\n" + getFooter() );
        executeSEP( xml.toString() );
    }
    

    public static void main( String[] argv ) {
        SmUser su = new SmUser();
        String pag = su.parseArgs( argv );
        
        if ( pag != "" ) {
            System.err.println( pag );
            System.exit(0);
        }
        
        try {
            su.openConnection();
            if ( su.addUser ) su.addUser();
            else
                if ( su.modUser ) su.modUser();
                else 
                    if ( su.delUser ) su.delUser();
                    else
                        if ( su.listUser ) su.listUser();
                        else
                            if ( su.blUser ) su.blockUser();
                            else su.unblockUser();
            su.closeConnection();
        }
        catch ( Exception e ) {
            System.err.println("Error: " + e.getMessage() );
        }
    }
}
