/*
 * $COPYRIGHT$
 * $Id: Fetch.java,v 1.5 2001/10/02 15:39:16 atech Exp $
 *
 * Date         Author          Changes
 * May 28 2001  Antal Attila    Created
 */

import java.io.InputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader; 

import org.media.datastore.sepengine.driver.beepDriver.*;
import org.media.datastore.sepengine.driver.*;

/**
 * @author <a href="mailto:atech@nolimits.ro">Antal Attila </a>
 * @version $Revision: 1.5 $ $Date: 2001/04/21 15:00:00
 * @see String
 * @see java.net.Socket
 */

public class Fetch {
   
    /*
     * The Datastore core working with BEEP/SEP simple store
     * and fetch commands
     * With the following SEP command can query document from
     * subtree=xmlrpctest where the persons name element first
     * attribute equal with Antal.
     */ 
    
    static SepStoreConnection con = null;

    /*
     * The security option is optional, if use makes safe but slow connection 
     */ 

    static String url = "sep:beep://localhost:10288/XMLDB;security=jsse";
    static String user = "guest";
    static String passwd = "guest";


    /* Querying the person document if only one document has 
     * in subtree xmlrpctest
     * if case of many documents list those documents
     */
    static String sep = "<request reqno='1'><fetch><union><intersect>"+
        "<compare subtree='test'>" +
        "<path attribute='first'><element property='person'/>"+
        "<element property='name'/></path>" +
        "<value>Antal</value></compare>" +
        "</intersect></union></fetch></request>\n";

    public void executeAndList( String _sep ) throws Exception {
        con = SepStoreDriverManager.getConnection(url, user, passwd);
        InputStreamReader response = new InputStreamReader(con.executeSEP(_sep));
        BufferedReader reader = new BufferedReader( response );
        String line = null;
        while ( ( line = reader.readLine() ) != null ) System.out.println(line);
        con.close();
    }

    public static void main( String[] argv ) {
        Fetch fetch = new Fetch();
        try {
            System.setProperty( "sep.drivers",
				"org.media.datastore.sepengine.driver.beepDriver.BeepDriver");

            fetch.executeAndList( sep );

        }
        catch ( Exception e ) {
            System.err.println( "Error: " + e.getMessage() ); 
        }
    }
}
