/*
 * $COPYRIGHT$
 * $Id: Fetch_more.java,v 1.2 2002/05/17 12:36:20 crow Exp $
 *
 * Date         Author          Changes
 * May 28 2001  Antal Attila    Created
 */

import java.io.InputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader; 

import org.media.datastore.sepengine.driver.beepDriver.*;
import org.media.datastore.sepengine.driver.*;

/**
 * @author <a href="mailto:atech@nolimits.ro">Antal Attila </a>
 * @version $Revision: 1.2 $ $Date: 2001/04/21 15:00:00
 * @see String
 * @see java.net.Socket
 */

public class Fetch_more {
   
    /*
     * The Datastore core working with BEEP/SEP simple store
     * and fetch commands
     * With the following SEP command can query document from
     * subtree=xmlrpctest where the persons name element first
     * attribute equal with Antal.
     */ 
    
    static SepStoreConnection con = null;

    /*
     * The security option is optional, if use makes safe but slow connection 
     */ 

    static String url = "sep:beep://localhost:10288/XMLDB;security=jsse";
    static String user = "guest";
    static String passwd = "guest";


    /*
     * Querying the first person document from the xmlrpctest subtree
     */
    static String sep = "<request reqno='1'><fetch><union><intersect>" +
        "<compare subtree='test/1'>" +
        "<path/><value></value></compare>" +
        "</intersect></union></fetch></request>\n";


    public void executeAndList( String _sep ) throws Exception {
        con = SepStoreDriverManager.getConnection(url, user, passwd);
        InputStreamReader response = new InputStreamReader(con.executeSEP(_sep));
        BufferedReader reader = new BufferedReader( response );
        String line = null;
        while ( ( line = reader.readLine() ) != null ) System.out.println(line);
        con.close();
    }
    
    public static void main( String[] argv ) {
        Fetch_more fetch = new Fetch_more();
        try {
            System.setProperty( "sep.drivers",
				"org.media.datastore.sepengine.driver.beepDriver.BeepDriver");

            fetch.executeAndList( sep );

        }
        catch ( Exception e ) {
            System.err.println( "Error: " + e.getMessage() ); 
        }
    }
}
