/*
 * $COPYRIGHT$
 * $Id: Store.java,v 1.3 2001/09/25 12:21:09 crow Exp $
 *
 * Date         Author          Changes
 * May 28 2001  Antal Attila    Created
 */

import java.io.InputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader; 

import org.media.datastore.sepengine.driver.beepDriver.*;
import org.media.datastore.sepengine.driver.*;

/**
 * @author <a href="mailto:atech@nolimits.ro">Antal Attila </a>
 * @version $Revision: 1.3 $ $Date: 2001/04/21 15:00:00
 * @see String
 * @see java.net.Socket
 */

public class Store {

    /*
     * The Datastore core working with BEEP/SEP simple store
     * and fetch commands
     * With the following SEP command can store the person document
     * into the subtree xmlrpctest.
     */ 

    static SepStoreConnection con = null;

    /*
     * The security option is optional, if use makes safe but slow connection 
     */ 

    static String url = "sep:beep://localhost:10288/XMLDB;security=jsse";
    static String user = "guest";
    static String passwd = "guest";

    static String sep = "<request reqno='1'><store action='write'>"+
	"<block name='test'>" +
	"<person>\n"+
	"   <name first='Antal' last='Attila'/>\n"+ 
	"   <occupation>developer</occupation>\n"+ 
	"   <email>atech@nolimits.ro</email>\n"+ 
	"</person>"+
	"</block>" +
	"</store></request>\n";
    
    public static void main( String[] argv ) {
	try {
	    
	    System.setProperty( "sep.drivers",
                "org.media.datastore.sepengine.driver.beepDriver.BeepDriver");
	    con = SepStoreDriverManager.getConnection(url, user, passwd);

	    InputStreamReader response = new InputStreamReader(con.executeSEP(sep));
	    BufferedReader reader = new BufferedReader( response );

	    String line = null;
	    while ( ( line = reader.readLine() ) != null )
	        System.out.println(line);

	    con.close();
	}
	catch ( Exception e ) {
	    System.err.println( "Error: " + e.getMessage() ); 
	}
    }
}
