import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Vector;

import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

public class SepFetch {

    public static void main(String args[]) {

        /*
         * The Datastore core working with XML-RPC/SEP simple store
         * and fetch commands
         * With the following SEP command can query document from
         * subtree=xmlrpctest where the persons name element first
         * attribute equal with Antal.
         */ 


        /* Querying the person document if only one document has 
         * in subtree xmlrpctest
         * if case of many documents list those documents
         */


        String sep1 = "<request reqno='1'><fetch><union><intersect>"+
            "<compare subtree='xmlrpctest'>" +
            "<path attribute='first'><element property='person'/>"+
            "<element property='name'/></path>" +
            "<value>Antal</value></compare>" +
            "</intersect></union></fetch></request>\n";

        try {
            XmlRpcClient client = new XmlRpcClient("http://localhost:10300/");
            Vector params = new Vector();
			// SEP string
            params.addElement(sep1);
			// database name
            params.addElement("XMLDB");
			// user name
            params.addElement("guest");
			// user password
            params.addElement("guest");
            String result = (String) client.execute("sep.execute", params);
            System.out.println(result);
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (XmlRpcException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }


        // Querying the first person document from the xmlrpctest subtree
        String sep2 = "<request reqno='1'><fetch><union><intersect>" +
            "<compare subtree='xmlrpctest/1'>" +
            "<path/><value></value></compare>" +
            "</intersect></union></fetch></request>\n";

        try {
            XmlRpcClient client = new XmlRpcClient("http://localhost:10300/");
            Vector params = new Vector();
            params.addElement(sep2);
            params.addElement("XMLDB");
            params.addElement("guest");
            params.addElement("guest");
            String result = (String) client.execute("sep.execute", params);
            System.out.println(result);
        } catch (MalformedURLException e) {
            e.printStackTrace();
        } catch (XmlRpcException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
