import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Vector;

import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

public class SepStore {

    public static void main(String args[]) {

        /*
         * The Datastore core working with XML-RPC/SEP simple store
         * and fetch commands
         * With the following SEP command can store the person document
         * into the subtree xmlrpctest.
         */ 

	String sep = "<request reqno='1'><store action='write'>"+
	    "<block name='xmlrpctest'>" +
	    "<person>\n"+
	    "   <name first='Antal' last='Attila'/>\n"+ 
	    "   <occupation>developer</occupation>\n"+ 
	    "   <email>atech@nolimits.ro</email>\n"+ 
	    "</person>"+
	    "</block>" +
	    "</store></request>\n";

	try {
	    XmlRpcClient client = new XmlRpcClient("http://localhost:10300/");
	    Vector params = new Vector();
		// SEP string
	    params.addElement(sep);
		// database name
	    params.addElement("XMLDB");
		// user name
	    params.addElement("guest");
		// user password
	    params.addElement("guest");
	    String result = (String) client.execute("sep.execute", params);
	    System.out.println(result);
	} catch (MalformedURLException e) {
	    e.printStackTrace();
	} catch (XmlRpcException e) {
	    e.printStackTrace();
	} catch (IOException e) {
	    e.printStackTrace();
	}
    }
}
