<?php
    $stack      = array();

    $first_name = "";
    $last_name  = "";
    $work_phone = "";
    $home_phone = "";
    $cell_phone = "";
    $home_email = "";
    $work_email = "";
    $home_addr  = "";
    $work_addr  = "";
    
    $type       = "";
    $xml        = "";
    $skiped     = true;
    
    function get_info_from_xml( $parser, $data ) {
	global $stack, $type, $xml, $skiped,
	       $first_name, $last_name, 
	       $work_phone, $home_phone, $cell_phone,
	       $work_email, $home_email,
	       $work_addr,  $home_addr;
	       
	
	array_push( $stack, "");	
	$type = "";
	$xml  = "&lt;?xml version='1.0'?&gt;<br>";
	$skiped = true;
	
	$first_name = "";
	$last_name  = "";
	$work_phone = "";
	$home_phone = "";
	$cell_phone = "";
	$home_email = "";
	$work_email = "";
	$home_addr  = "";
	$work_addr  = "";

	if ( !xml_parse($parser, $data, false) ) {
	    return (false);
	}
	return (true);
    }
    
    function element_start ( $parser, $name, $attrs ) {
	global $stack, $type, $xml, $skiped;
	
	array_push( $stack, $name );
	
	if ( !$skiped ) 
	    $xml .= "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;".
	            "&lt;".strtolower($name);
		    
	if ( sizeof( $attrs ) ) {
	    while ( list( $k, $v ) = each ( $attrs ) ) {
		if ( strtolower( $k ) == "type" ) $type = $v;
		if ( !$skiped ) $xml .= " ".strtolower($k)."='".$v."'";	
	    }
	}
	if ( !$skiped ) $xml .= "&gt;";
	
	if ( strtolower( $name ) == "person" ) {
	    $skiped = false;
	    $xml .= "&lt;".strtolower($name)."&gt;";
	}
    }
    
    function element_stop ( $parser, $name ) {
	global $stack, $xml, $skiped;
	
	$pname = $stack[ count($stack) - 1 ];
	
	if ( $name == $pname ) {
	    if ( strtolower ( $name ) == "person" ) {
		$skiped = true;
		$xml .= "<br>&lt;/".strtolower($name)."&gt;";
	    }
	    if ( !$skiped ) $xml .= "&lt;/".strtolower($name)."&gt;";

	    array_pop( $stack );
	}
	else {
	    return (false);
	}
    }
    
    function data_char ( $parser, $data ) {
	global $stack, $type, $xml, $skiped, 
	       $first_name, $last_name, 
	       $work_phone, $home_phone, $cell_phone,
	       $work_email, $home_email,
	       $work_addr,  $home_addr;

	$pname = $stack[ count($stack) - 1 ];
	
	if ( !$skiped ) $xml .= $data;
	
	if ( strtolower( $pname ) == "lname" ) $last_name  = trim( $data );
	if ( strtolower( $pname ) == "fname" ) $first_name = trim( $data );
	if ( strtolower( $pname ) == "phone" ) {
	    if ( strtolower( $type ) == "work" ) $work_phone = trim( $data );
	    if ( strtolower( $type ) == "home" ) $home_phone = trim( $data );
	    if ( strtolower( $type ) == "cell" ) $cell_phone = trim( $data );
	}
	if ( strtolower( $pname ) == "email" ) {
	    if ( strtolower( $type ) == "work" ) $work_email = trim( $data );
	    if ( strtolower( $type ) == "home" ) $home_email = trim( $data );
	}
	if ( strtolower( $pname ) == "address" ) {
	    if ( strtolower( $type ) == "work" ) $work_addr = trim( $data );
	    if ( strtolower( $type ) == "home" ) $home_addr = trim( $data );
	}
    }
?>