/*
 * $COPYRIGHT$
 * $Id: BeepLog.java,v 1.5 2001/11/29 17:32:14 atech Exp $
 *
 * Date         Author          Changes
 * May 28 2001  Antal Attila    Created
 */
      
package org.media.datastore.beepserver;

import org.beepcore.beep.util.Log;
import org.beepcore.beep.util.LogService;
import org.media.datastore.beepserver.BeepServer;
import org.apache.avalon.framework.logger.Logger;
import org.apache.log.Priority;

/**
* @author <a href="mailto:atech@nolimits.ro">Antal Attila </a>
* @version $Revision: 1.5 $ $Date: 2001/04/21 15:00:00
* @see org.beepcore.beep.util.Log
* @see org.beepcore.beep.util.LogService
*/


public class BeepLog  implements LogService {

    private int severity;
    private Logger logger = BeepServer.BEEPLOGGER;
    private boolean toScreen = false;


    public BeepLog() {
	this.severity = Log.SEV_ERROR;
        Log.setLogService(this);
    }


    public BeepLog(int severity) {
        this.severity = severity;
        Log.setLogService(this);
    }
    

    public boolean isLogged(int sev) {
	return this.severity >= sev;
    }


    public void logEntry(int sev, String service, String message) {
        if (sev > this.severity) {
            return;
        }
        String name = Thread.currentThread().getName();
	if (toScreen) 
	    System.out.println(name + ":" + service + ": " + message);
	else
	    logger.info(name + ":" + service + ": " + message);
    }


    public void logEntry(int sev, String service, Throwable exception) {
        if (sev > this.severity) {
            return;
        }
        String name = Thread.currentThread().getName();
	if (toScreen) {
	    System.out.println(name + ":" + service + ": " + exception.toString());
	    exception.printStackTrace();
	}
	else
	    logger.error(name + ":" + service + ": " + exception.toString());
    }
    

    public void setSeverity(int severity) {
       this.severity = severity;
    }

    
    public void selectTarget() {
	if ( logger == null )  toScreen = true;
//	else logger.setPriority( Priority.DEBUG );
    }

    
    public void startLogging( String severity ) {
	String s = severity.toUpperCase();
	if (s.equals("ALERT"))
	    setSeverity( Log.SEV_ALERT );
	else if (s.equals("CRITICAL"))
	    setSeverity( Log.SEV_CRITICAL );
	else if (s.equals("DEBUG"))
	    setSeverity( Log.SEV_DEBUG );
	else if (s.equals("VERBOSE"))
	    setSeverity( Log.SEV_DEBUG_VERBOSE );
	else if (s.equals("EMERGENCY"))
	    setSeverity( Log.SEV_EMERGENCY );
	else if (s.equals("ERROR"))
	    setSeverity( Log.SEV_ERROR );
	else if (s.equals("INFORMATIONAL"))
	    setSeverity( Log.SEV_INFORMATIONAL );
	else if (s.equals("NOTICE"))
	    setSeverity( Log.SEV_NOTICE );
	else if (s.equals("WARNING"))
	    setSeverity( Log.SEV_WARNING );
	else 
	    setSeverity( Log.SEV_ERROR );
	selectTarget();
    }
}
