/*
 * $COPYRIGHT$
 * $Id: BeepServer.java,v 1.17 2001/11/29 17:32:14 atech Exp $
 *
 * Date         Author          Changes
 * May 28 2001  Antal Attila    Created
 */
 
package org.media.datastore.beepserver;

import org.apache.avalon.framework.configuration.*;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.phoenix.Block; 

import java.util.Hashtable;
import java.util.Enumeration;
import java.net.InetAddress;
import java.util.Vector;
import java.security.*;
import javax.naming.*;

import org.beepcore.beep.core.*;
import org.beepcore.beep.util.*;
import org.beepcore.beep.transport.tcp.*;
import org.beepcore.beep.profile.*;
import org.beepcore.beep.profile.tls.*;
import org.beepcore.beep.profile.tls.jsse.*;
import org.beepcore.beep.profile.tls.ptls.*;
import org.beepcore.beep.profile.sasl.*;
import org.beepcore.beep.profile.sasl.anonymous.*;
import org.beepcore.beep.profile.sasl.otp.*;
import org.beepcore.beep.profile.sasl.otp.database.*;

import org.media.datastore.sepengine.RDBInfo;
import org.media.datastore.sepengine.UserInfo;
import org.media.datastore.sepengine.SepInterpreter;
import org.media.datastore.sepengine.util.SepADMDBHandler;
import org.media.datastore.sepengine.LexiconManager;


/**
 * @author <a href="mailto:atech@nolimits.ro">Antal Attila </a>
 * @version $Revision: 1.17 $ $Date: 2001/04/21 15:00:00
 * @see org.apache.avalon.phoenix.Block
 * @see org.apache.avalon.framework.configuration.Configurable
 * @see org.apache.avalon.framework.activity.Startable
 * @see org.apache.avalon.phoenix.Block
 */


public class BeepServer extends AbstractLogEnabled 
    implements Block, Configurable, Startable {

    public static Logger BEEPLOGGER; 
    int port = 10288;
    ListenThread listener;
    private Hashtable conf = new Hashtable();
    private static boolean     isUpLM = false;
    private static boolean autoCommit = true;
    private boolean beepLog = false;


    public static void setLexiconManagerState( boolean state ) {
        isUpLM = state;
    }

    
    public static boolean lexiconManagerIsUp() {
        return isUpLM;
    }

    
    public static void setAutoCommit( boolean flag ) {
        autoCommit = flag;
    }

    
    public static boolean isAutoCommit() {
        return autoCommit;
    }


    public void configure( final Configuration configuration )
        throws org.apache.avalon.framework.configuration.ConfigurationException {


        Configuration[] allChildrens;
        Configuration[] prfChildrens = null;
        Configuration[] pemChildrens = null;
        Vector profiles = new Vector();
        String tagName = "";

	getLogger().info("BEEP server configuration started...");

        try {
            allChildrens  = configuration.getChildren();
            for (int cx = 0; cx < allChildrens.length; cx++ ) {
                tagName = allChildrens[cx].getName();
                if ( tagName.equalsIgnoreCase("connection") ) {
                    conf.put( "port", allChildrens[cx].getAttribute("port") );
                    conf.put( "host", allChildrens[cx].getAttribute("host") );
                }
                if ( tagName.equalsIgnoreCase("beepLog") ) {
                    beepLog = true;
                    conf.put( "beepLog_severity", allChildrens[cx].getAttribute("severity") );
                    conf.put( "beepLog_target", allChildrens[cx].getAttribute("target") );
                }
                if ( tagName.equalsIgnoreCase("loadprofile") ) {
		    Configuration[] load = allChildrens[cx].getChildren();
		    for (int lx = 0; lx < load.length; lx++ ) {
			profiles.addElement(load[lx].getAttribute("profile"));
		    }
                    conf.put( "profiles", profiles );
                }
                if ( tagName.equalsIgnoreCase("sslprovider") ) {
                    conf.put( "provider", allChildrens[cx].getAttribute("name") );
                }
                if ( tagName.equalsIgnoreCase("profiles") ) {
                    prfChildrens  = allChildrens[cx].getChildren();
                }
                if ( tagName.equalsIgnoreCase("pem") ) {
                    pemChildrens  = allChildrens[cx].getChildren();
                }
            }
            String suffix = "profile_";
            for ( int cy = 0; cy < profiles.size(); cy++) {
                String vectorName = ( String ) profiles.get(cy);
                for (int cxy = 0; cxy < prfChildrens.length; cxy++) {
                    tagName = prfChildrens[cxy].getName();
                    if ( tagName.equalsIgnoreCase(vectorName) ) {
                        String putName = suffix + tagName;
                        ProfileParams pp = new ProfileParams();
                        pp.className =  prfChildrens[cxy].getAttribute("class");
                        pp.classUri  =  prfChildrens[cxy].getAttribute("uri");
                        conf.put( putName, pp );
                    }
                }
            }
            for (int cz = 0; cz < pemChildrens.length; cz++ ) {
                tagName = pemChildrens[cz].getName();
                if ( tagName.equalsIgnoreCase("ciphersuite") ) {
                    conf.put( "pem_cipher", pemChildrens[cz].getAttribute("type") );
                }
                if ( tagName.equalsIgnoreCase("privatekey") ) {
                    conf.put( "pem_prvkey", pemChildrens[cz].getAttribute("filename"));
                    conf.put( "pem_prvtyp", pemChildrens[cz].getAttribute("type"));
                    conf.put( "pem_prvpsw", pemChildrens[cz].getAttribute("password"));
                }
                if ( tagName.equalsIgnoreCase("certificates") ) {
                    conf.put( "pem_cerfile", pemChildrens[cz].getAttribute("filename"));
                    conf.put( "pem_certrus", pemChildrens[cz].getAttribute("rootfilename"));
                }
            }
        } 
        catch ( Exception e ) { 
	    getLogger().warn("BEEP server configuration error:" + e.getMessage() );
            System.err.println("BEEP server configuration error: " + e.getMessage() );
        }
	getLogger().info("BEEP server configuration done.");
    }


    public void start() throws Exception {
        validateDataBase();
        synchronizeUsers();
        listener = new ListenThread( port, register() );
        Thread listenerThread = new Thread(listener);
	getLogger().info("BEEP server is operational...");
        System.err.println("BEEP server is operational...");
	
	String target = (String) conf.get("beepLog_target");
	if ( "file".equals(target) ) BEEPLOGGER = getLogger();
	   else BEEPLOGGER = null;
	if ( beepLog ) {
	    BeepLog log = new BeepLog();
	    log.startLogging( (String) conf.get("beepLog_severity") );
	}
	
        listenerThread.start();
    }


    public void stop() throws Exception {
        System.err.println("BEEP server is down.");
	getLogger().info("BEEP server is down");
        listener.setShutDown(true);
    }


    private class ListenThread implements Runnable {
        private boolean _shutDown = false;
        private int _port;
        private ProfileRegistry _reg;


        ListenThread( int port, ProfileRegistry reg ) {
            _reg  = reg;
            _port = port;
        }
        

        public void setShutDown( boolean shutDown ) {
            _shutDown = shutDown;
        }
        

        public boolean isShutDown() {
            return _shutDown;
        }
        

        public void run() {
            try {
                while ( !isShutDown() ) {
                    AutomatedTCPSessionCreator.listen( _port, _reg );
                }
            } 
            catch ( Exception e ) {
		getLogger().error( "Error starting BEEP server: " + e.getMessage() );
            }
        }    
    }




    private void validateDataBase() throws Exception {
        System.err.print("Validate transactions .... ");
        ( new LexiconManager() ).runLexiconManager( true );
        System.err.println("done");
    }
    

    private void synchronizeUsers() throws Exception {
        Hashtable env = new Hashtable();
        env.put(Context.INITIAL_CONTEXT_FACTORY, "org.media.datastore.naming.StaticMemoryContextFactory");

        try {                                                                                                                                             
            Context ctx = new InitialContext( env );
            NamingEnumeration nen = ctx.list( "system/datasources/" );
                                                 
            while ( nen.hasMore() ) {
                String sepDBName = ( (NameClassPair)nen.next() ).getName();
                RDBInfo rdbInfo  = (RDBInfo)ctx.lookup("system/datasources/" + sepDBName);
                
                if ( rdbInfo != null ) {
		    SepInterpreter si = new SepInterpreter();
                    SepADMDBHandler handler = new SepADMDBHandler( rdbInfo , "root", si );
                    for ( Enumeration e = handler.getUsers().elements(); e.hasMoreElements(); ) {
                        UserInfo ui = (UserInfo)e.nextElement();
                        

                        (new UserDatabasePool()).addUser( sepDBName + "_" + ui.getUserName(), 
                                                          si.getHashMethod(), 
                                                          si.getPasswdHash( ui.getPassword() ), 
                                                          si.getSeed(), si.getSeq() );
                    } 
                }
            }
        } 
        catch ( Exception e ) {
            throw new Exception("Error synchronizing users." + e.getMessage() );
        }
    }
    

    private ProfileRegistry chooseTls( ProfileParams pp, ProfileRegistry preg ) {
        ProfileConfiguration cfg = new ProfileConfiguration();
        String providerName = ( String ) conf.get("provider");
        String profileClass = pp.className;
        String profileUri = pp.classUri;

        try {
            Security.addProvider( (Provider) Class.forName( providerName ).newInstance() );
            if ( profileClass.indexOf("TLSProfileJSSE") > -1 ) {
                TLSProfile tls = TLSProfile.getInstance( profileClass );
                preg.addStartChannelListener(profileUri, tls.init(profileUri, cfg), null );
            } 
            else 
                if ( profileClass.indexOf("TLSProfilePureTLSPemInit") > -1 ) {
                    TLSProfilePureTLSPemInit tls = new TLSProfilePureTLSPemInit();
                    cfg.put( tls.PROPERTY_CIPHER_SUITE,           conf.get("pem_cipher") );
                    cfg.put( tls.PROPERTY_PRIVATE_KEY,            conf.get("pem_prvkey") );
                    cfg.put( tls.PROPERTY_PRIVATE_KEY_TYPE,       conf.get("pem_prvtyp") );
                    cfg.put( tls.PROPERTY_PRIVATE_KEY_PASSPHRASE, conf.get("pem_prvpsw") );
                    cfg.put( tls.PROPERTY_CERTIFICATES,           conf.get("pem_cerfile") );
                    cfg.put( tls.PROPERTY_TRUSTED_CERTS,          conf.get("pem_certrus") );
                    preg.addStartChannelListener(profileUri, tls.init(profileUri, cfg), null );
                }
                else {
                    System.err.println("Profile " + profileClass + " is not implemented!" );
                }
        } 
        catch ( Exception e ) {
            System.err.println("TLS Profile error:" + e.getMessage() );
        }

        return preg;
    }
    

    private ProfileRegistry register() {
        ProfileRegistry reg = new ProfileRegistry();
        String profileName  = "";
        String profileClass = "";
        String profileUri   = "";
        ProfileParams pp;
        
        try {
            Vector profiles = ( Vector ) conf.get("profiles");
	    Profile p;
           
            for ( int cx = 0; cx < profiles.size(); cx++ ) {
                profileName ="profile_" + ( String )profiles.get(cx);
                pp = (ProfileParams) conf.get( profileName );
                profileClass = pp.className;
                profileUri   = pp.classUri;

                if ( profileClass.indexOf("SASLOTP") > -1 ) {
                    SASLOTPProfile sop = 
                        (SASLOTPProfile)Class.forName(profileClass).newInstance();
                    reg.addStartChannelListener( profileUri, sop.init( null, null ), null );
                }
                else {
                    if ( profileClass.indexOf("SASLAnonymous") > -1 ) {
                        SASLAnonymousProfile sap =
                            (SASLAnonymousProfile)Class.forName(profileClass).newInstance();
                        reg.addStartChannelListener( profileUri, sap.init( null, null ), null );
                    }
                    else {
                        if ( profileClass.indexOf("TLS") > -1 ) {
                            reg = chooseTls( pp, reg );
                        }
                        else {
                            p = (Profile) Class.forName(profileClass).newInstance();
			    reg.addStartChannelListener( profileUri,
                                             p.init( profileUri, new ProfileConfiguration() ),
                                             null );
                        }
                    }
                }
		getLogger().info("BEEP profile: " + profileClass + " loaded." );

            }
        } 
        catch ( Exception e ) {
	    getLogger().warn("BEEP profiles registration error: " + e.getMessage() );
            System.err.println("BEEP profiles registration error: " +e.getMessage() );
        }

        return reg;
    }


    private class ProfileParams {
        String className;
        String classUri;
        ProfileParams() {
        }
    }
}
