/*
 * $COPYRIGHT$
 * $Id: SEPprofile.java,v 1.21 2002/05/31 21:05:58 crow Exp $
 *
 * Date         Author          Changes
 * JUL 11 2001  Szabo Csaba     Created
 * Oct 01 2001  Antal Attila    Modified
 */

package org.media.datastore.beepserver;

import java.io.ByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Hashtable;
import javax.naming.*;

import org.media.datastore.sepengine.SepInterpreter;
import org.media.datastore.sepengine.driver.*;
import org.media.datastore.sepengine.util.StringInputStream;

import org.beepcore.beep.core.*;
import org.beepcore.beep.profile.*;
import org.beepcore.beep.util.*;
import org.beepcore.beep.profile.sasl.otp.*;
import org.beepcore.beep.profile.sasl.otp.database.*; 
import org.media.datastore.sepengine.LogManager;

/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.21 $ $Date: 2001/08/15 15:00:00
 * @see java.lang.String
 * @see org.beepcore.beep.core.Channel
 * @see org.beepcore.beep.core.Session
 * @see java.io.InputStream
 */
    
public class SEPprofile
    implements Profile, StartChannelListener, MessageListener {
    
    private static final int BUFFER_SIZE = 1024;
    public  static final String      URI ="http://spacemapper.sf.net/profiles/SEP";
    
    private Hashtable           sessions = new Hashtable(); 
    private boolean        firstInstance = true;
    private SepStoreConnection    sepCon;
    private static String        sepUser = "guest";
    private static String      sepPasswd = "guest";
    private static StringInputStream sis = null;
    private static BufferedReader reader = null;
    private static int         sessionNr = 0;
    private static String          order = "ASC";

    public static int getSessionNr() {
        return sessionNr;
    }
    
 
    public static void setOrder( String or ) {
        order = or;
    }
		   
		   
    public static String getOrder() {
        return order;
    }
				  
				  
    public boolean advertiseProfile( Session session ) {
        return true;
    }


    public StartChannelListener init( String uri, ProfileConfiguration config )
        throws BEEPException {
        return this;
    }


    public void startChannel( Channel channel, String encoding, String data )
        throws StartChannelException {

        sepUser   = channel.getSession().getPeerCredential().getAuthenticator();
        sessionNr = channel.getSession().hashCode();
        
        if ( !sessions.containsKey( sessionNr+"" ) ) { 
            sessions.put(sessionNr+"", sepUser);
            firstInstance = true;
        } 
        
        try {
            sepPasswd = MyOTPProfile.getUser(sepUser).getLastHashAsString();
            channel.setDataListener(this);
            order = "ASC";
            sis   = new StringInputStream();
        }
        catch ( Exception e ) {
            try {
                LogManager.getReference().message("warn",
                                                  "sep_profile_sec_password",
                                                   e.getMessage() );
                channel.sendERR( 500, "Invalid User or Database name!\n");
                channel.close();
            } 
            catch ( Exception _e ) {
                LogManager.getReference().message("error",
                                                  "channel_close_error",
                                                  _e.getMessage() );
            }
        }
    }


    public void closeChannel( Channel channel ) 
        throws CloseChannelException {
            channel.setDataListener( null );
            channel.setAppData( null );
    }


    public void receiveMSG( Message message ) 
        throws BEEPError, AbortChannelException {
        new ReplyThread(message).start();
    }
    

    private String streamToString( InputStream is ) {
        StringBuffer sb = new StringBuffer();
        int ch;
        
        try {       
            while ( ( ch = is.read() ) != -1 ) sb.append( (char)ch );
        } 
        catch ( Exception e ) {
            LogManager.getReference().message("warn","sep_profile_stream",
					      ": " + e.getMessage() );
        }
        
        return sb.toString();
    }
    

    private String getDBName( InputStream is ) {
        String sepDB = null;
        String  mess = streamToString(is);

        if ( !mess.startsWith("SEP:") ) return null;
                    
        if ( mess.indexOf(":") > mess.length() - 2 ) {
            Hashtable env = new Hashtable();
            env.put(Context.INITIAL_CONTEXT_FACTORY,
                    "org.media.datastore.naming.StaticMemoryContextFactory");
            try {           
                Context ctx = new InitialContext(env);
                NamingEnumeration nen = ctx.list("system/datasources/");
                while( nen.hasMore() ) {
                    if ( sepDB == null ) 
                        sepDB = ((NameClassPair)nen.next()).getName();
                    else
                        sepDB = null;
                }
            }
            catch ( Exception e ) {
                LogManager.getReference().message("error",
                                                  "sep_profile_dbname",
                                                  ": " + e.getMessage() );
            }
        }    
        else {
            sepDB = mess.substring( mess.indexOf(":") + 1 );
        }
        return sepDB;
    }


    private class ReplyThread extends Thread {
        private Message _message;

        ReplyThread( Message message) {
            _message = message;
        }


        public void run() {
            try {
                DataStream  ds = _message.getDataStream();
                InputStream is = ds.getInputStream();
                InputStream response = null;
            
                if ( is.available() > 0 ) {
                    if ( firstInstance ) {
                        String sepDB = getDBName ( is );
                         if ( sepDB != null && sepUser != null && sepPasswd != null ) {
                            try {
                                sepCon = SepStoreDriverManager.getConnection("sep:local:" +
                                                               sepDB, sepUser, sepPasswd);
                                firstInstance = false;
                                _message.sendRPY( new StringDataStream(
                                     "<response reqno='0'><additional><info code=\"0\">\n" +
                                     "You are connected to BEEP server!\n"+
                                     "</info></additional></response>\n" ) );
                            }
                            catch ( Exception _ex ) {
                                _message.sendERR( 500,
                                                  "Connection failed to BEEP server! " +
                                                   _ex.getMessage() +"\n" );
                            }
                        }
                        else {
                            _message.sendERR( 500,
                             "Connection failed to BEEP server! Incorect database name.\n" );
                        }
                    }
                    else {
                        response = sepCon.executeSEP( is );
                        if ( response != null ) 
                            _message.getChannel().sendRPY(
                                                          new InputStreamDataStream( response,
                                                                                     response.available() ) ); 
                    }
                }	
            } 
            catch ( Exception e ) {
                LogManager.getReference().message("error",
                                                  "sep_profile_receive_msg",
                                                  ": " + e.getMessage());
            }
        }
    }
}
