/* 
 * $COPYRIGHT$
 * $Id: StaticMemoryContextFactory.java,v 1.6 2002/05/08 12:30:22 crow Exp $
 *
 * Date        Author            Changes 
 * May 20 2001 Remus Pereni      Created
 */

package org.media.datastore.naming;

import org.media.naming.*;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.CompositeName;
import javax.naming.NotContextException;
import javax.naming.NoPermissionException;
import javax.naming.spi.InitialContextFactory;

/**
 * Implements a context factory for MemoryContext. When set properly
 * javax.naming.InitialContext will return a MemoryContext referencing 
 * the named path in the shared memory space.
 * <p>
 * To use this context factory the JNDI properties file must include
 * the following properties:
 * <pre>
 * java.naming.factory.initial=org.media.naming.MemoryContextFactory
 * java.naming.provider.url=
 * </pre>
 * Any non-empty URL will return a context to that path in the object tree,
 * relative to the same shared root. The returned context is read/write.
 * <p>
 * This class was inspired by the tyrex.naming package from the 
 * <a href="http://tyrex.exolab.org">Tyrex</a> project.
 * All credits for the good stuff should go to Assaf Arkin and
 * the <a href="http://www.exolab.org">Exolab</a> group, 
 * all the bad stuff blame it on 
 * <a href="mailto:remus@nolimits.ro">me</a> :).
 * </p> 
 *
 * @author <a href="remus@nolimits.ro">Remus Pereni</a>
 * @version $Revision: 1.6 $ $Date: 2002/05/08 12:30:22 $
 */

public final class StaticMemoryContextFactory
    implements InitialContextFactory {

    private static MemoryContext _mc ;

    /**
     * The shared root of the binding tree.
     */
    private static final MemoryBinding  _root = new MemoryBinding();


    /**
     * Returns a binding in the specified path. If the binding does
     * not exist, the full path is created and a new binding is returned.
     * The binding is always obtained from the shared root.
     *
     * @param path The path
     * @return The memory binding for the path
     * @throws NamingException Name is invalid
     */
    synchronized static MemoryBinding getBindings( String path )
        throws NamingException {
        
        MemoryBinding  binding;
        MemoryBinding  newBinding;
        CompositeName  name;
        int            i;
        
        name = new CompositeName( path );
        binding = _root;
        for ( i = 0 ; i < name.size() ; ++i ) {
            if ( name.get( i ).length() > 0 ) {
                try {
                    newBinding = (MemoryBinding) binding.get( name.get( i ) );
                    if ( newBinding == null ) {
                        newBinding = new MemoryBinding();
                        binding.put( name.get( i ), newBinding );
                    }
                    binding = newBinding;
                } catch ( ClassCastException except ) {
                    throw new NotContextException( path + " does not specify a context" );
                }
            }
        }

        return binding;
    }


    /**
     * Returns an initial context based on the {@link javax.naming.Context#PROVIDER_URL}
     * environment attribute. If this attribute is missing or an empty
     * string, a new memory context be returned. Otherwise, the specified
     * context will be returned.
     */
    public Context getInitialContext( Hashtable env )
	throws NamingException {
       
        String url = null;
        
        if ( env.get( Context.PROVIDER_URL ) != null )
            url = env.get( Context.PROVIDER_URL ).toString();
        if ( url == null || url.length() == 0 )
            return getReference();
        else
            return getReference();
    }


    public Context getReference() {
        try {
            if ( _mc == null ) {
                _mc = new MemoryContext(  new Hashtable() );
            }
        } 
	catch (Exception ex) {
        } 
	finally {
            if ( _mc == null ) {
                System.err.println("Unable to create Memory Context in naming system!.");
                System.exit(1);
            }
        }
     
        return _mc;
    }
}
