/*
 * $COPYRIGHT$
 * $Id: StoreScheduler.java,v 1.13 2001/11/29 17:32:14 atech Exp $
 *
 * Date         Author          Changes
 * May 28 2001  Antal Attila    Created
 */
 
package org.media.datastore.scheduler;

import java.util.Vector;
import java.util.StringTokenizer;
import org.apache.avalon.framework.activity.Initializable;  
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.phoenix.Block; 
import org.apache.avalon.cornerstone.services.scheduler.CronTimeTrigger;
import org.apache.avalon.cornerstone.services.scheduler.PeriodicTimeTrigger;
import org.apache.avalon.cornerstone.services.scheduler.Target;
import org.apache.avalon.cornerstone.services.scheduler.TimeScheduler;
import org.apache.avalon.cornerstone.services.scheduler.TimeTrigger;                 

/**
 * @author <a href="mailto:atech@nolimits.ro">Antal Attila </a>
 * @version $Revision: 1.13 $ $Date: 2001/04/21 15:00:00
 * @see java.lang.String
 * @see org.apache.avalon.framework.configuration.Configurable
 * @see org.apache.avalon.framework.component.ComponentManager
 * @see org.apache.avalon.framework.component.Composable
 * @see org.apache.avalon.framework.activity.Initializable
 * @see org.apache.avalon.phoenix.Block
 */

public class StoreScheduler extends AbstractLogEnabled 
    implements Block, Composable, Configurable, Initializable {

    private Vector repository = new Vector();
    protected TimeScheduler timeScheduler;


    public void compose( final ComponentManager componentManager ) 
        throws ComponentException  {
        timeScheduler = (TimeScheduler)componentManager.lookup( TimeScheduler.ROLE );
    }                                                                                           
    

    public void configure( final Configuration configuration )
        throws ConfigurationException {
        Configuration[] allChildrenNodes;
        Configuration[] myChildren;
        
	try {
            allChildrenNodes  = configuration.getChildren();
            myChildren = allChildrenNodes[0].getChildren(); 
            for (int cx = 0; cx < myChildren.length; cx++) {
                CronCollector collector = new CronCollector();
                collector.targetName = myChildren[cx].getAttribute("trigger");
                collector.cronString = myChildren[cx].getAttribute("at");
                repository.add(cx, collector);
            }
            CronCollector collector;
            String targetName, className;
            int repositorySize = repository.size();
            myChildren = allChildrenNodes[1].getChildren(); 
            for (int cx = 0; cx < myChildren.length; cx++) {
                targetName = myChildren[cx].getAttribute("name");
                className  = myChildren[cx].getAttribute("class");
                for (int cy = 0; cy < repositorySize; cy++) {
                    collector = (CronCollector) repository.get(cy);
                    if (collector.targetName.equals(targetName) && 
                        !collector.targetClass.equals(className)) {
                        if (collector.targetClass.equals("")) {
                            collector.targetClass = className;
                            repository.set(cy, collector);
                        }
                        else {
                            CronCollector newEntry = new CronCollector();
                            newEntry.targetName = collector.targetName;
                            newEntry.cronString = collector.cronString;
                            newEntry.targetClass = className;
                            repository.add(repositorySize, newEntry);
                        }
                    }
                }
            }
        } 
	catch ( Exception e ) {
	    getLogger().error("Error durring when configured StoreScheduler."); 
        }
        getLogger().info("StoreScheduler has been configured.");
    }


    public void initialize() throws Exception {
        TimeTrigger trigger = null;
        CronCollector collector;
        String name, tname = "", cron, target;

        for (int cy = 0; cy < repository.size(); cy++) {
            collector = (CronCollector) repository.get(cy);
            name =  collector.targetName;
            cron =  collector.cronString;
            target =  collector.targetClass;

            getLogger().info("Cron like Unix:" +
                             " TriggerName='" + name + "'" +
                             " CronString ='" + cron + "'" + 
                             " TargetClass='" + target + "'" );
   
            CronMaker cronMaker = new CronMaker();
            cronMaker.setMaker( cron );
            if ( !cronMaker.ignored ) {
                for (int cx = 0; cx < cronMaker.getSize(); cx++) {
                    cronMaker.setCurrent(cx);

                    trigger = new CronTimeTrigger( cronMaker.getMin(),
                                                   cronMaker.getHour(),
                                                   cronMaker.getDay(),
                                                   cronMaker.getMonth(),
                                                   -1,
                                                   cronMaker.getIsDayOfWeek() );
		    tname = name + "-" + cx;
                    timeScheduler.addTrigger( tname, trigger,
					      (Target)Class.forName(target).newInstance() );
                    getLogger().info("Cron like Avalon:" +
                                     " TriggerName: " + tname +
                                     " Cron: " + trigger.toString() );
                }
            }
            else System.err.println("WARNING: Error found in your" +
                                    " configuration, please consult" + 
                                    " your SepEngine.log file!.");
        }
        getLogger().info( "StoreScheduler has been initialized." );
        System.err.println("StoreScheduler is operational...");
    }
                                              

    class CronMaker {

        CronElement ce = new CronElement();
        private Vector avalonCrons = new Vector();
        private Vector repMins = new Vector();
        private Vector repHours = new Vector();
        private Vector repDays = new Vector();
        private Vector repMonths = new Vector();
        private Vector repWeekDays = new Vector();
        private boolean weekDaysFound = true;
        private boolean mnthDaysFound = true;
        private byte paramNr = 1;
        private boolean ignored = false;

        CronMaker() {}


        public void setMaker( String cron ) {
            StringTokenizer st = new StringTokenizer( cron, " " );
            while (st.hasMoreTokens() && paramNr <= 5 ) {
                comaParser( st.nextToken() );
                paramNr++;
            }
            wormCollector();
        }


        public void wormCollector() {
            if ( weekDaysFound ) makeCronElements( repWeekDays, true );
            if ( mnthDaysFound ) makeCronElements( repDays, false );
            if ( !weekDaysFound && !mnthDaysFound )
		makeCronElements( repDays, false );
        }


        public void makeCronElements( Vector days, boolean week) {
            byte min, hour, day, month;
            for ( int i = 0; i < repMins.size(); i++ ) {
                min = ((Integer)repMins.get(i)).byteValue();
                for ( int j = 0; j < repHours.size(); j++ ) {
                    hour = ((Integer)repHours.get(j)).byteValue();              
                    for ( int k = 0; k < days.size(); k++ ) {
                        day = ((Integer)days.get(k)).byteValue();
                        for ( int l = 0; l < repMonths.size(); l++ ) {
                            month = ((Integer)repMonths.get(l)).byteValue();
                            CronElement newCE = new CronElement();
                            newCE.min = min;
                            newCE.hour = hour;
                            newCE.day = day;
                            newCE.month = month;
                            newCE.week = week;
                            avalonCrons.addElement( newCE );
                        }
                    }
                }
            }
        }


        public void setCurrent( int current ) {
            ce = ( CronElement )avalonCrons.elementAt( current );
        }


        public int getSize() {
            return avalonCrons.size();
        }


        public int getMin() {
            return ce.min;
        }


        public int getHour() {
            return ce.hour;
        }


        public int getDay() {
            return ce.day;
        }


        public int getMonth() {
            return ce.month;
        }


        public boolean getIsDayOfWeek() {
            return ce.week;
        }
	

        private byte paramLow( byte par ) {
            if ( par == 1 || par == 2 || par == 5 ) return 0;
            else return 1;
        }


        private byte paramHigh( byte par ) {
            if ( par == 1 ) return 59;
            else if ( par == 2 ) return 23;
            else if ( par == 3 ) return 31;
            else if ( par == 4 ) return 12;
            else return 7;          
        }


	private void comaParser( String worm ) {
            byte avalonTypeOfAll = -1;
            StringTokenizer coma = new StringTokenizer( worm, ",");
            while ( coma.hasMoreTokens() ) {
                String _coma = coma.nextToken();
                if ( _coma.equals("*") ) {
                    wormMaker( avalonTypeOfAll );
                    if ( paramNr == 5 ) weekDaysFound = false;
                    if ( paramNr == 3 ) mnthDaysFound = false;
                    break;
                }
                else if ( convert(_coma) >= 0 ) {
                    wormMaker( convert(_coma) );
                }
                else {
                    slashParser(_coma);
                }
            }
        }


        private void slashParser ( String slash ) {
            StringTokenizer _slash = 
                new StringTokenizer( slash, "/");
            String interval = "";
            byte count = 1;
            int step = 1;
            while ( _slash.hasMoreTokens() ) {
                if ( count == 1 ) interval = _slash.nextToken();
                if ( count == 2 ) {
                    step = convert(_slash.nextToken());
                    break;
                }
                count++;
            }
            if ( interval.equals("*") ) {
                for ( byte cx = paramLow(paramNr); 
                      cx <= paramHigh(paramNr);
                      cx += step ) {
                    wormMaker( cx );
                }
            }
            else if ( convert( interval ) >= 0 ) {
                wormMaker( convert(interval) );
            }
            else {
                minusParser ( interval, step );
            }
        }


        private void minusParser ( String interval, int step ) {
            StringTokenizer minus = 
                new StringTokenizer( interval, "-");
            int first = 0, last = 0;
            byte count = 1;
            while ( minus.hasMoreTokens() ) {
                if ( count == 1 ) first = convert( minus.nextToken() );
                if ( count == 2 ) {
                    last = convert( minus.nextToken() );
                    break;
                }
                count++;
            }
            for ( int cx = first; cx <= last; cx += step ) {
                wormMaker( cx );
            }
        }


        private void wormMaker( int worm ) {
            if (!ignored) {
                switch ( paramNr ) {
                case 1 : repMins.add( new Integer(worm) ); break;
                case 2 : repHours.add( new Integer(worm) ); break;
                case 3 : repDays.add( new Integer(worm) ); break;
                case 4 : repMonths.add( new Integer(worm) ); break;
                case 5 : repWeekDays.add( new Integer(worm) ); break;
                }
            }
        }


        private int convert( String conv ) {
            int retValue = -1;
            try {
                retValue = new Integer( conv ).intValue();              
                if ( (retValue < paramLow(paramNr) ||
		      retValue > paramHigh(paramNr)) && !ignored ) {
                    ignoreCron( conv );
                }
            }
            catch ( Exception e ) {
                if ( conv.indexOf(',') == -1 &&
                     conv.indexOf('-') == -1 &&
                     conv.indexOf('/') == -1 && !ignored ) {
                    ignoreCron( conv );
                }
            }
            return retValue;
        }


        private void ignoreCron( String ignoredParam ) {
            String paramWord = "";
            switch(paramNr) {
            case 1: paramWord = "MINUTE"; break;
            case 2: paramWord = "HOUR"; break;
            case 3: paramWord = "DAY"; break;
            case 4: paramWord = "MONTH"; break;
            case 5: paramWord = "DAY OF WEEK"; break;
            }
            getLogger().warn( "Bad " +paramWord+ " parameter:" + ignoredParam +
                              ". This CronString will be ignored!");
            ignored = true;
        }
    }


    class CronElement {
        public int min;
        public int hour;
        public int day;
        public int month;
        public boolean week;
        private CronElement() {
        }
    }


    class CronCollector {
        public String targetName  = "";
        public String cronString  = "";
        public String targetClass = "";
        private CronCollector() {
        }
    }
}
