/*
 * $COPYRIGHT$
 * $Id: ChmodInfo.java,v 1.3 2001/08/21 17:29:29 crow Exp $
 *
 * Date          Author            Changes
 * Jul 02 2001   Szabo Csaba       Modified
 */

package org.media.datastore.sepengine;

/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.3 $ $Date: 2001/08/21 15:00:00
 * @see java.lang.String
 */
     
public class ChmodInfo {

    private boolean recursive;
    private boolean verbose;
    private String  mode;
    private String  doc;

    
    public ChmodInfo() {
        recursive = false;
        verbose   = false;
        mode      = null;
        doc       = null;
    }
    

    public void setRecursive( boolean flag ) {
        recursive = flag;
    }
    

    public boolean isRecursive() {
        return recursive;
    }
    

    public void setVerbose( boolean flag ) {
        verbose = flag;
    }
    

    public boolean isVerbose() {
        return verbose;
    }
    

    public void setMode(String mod) {
        mode = mod;
    }
    

    public String getMode() {
        return mode;
    }


    public void setDoc(String d) {
        doc = d;
    }

    
    public String getDoc() {
        return doc;
    }
    

    public String toString() {
        StringBuffer sb = new StringBuffer();

        sb.append( "  Recursive : " + (new Boolean(recursive)).toString() + "\n");
        sb.append( "    Verbose : " + (new Boolean(verbose)).toString() + "\n");
        sb.append( "       Mode : " + mode + "\n");
        sb.append( "   Document : " + doc + "\n");
        
        return sb.toString();
    }
}
