/* 
 * $COPYRIGHT$
 * $Id: LexiconManager.java,v 1.13 2001/10/22 16:49:18 atech Exp $
 *
 * Date        Author            Changes 
 * Jun 22 2001 Antal Attila      Created
 */

package org.media.datastore.sepengine;

import org.apache.avalon.cornerstone.services.scheduler.Target;
import org.media.datastore.beepserver.BeepServer;
import org.media.datastore.sepengine.util.SepDBHandler;
import java.util.Hashtable;
import javax.naming.*;

/**
 * @author <a href="mailto:atech@nolimits.ro">AntalAttila</a>
 * @version $Revision: 1.13 $ $Date: 2001/10/22 16:49:18 $
 * @see java.lang.String
 */

public class LexiconManager implements Target {


    public void runLexiconManager( boolean init ) {
        if ( BeepServer.isAutoCommit() ) {
            LexiconWorker worker = new LexiconWorker( "lexiconManager", init , false);
            Thread workerThread  = new Thread( worker );
            workerThread.start();
        }
    }


    public void runLexiconManager( boolean init , boolean full ) {
        if ( BeepServer.isAutoCommit() ) {
            LexiconWorker worker = new LexiconWorker( "lexiconManager", init , full);
            Thread workerThread  = new Thread( worker );
            workerThread.start();
        }
    }


    public void targetTriggered( final String triggerName ) {
        LexiconWorker worker = new LexiconWorker( triggerName, false , false);
        Thread workerThread = new Thread( worker );
        workerThread.start();
    }                                                                           


    private class LexiconWorker implements Runnable {
        private String  workName;
        private boolean init;
	private boolean full;

        
        LexiconWorker( String _workName, boolean flag , boolean flag1) {
            workName = _workName;
            init = flag;
	    full = flag1;
        }


        public void run() {
            if ( !BeepServer.lexiconManagerIsUp() ) {
		BeepServer.setLexiconManagerState( true );
		
		Hashtable env = new Hashtable();
		env.put( Context.INITIAL_CONTEXT_FACTORY, 
			 "org.media.datastore.naming.StaticMemoryContextFactory" );
		try {
		    if ( workName.startsWith("lexiconManager") ) {
			if ( !init ) 
			    LogManager.getReference().message("info", "start_lexicon_manager");
			
			Context           ctx = new InitialContext( env );
			NamingEnumeration nen = ctx.list( "system/datasources/" );      
			
			while ( nen.hasMore() ) {
			    String sepDBName = (( NameClassPair )nen.next()).getName();
			    RDBInfo rdbInfo = (RDBInfo)ctx.lookup( "system/datasources/" + sepDBName );
			    if ( rdbInfo != null ) {
				SepDBHandler handler = new SepDBHandler( rdbInfo , "root" , new SepInterpreter() );
				if ( init ) {
				    handler.validateEntries();
				}
				else {
				    handler.removeEntries( full );
				    handler.writeEntries();
				}
			    }
			}
			if ( !init ) LogManager.getReference().message("info", "stop_lexicon_manager");
		    }
		} 
		catch ( Exception e ) {
		    System.err.println( "Error starting trigger: " + e.getMessage() ); 
		}
		
		BeepServer.setLexiconManagerState( false );
	    }
	}
    }
}
