/* 
 * $COPYRIGHT$
 * $Id: LogManager.java,v 1.6 2001/11/29 17:32:14 atech Exp $
 *
 * Date        Author            Changes 
 * May 08 2001 Szabo Csaba       Modified
 */

package org.media.datastore.sepengine;


import java.util.Properties;

import java.io.InputStream;
import java.io.PrintWriter;
import java.io.PrintStream;
import java.io.OutputStream;

import org.apache.avalon.framework.logger.Logger;


/**
 * Class responsible for managing logging messages. Loading them from the resource 
 * bundles and properly displaying them on the requested writer.
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba</a>
 * @version $Revision: 1.6 $ $Date: 2001/11/29 17:32:14 $
 * @see java.lang.String
 * @see java.util.Properties
 */

public class LogManager {

    private static final String _MESSAGES_RESOURCE_FILE = "conf/res/datastoremessages.properties";
    
    private static Properties _prop = null;
    private static String  _warning = "WARN";
    private static String    _error = "ERROR";
    private static String     _info = "INFO";
    private static Logger logger;

    protected static LogManager _logManager = new LogManager();
    

    /**
     * Dafault constructor
     */
    private LogManager () {  
    
        try {
            Class c = Class.forName( "org.media.datastore.sepengine.LogManager" );
            _prop = new Properties();
            if ( c.getResourceAsStream( _MESSAGES_RESOURCE_FILE ) == null )
                throw new RuntimeException ( "Unable to load resource file : " + 
					     _MESSAGES_RESOURCE_FILE );
            _prop.load( c.getResourceAsStream( _MESSAGES_RESOURCE_FILE ) );           
        } catch ( Exception ex ) {
            sysMessage ( _warning, ex.getMessage());
            _prop =  null;
        }
    }


    /**
     * Method for getting the LogManager instance. Don't forger that it
     * implements a Singleton pattern.
     * @return The default instance of LogManager
     */
    public static LogManager getReference () {
        logger = SepEngine.SEPENGINELOGGER;
//        logger.setPriority( Priority.DEBUG );
        return _logManager;
    }


    /**
     * The main method for displaying system messages for datastore.
     * @param type_id The type of the messages (error, warning, ...). This is
     * actually an key in the resource bundle where the actual value which will be
     * displayed is hold. datastore.messages.type. has to be inserted before the key in the resource 
     * bundle to store such messages types.
     * <pre>
     *   datastore.messages.type.warning=[WARNING]
     * </pre>
     * @param message_id The id of the messages. This is
     * actually an key in the resource bundle where the actual value which will be
     * displayed is hold. datastore.messages. has to be inserted before the key in the resource 
     * bundle to store such messages.
     * <pre>
     *   datastore.messages.file_missing=Sorry the file: xxx.jar \n is mising.
     * </pre>
     */
    public void message( String type_id, String message_id ) {
        message( type_id, message_id, "" , "" );
    }


    /**
     * The main method for displaying system messages for datastore.
     * @param type_id The type of the messages (error, warning, ...). This is
     * actually an key in the resource bundle where the actual value which will be
     * displayed is hold. datastore.messages.type. has to be inserted before the key in the resource 
     * bundle to store such messages types.
     * <pre>
     *   datastore.messages.type.warning=[WARNING]
     * </pre>
     * @param message_id The id of the messages. This is
     * actually an key in the resource bundle where the actual value which will be
     * displayed is hold. datastore.messages. has to be inserted before the key in the resource 
     * bundle to store such messages.
     * <pre>
     *   datastore.messages.file_missing=Sorry the file: xxx.jar \n is mising.
     * </pre>
     * @param suplement Another text to be added to the message.
     */
    public void message( String type_id, String message_id, String suplement ) {
        String type = null, message = null;

        type = type_id;
            
        if ( _prop.getProperty("datastore.messages." + message_id) == null ){
            sysMessage (_warning, "Unable to find datastore.messages." + message_id 
                        + " in resource bundle: " + _MESSAGES_RESOURCE_FILE
                        , suplement, "" );
        } 
        else message = _prop.getProperty("datastore.messages." + message_id);
            
        if ( type != null && message != null) 
            sysMessage ( type, message, suplement, "" );
        else 
            if ( type == null )
                sysMessage ( _error, message);                
            else  sysMessage ( type, message_id, suplement, "");                
    }


    public void message( String type_id, String message_id, String suplement, String prefix ) {
        String type = null, message = null;

        type = type_id;
            
        if ( _prop.getProperty("datastore.messages." + message_id) == null ){
            sysMessage (_warning, "Unable to find datastore.messages." + message_id 
                        + " in resource bundle: " + _MESSAGES_RESOURCE_FILE
                        , suplement , "");
        } 
        else message = _prop.getProperty("datastore.messages." + message_id);
            
        if ( type != null && message != null) 
            sysMessage ( type, message, suplement, prefix );
        else 
            if ( type == null )
                sysMessage ( _error, message);                
            else  sysMessage ( type, message_id, suplement, prefix);                
    }


    public String getMessage( String message_id ) {
        if ( _prop.getProperty("datastore.messages." + message_id) == null ){
            sysMessage (_warning, "Unable to find datastore.messages." + message_id 
                        + " in resource bundle: " + _MESSAGES_RESOURCE_FILE );
            return null;
        } 
        else return _prop.getProperty("datastore.messages." + message_id);
    }


    private void sysMessage ( String type, String message ) {
        sysMessage ( type, message, "", "" );
    }
    

    private void sysMessage (String type, String message, String suplement , String prefix ) {
        if ( type.equalsIgnoreCase ( "ERROR" ) )
            logger.error( prefix + message + suplement );
        else if ( type.equalsIgnoreCase( "WARN" ) )
            logger.warn( prefix + message + suplement );
        else
            logger.info( prefix + message + suplement );
    }
}
