/*
 * $COPYRIGHT$
 * $Id: RDBInfo.java,v 1.4 2001/08/21 17:29:29 crow Exp $
 *
 * Date          Author            Changes
 * Jul 02 2001   Szabo Csaba       Modified
 */

package org.media.datastore.sepengine;

import java.sql.Connection;
import java.util.Vector;

/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.4 $ $Date: 2001/08/21 15:00:00
 * @see java.lang.String
 * @see java.util.Vector
 * @see java.sql.Connection
 */
    
public class RDBInfo {
    
    private String     dbName;
    private DTDDirInfo dtdDir;
    private Connection dbCon;
    private Vector     ignoredKeys;
    private Vector     specialKeys;
    

    public RDBInfo (String name, DTDDirInfo dtdInfo, Connection dbCon, Vector iKeys, Vector sKeys) {
        this.dbName      = name;
        this.dtdDir      = dtdInfo; 
        this.dbCon       = dbCon;
        this.ignoredKeys = iKeys;
        this.specialKeys = sKeys;
    }  


    public String getName() {
        return dbName;
    }

    
    public DTDDirInfo getDTDDirInfo() {
        return dtdDir;
    }

    
    public Connection getConnection() {
        return dbCon;
    }

    
    public Vector getIgnoredKeys() {
        return ignoredKeys;
    }

    
    public Vector getSpecialKeys() {
        return specialKeys;
    }
}
