/*
 * $COPYRIGHT$
 * $Id: SepEngine.java,v 1.10 2002/05/17 12:39:56 crow Exp $
 *
 * Date         Author          Changes
 * May 28 2001  Antal Attila    Created
 * Jun 30 2001  Szabo Csaba     Modified
 */
 
package org.media.datastore.sepengine;

import java.util.Hashtable;
import java.util.Vector;
import java.util.Enumeration;
import java.sql.DriverManager;
import java.sql.Connection;
import java.security.Permission;
import java.util.PropertyPermission;
import javax.naming.*;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.phoenix.Block; 
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;  
import org.media.datastore.sepengine.DTDDirInfo;
import org.media.datastore.sepengine.RDBInfo;
import org.media.datastore.beepserver.BeepServer;


/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.10 $ $Date: 2001/04/21 15:00:00
 * @see org.apache.avalon.framework.configuration.Configurable
 * @see org.apache.avalon.framework.activity.Startable
 * @see org.apache.avalon.phoenix.Block
 */

public class SepEngine extends AbstractLogEnabled 
    implements Block, Configurable, Startable {

    public static Logger SEPENGINELOGGER;    
    private static Hashtable databases = new Hashtable();
    private static String errorMsg = "";


    public void configure( final Configuration conf )
        throws ConfigurationException {
        getLogger().info("SepEngine configuration started...");

        boolean error = false;
        Configuration[]  database = conf.getChildren("database");
        Configuration[] lexWriter = conf.getChildren("lexiconWriter");

        for ( int i = 0; i < lexWriter.length; i++ )
            setLexiconWriter( lexWriter[i] );

        for ( int i = 0; i < database.length; i++ )
            addJDBCDrivers( database[i] );
        
        for ( int i = 0; i < database.length; i++ ) {
            boolean parsed = parseDatabaseSection( database[i] );
            if ( !parsed ) error = true;
        }

        if ( !error )
            getLogger().info("SepEngine has been configured.");
        else
            getLogger().info("The configuration file was not loaded perfectly.");
    }


    public void start() throws Exception {
        boolean found = false;
        SEPENGINELOGGER = getLogger();
        Hashtable env = new Hashtable();
        env.put(Context.INITIAL_CONTEXT_FACTORY, 
                "org.media.datastore.naming.StaticMemoryContextFactory");
        Context ctx = new InitialContext(env);
        
        ctx = ctx.createSubcontext("system");
        ctx = ctx.createSubcontext("datasources");
        for ( Enumeration e = databases.keys(); e.hasMoreElements(); ) {
            String   key = (String)e.nextElement();
            RDBInfo info = (RDBInfo)databases.get( key );
            ctx.rebind( key, info );
            found = true;
        }

        if ( !found ) stop();
        else {
            System.setProperty("sep.drivers", "org.media.datastore.sepengine.driver.localDriver.LocalDriver");
            getLogger().info("SepEngine is operational...");
            System.err.println("SepEngine is operational...");
        }
    }
                                                                                                                                     

    public void stop() throws Exception {
        System.err.println("SepEngine is down.");
        getLogger().info("SepEngine is down");
    }


    private void setLexiconWriter( final Configuration conf ) {
        String[]     attrs = conf.getAttributeNames();
        boolean autoCommit = true;
        
        for ( int i = 0; i < attrs.length; i++ ) {
            if ( attrs[i].equalsIgnoreCase("startOnChange") ) {
                try {
                    if ( conf.getAttribute( attrs[i] ).equalsIgnoreCase("false") ) 
                        autoCommit = false;
                }
                catch ( Exception _ex3 ) {
                }
            }
        }
        BeepServer.setAutoCommit( autoCommit );
    }


    private void addJDBCDrivers( final Configuration conf ) {
        Configuration[] dbProp = conf.getChildren();

        for ( int i = 0; i < dbProp.length; i++ ) {
            String tagName = dbProp[i].getName();
            
            if ( tagName.equalsIgnoreCase("db.driver") )
                addDBDriverFromSection( dbProp[i] );
        }
    }


    private boolean parseDatabaseSection( final Configuration conf ) {
        Configuration[] dbProp = conf.getChildren();
        DTDDirInfo      dtdDir = null;
        String          dbName = null;
        Connection      dbCon  = null;
        Vector          ignoredKeys = null;
        Vector          specialKeys = null;

        for ( int i = 0; i < dbProp.length; i++ ) {
            String tagName = dbProp[i].getName();
            if ( tagName.equalsIgnoreCase("dtd.dir") )
                dtdDir = getDTDDirFromSection( dbProp[i] );
            else
                if ( tagName.equalsIgnoreCase("db.name") ) 
                    dbName = getDBNameFromSection( dbProp[i] );
                else
                    if ( tagName.equalsIgnoreCase("db.connection") )
                        dbCon = getDBConnectionFromSection( dbProp[i] );
                    else
                        if ( tagName.equalsIgnoreCase("ignored") )
                            ignoredKeys = getKeysFromSection( dbProp[i] );
                        else        
                            if ( tagName.equalsIgnoreCase("special.ignored") )
                                specialKeys = getKeysFromSection( dbProp[i] );
                            else
                                if ( !tagName.equalsIgnoreCase("db.driver") )
                                    getLogger().warn(tagName + " section can not be parsed.");
        }
        
        if ( dtdDir != null && dbName != null && dbCon != null ) {
            databases.put( dbName, new RDBInfo ( dbName, dtdDir, dbCon, ignoredKeys, specialKeys) );
            getLogger().info( dbName + " database has been loaded." );
            return true; 
        }
        else {        
            if ( dtdDir == null ) {
                errorMsg = LogManager.getReference().getMessage("sepengine_invalid_dtd");
                getLogger().error( errorMsg );
            }
            else if ( dbName == null ) {
                errorMsg = LogManager.getReference().getMessage("sepengine_invalid_dbname");
                getLogger().error( errorMsg );
            }
            else if ( dbCon == null ) {
                errorMsg = LogManager.getReference().getMessage("sepengine_invalid_con");
                getLogger().error( errorMsg );
            }

            getLogger().error("Error in configuration file 'server.xml'.");
            System.err.println("\n\tError occurred during the configuration file is loading.\n\tPlease check the log file.\n");
            return false;
        }
    }
    

    private DTDDirInfo getDTDDirFromSection ( final Configuration conf ) {
        String[]  attrs = conf.getAttributeNames();
        String     path = null;
        String     mode = null;
        String   naming = null;
        boolean ignored = false;
        
        for ( int i = 0; i < attrs.length; i++ ) {
            if ( attrs[i].equalsIgnoreCase("path") ) {
                try {
                    path = conf.getAttribute(attrs[i]);
                }
                catch (Exception _ex1) {
                    getLogger().error( "Section dtd.dir: " + _ex1.getMessage() );
                    return null;
                }
            }
            else if ( attrs[i].equalsIgnoreCase("mode") ) {
                try {
                    mode = conf.getAttribute(attrs[i]);
                }
                catch (Exception _ex2) {
                    getLogger().error( "Section dtd.dir: " + _ex2.getMessage() );
                    return null;
                }
            }
            else if ( attrs[i].equalsIgnoreCase("naming") ) {
                try {
                    naming = conf.getAttribute(attrs[i]);
                } 
                catch (Exception _ex3) {
                    getLogger().error( "Section dtd.dir: " + _ex3.getMessage() );
                    return null;
                }
            }
            else if ( attrs[i].equalsIgnoreCase("tag_ignored") ) {
                try {
                    if ( conf.getAttribute(attrs[i]).equalsIgnoreCase("true") )
                        ignored = true;
                }
                catch (Exception _ex4) {
                }
            }
        }
        if ( path == null || mode == null ) return null;
        return new DTDDirInfo(path, mode, naming, ignored);
    }
    

    private String getDBNameFromSection( final Configuration conf ) {
        String[] attrs = conf.getAttributeNames();
        for ( int i =0; i < attrs.length; i++ ) {
            if ( attrs[i].equalsIgnoreCase("name") ) {
                try {
                    return conf.getAttribute( attrs[i] );
                }
                catch (Exception ex) {
                    getLogger().error( "Section db.name: " + ex.getMessage() );
                    return null;
                }
            }
        }
        return null;
    }
    

    private void addDBDriverFromSection( final Configuration conf ) {
        String[] attrs = conf.getAttributeNames();
        for ( int i = 0; i < attrs.length; i++ ) {
            if ( attrs[i].equalsIgnoreCase("class") ) {
                try {
                    addDriver( conf.getAttribute( attrs[i] ) );
                }
                catch (Exception ex) {
                    getLogger().error( "Section db.driver: " + ex.getMessage() );
                    return;
                }
            }
        } 
    } 


    private Connection getDBConnectionFromSection( final Configuration conf ) {
        String[] attrs = conf.getAttributeNames();
        String     url = null;
        String    user = "";
        String  passwd = "";
        
        for ( int i = 0; i < attrs.length; i++ ) {
            if ( attrs[i].equalsIgnoreCase("uri") ) {
                try {
                    url = conf.getAttribute( attrs[i] );
                }
                catch ( Exception _ex1 ) {
                    getLogger().error( "Section db.connection: " + _ex1.getMessage() );
                    return null;
                }
            }
            else {
                if ( attrs[i].equalsIgnoreCase("user") ) {
                    try {
                        user = conf.getAttribute( attrs[i], "" );
                    } 
                    catch ( Exception _ex2 ){
                        getLogger().error( "Section db.connection: " + _ex2.getMessage() );
                    }
                }
                else {
                    if ( attrs[i].equalsIgnoreCase("passwd") ) {
                        try {
                            passwd = conf.getAttribute( attrs[i], "" );
                        } 
                        catch ( Exception _ex2 ){
                            getLogger().error( "Section db.connection: " + _ex2.getMessage() );                 
                        }
                    }
                }
            }
        }
        
        try {
            return DriverManager.getConnection(url, user, passwd);
        } 
        catch ( Exception _ex ) {
            getLogger().error( "Connection Failed: " + _ex.getMessage() );
            return null;
        }
    } 
    

    private Vector getKeysFromSection( final Configuration conf ) {
        Configuration[] ikeysConf = conf.getChildren();
        Vector              ikeys = new Vector();
        
        for ( int i = 0; i < ikeysConf.length; i++ ) {
            String tagName = ikeysConf[i].getName();
            if ( tagName.equalsIgnoreCase("item") ) {
                String value = getKeyValue(ikeysConf[i]);
                if ( value != null ) ikeys.addElement( value );
            }
        }
        
        return ikeys;
    } 


    private String getKeyValue( final Configuration conf ) {
        String[] attrs = conf.getAttributeNames();
        
        for ( int i = 0; i < attrs.length; i++ ) {
            if ( attrs[i].equalsIgnoreCase("value" ) ) {
                try {
                    return conf.getAttribute( attrs[i] );
                }
                catch ( Exception e ) {
                    getLogger().error( e.getMessage() );
                    return null;
                }
            } 
        }
        
        return null;
    }
    

    private void addDriver( String driver ) {
        String drivers = System.getProperty("jdbc.drivers");
        if ( drivers == null ) {
            System.setProperty("jdbc.drivers", driver);
        }
        else {
            if ( drivers.indexOf( driver ) == -1 )
                System.setProperty("jdbc.drivers", drivers + ":" + driver);
        }
    }
}
