/*
 * $COPYRIGHT$
 * $Id: TreeInfo.java,v 1.3 2001/08/21 17:29:29 crow Exp $
 *
 * Date          Author            Changes
 * Jul 02 2001   Szabo Csaba       Modified
 */

package org.media.datastore.sepengine;

import java.util.Vector;

/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.3 $ $Date: 2001/08/21 15:00:00
 * @see java.lang.String
 */
      
public class TreeInfo {

    private String action;
    private String subtree;
    private String src;
    private String dest;
    private boolean force;
    private boolean _long;
    private boolean tree;
    private boolean recursive;
    private boolean verbose;

    
    public TreeInfo() {
        action    = null;
        subtree   = null;
        src       = null;
        dest      = null;
        force     = false;
        _long     = false;
        tree      = false;
        recursive = false;
        verbose   = false;
    }

    
    public void setAction(String act) {
        action = act;
    }

    
    public String getAction() {
        return action;
    }

    
    public void setSubtreeName(String stree) {
        subtree = stree;
    }

    
    public String getSubtreeName() {
        return subtree;
    }

    
    public void setSource(String s) {
        src = s;
    }

    
    public String getSource() {
        return src;
    }
    

    public void setDestination(String d) {
        dest = d;
    }
    

    public String getDestination() {
        return dest;
    }

    
    public void setForced(boolean flag) {
        force = flag;
    }

    
    public boolean isForced() {
        return force;
    }

    
    public void setLongFormat(boolean flag) {
        _long = flag;
    }

    
    public boolean isLongFormat() {
        return _long;
    }

    
    public void setTreeList(boolean flag) {
        tree = flag;
    }

      
    public boolean isTreeList() {
        return tree;
    }

    
    public void setRecursive(boolean flag) {
        recursive = flag;
    }

    
    public boolean isRecursive() {
        return recursive;
    }

    
    public void setVerboseMode(boolean flag) {
        verbose = flag;
    }

    
    public boolean isVerboseMode() {
        return verbose;
    }

    
    public String toString() {
        StringBuffer sb = new StringBuffer();

        sb.append( "     Action : " + action + "\n");
        sb.append( "    Subtree : " + subtree + "\n");
        sb.append( "      Souce : " + src + "(for copy)\n");
        sb.append( "Destination : " + dest + " (for copy)\n");
        sb.append( "     Forced : " + (new Boolean( force )).toString() + "(for delete)\n");    
        sb.append( " Longformat : " + (new Boolean( _long )).toString() + "(for list)\n");      
        sb.append( "  Tree list : " + (new Boolean( tree )).toString() + "(for list)\n");
        sb.append( "  Recursive : " + (new Boolean( recursive )).toString() + "(for copy)\n");  
        sb.append( "    Verbose : " + (new Boolean( verbose )).toString() + "(for copy)\n");
        
        return sb.toString();
    }
}
