/*
 * $COPYRIGHT$
 * $Id: UserInfo.java,v 1.3 2001/08/21 17:29:29 crow Exp $
 *
 * Date          Author            Changes
 * Jul 02 2001   Szabo Csaba       Modified
 */

package org.media.datastore.sepengine;

import java.util.Vector;

/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.3 $ $Date: 2001/08/21 15:00:00
 * @see java.lang.String
 * @see java.util.Vector
 */
      
public class UserInfo {

    private String action;
    private String lname;
    private String uname;
    private String passwd;
    private String homedir;
    private String group;
    private Vector groups;
    

    public UserInfo() {
        action  = null;
        lname   = null;
        uname   = null;
        passwd  = null;
        homedir = null;
        group   = null;
        groups  = null;
    }

    
    public void setAction(String act) {
        action = act;
    }

    
    public String getAction() {
        return action;
    }

    
    public void setLoginname(String name) {
        lname = name;
    }

    
    public String getLoginName() {
        return lname;
    }

    
    public void setUsername(String name) {
        uname = name;
    }
    

    public String getUserName() {
        return uname;
    }
    

    public void setPassword(String pwd) {
        passwd = pwd;
    }

    
    public String getPassword() {
        return passwd;
    }
    

    public void setHomedir(String dir) {
        homedir = dir;
    }
    

    public String  getHomedir() {
        return homedir;
    }
    

    public void setInitialgroup(String gr) {
        group = gr;
    }
    

    public String getInitialgroup() {
        return group;
    }

    
    public void addGroup(String gr){
        if ( groups == null ) groups = new Vector();
        groups.addElement(gr);
    }
    

    public Vector getGroups() {
        return groups;
    }

    
    public String toString() {
        StringBuffer sb = new StringBuffer();

        sb.append( "   Action: " + action + "\n");
        sb.append( " Username: " + uname + "\n");
        sb.append( "Loginname: " + lname + "\n");
        sb.append( " Password: " + passwd + "\n");
        sb.append( "  Homedir: " + homedir + "\n");     
        sb.append( "  I.Group: " + group + "\n");       
        if ( groups != null ) sb.append( "   Groups: " + groups.toString() );
        
        return sb.toString();
    }
}
