/*
 * $COPYRIGHT$
 * $Id: SepStoreDriverManager.java,v 1.4 2001/08/21 17:29:29 crow Exp $
 *
 *  Date         Author            Changes
 *  May 31 2001  Szabo Csaba       Created
 */
       
package org.media.datastore.sepengine.driver;

import java.util.Vector;
import java.util.Properties;
import java.util.Enumeration;

/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.4 $ $Date: 2001/08/21 15:00:00
 * @see java.lang.String
 * @see java.util.Properties
 */
     
public class SepStoreDriverManager {


    public static synchronized SepStoreConnection getConnection(String url, Properties prop) 
        throws Exception {
        ClassLoader loader = SepStoreDriverManager.class.getClassLoader();
        
        return getConnection(url, prop, loader);
    }
    

    public static synchronized SepStoreConnection getConnection(String url, String uname, String passwd) 
        throws Exception {
        Properties    prop = new Properties();
        ClassLoader loader = SepStoreDriverManager.class.getClassLoader();
        
        if ( uname != null ) 
            prop.put("user", uname);
        if ( passwd != null )
            prop.put("password", passwd);
        
        return getConnection(url, prop, loader);    
    }
    

    public static synchronized SepStoreConnection getConnection(String url) 
        throws Exception {
        Properties    prop = new Properties();
        ClassLoader loader = SepStoreDriverManager.class.getClassLoader();
        
        return getConnection(url, prop, loader);    
    }
    

    public static synchronized SepStoreDriver getDriver(String url) 
        throws Exception {
        if ( !initialized )
            initialize();
        ClassLoader loader = SepStoreDriverManager.class.getClassLoader();
        
        for ( int i = 0; i < drivers.size(); i++ ) {
            SepStoreDriverInfo info = (SepStoreDriverInfo)drivers.elementAt(i);
            if ( getCallerClass(loader, info.driverClassName) == info.driverClass ) {
                try {
                    if ( info.driver.acceptsURL(url) )
                        return info.driver;
                }
                catch ( Exception ex ) {}
            } 
        }
        
        throw new Exception("No suitable driver.");
    }
    

    public static synchronized void registerDriver ( SepStoreDriver driver ) 
        throws Exception {
        if ( !initialized ) 
            initialize();
        SepStoreDriverInfo info = new SepStoreDriverInfo();
        info.driver = driver;
        info.driverClass = driver.getClass();
        info.driverClassName = info.driverClass.getName();
        drivers.addElement(info);
    }
    

    public static synchronized void deregisterDriver ( SepStoreDriver driver ) 
        throws Exception {
        ClassLoader      loader = SepStoreDriverManager.class.getClassLoader();
        SepStoreDriverInfo info = null;
        int i;
        
        for ( i = 0; i < drivers.size(); i++ ) {
            info = (SepStoreDriverInfo)drivers.elementAt(i);
            if ( info.driver == driver )
                break;
        }
        if ( i >= drivers.size() ) return;
        if ( getCallerClass(loader, info.driverClassName) != info.driverClass ) {
            throw new SecurityException();
        }
        else {
            drivers.removeElementAt(i);
            return;
        }
    }
    

    public static synchronized Enumeration getDrivers()
        throws Exception {
        Vector      vector = new Vector();
        ClassLoader loader = SepStoreDriverManager.class.getClassLoader();      
        
        if ( !initialized ) 
            initialize();
        for ( int i = 0; i < drivers.size(); i++ ) {
            SepStoreDriverInfo info = (SepStoreDriverInfo)drivers.elementAt(i);
            if ( getCallerClass( loader, info.driverClassName) == info.driverClass )
                vector.addElement(info.driver);
        }
        
        return vector.elements();
    }
    

    private static Class getCallerClass(ClassLoader loader, String className ) {
        Class class1 = null;
        
        try {
            class1 = Class.forName(className, true, loader);
        }
        catch ( Exception e ) {
            class1 = null;
        }
        
        return class1;
    }
    

    private static void loadInitialDrivers() {
        String s;
        try {
            s = System.getProperty("sep.drivers");
        }
        catch ( RuntimeException e ) {
            s = null;
        }
        if ( s == null ) return;
        while ( s.length() != 0 ) {
            int i = s.indexOf(58);
            String s1;
            
            if ( i == -1 ) {
                s1 = s;
                s  = "";
            }
            else {
                s1 = s.substring(0, i);
                s  = s.substring(i + 1);
            }
            if ( s1.length() > 0 ) {
                try {
                    Class.forName(s1, true, SepStoreDriverManager.class.getClassLoader());
                }
                catch ( Exception e ) {
                    e.printStackTrace();
                }
            }
        } 
    }
    

    private static synchronized SepStoreConnection getConnection(String url, Properties prop, ClassLoader loader )
        throws Exception {
        if ( url == null )
            throw new Exception( "The URL cannot be null" );
        if ( !initialized )
            initialize();
            
        Exception _ex = null;
        for ( int i = 0; i < drivers.size(); i++ ) {
            SepStoreDriverInfo info = (SepStoreDriverInfo)drivers.elementAt(i);
            if ( getCallerClass ( loader, info.driverClassName ) == info.driverClass ) {
                try {
                    SepStoreConnection con = info.driver.connect(url, prop);
                    if ( con != null ) return con;
                }
                catch ( Exception ex1 ) {
                    if ( _ex == null ) _ex = ex1;
                }
            }
        }
        if ( _ex != null ) throw _ex;
        else throw new Exception( "No suitable driver" );           
    }   
     

    static void initialize() {
        if ( !initialized ) {
            initialized = true;
            loadInitialDrivers();
        }
    } 
    

    private SepStoreDriverManager() {
    }    
    

    private static Vector drivers = new Vector();
    private static boolean initialized = false;
}
