/*
 * $COPYRIGHT$y
 * $Id: BeepConnection.java,v 1.17 2002/05/31 21:05:58 crow Exp $
 *
 *  Date           Author            Changes
 *  Jun 29 2001    Szabo Csaba       Created
 *  Oct 01 2001    Antal Attila      implemented beep things
 */
       
package org.media.datastore.sepengine.driver.beepDriver;

import java.util.Properties;
import java.io.IOException;
import java.io.InputStream;
import java.io.ByteArrayInputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.security.Security;

import org.beepcore.beep.util.*;
import org.beepcore.beep.core.*;
import org.beepcore.beep.lib.Reply;
import org.beepcore.beep.transport.tcp.*;
import org.beepcore.beep.profile.ProfileConfiguration;
import org.beepcore.beep.profile.tls.TLSProfile;
import org.beepcore.beep.profile.sasl.otp.SASLOTPProfile;
import org.beepcore.beep.profile.sasl.otp.algorithm.md5.*;
import org.beepcore.beep.profile.sasl.otp.algorithm.sha1.*;
import org.beepcore.beep.profile.sasl.otp.database.UserDatabasePool;

import org.media.datastore.sepengine.driver.SepStoreDriver;
import org.media.datastore.sepengine.SepInterpreter;
import org.media.datastore.beepserver.SEPprofile; 
import org.media.datastore.sepengine.util.StringInputStream;
import org.media.datastore.sepengine.util.ProgressBar;

/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.17 $ $Date: 2001/08/21 15:00:00
 * @see java.lang.String
 * @see java.io.InputStream
 * @see org.media.datastore.sepengine.driver.SepStoreConnection
 * @see org.beepcore.beep.core.Message
 */
     
public class BeepConnection 
    implements org.media.datastore.sepengine.driver.SepStoreConnection {

    private Session _session = null;
    private String         SEP_HOST;
    private int            SEP_PORT;
    private String         SEP_DATABASE;
    private String         SEP_USER;
    private String         SEP_PASSWD;
    private boolean        SEP_STATUS;
    private String         SEP_SECURE = "";
    public  boolean        CONNECTION_BAD;
    public  boolean        CONNECTION_OK;
    public  SepStoreDriver this_driver;
    private String         this_url;
    //private Channel          channel = null;
    private boolean         replayed = false;
    private InputStream     response = null;
    private StringInputStream    sis = new StringInputStream();
    
    private final int    BUFFER_SIZE = 1024;
    private final String  hashMethod = "otp-md5";
    private final String        seed = "xyz";
    private final int            seq = 1;
            
    public BeepConnection () {
        CONNECTION_OK  = true;
        CONNECTION_BAD = false;
    }


    public InputStream executeSEP( InputStream sepStream ) throws Exception {
        Reply     reply = new Reply();        
        Channel channel = null;
        StringBuffer sb = new StringBuffer();

        if ( ( channel = initChannel( _session ) ) == null ) throw new Exception("Cannot open Channel.");
        channel.sendMSG( new InputStreamDataStream(sepStream, sepStream.available()), reply);
        while( reply.hasNext() ) 
            sb.append( streamToString( reply.getNextReply().getDataStream().getInputStream() ) );
        channel.close();
        
        return new ByteArrayInputStream( sb.toString().getBytes());
    }


    public InputStream executeSEP( String sepString ) throws Exception {
        Reply     reply = new Reply();
        Channel channel = null;
        StringBuffer sb = new StringBuffer();

        if ( ( channel = initChannel( _session ) ) == null ) throw new Exception("Cannot open Channel.");
        channel.sendMSG( new StringDataStream(sepString), reply);
        while( reply.hasNext() ) 
            sb.append( streamToString( reply.getNextReply().getDataStream().getInputStream() ) );
        channel.close();
         
        return new ByteArrayInputStream( sb.toString().getBytes());

    }
    
    
    public String getURL() throws Exception {
        return this_url;
    }

    
    public String getUserName() throws Exception {
        return SEP_USER;
    }

    protected void openConnection (String host, int port, Properties prop, 
                                   String dbName, String url, SepStoreDriver driver ) throws Exception {
        Channel channel = null;

        if ( prop.getProperty("user") == null )
            throw new Exception("The user property is missing. It is mandatory.");
        if ( prop.getProperty("password") == null )
            throw new Exception("The password property is missing. It is mandatory.");
        if ( prop.getProperty("security") != null )
            SEP_SECURE = new String( prop.getProperty("security") );
            
        this_driver  = driver;
        this_url     = new String( url );
        SEP_DATABASE = new String( dbName );
        SEP_PASSWD   = new String( prop.getProperty("password") );
        SEP_USER     = new String( prop.getProperty("user") );
        SEP_PORT     = port;
        SEP_HOST     = new String(host);
        SEP_STATUS   = CONNECTION_BAD;

        _session = initSession(SEP_HOST, SEP_PORT);
        if ( ( channel = initChannel( _session ) ) == null ) 
            throw new Exception("Cannot connect to BEEP server. Incorrect host or port number.");
        
        try {
            Reply reply= new Reply();
            Message result  = null;
            channel.sendMSG( new StringDataStream("SEP:" + SEP_DATABASE), reply ); 
            result = reply.getNextReply();
            channel.close();
            if ( result != null && result.getMessageType() == Message.MESSAGE_TYPE_ERR )
                throw new RuntimeException( streamToString(
					        result.getDataStream().getInputStream()));
        }
        catch ( Exception e ) {
            throw new Exception("Connection failed to " + SEP_DATABASE);
        }
    }


    public void close() throws BEEPException {
        //channel.close();
        _session.close();
    }


    private String streamToString( InputStream is ) throws Exception {
        int        size = 0;
        char[]   buffer = new char [ BUFFER_SIZE ];
        StringBuffer sb = new StringBuffer();
        
        try {
            BufferedReader in = new BufferedReader( new InputStreamReader( is ) );
            while ( true ) {
                if ( ( size = in.read( buffer, 0, BUFFER_SIZE) ) == -1) break;
                sb.append( new String( buffer, 0, size) ); 
            } 
        }
        catch ( Exception _ex ) {
            throw new Exception ("Response from server not receiving.");
        }
                                                             
        return sb.toString();
    }

    
    private String preDigest( String pwd ) throws Exception {
        return SASLOTPProfile.convertBytesToHex(
						( new MD5() ).generateHash( pwd.getBytes() )
						);
    }

                 
    private String getPasswdHash( String pwd ) throws Exception {
        byte[] pw = ( seed + pwd ).getBytes();
                                     
        try {
            for ( int cx = 0; cx <= seq; cx++ ) {
                if ( hashMethod.equals( "otp-md5" ) )
                    pw = ( new MD5() ).generateHash( pw );
                else
                    if ( hashMethod.equals( "otp-sha1" ) )
                        pw = ( new SHA1() ).generateHash( pw );
                    else
                        throw new Exception( "\nInvalid algorithm method:"+ hashMethod + "\n");
	    }
	}
        catch ( Exception e ) {
            throw e;
        }
                                                                                                     
        return SASLOTPProfile.convertBytesToHex( pw );
    }


    private Session authenticate ( Session sess, String user, String  pwd ) throws Exception {
        SASLOTPProfile otp = new SASLOTPProfile();
        
        try {
            String newHash = getPasswdHash( pwd = preDigest( pwd ) );

            otp.init( SASLOTPProfile.URI, new ProfileConfiguration() );
            ( new UserDatabasePool() ).addUser( user, hashMethod, newHash, seed, seq + "" );
            sess = otp.AuthenticateSASLOTPWithInit( sess,
                                                    SEP_DATABASE + "_",
                                                    user, pwd,
                                                    hashMethod,
                                                    newHash, seed, seq + "" );
        } 
        catch ( Exception e ) {
            sess = null;
            throw e;
        }
        
        return sess;
    }


    private Session tls( Session tlsSes, String privacy) throws Exception {

        if ( privacy.trim().length() > 0 ) {
	    //            Security.addProvider( new com.sun.net.ssl.internal.ssl.Provider() );  
            if ( "jsse".equals( privacy.toLowerCase() ) ) {
                try {
                    TLSProfile tlsProfile = 
                        TLSProfile.getInstance("org.beepcore.beep." +
                                               "profile.tls.jsse.TLSProfileJSSE");
                    tlsSes = tlsProfile.startTLS( (TCPSession)tlsSes );
                } 
                catch ( Exception e ) {
	    if ( e.getMessage() == null  ) {
		throw new Exception( "JSSE TLS Provider is not specified!" );
	    }
	    else {
		throw new Exception( "JSSE TLS connection not supported by server!" );
	    }
                }
            }
            else { 
                if ( "ptls".equals(privacy.toLowerCase()) ) {
                    try {
                        TLSProfile tlsProfile = TLSProfile.getDefaultInstance();        
                        tlsSes = tlsProfile.startTLS( (TCPSession)tlsSes );
                    } 
                    catch ( Exception e1 ) {
                        throw new Exception( "Pure TLS connection not supported by server!" );
                    }
                }
                else {
                    throw new Exception( "Invalid security parameter!" );
                }
            }
        }
        
        return tlsSes;
    }
   

    private void beepLogger() {
        ConsoleLog log = new ConsoleLog();
        log.setSeverity( Log.SEV_DEBUG_VERBOSE );
        Log.setLogService( log );
    }

   
    private Session initSession( String host, int port ) throws Exception {
        Session ses;
        //beepLogger();
        try {
            ses = AutomatedTCPSessionCreator.initiate(host, port, new ProfileRegistry());
            ses = tls( ses, SEP_SECURE );
            ses = authenticate( ses, SEP_USER, SEP_PASSWD );
        }
        catch ( Exception e ) {
            throw e;
        }
        
        return ses;
    } 

    
    private Channel initChannel( Session ses ) throws Exception {
        Channel chan = null;
        
        if ( ses == null ) return null;
        try {
            chan = ses.startChannel( SEPprofile.URI );
        }
        catch ( Exception e ) {
            throw e;
        }
        
        return chan;
    }
}
