/*
 * $COPYRIGHT$
 * $Id: BeepDriver.java,v 1.5 2002/03/20 17:23:18 atech Exp $
 *
 *  Date           Author            Changes
 *  Jun 28 2001    Szabo Csaba       Created
 */
       
package org.media.datastore.sepengine.driver.beepDriver;

import java.util.Properties;
import java.util.StringTokenizer;
import org.media.datastore.sepengine.driver.*;

/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.5 $ $Date: 2001/08/21 15:00:00
 * @see java.lang.String
 * @see java.util.Properties
 * @see org.media.datastore.sepengine.driver.SepStoreDriver 
 */
     
public class BeepDriver 
    implements org.media.datastore.sepengine.driver.SepStoreDriver {


    public BeepDriver() throws Exception {
    }

    
    public boolean acceptsURL(String url) throws Exception {
        return parseURL(url, null) != null;
    }

    
    public SepStoreConnection connect(String url, Properties info) throws Exception {
        if ( ( props = parseURL( url, info ) ) == null ) return null;
        try {
            BeepConnection con = ( BeepConnection )Class.forName(BeepDriverClass.connectClass).newInstance();
            con.openConnection( host(), port(), props, database(), url, this );
            return (BeepConnection)con;  
        }
        catch ( Exception e ) {
            throw e;
        } 
    }
    

    public String database() {
        return props.getProperty("SEPDBNAME");
    }

    
    public String host() {
        return props.getProperty("SEPHOST", "localhost");
    }
    

    public int port() {
        return Integer.parseInt(props.getProperty("SEPPORT", "10288"));
    }
    

    public SepStoreDriverPropertyInfo[] getPropertyInfo( String url, Properties info )
        throws Exception {
        Properties prop = parseURL(url, info);
        SepStoreDriverPropertyInfo dpi[] = new SepStoreDriverPropertyInfo[0];
        return dpi;
    }

    
    public String property( String name ) {
        return props.getProperty(name);
    }

    
    // parse URL and add SEP database name to properties 
    Properties parseURL(String url, Properties defaults) throws Exception {
        int           state = -1;
        Properties urlProps = new Properties(defaults);
        String          key = new String();
        String        value = new String();
        StringTokenizer  st = new StringTokenizer ( url, ":/;?&=#", true );
        
        for ( int count = 0; st.hasMoreTokens() ; count++ ) {
            String token = st.nextToken();
            
            if ( count <= 3 ) {
                if ( count % 2 == 0 || !token.equals(":") ) {
                    if ( count % 2 == 0 ) {
                        if ( count == 0 && !token.equals( protocols[0] ) ) return null;
                        if ( count == 2 && !token.equals( protocols[1] ) ) return null;
                    }
                    else {
                        return null;
                    }
                } 
            }
            else {
                if ( count == 4 &&  token.equals("/") ) {
		    state = 0;
                }
                else {
                    if ( count == 4 ) {
                        urlProps.put("SEPDBNAME", token);
                        state = -2;
                    }
                    else {
                        if ( count == 5 && state == 0 && token.equals("/") ) {
                            state = 1;
                        }
                        else {
                            if ( count == 5 && state == 0 ) return null;
                            if ( count == 6 && state == 1 ) {
                                urlProps.put("SEPHOST", token);
                            }
                            else {
                                if ( count == 7 && token.equals(":") ) {
                                    state = 2;
                                }
                                else {
                                    if ( count == 8 && state == 2 ) {
                                        try {
                                            Integer portNumber = Integer.decode(token);
                                            urlProps.put("SEPPORT", portNumber.toString());
                                        }
                                        catch ( Exception _ex ) {
                                            return null;
                                        }
                                    }
                                    else {
                                        if ( ( count == 7 || count == 9 ) && ( state == 1 || state == 2 ) && token.equals("/") ) {
                                            state = -1;
                                        } 
                                        else {
                                            if ( state == -1 ) {
                                                urlProps.put("SEPDBNAME", token);
                                                state = -2;
                                            }
                                            else {
                                                if ( state <= -2 && count % 2 == 1 ) {
                                                    if ( token.equals(";") || token.equals("?") || token.equals("&") ) {
                                                        state = -3;
                                                    }
                                                    else {
                                                        if ( token.equals("=") ) state = -5;
                                                    } 
                                                }
                                                else {
                                                    if ( state <= -2 && count % 2 == 0 ) {
                                                        if ( state == -3 ) {
                                                            key = token;
                                                        }
                                                        else {
                                                            if ( state == -5 ) {
                                                                value = token;
                                                                urlProps.put(key, value);
                                                                state = -2;
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }       
                }
            }
        }
        
        return urlProps;
    }

    
    private Properties props;
    private static String protocols[] = {"sep", "beep"};

    
    static {
        try {
            SepStoreDriverManager.registerDriver( new BeepDriver() );
        }
        catch ( Exception e ) {
            e.printStackTrace();
        }
    }
} 
