/*
 * $COPYRIGHT$
 * $Id: LocalConnection.java,v 1.5 2001/12/06 14:13:29 crow Exp $
 *
 *  Date           Author            Changes
 *  Jun 29 2001    Szabo Csaba       Created
 */
       
package org.media.datastore.sepengine.driver.localDriver;

import java.util.Properties;
import java.util.Hashtable;
import javax.naming.*;
import java.io.InputStream;
import java.io.ByteArrayInputStream;
import org.media.datastore.sepengine.driver.SepStoreDriver;
import org.media.datastore.sepengine.RDBInfo;
import org.media.datastore.sepengine.SepInterpreter;
import org.media.datastore.sepengine.util.SepDBHandler;

/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.5 $ $Date: 2001/08/21 15:00:00
 * @see java.lang.String
 * @see java.io.InputStream
 * @see java.util.Properties
 * @see org.media.datastore.sepengine.driver.SepStoreConnection 
 * @see org.media.datastore.sepengine.driver.SepStoreDriver
 */
     
public class LocalConnection 
    implements org.media.datastore.sepengine.driver.SepStoreConnection {
    

    public LocalConnection () {
        CONNECTION_OK  = true;
        CONNECTION_BAD = false;
    }

    
    public InputStream executeSEP( InputStream sepStream ) {
	return ( new SepInterpreter() ).execute(sepStream, rdbInfo, getUserName());
    }

    
    public InputStream executeSEP( String sepString ) {
        return executeSEP( new ByteArrayInputStream( sepString.getBytes() ) );
    } 

    
    public void close() {
    }


    public String getURL() {
        return this_url;
    }

    
    public String getUserName() {
        return SEP_USER;
    }

    
    protected void openConnection (Properties prop, String dbName, String url, SepStoreDriver driver )
        throws Exception {
        Hashtable env = new Hashtable();
        env.put(Context.INITIAL_CONTEXT_FACTORY,
                "org.media.datastore.naming.StaticMemoryContextFactory");
        Context ctx = new InitialContext(env);
        
        if ( prop.getProperty("user") == null )
            throw new Exception("The user property is missing. It is mandatory.");
        if ( prop.getProperty("password") == null )
            throw new Exception("The password property is missing. It is mandatory.");
        this_driver  = driver;
        this_url     = new String( url );
        SEP_DATABASE = new String( dbName );
        SEP_PASSWD   = new String( prop.getProperty("password") );
        SEP_USER     = new String( prop.getProperty("user") );
        SEP_USER     = SEP_USER.substring( SEP_DATABASE.length() + 1 );
        SEP_STATUS   = CONNECTION_BAD;
        
        rdbInfo      = (RDBInfo)ctx.lookup("system/datasources/" + SEP_DATABASE);
        if ( rdbInfo == null )
            throw new Exception("Cannot find specified database in memoryContext");
            
        if ( !(new SepDBHandler(rdbInfo, SEP_USER, new SepInterpreter() )).authenticate(SEP_USER, SEP_PASSWD ) )
            throw new Exception("Authentification failed !!!");
                
        SEP_STATUS   = CONNECTION_OK;
    }

    
    private String         SEP_DATABASE;
    private String         SEP_USER;
    private String         SEP_PASSWD;
    private boolean        SEP_STATUS;
    public  boolean        CONNECTION_BAD;
    public  boolean        CONNECTION_OK;
    public  SepStoreDriver this_driver;
    private String         this_url;
    private RDBInfo        rdbInfo;
}
