/*
 * $COPYRIGHT$
 * $Id: LocalDriver.java,v 1.3 2001/08/21 17:29:29 crow Exp $
 *
 *  Date           Author            Changes
 *  Jun 28 2001    Szabo Csaba       Created
 */
       
package org.media.datastore.sepengine.driver.localDriver;

import java.util.Properties;
import java.util.StringTokenizer;
import org.media.datastore.sepengine.driver.*;

/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.3 $ $Date: 2001/08/21 15:00:00
 * @see java.lang.String
 * @see java.util.Properties
 */
     
public class LocalDriver 
    implements org.media.datastore.sepengine.driver.SepStoreDriver {

   
    public LocalDriver() throws Exception {
    }
    

    public boolean acceptsURL(String url) throws Exception {
        return parseURL(url, null) != null;
    }

    
    public SepStoreConnection connect(String url, Properties info) throws Exception {
        if ( ( props = parseURL( url, info ) ) == null ) return null;
        try {
            LocalConnection con = ( LocalConnection )Class.forName(LocalDriverClass.connectClass).newInstance();
            con.openConnection( props, database(), url, this );
            return (LocalConnection)con;  
        }
        catch ( Exception e ) {
            throw e;
        } 
    }

    
    public String database() {
        return props.getProperty("SEPDBNAME");
    }

    
    public SepStoreDriverPropertyInfo[] getPropertyInfo( String url, Properties info )
        throws Exception {
        Properties prop = parseURL(url, info);
        SepStoreDriverPropertyInfo dpi[] = new SepStoreDriverPropertyInfo[0];
        return dpi;
    }
    
    public String property( String name ) {
        return props.getProperty(name);
    }

    
    // parse URL and add SEP database name to properties 
    Properties parseURL(String url, Properties defaults) 
        throws Exception {
        int           state = -1;
        Properties urlProps = new Properties(defaults);
        String          key = new String();
        String        value = new String();
        StringTokenizer  st = new StringTokenizer (url, ":", true );
        
        for ( int count = 0; st.hasMoreTokens(); count++ ) {
            String token = st.nextToken();
            
            if ( count <= 3 ) {
                if ( count % 2 == 0 || !token.equals(":") ) {
                    if ( count % 2 == 0 ) {
                        if ( count == 0 && !token.equals( protocols[0] ) ) return null;
                        if ( count == 2 && !token.equals( protocols[1] ) ) return null;
                    }
                    else {
                        return null;
                    }
                } 
            }
            else {
                if ( count == 4 && !token.equals(":") )
                    urlProps.put("SEPDBNAME", token);
                else
                    return null;
            }
        }
        
        return urlProps;
    }

    
    private Properties props;
    private static String protocols[] = {"sep", "local"};

    
    static {
        try {
            SepStoreDriverManager.registerDriver( new LocalDriver() );
        }
        catch ( Exception e ) {
            e.printStackTrace();
        }
    }
} 
