/* 
 * $COPYRIGHT$
 * $Id: sep.g,v 1.20 2001/11/09 18:33:47 crow Exp $
 *
 * Date        Author            Changes 
 * Apr 10 2001 Antal Attila      Created
 */

header {
package org.media.datastore.sepengine.parser;

import org.media.datastore.sepengine.SepInterpreter;
import org.media.datastore.sepengine.util.*;
import org.media.datastore.sepengine.RDBInfo;
import org.media.datastore.sepengine.LogManager;
import org.apache.log.*;
}


/** 
 * The parser for SEP.<br>
 * This class is automaticaly generated by 
 * <a href="http://www.antlr.org">ANTLR</a>.
 * @author <a href="mailto:atech@nolimits.ro">Antal Attila</a>
 * @version $Revision: 1.20 $ $Date: 2001/11/09 18:33:47 $
 */

class sepParser extends Parser;


options {
	defaultErrorHandler=false;
	exportVocab=sep;
	k = 4;
}

{

/* Variables for error messages for logging */
public static String errorLine = LogManager.getReference().getMessage("sep_parser_eline");
public static String errorWord = LogManager.getReference().getMessage("sep_parser_eword");
public static String extraWord = LogManager.getReference().getMessage("sep_parser_extraword");
public static String missingAp = LogManager.getReference().getMessage("sep_parser_missingap");
public static String missingEl = LogManager.getReference().getMessage("sep_parser_misseleme");
public static String suspEleme = LogManager.getReference().getMessage("sep_parser_suspeleme");
public static String breaEleme = LogManager.getReference().getMessage("sep_parser_breaeleme");

/* The parser returns with this table containing a lot of info*/ 
public SepReturnTable ret = new SepReturnTable();

/* Objects for working to driver */
private SepDBHandler       handler = null;
private SepADMDBHandler admHandler = null;

/* SEP attribute variables */
private String related  = null;
private String offset   = "0";
private String maxnum   = null;
private String notifi   = "false";
private String prevstmp = null;
private String subtree  = null;
private String attrib   = null;
private String order    = "ascending";
private String property = null;

/* Some variables for making SQL */
private String  sqlPath    = "";
private String  sqlAscDesc = "ASC";
private boolean sqlCsens   = true;
private boolean sqlApprox  = false;
private String  sqlOp      = "eq";
private boolean sqlIsPath  = false;
private int     sqlTreeID      = 0;
private int     sqlDocumentID  = -1;
private int     sqlBlockNr = 1;
private String  toSQLfinal = "";
private String  sqlError = "";
private String  sqlValue   = "";
private String  actToken = "";
private String  at = "";
private String  nt = "";

/* Counter variables for attributes */
private byte cnt_related = 0;
private byte cnt_offset = 0;
private byte cnt_maxnum = 0;
private byte cnt_notification = 0;
private byte cnt_prevstamp = 0;
private byte cnt_subtree = 0;
private byte cnt_operator = 0;
private byte cnt_casesens = 0;
private byte cnt_approx = 0;
private byte cnt_attribute = 0;
private byte cnt_order = 0;
private byte cnt_property = 0;


private String manyAttr(String attr, String elem) {
	return LogManager.getReference().getMessage("sep_parser_manyattri") + 
		   "'" + attr + "', " + 
		   LogManager.getReference().getMessage("sep_parser_permitted") +
           " '" + elem + "' ";
}

private String missingAttr(String attr, String elem) {
	return LogManager.getReference().getMessage("sep_parser_missattri") + 
		   "'" + attr + "', " + 
		   LogManager.getReference().getMessage("sep_parser_misspermi") +
           " '" + elem + "' ";
}

private String errorInAttr(String attr, String msg) {
	return LogManager.getReference().getMessage("sep_parser_eattr") + 
		   "'" + attr + "', " + msg;
}

}



sepStart [RDBInfo info, String uname, SepInterpreter si] returns [SepReturnTable xret = ret] 
	:
	{
	handler    = new SepDBHandler(info, uname, si);
	admHandler = new SepADMDBHandler(info, uname, si);
        ret.reqno  = 0;
	ret.action = "write";
	ret.scanTree = true;
	actToken = "";
	at = "";
	nt = "";
	}
	    
	request

    { ret.sql = toSQLfinal;	}

	exception 
	catch [RecognitionException e]
	{ 
	  int l = e.getLine() - 1;
	  if ( subtree == null || !subtree.trim().startsWith("_admin") )
		if ( l > 0 )
			sqlError = LogManager.getReference().getMessage("sep_parser_excep") + "\n" +
					   errorLine + l + "\n" + e.getMessage() + "\n\n" + 
                       breaEleme + "\n" + at + "\n\n" +
                       missingEl + " " + nt + "\n" ; 
    		else {
			if ( !e.getMessage().startsWith("ERROR")) sqlError = "ERROR ";
			sqlError += e.getMessage() + "\n\n" + breaEleme + "\n" + at + "\n\n"; 
		}
	  else
			sqlError = e.getMessage();
	  ret.error = sqlError;
	}
    catch [TokenStreamException e]
	{
	  if ( subtree == null || !subtree.trim().startsWith("_admin") )
			sqlError = LogManager.getReference().getMessage("sep_parser_excep") + "\n" +
			           e.getMessage() + "\n\n" +
					   breaEleme + "\n" + at + "\n\n" +
                       missingEl + " " + nt + "\n" ;  
	  else
			sqlError = e.getMessage();

	  ret.error = sqlError;
	}
	;

request
	:   orequest
		  { nt = "&lt;";}
		LT
          { at += "&lt;"; nt = "fetch or store"; }
		((fetch crequest) | store)
		exception
		catch [RecognitionException e]
 		{ throw new RecognitionException( e.getMessage(), "", e.getLine() ); }
    ;

store
	:	a:STORE
          { at += a.getText(); nt = "\n-optional attribute: action \n-or end of token: &gt; "; }
		  (action)?
		GT
	  { ret.type = "store"; }
	  exception
	  catch [RecognitionException e]
	  { throw new RecognitionException( e.getMessage(), "", e.getLine() ); }
	;

fetch
	:	ofetch
		{ ret.type = "fetch"; }
		  { nt = "&lt;";}
		LT
          { at += nt; nt = "union"; }
		union[1] (ordering)? 
		cfetch
		exception
		catch [RecognitionException e]
		{ throw new RecognitionException( e.getMessage(), "", e.getLine() ); }
	;	

ordering 
	:	oordering (path)+ cordering
		exception
		catch [RecognitionException e]
		{ throw new RecognitionException( e.getMessage(), "", e.getLine() ); }
	;

union [ int compareNr ]
	:	{
		int intersectNr = 1;
		if (compareNr > 1) toSQLfinal += " INTERSECT ";
		}
		ounion
		{ if (compareNr > 1) toSQLfinal += " "; }
		(intersect[intersectNr++])+
		cunion
		{ if (compareNr > 1) toSQLfinal += " "; }
		exception
		catch [RecognitionException e]
		{ throw new RecognitionException( e.getMessage(), "", e.getLine() ); }

	;

compare [int compareNr]
	:   {
		attrib    = null;
		order     = "ascending";
		property  = null;
		sqlPath   = "";
		sqlIsPath = false;

		if (compareNr > 1) toSQLfinal += " INTERSECT ";
	    }
	  ocompare
	  {
	    if ( !subtree.trim().startsWith("_admin.") ) {
		   sqlTreeID = handler.getTreeID(subtree);
		   if (sqlTreeID == -1)
			  throw new RecognitionException("ERROR " + handler.getErrorMessage(), "", 0);
		   sqlDocumentID = handler.getDocumentID(subtree);
	    }
	  }
	  path
	  value
	  ccompare
	  {
		if ( !subtree.trim().startsWith("_admin.") ) {
		    ret.scanTree = sqlPath.trim().length() > 0 || sqlValue.trim().length() > 0;
		    toSQLfinal += handler.toSQL(sqlPath, sqlValue, sqlOp, sqlApprox, sqlCsens, sqlTreeID, sqlDocumentID, sqlBlockNr++, sqlAscDesc, subtree);
		}
		else {
		    String tree = null;
		    int     poz = -1;
		    if ( subtree.indexOf(".") != -1 ) {
			   poz = subtree.indexOf(".", subtree.indexOf(".") + 1 );
			   if ( poz != -1 ) tree = subtree.substring(subtree.indexOf(".")+1, poz);
			   else tree = subtree.substring(subtree.indexOf(".")+1);
		    }
		    if ( poz == -1 ) {
			   String result = admHandler.toSQL(tree, null);
			   if ( result == null )
			      throw new RecognitionException("ERROR " + admHandler.getErrorMSG(), "", 0);
			   else
			      throw new RecognitionException(subtree + ":" + result, "", 0);
		    }
		    else {
			   String result = admHandler.toSQL( tree, subtree.substring(poz + 1) );
			   if ( result == null )
			      throw new RecognitionException("ERROR " + admHandler.getErrorMSG(), "", 0);
			   else
			      throw new RecognitionException(subtree.substring( 0, poz ) + ":" + result, "", 0);
		    }
		}
	  }
	exception
	catch [RecognitionException e]
	{ throw new RecognitionException( e.getMessage(), "", e.getLine() ); }
	;

intersect [int intersectNr]
	:	{
		subtree   = "";
		sqlCsens  = true;
		sqlApprox = false;
		sqlTreeID = 0;
		sqlDocumentID = -1;
		sqlOp     = "eq";
		sqlValue  = "";

		int compareNr = 1;
		if (intersectNr > 1) toSQLfinal += " UNION "; else toSQLfinal +=" ";
		}    
		ointersect
		  { nt = "&lt;";}
		( LT
          { at += nt; nt = "union or compare"; }
	    ( union[compareNr++] | compare[compareNr++] ) )+
		cintersect
		{ toSQLfinal += " "; }
	   exception
	   catch [RecognitionException e]
	   { throw new RecognitionException( e.getMessage(), "",  e.getLine() ); }
	;


path
	:   opath
		(
		    ( SL { at += "/"; } GT { at += "&gt;"; } ) 
		  | ( GT { at += "&gt;"; } 
              (options {greedy=false;}:element)*
              cpath 
            )
		)

	    {
		if (attrib != null) sqlPath += ";" + attrib;
		sqlIsPath = handler.isPath(sqlPath);
		if (!sqlIsPath)
			throw new RecognitionException( "ERROR " + handler.getErrorMessage() , "", 0 );
	    }
		exception
		catch [RecognitionException e]
		{ throw new RecognitionException( e.getMessage(), "", e.getLine() ); }
	;

value
	: 	  { nt = "&lt;"; }
		l:LT
          { at += nt; nt = "value&gt;...&lt;/value"; }
		t:XVALUE
          { at += "value&gt;" + t.getText() + "&lt;/value"; nt = "&gt;"; }
		GT
		  { at += nt;  sqlValue = t.getText(); }
		exception
		catch [RecognitionException e]
	    { throw new RecognitionException( e.getMessage(), "", l.getLine() ); }
	;


orequest
	:     { nt = "&lt;"; }
		l:LT
          { at += nt; nt = "request"; }
		a:REQUEST
          { at += a.getText(); nt = " reqno"; }
          reqno
		GT
          { at += "&gt;"; }
		exception
		catch [RecognitionException e]
		{ throw new RecognitionException( e.getMessage(), "", l.getLine() ); }
	;

crequest
	:     { nt = "&lt;/"; }
		l:ET
          { at += nt; nt = "request"; }
		a:REQUEST
          { at += a.getText(); nt = "&gt;"; }
		GT
          { at += nt; }
		exception
		catch [RecognitionException e]
		{ throw new RecognitionException( e.getMessage(), "", l.getLine() ); }
	;

ofetch
	:	  {
			cnt_related=0; cnt_offset=0; cnt_maxnum=0;
            cnt_notification=0; cnt_prevstamp=0;
		  }
        a:FETCH
          { at += a.getText();
            nt  = "\n-some of the optional atributes: related, offset, maxnum," + 
                  " notification, prevstamp ";
            nt += "\n-or the end of token: &gt; "; }
          ( related | offset | maxnum | notification | prevstamp )*
        GT
          {
			at += "&gt;";
		    if ( cnt_related>1 || cnt_offset>1 || cnt_maxnum>1 ||
                 cnt_notification>1 || cnt_prevstamp>1 ) throw new RecognitionException();
		  }

		exception
		catch [RecognitionException e]
		{
		  sqlError = e.getMessage() + "\n" ;
		  if (cnt_related > 1) sqlError += manyAttr("related","fetch") ;
		  if (cnt_offset > 1)  sqlError += manyAttr("offset","fetch") ;
		  if (cnt_maxnum > 1)  sqlError += manyAttr("maxnum","fetch") ;
		  if (cnt_notification > 1) sqlError += manyAttr("notification","fetch") ;
		  if (cnt_prevstamp > 1) sqlError += manyAttr("prevstamp","fetch") ;
		  throw new RecognitionException( sqlError, "", a.getLine() );
		}
	;

cfetch
	:     { nt = "&lt;/"; }
		l:ET
          { at += nt; nt = "fetch"; }
		a:FETCH
          { at += a.getText(); nt = "&gt;"; }
		GT
          { at += nt; }
		exception
		catch [RecognitionException e]
		{ throw new RecognitionException( e.getMessage(), "", l.getLine() ); }
	;

oordering
	: 	  { nt = "&lt;"; }
		l:LT
          { at += nt; nt = "ordering"; }
		a:ORDERING
          { at += a.getText(); nt = "&gt;"; }
		GT 
          { at += nt; }
		exception
		catch [RecognitionException e]
		{ throw new RecognitionException( e.getMessage(), "", l.getLine() ); }

	;

cordering
	: 	  { nt = "&lt;/"; }
		l:ET
          { at += nt; nt = "ordering"; }
		a:ORDERING
          { at += a.getText(); nt = "&gt;"; }
		GT
          { at += nt; }
		exception
		catch [RecognitionException e]
		{ throw new RecognitionException( e.getMessage(), "", l.getLine() ); }
	;

ounion
	: 	a:UNION
          { at += a.getText(); nt = "&gt;"; }
		b:GT
          { at += nt; }
		exception
		catch [RecognitionException e]
		{ throw new RecognitionException( e.getMessage(), "", a.getLine() ); }
	;

cunion
	: 	  { nt = "&lt;/"; }
		l:ET
          { at += nt; nt = "union"; }
		a:UNION
          { at += a.getText(); nt = "&gt;"; }
		GT
          { at += nt; }
		exception
		catch [RecognitionException e]
		{ throw new RecognitionException( e.getMessage(), "", l.getLine() ); }
	;

ointersect
	: 	  { nt = "&lt;"; }
		l:LT
          { at += nt; nt = "intersect"; }
		a:INTERSECT
          { at += a.getText(); nt = "&gt;"; }
		GT
          { at += nt; }
		exception
		catch [RecognitionException e]
		{ throw new RecognitionException( e.getMessage(), "", l.getLine() ); }
	;

cintersect
	: 	  { nt = "&lt;/"; }
		l:ET
          { at += nt; nt = "intersect"; }
		a:INTERSECT
          { at += a.getText(); nt = "&gt;"; }
		GT
          { at += nt; }
		exception
		catch [RecognitionException e]
		{ throw new RecognitionException( e.getMessage(), "", l.getLine() ); }
	;

ocompare
	: 	  { cnt_subtree=0; cnt_operator=0; cnt_casesens=0; cnt_approx=0; }
		a:COMPARE
		  {
			at += a.getText();
            nt  = "\n-the needed atribute: subtree ";
            nt += "\n-or some of the optional atributes: operator, casesensitive, approximate ";
		  }
		  ( subtree | operator | casesensitive | approximate )+
		GT
		  {
			at += "&gt;";
		    if (cnt_subtree==0 || cnt_subtree>1 || cnt_operator>1 || cnt_casesens>1 || cnt_approx>1)
			   throw new RecognitionException();
		  }
		exception
		catch [RecognitionException e]
		{
		  sqlError = e.getMessage() + "\n";
		  if (cnt_subtree == 0)	sqlError += missingAttr("subtree","compare") ;
		  if (cnt_subtree > 1)	sqlError += manyAttr("subtree","compare") ;
		  if (cnt_operator > 1)	sqlError += manyAttr("operator","compare") ;
		  if (cnt_casesens > 1)	sqlError += manyAttr("casesensitive","compare");
		  if (cnt_approx > 1)	sqlError += manyAttr("approximate","compare");
		  throw new RecognitionException( sqlError, "", a.getLine() );
		}
	;

ccompare
	: 	  { nt = "&lt;/"; }
		l:ET
          { at += nt; nt = "compare"; }
		a:COMPARE
          { at += a.getText(); nt = "&gt;"; }
		GT
          { at += nt; }
		exception
		catch [RecognitionException e]
		{ throw new RecognitionException( e.getMessage(), "", l.getLine() ); }
	;

opath
	:     { nt = "&lt;"; cnt_attribute=0; cnt_order=0; }
        l:LT
          { at += nt; nt = "path"; }
		a:PATH
		  {
			at += a.getText();
            nt  = "\n-some of the optional atributes: order, attribute ";
            nt += "\n-or the end of token: &gt; ";
            nt += "\n-or the end of element: /&gt; ";
		  }
		  ( attribute | order )*
		  { if ( cnt_attribute>1 || cnt_order>1 ) throw new RecognitionException();	}
		exception
		catch [RecognitionException e]
		{
		  sqlError = e.getMessage() + "\n";
		  if (cnt_attribute > 1)	sqlError += manyAttr("attribute","path");
		  if (cnt_operator  > 1)	sqlError += manyAttr("operator" ,"path");
		  throw new RecognitionException( sqlError, "", l.getLine() );
		}
	;

cpath
	: 	  { nt = "&lt;/"; }
		l:ET
          { at += nt; nt = "path"; }
		a:PATH
          { at += a.getText(); nt = "&gt;"; }
		GT
          { at += nt; }
		exception
		catch [RecognitionException e]
		{ throw new RecognitionException( e.getMessage(), "", l.getLine() ); }
	;


element
	:	oelement
		(
		  ( SL { at += "/"; nt = "&gt;"; }  GT { at += "&gt;";} )
		| ( GT { at += "&gt;"; } celement )
		)
		exception
		catch [RecognitionException e]
		{ throw new RecognitionException( e.getMessage(), "", e.getLine() ); }
	;

oelement
	:     { nt = "&lt;"; }
        l:LT
          { at += nt; nt = "element or /path"; }
		a:ELEMENT
          { at += a.getText(); nt = "property"; }
		  property
		exception
		catch [RecognitionException e]
		{ throw new RecognitionException( e.getMessage(), "", l.getLine() ); }
	;

celement
	: 	  { nt = "&lt;/"; }
		l:ET
          { at += nt; nt = "element"; }
		a:ELEMENT
          { at += a.getText(); nt = "&gt"; }
		GT
          { at += nt; }
		exception
		catch [RecognitionException e]
		{ throw new RecognitionException( e.getMessage(), "", l.getLine() ); }
	;


/* Attributes for STORE */
action	: 	a:ACTION
		      { at += " " + a.getText(); nt = "="; }
			b:EQ
		      {	at += b.getText(); nt = "Value of attribute (action='...')!"; }
			t:STRING
			{
			String gt = t.getText();
			ret.action= gt.replace( gt.charAt(0), ' ' ).trim();
			at += t.getText();
			nt  = "&gt;";
			}
			exception
			catch [RecognitionException e]
			{
			throw new RecognitionException(errorInAttr("action",e.getMessage()),"",e.getLine()); 
			}
		;

/* Attributes for REQUEST */
reqno	: 	a:REQNO
		      { at += " " + a.getText(); nt = "="; }
            b:EQ
		      {	at += b.getText(); nt = "Value of attribute (reqno='...')!"; }
            t:STRING
			{
			try {
				String gt = (t.getText()).replace( (t.getText()).charAt(0), ' ' ).trim();
				ret.reqno = Integer.parseInt(gt);
			}
			catch ( Exception e) { throw new RecognitionException( 
				                   LogManager.getReference().getMessage("sep_parser_reqno") +
                                   " " + t.getText(), "", t.getLine());
			}
			at += t.getText();
			nt  = "&gt;";
			}	
			exception
		    catch [RecognitionException e]
			{
			throw new RecognitionException(errorInAttr("reqno",e.getMessage()),"",e.getLine()); 
			}
			;

/* Attributes for FETCH */
related	:   a:RELATED
		      { at += " " + a.getText(); nt = "="; }
            b:EQ
		      {	at += b.getText(); nt = "Value of attribute (related='...')!"; }
            t:STRING
 			{
			String gt = t.getText();
			related = gt.replace( gt.charAt(0), ' ' ).trim();
			cnt_related++;
			at += t.getText();
            nt  = "\n-some of the optional atributes: offset, maxnum, notification, prevstamp ";
            nt += "\n-or the end of token: &gt; ";
			}
			exception
		    catch [RecognitionException e]
			{
			throw new RecognitionException(errorInAttr("related",e.getMessage()),"",e.getLine()); 
			}
		    ;
offset	:   a:OFFSET
		      { at += " " + a.getText(); nt = "="; }
            b:EQ
		      {	at += b.getText(); nt = "Value of attribute (offset='...')!"; }
			t:STRING
			{
			String gt = t.getText();
			offset = gt.replace( gt.charAt(0), ' ' ).trim();
			cnt_offset++;
			at += t.getText();
            nt  = "\n-some of the optional atributes: related, maxnum, notification, prevstamp ";
            nt += "\n-or the end of token: &gt; ";
		    }
			exception
		    catch [RecognitionException e]
			{
			throw new RecognitionException(errorInAttr("offset",e.getMessage()),"",e.getLine()); 
			}
			;
maxnum	:   a:MAXNUM
		      { at += " " + a.getText(); nt = "="; }
			b:EQ
		      {	at += b.getText(); nt = "Value of attribute (maxnum='...')!"; }
			t:STRING
			{
			String gt = t.getText();
			maxnum = gt.replace( gt.charAt(0), ' ' ).trim();
			cnt_maxnum++;
			at += t.getText();
            nt  = "\n-some of the optional atributes: related, offset, notification, prevstamp ";
            nt += "\n-or the end of token: &gt; ";
		    }
			exception
		    catch [RecognitionException e]
			{
			throw new RecognitionException(errorInAttr("maxnum",e.getMessage()),"",e.getLine()); 
			}
 			;
notification
		:	a:NOTIFICATION
		      { at += " " + a.getText(); nt = "="; }
			b:EQ
		      {	at += b.getText(); nt = "Value of attribute (notification='...')!"; }
			t:STRING
			{
			String gt = t.getText();
			notifi = gt.replace( gt.charAt(0), ' ' ).trim();
			cnt_notification++;
			at += t.getText();
            nt  = "\n-some of the optional atributes: related, offset, maxnum, prevstamp ";
            nt += "\n-or the end of token: &gt; ";
		    }
			exception
		    catch [RecognitionException e]
			{
			throw new RecognitionException(errorInAttr("notification",e.getMessage()),"",e.getLine()); 
			}
 			;
prevstamp:  a:PREVSTAMP
		      { at += " " + a.getText(); nt = "="; }
			b:EQ
		      {	at += b.getText(); nt = "Value of attribute (prevstamp='...')!"; }
			t:STRING
			{
			String gt = t.getText();
			prevstmp = gt.replace( gt.charAt(0), ' ' ).trim();
			cnt_prevstamp++;
			at += t.getText();
            nt  = "\n-some of the optional atributes: related, offset, maxnum, notification ";
            nt += "\n-or the end of token: &gt; ";
		    }
			exception
		    catch [RecognitionException e]
			{
			throw new RecognitionException(errorInAttr("prevstamp",e.getMessage()),"",e.getLine()); 
			}
			;

/* Attributes for COMPARE */
subtree	:	a:SUBTREE
		      { at += " " + a.getText(); nt = "="; }
			b:EQ
		      {	at += b.getText(); nt = "Value of attribute (subtree='...')!"; }
			t:STRING
			{
			String gt = t.getText();
			subtree = gt.replace( gt.charAt(0), ' ' ).trim();
			cnt_subtree++;
			at += t.getText();
            nt  = "\n-some of the optional atributes: operator, casesensitive, approximate ";
            nt += "\n-or the end of token: &gt; ";
		    }
			exception
		    catch [RecognitionException e]
			{
			throw new RecognitionException(errorInAttr("subtree",e.getMessage()),"",e.getLine());
			}
 			;
operator:   a:OPERATOR
		      { at += " " + a.getText(); nt = "="; }
			b:EQ
		      {	at += b.getText(); nt = "Value of attribute (operator='...')!"; }
			t:STRING
			{
			String gt = t.getText();
			sqlOp = gt.replace( gt.charAt(0), ' ' ).trim();
			cnt_operator++;
			at += t.getText();
            nt  = "\n-the needed atribute: subtree ";
            nt += "\n-or some of the optional atributes: casesensitive, approximate ";
            nt += "\n-or the end of token: &gt; ";
		    }
			exception
		    catch [RecognitionException e]
			{
			throw new RecognitionException(errorInAttr("operator",e.getMessage()),"",e.getLine());
			}
			;
casesensitive
		:	a:CASESENSITIVE
		      { at += " " + a.getText(); nt = "="; }
			b:EQ
		      {	at += b.getText(); nt = "Value of attribute (casesensitive='...')!"; }
			t:STRING
			{
			String gt = t.getText();
			if ( ("true").equals( gt.replace( gt.charAt(0), ' ' ).trim() ) ) sqlCsens = true;
			else sqlCsens = false;
			cnt_casesens++;
			at += t.getText();
            nt  = "\n-the needed atribute: subtree ";
            nt += "\n-or some of the optional atributes: operator, approximate ";
            nt += "\n-or the end of token: &gt; ";
		    }
			exception
		    catch [RecognitionException e]
		    {
			throw new RecognitionException(errorInAttr("casesensitive",e.getMessage()),"",e.getLine());
			}
			;
approximate
		:	a:APPROXIMATE
		      { at += " " + a.getText(); nt = "="; }
			b:EQ
		      {	at += b.getText(); nt = "Value of attribute (approximate='...')!"; }
			t:STRING
			{
			String gt = t.getText();
			if ( ("true").equals( gt.replace( gt.charAt(0), ' ' ).trim() ) ) sqlApprox = true;
			else sqlApprox = false;
			cnt_approx++;
			at += t.getText();
            nt  = "\n-the needed atribute: subtree ";
            nt += "\n-or some of the optional atributes: operator, casesensitive ";
            nt += "\n-or the end of token: &gt; ";
		    }
			exception
		    catch [RecognitionException e]
			{
			throw new RecognitionException(errorInAttr("approximate",e.getMessage()),"",e.getLine());
			}
			;

/* Attributes for PATH */
attribute:  a:ATTRIBUTE
		      { at += " " + a.getText(); nt = "="; }
			b:EQ
		      {	at += b.getText(); nt = "Value of attribute (attribute='...')!"; }
			t:STRING
			{
			String gt = t.getText();
		    attrib = gt.replace( gt.charAt(0), ' ' ).trim();
			cnt_attribute++;
			at += t.getText();
            nt  = "\n-the atribute: order ";
            nt += "\n-or the end of token: &gt; ";
		    }
			exception
		    catch [RecognitionException e]
			{
			throw new RecognitionException(errorInAttr("attribute",e.getMessage()),"",e.getLine());
			}
			;
order	:	a:ORDER
		      { at += " " + a.getText(); nt = "="; }
			b:EQ
		      {	at += b.getText(); nt = "Value of attribute (order='...')!"; }
			t:STRING
			{
			String gt = t.getText();
			if ( ("ascendent").equals( gt.replace( gt.charAt(0), ' ' ).trim() ) ) sqlAscDesc = "ASC";
			else sqlAscDesc = "DESC";
            cnt_order++;
			at += t.getText();
            nt  = "\n-the atribute: attribute ";
            nt += "\n-or the end of token: &gt; ";
		    }
			exception
		    catch [RecognitionException e]
			{
			throw new RecognitionException(errorInAttr("order",e.getMessage()),"",e.getLine());
			}
			;

/* Attributes for ELEMENT */
property:	a:PROPERTY
		      { at += " " + a.getText(); nt = "="; }
			b:EQ
		      {	at += b.getText(); nt = "Value of attribute (property='...')!"; }
			t:STRING
			{
			String gt = t.getText();
			property = gt.replace( gt.charAt(0), ' ' ).trim();
			if (sqlPath.trim().length() < 1 ) sqlPath = property;
			else sqlPath += ":" + property;
			cnt_property++;
			at += t.getText();
            nt  = "&gt; or /&gt; ";
		    }
			exception
		    catch [RecognitionException e]
			{
			throw new RecognitionException(errorInAttr("property",e.getMessage()),"",e.getLine());
			}
			;



/** 
 * The lexer for sep.
 * This class is automaticaly generated by 
 * <a href="http://www.antlr.org">ANTLR</a>.
 * @author <a href="mailto:atech@nolimits.ro">Antal Attila</a>
 * @version $Revision: 1.20 $ $Date: 2001/11/09 18:33:47 $
 */

class sepLexer extends Lexer;

options {	
	k = 6;
	exportVocab=sep;
	charVocabulary = '\3'..'\377';
	caseSensitive=false;
	defaultErrorHandler=false;
	filter=WS;
}

{

/* If true, will print debugg information to screen */
public static boolean debug = false;

private String eLine( int lineNo) {
  int l = lineNo - 1;
  return sepParser.errorLine + l + "\n";
}

private String eWord( String wrd) {
  return sepParser.errorWord + "'" + wrd + "' " ;
}

}

XVALUE
options {paraphrase="&lt;value&gt;TEXT value&lt;/value&gt;";}
	:
	 VALUE (WS)? GT ( options {greedy=false;}:. )* 
	 {
	 String gtx = $getText;
	 String val = gtx.substring( gtx.indexOf(">")+1 );
	 if (debug) System.out.print(val);
     CommonToken t = new CommonToken(XVALUE,val);
     $setToken(t);
     }
	 ET VALUE (WS)?
exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine())+ "ERROR in value element: " +  e.getMessage() ); } ;



/* Element tokens */
REQUEST    	: "request"    	  { if (debug) System.out.print( "request"); }

exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine()) + eWord("request") + e.getMessage() );} ;


FETCH     	: "fetch"    	  { if (debug) System.out.print( "fetch");     }
exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine()) + eWord("fetch") + e.getMessage() ); } ;

ORDERING  	: "ordering"      { if (debug) System.out.print( "ordering");  }
exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine()) + eWord("ordering") + e.getMessage() ); } ;

UNION     	: "union"         { if (debug) System.out.print( "union");     }
exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine()) + eWord("union") + e.getMessage() ); } ;

INTERSECT 	: "intersect"     { if (debug) System.out.print( "intersect"); }
exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine()) + eWord("intersect") + e.getMessage() ); } ;

COMPARE   	: "compare"       { if (debug) System.out.print( "compare");   }
exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine()) + eWord("compare") + e.getMessage() ); } ;

PATH      	: "path"          { if (debug) System.out.print( "path");      }
exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine()) + eWord("path") + e.getMessage() ); } ;

ELEMENT   	: "element"       { if (debug) System.out.print( "element");   }
exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine()) + eWord("element") + e.getMessage() ); } ;

VALUE     	: "value"         { if (debug) System.out.print( "value");     }
exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine()) + eWord("value") + e.getMessage() ); } ;

STORE     	: "store"         { if (debug) System.out.print( "store");     }
exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine()) + eWord("store") + e.getMessage() ); } ;




/* Attribute tokens */

REQNO	  	: "reqno"		  { if (debug) System.out.print( " reqno"); }
exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine()) + eWord("reqno") + e.getMessage() ); } ;

RELATED		: "related" 	  { if (debug) System.out.print( " related"); }
exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine()) + eWord("related") + e.getMessage() ); } ;

OFFSET		: "offset"		  { if (debug) System.out.print( " offset"); }
exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine()) + eWord("offset") + e.getMessage() ); } ;

MAXNUM		: "maxnum"		  { if (debug) System.out.print( " maxnum"); }
exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine()) + eWord("maxnum") + e.getMessage() ); } ;

NOTIFICATION: "notification"  { if (debug) System.out.print(" notificaton");}
exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine()) + eWord("notification") + e.getMessage() ); } ;

PREVSTAMP	: "prevstamp"	  { if (debug) System.out.print( " prevstamp");    }
exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine()) + eWord("prevstamp") + e.getMessage() ); } ;

SUBTREE		: "subtree"		  { if (debug) System.out.print( " subtree");      }
exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine()) + eWord("subtree") + e.getMessage() ); } ;

OPERATOR	: "operator"	  { if (debug) System.out.print( " operator");     }
exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine()) + eWord("operator") + e.getMessage() ); } ;

CASESENSITIVE: "casesensitive"{ if (debug) System.out.print( " casesensitive");}
exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine()) + eWord("casesensitive") + e.getMessage() ); } ;

APPROXIMATE	: "approximate"	  { if (debug) System.out.print( " approximate");  }
exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine()) + eWord("approximate") + e.getMessage() ); } ;

ATTRIBUTE	: "attribute"	  { if (debug) System.out.print( " attribute");    }
exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine()) + eWord("attribute") + e.getMessage() ); } ;

ORDER		: "order"		  { if (debug) System.out.print( " order");        }
exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine()) + eWord("order") + e.getMessage() ); } ;

PROPERTY	: "property"	  { if (debug) System.out.print( " property");     } 
exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine()) + eWord("property") + e.getMessage() ); } ;

ACTION		: "action"	  { if (debug) System.out.print( " action");     } 
exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine()) + eWord("action") + e.getMessage() ); } ;



/* Elementary tokens */

ET
options {paraphrase="&lt;/";}:	LT SL	;
LT
options {paraphrase="&lt;";}:	'<'		{ if (debug) System.out.print("<"); } ;
GT
options {paraphrase="&gt;";}:	'>'		{ if (debug) System.out.print(">"); } ;
SL
options {paraphrase="/";}:  	"/"	    { if (debug) System.out.print("/"); } ;
EQ
options {paraphrase="=";}:      "="     { if (debug) System.out.print("="); } ;


STRING
options { paraphrase="attribute string type value"; }
	:   '\''  { if (debug) System.out.print("'" ); }
     (a:~('\''|'<'|'>') { if (debug) System.out.print( a  ); } )*
        '\''  { if (debug) System.out.print("'" ); }
	|	'"'   { if (debug) System.out.print("\""); }
     (b:~('"'|'<'|'>')  { if (debug) System.out.print( b  ); } )*
        '"'   { if (debug) System.out.print("\""); }
exception
catch [RecognitionException e]
{throw new TokenStreamException( eLine(e.getLine()) + sepParser.missingAp );} ;



/* Protected tokens */

protected
WS	:	(
		options { generateAmbigWarnings=false; }
		:	' '    
		|	'\t'
		|	'\n'	{ newline(); }
		|	"\r\n"	{ newline(); }
		|	'\r'	{ newline(); }
		)+
		{ $setType(Token.SKIP); }
	;


exception
catch [RecognitionException e]
{ throw new TokenStreamException( eLine(e.getLine()) + e.getMessage() ); }

