// $ANTLR 2.7.1: "sep.g" -> "sepLexer.java"$

package org.media.datastore.sepengine.parser;

import org.media.datastore.sepengine.SepInterpreter;
import org.media.datastore.sepengine.util.*;
import org.media.datastore.sepengine.RDBInfo;
import org.media.datastore.sepengine.LogManager;
import org.apache.log.*;

import java.io.InputStream;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.TokenStreamRecognitionException;
import antlr.CharStreamException;
import antlr.CharStreamIOException;
import antlr.ANTLRException;
import java.io.Reader;
import java.util.Hashtable;
import antlr.CharScanner;
import antlr.InputBuffer;
import antlr.ByteBuffer;
import antlr.CharBuffer;
import antlr.Token;
import antlr.CommonToken;
import antlr.RecognitionException;
import antlr.NoViableAltForCharException;
import antlr.MismatchedCharException;
import antlr.TokenStream;
import antlr.ANTLRHashString;
import antlr.LexerSharedInputState;
import antlr.collections.impl.BitSet;
import antlr.SemanticException;

/** 
 * The lexer for sep.
 * This class is automaticaly generated by 
 * <a href="http://www.antlr.org">ANTLR</a>.
 * @author <a href="mailto:atech@nolimits.ro">Antal Attila</a>
 * @version $Revision: 1.20 $ $Date: 2001/11/09 18:33:47 $
 */
public class sepLexer extends antlr.CharScanner implements sepTokenTypes, TokenStream
 {


/* If true, will print debugg information to screen */
public static boolean debug = false;

private String eLine( int lineNo) {
  int l = lineNo - 1;
  return sepParser.errorLine + l + "\n";
}

private String eWord( String wrd) {
  return sepParser.errorWord + "'" + wrd + "' " ;
}

public sepLexer(InputStream in) {
	this(new ByteBuffer(in));
}
public sepLexer(Reader in) {
	this(new CharBuffer(in));
}
public sepLexer(InputBuffer ib) {
	this(new LexerSharedInputState(ib));
}
public sepLexer(LexerSharedInputState state) {
	super(state);
	literals = new Hashtable();
caseSensitiveLiterals = true;
setCaseSensitive(false);
}

public Token nextToken() throws TokenStreamException {
	Token theRetToken=null;
tryAgain:
	for (;;) {
		Token _token = null;
		int _ttype = Token.INVALID_TYPE;
		setCommitToPath(false);
		int _m;
		_m = mark();
		resetText();
		try {   // for char stream error handling
			try {   // for lexical error handling
				switch ( LA(1)) {
				case '>':
				{
					mGT(true);
					theRetToken=_returnToken;
					break;
				}
				case 'f':
				{
					mFETCH(true);
					theRetToken=_returnToken;
					break;
				}
				case 'u':
				{
					mUNION(true);
					theRetToken=_returnToken;
					break;
				}
				case 'i':
				{
					mINTERSECT(true);
					theRetToken=_returnToken;
					break;
				}
				case 'e':
				{
					mELEMENT(true);
					theRetToken=_returnToken;
					break;
				}
				case 'm':
				{
					mMAXNUM(true);
					theRetToken=_returnToken;
					break;
				}
				case 'n':
				{
					mNOTIFICATION(true);
					theRetToken=_returnToken;
					break;
				}
				case '/':
				{
					mSL(true);
					theRetToken=_returnToken;
					break;
				}
				case '=':
				{
					mEQ(true);
					theRetToken=_returnToken;
					break;
				}
				case '"':  case '\'':
				{
					mSTRING(true);
					theRetToken=_returnToken;
					break;
				}
				default:
					if ((LA(1)=='v') && (LA(2)=='a') && (LA(3)=='l') && (LA(4)=='u') && (LA(5)=='e') && (_tokenSet_0.member(LA(6)))) {
						mXVALUE(true);
						theRetToken=_returnToken;
					}
					else if ((LA(1)=='o') && (LA(2)=='r') && (LA(3)=='d') && (LA(4)=='e') && (LA(5)=='r') && (LA(6)=='i')) {
						mORDERING(true);
						theRetToken=_returnToken;
					}
					else if ((LA(1)=='v') && (LA(2)=='a') && (LA(3)=='l') && (LA(4)=='u') && (LA(5)=='e') && (true)) {
						mVALUE(true);
						theRetToken=_returnToken;
					}
					else if ((LA(1)=='o') && (LA(2)=='r') && (LA(3)=='d') && (LA(4)=='e') && (LA(5)=='r') && (true)) {
						mORDER(true);
						theRetToken=_returnToken;
					}
					else if ((LA(1)=='r') && (LA(2)=='e') && (LA(3)=='q') && (LA(4)=='u')) {
						mREQUEST(true);
						theRetToken=_returnToken;
					}
					else if ((LA(1)=='r') && (LA(2)=='e') && (LA(3)=='q') && (LA(4)=='n')) {
						mREQNO(true);
						theRetToken=_returnToken;
					}
					else if ((LA(1)=='r') && (LA(2)=='e') && (LA(3)=='l')) {
						mRELATED(true);
						theRetToken=_returnToken;
					}
					else if ((LA(1)=='p') && (LA(2)=='r') && (LA(3)=='e')) {
						mPREVSTAMP(true);
						theRetToken=_returnToken;
					}
					else if ((LA(1)=='p') && (LA(2)=='r') && (LA(3)=='o')) {
						mPROPERTY(true);
						theRetToken=_returnToken;
					}
					else if ((LA(1)=='<') && (LA(2)=='/')) {
						mET(true);
						theRetToken=_returnToken;
					}
					else if ((LA(1)=='c') && (LA(2)=='o')) {
						mCOMPARE(true);
						theRetToken=_returnToken;
					}
					else if ((LA(1)=='p') && (LA(2)=='a')) {
						mPATH(true);
						theRetToken=_returnToken;
					}
					else if ((LA(1)=='s') && (LA(2)=='t')) {
						mSTORE(true);
						theRetToken=_returnToken;
					}
					else if ((LA(1)=='o') && (LA(2)=='f')) {
						mOFFSET(true);
						theRetToken=_returnToken;
					}
					else if ((LA(1)=='s') && (LA(2)=='u')) {
						mSUBTREE(true);
						theRetToken=_returnToken;
					}
					else if ((LA(1)=='o') && (LA(2)=='p')) {
						mOPERATOR(true);
						theRetToken=_returnToken;
					}
					else if ((LA(1)=='c') && (LA(2)=='a')) {
						mCASESENSITIVE(true);
						theRetToken=_returnToken;
					}
					else if ((LA(1)=='a') && (LA(2)=='p')) {
						mAPPROXIMATE(true);
						theRetToken=_returnToken;
					}
					else if ((LA(1)=='a') && (LA(2)=='t')) {
						mATTRIBUTE(true);
						theRetToken=_returnToken;
					}
					else if ((LA(1)=='a') && (LA(2)=='c')) {
						mACTION(true);
						theRetToken=_returnToken;
					}
					else if ((LA(1)=='<') && (true)) {
						mLT(true);
						theRetToken=_returnToken;
					}
				else {
					if (LA(1)==EOF_CHAR) {uponEOF(); _returnToken = makeToken(Token.EOF_TYPE);}
				else {
					commit();
					try {mWS(false);}
					catch(RecognitionException e) {
						// catastrophic failure
						reportError(e);
						consume();
					}
					continue tryAgain;
				}
				}
				}
				commit();
				if ( _returnToken==null ) continue tryAgain; // found SKIP token
				_ttype = _returnToken.getType();
				_ttype = testLiteralsTable(_ttype);
				_returnToken.setType(_ttype);
				return _returnToken;
			}
			catch (RecognitionException e) {
				if ( !getCommitToPath() ) {
					rewind(_m);
					resetText();
					try {mWS(false);}
					catch(RecognitionException ee) {
						// horrendous failure: error in filter rule
						reportError(ee);
						consume();
					}
					continue tryAgain;
				}
				throw new TokenStreamRecognitionException(e);
			}
		}
		catch (CharStreamException cse) {
			if ( cse instanceof CharStreamIOException ) {
				throw new TokenStreamIOException(((CharStreamIOException)cse).io);
			}
			else {
				throw new TokenStreamException(cse.getMessage());
			}
		}
	}
}

	public final void mXVALUE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = XVALUE;
		int _saveIndex;
		
		try {      // for error handling
			mVALUE(false);
			{
			switch ( LA(1)) {
			case '\t':  case '\n':  case '\r':  case ' ':
			{
				mWS(false);
				break;
			}
			case '>':
			{
				break;
			}
			default:
			{
				throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine());
			}
			}
			}
			mGT(false);
			{
			_loop70:
			do {
				// nongreedy exit test
				if ((LA(1)=='<') && (LA(2)=='/') && (LA(3)=='v') && (LA(4)=='a') && (LA(5)=='l') && (LA(6)=='u')) break _loop70;
				if (((LA(1) >= '\u0003' && LA(1) <= '\u00ff')) && ((LA(2) >= '\u0003' && LA(2) <= '\u00ff')) && ((LA(3) >= '\u0003' && LA(3) <= '\u00ff')) && ((LA(4) >= '\u0003' && LA(4) <= '\u00ff')) && ((LA(5) >= '\u0003' && LA(5) <= '\u00ff')) && ((LA(6) >= '\u0003' && LA(6) <= '\u00ff'))) {
					matchNot(EOF_CHAR);
				}
				else {
					break _loop70;
				}
				
			} while (true);
			}
			
				 String gtx = new String(text.getBuffer(),_begin,text.length()-_begin);
				 String val = gtx.substring( gtx.indexOf(">")+1 );
				 if (debug) System.out.print(val);
			CommonToken t = new CommonToken(XVALUE,val);
			_token = t;
			
			mET(false);
			mVALUE(false);
			{
			if ((_tokenSet_1.member(LA(1)))) {
				mWS(false);
			}
			else {
			}
			
			}
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine())+ "ERROR in value element: " +  e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mVALUE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = VALUE;
		int _saveIndex;
		
		try {      // for error handling
			match("value");
			if (debug) System.out.print( "value");
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + eWord("value") + e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	protected final void mWS(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = WS;
		int _saveIndex;
		
		try {      // for error handling
			{
			int _cnt110=0;
			_loop110:
			do {
				switch ( LA(1)) {
				case ' ':
				{
					match(' ');
					break;
				}
				case '\t':
				{
					match('\t');
					break;
				}
				case '\n':
				{
					match('\n');
					newline();
					break;
				}
				default:
					if ((LA(1)=='\r') && (LA(2)=='\n') && (true) && (true) && (true) && (true)) {
						match("\r\n");
						newline();
					}
					else if ((LA(1)=='\r') && (true) && (true) && (true) && (true) && (true)) {
						match('\r');
						newline();
					}
				else {
					if ( _cnt110>=1 ) { break _loop110; } else {throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine());}
				}
				}
				_cnt110++;
			} while (true);
			}
			_ttype = Token.SKIP;
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mGT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = GT;
		int _saveIndex;
		
		match('>');
		if (debug) System.out.print(">");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mET(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = ET;
		int _saveIndex;
		
		mLT(false);
		mSL(false);
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mREQUEST(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = REQUEST;
		int _saveIndex;
		
		try {      // for error handling
			match("request");
			if (debug) System.out.print( "request");
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + eWord("request") + e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mFETCH(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = FETCH;
		int _saveIndex;
		
		try {      // for error handling
			match("fetch");
			if (debug) System.out.print( "fetch");
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + eWord("fetch") + e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mORDERING(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = ORDERING;
		int _saveIndex;
		
		try {      // for error handling
			match("ordering");
			if (debug) System.out.print( "ordering");
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + eWord("ordering") + e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mUNION(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = UNION;
		int _saveIndex;
		
		try {      // for error handling
			match("union");
			if (debug) System.out.print( "union");
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + eWord("union") + e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mINTERSECT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = INTERSECT;
		int _saveIndex;
		
		try {      // for error handling
			match("intersect");
			if (debug) System.out.print( "intersect");
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + eWord("intersect") + e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mCOMPARE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = COMPARE;
		int _saveIndex;
		
		try {      // for error handling
			match("compare");
			if (debug) System.out.print( "compare");
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + eWord("compare") + e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mPATH(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = PATH;
		int _saveIndex;
		
		try {      // for error handling
			match("path");
			if (debug) System.out.print( "path");
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + eWord("path") + e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mELEMENT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = ELEMENT;
		int _saveIndex;
		
		try {      // for error handling
			match("element");
			if (debug) System.out.print( "element");
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + eWord("element") + e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mSTORE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = STORE;
		int _saveIndex;
		
		try {      // for error handling
			match("store");
			if (debug) System.out.print( "store");
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + eWord("store") + e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mREQNO(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = REQNO;
		int _saveIndex;
		
		try {      // for error handling
			match("reqno");
			if (debug) System.out.print( " reqno");
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + eWord("reqno") + e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mRELATED(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = RELATED;
		int _saveIndex;
		
		try {      // for error handling
			match("related");
			if (debug) System.out.print( " related");
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + eWord("related") + e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mOFFSET(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = OFFSET;
		int _saveIndex;
		
		try {      // for error handling
			match("offset");
			if (debug) System.out.print( " offset");
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + eWord("offset") + e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mMAXNUM(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = MAXNUM;
		int _saveIndex;
		
		try {      // for error handling
			match("maxnum");
			if (debug) System.out.print( " maxnum");
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + eWord("maxnum") + e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mNOTIFICATION(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = NOTIFICATION;
		int _saveIndex;
		
		try {      // for error handling
			match("notification");
			if (debug) System.out.print(" notificaton");
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + eWord("notification") + e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mPREVSTAMP(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = PREVSTAMP;
		int _saveIndex;
		
		try {      // for error handling
			match("prevstamp");
			if (debug) System.out.print( " prevstamp");
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + eWord("prevstamp") + e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mSUBTREE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = SUBTREE;
		int _saveIndex;
		
		try {      // for error handling
			match("subtree");
			if (debug) System.out.print( " subtree");
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + eWord("subtree") + e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mOPERATOR(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = OPERATOR;
		int _saveIndex;
		
		try {      // for error handling
			match("operator");
			if (debug) System.out.print( " operator");
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + eWord("operator") + e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mCASESENSITIVE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = CASESENSITIVE;
		int _saveIndex;
		
		try {      // for error handling
			match("casesensitive");
			if (debug) System.out.print( " casesensitive");
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + eWord("casesensitive") + e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mAPPROXIMATE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = APPROXIMATE;
		int _saveIndex;
		
		try {      // for error handling
			match("approximate");
			if (debug) System.out.print( " approximate");
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + eWord("approximate") + e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mATTRIBUTE(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = ATTRIBUTE;
		int _saveIndex;
		
		try {      // for error handling
			match("attribute");
			if (debug) System.out.print( " attribute");
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + eWord("attribute") + e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mORDER(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = ORDER;
		int _saveIndex;
		
		try {      // for error handling
			match("order");
			if (debug) System.out.print( " order");
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + eWord("order") + e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mPROPERTY(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = PROPERTY;
		int _saveIndex;
		
		try {      // for error handling
			match("property");
			if (debug) System.out.print( " property");
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + eWord("property") + e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mACTION(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = ACTION;
		int _saveIndex;
		
		try {      // for error handling
			match("action");
			if (debug) System.out.print( " action");
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + eWord("action") + e.getMessage() );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mLT(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = LT;
		int _saveIndex;
		
		match('<');
		if (debug) System.out.print("<");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mSL(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = SL;
		int _saveIndex;
		
		match("/");
		if (debug) System.out.print("/");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mEQ(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = EQ;
		int _saveIndex;
		
		match("=");
		if (debug) System.out.print("=");
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	public final void mSTRING(boolean _createToken) throws RecognitionException, CharStreamException, TokenStreamException {
		int _ttype; Token _token=null; int _begin=text.length();
		_ttype = STRING;
		int _saveIndex;
		char  a = '\0';
		char  b = '\0';
		
		try {      // for error handling
			switch ( LA(1)) {
			case '\'':
			{
				match('\'');
				if (debug) System.out.print("'" );
				{
				_loop104:
				do {
					if ((_tokenSet_2.member(LA(1)))) {
						{
						a = LA(1);
						match(_tokenSet_2);
						}
						if (debug) System.out.print( a  );
					}
					else {
						break _loop104;
					}
					
				} while (true);
				}
				match('\'');
				if (debug) System.out.print("'" );
				break;
			}
			case '"':
			{
				match('"');
				if (debug) System.out.print("\"");
				{
				_loop107:
				do {
					if ((_tokenSet_3.member(LA(1)))) {
						{
						b = LA(1);
						match(_tokenSet_3);
						}
						if (debug) System.out.print( b  );
					}
					else {
						break _loop107;
					}
					
				} while (true);
				}
				match('"');
				if (debug) System.out.print("\"");
				break;
			}
			default:
			{
				throw new NoViableAltForCharException((char)LA(1), getFilename(), getLine());
			}
			}
		}
		catch (RecognitionException e) {
			throw new TokenStreamException( eLine(e.getLine()) + sepParser.missingAp );
		}
		if ( _createToken && _token==null && _ttype!=Token.SKIP ) {
			_token = makeToken(_ttype);
			_token.setText(new String(text.getBuffer(), _begin, text.length()-_begin));
		}
		_returnToken = _token;
	}
	
	
	private static final long _tokenSet_0_data_[] = { 4611686022722364928L, 0L, 0L, 0L, 0L };
	public static final BitSet _tokenSet_0 = new BitSet(_tokenSet_0_data_);
	private static final long _tokenSet_1_data_[] = { 4294977024L, 0L, 0L, 0L, 0L };
	public static final BitSet _tokenSet_1 = new BitSet(_tokenSet_1_data_);
	private static final long _tokenSet_2_data_[] = { -5764608072790048776L, -1L, -1L, -1L, 0L, 0L, 0L, 0L };
	public static final BitSet _tokenSet_2 = new BitSet(_tokenSet_2_data_);
	private static final long _tokenSet_3_data_[] = { -5764607540214104072L, -1L, -1L, -1L, 0L, 0L, 0L, 0L };
	public static final BitSet _tokenSet_3 = new BitSet(_tokenSet_3_data_);
	
	}
