// $ANTLR 2.7.1: "sep.g" -> "sepParser.java"$

package org.media.datastore.sepengine.parser;

import org.media.datastore.sepengine.SepInterpreter;
import org.media.datastore.sepengine.util.*;
import org.media.datastore.sepengine.RDBInfo;
import org.media.datastore.sepengine.LogManager;
import org.apache.log.*;

import antlr.TokenBuffer;
import antlr.TokenStreamException;
import antlr.TokenStreamIOException;
import antlr.ANTLRException;
import antlr.LLkParser;
import antlr.Token;
import antlr.TokenStream;
import antlr.RecognitionException;
import antlr.NoViableAltException;
import antlr.MismatchedTokenException;
import antlr.SemanticException;
import antlr.ParserSharedInputState;
import antlr.collections.impl.BitSet;
import antlr.collections.AST;
import antlr.ASTPair;
import antlr.collections.impl.ASTArray;

/** 
 * The parser for SEP.<br>
 * This class is automaticaly generated by 
 * <a href="http://www.antlr.org">ANTLR</a>.
 * @author <a href="mailto:atech@nolimits.ro">Antal Attila</a>
 * @version $Revision: 1.20 $ $Date: 2001/11/09 18:33:47 $
 */
public class sepParser extends antlr.LLkParser
       implements sepTokenTypes
 {


/* Variables for error messages for logging */
public static String errorLine = LogManager.getReference().getMessage("sep_parser_eline");
public static String errorWord = LogManager.getReference().getMessage("sep_parser_eword");
public static String extraWord = LogManager.getReference().getMessage("sep_parser_extraword");
public static String missingAp = LogManager.getReference().getMessage("sep_parser_missingap");
public static String missingEl = LogManager.getReference().getMessage("sep_parser_misseleme");
public static String suspEleme = LogManager.getReference().getMessage("sep_parser_suspeleme");
public static String breaEleme = LogManager.getReference().getMessage("sep_parser_breaeleme");

/* The parser returns with this table containing a lot of info*/ 
public SepReturnTable ret = new SepReturnTable();

/* Objects for working to driver */
private SepDBHandler       handler = null;
private SepADMDBHandler admHandler = null;

/* SEP attribute variables */
private String related  = null;
private String offset   = "0";
private String maxnum   = null;
private String notifi   = "false";
private String prevstmp = null;
private String subtree  = null;
private String attrib   = null;
private String order    = "ascending";
private String property = null;

/* Some variables for making SQL */
private String  sqlPath    = "";
private String  sqlAscDesc = "ASC";
private boolean sqlCsens   = true;
private boolean sqlApprox  = false;
private String  sqlOp      = "eq";
private boolean sqlIsPath  = false;
private int     sqlTreeID      = 0;
private int     sqlDocumentID  = -1;
private int     sqlBlockNr = 1;
private String  toSQLfinal = "";
private String  sqlError = "";
private String  sqlValue   = "";
private String  actToken = "";
private String  at = "";
private String  nt = "";

/* Counter variables for attributes */
private byte cnt_related = 0;
private byte cnt_offset = 0;
private byte cnt_maxnum = 0;
private byte cnt_notification = 0;
private byte cnt_prevstamp = 0;
private byte cnt_subtree = 0;
private byte cnt_operator = 0;
private byte cnt_casesens = 0;
private byte cnt_approx = 0;
private byte cnt_attribute = 0;
private byte cnt_order = 0;
private byte cnt_property = 0;


private String manyAttr(String attr, String elem) {
	return LogManager.getReference().getMessage("sep_parser_manyattri") + 
		   "'" + attr + "', " + 
		   LogManager.getReference().getMessage("sep_parser_permitted") +
           " '" + elem + "' ";
}

private String missingAttr(String attr, String elem) {
	return LogManager.getReference().getMessage("sep_parser_missattri") + 
		   "'" + attr + "', " + 
		   LogManager.getReference().getMessage("sep_parser_misspermi") +
           " '" + elem + "' ";
}

private String errorInAttr(String attr, String msg) {
	return LogManager.getReference().getMessage("sep_parser_eattr") + 
		   "'" + attr + "', " + msg;
}


protected sepParser(TokenBuffer tokenBuf, int k) {
  super(tokenBuf,k);
  tokenNames = _tokenNames;
}

public sepParser(TokenBuffer tokenBuf) {
  this(tokenBuf,4);
}

protected sepParser(TokenStream lexer, int k) {
  super(lexer,k);
  tokenNames = _tokenNames;
}

public sepParser(TokenStream lexer) {
  this(lexer,4);
}

public sepParser(ParserSharedInputState state) {
  super(state,4);
  tokenNames = _tokenNames;
}

	public final SepReturnTable  sepStart(
		RDBInfo info, String uname, SepInterpreter si
	) throws RecognitionException, TokenStreamException {
		SepReturnTable xret = ret;
		
		
		try {      // for error handling
			
				handler    = new SepDBHandler(info, uname, si);
				admHandler = new SepADMDBHandler(info, uname, si);
			ret.reqno  = 0;
				ret.action = "write";
				ret.scanTree = true;
				actToken = "";
				at = "";
				nt = "";
				
			request();
			ret.sql = toSQLfinal;	
		}
		catch (RecognitionException e) {
			
				  int l = e.getLine() - 1;
				  if ( subtree == null || !subtree.trim().startsWith("_admin") )
					if ( l > 0 )
						sqlError = LogManager.getReference().getMessage("sep_parser_excep") + "\n" +
								   errorLine + l + "\n" + e.getMessage() + "\n\n" + 
			breaEleme + "\n" + at + "\n\n" +
			missingEl + " " + nt + "\n" ; 
					else {
						if ( !e.getMessage().startsWith("ERROR")) sqlError = "ERROR ";
						sqlError += e.getMessage() + "\n\n" + breaEleme + "\n" + at + "\n\n"; 
					}
				  else
						sqlError = e.getMessage();
				  ret.error = sqlError;
				
		}
		catch (TokenStreamException e) {
			
				  if ( subtree == null || !subtree.trim().startsWith("_admin") )
						sqlError = LogManager.getReference().getMessage("sep_parser_excep") + "\n" +
						           e.getMessage() + "\n\n" +
								   breaEleme + "\n" + at + "\n\n" +
			missingEl + " " + nt + "\n" ;  
				  else
						sqlError = e.getMessage();
			
				  ret.error = sqlError;
				
		}
		return xret;
	}
	
	public final void request() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			orequest();
			nt = "&lt;";
			match(LT);
			at += "&lt;"; nt = "fetch or store";
			{
			switch ( LA(1)) {
			case FETCH:
			{
				{
				fetch();
				crequest();
				}
				break;
			}
			case STORE:
			{
				store();
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
		}
		catch (RecognitionException e) {
			throw new RecognitionException( e.getMessage(), "", e.getLine() );
		}
	}
	
	public final void orequest() throws RecognitionException, TokenStreamException {
		
		Token  l = null;
		Token  a = null;
		
		try {      // for error handling
			nt = "&lt;";
			l = LT(1);
			match(LT);
			at += nt; nt = "request";
			a = LT(1);
			match(REQUEST);
			at += a.getText(); nt = " reqno";
			reqno();
			match(GT);
			at += "&gt;";
		}
		catch (RecognitionException e) {
			throw new RecognitionException( e.getMessage(), "", l.getLine() );
		}
	}
	
	public final void fetch() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			ofetch();
			ret.type = "fetch";
			nt = "&lt;";
			match(LT);
			at += nt; nt = "union";
			union(1);
			{
			switch ( LA(1)) {
			case LT:
			{
				ordering();
				break;
			}
			case ET:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			cfetch();
		}
		catch (RecognitionException e) {
			throw new RecognitionException( e.getMessage(), "", e.getLine() );
		}
	}
	
	public final void crequest() throws RecognitionException, TokenStreamException {
		
		Token  l = null;
		Token  a = null;
		
		try {      // for error handling
			nt = "&lt;/";
			l = LT(1);
			match(ET);
			at += nt; nt = "request";
			a = LT(1);
			match(REQUEST);
			at += a.getText(); nt = "&gt;";
			match(GT);
			at += nt;
		}
		catch (RecognitionException e) {
			throw new RecognitionException( e.getMessage(), "", l.getLine() );
		}
	}
	
	public final void store() throws RecognitionException, TokenStreamException {
		
		Token  a = null;
		
		try {      // for error handling
			a = LT(1);
			match(STORE);
			at += a.getText(); nt = "\n-optional attribute: action \n-or end of token: &gt; ";
			{
			switch ( LA(1)) {
			case ACTION:
			{
				action();
				break;
			}
			case GT:
			{
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			match(GT);
			ret.type = "store";
		}
		catch (RecognitionException e) {
			throw new RecognitionException( e.getMessage(), "", e.getLine() );
		}
	}
	
	public final void action() throws RecognitionException, TokenStreamException {
		
		Token  a = null;
		Token  b = null;
		Token  t = null;
		
		try {      // for error handling
			a = LT(1);
			match(ACTION);
			at += " " + a.getText(); nt = "=";
			b = LT(1);
			match(EQ);
				at += b.getText(); nt = "Value of attribute (action='...')!";
			t = LT(1);
			match(STRING);
			
						String gt = t.getText();
						ret.action= gt.replace( gt.charAt(0), ' ' ).trim();
						at += t.getText();
						nt  = "&gt;";
						
		}
		catch (RecognitionException e) {
			
						throw new RecognitionException(errorInAttr("action",e.getMessage()),"",e.getLine()); 
						
		}
	}
	
	public final void ofetch() throws RecognitionException, TokenStreamException {
		
		Token  a = null;
		
		try {      // for error handling
			
						cnt_related=0; cnt_offset=0; cnt_maxnum=0;
			cnt_notification=0; cnt_prevstamp=0;
					
			a = LT(1);
			match(FETCH);
			at += a.getText();
			nt  = "\n-some of the optional atributes: related, offset, maxnum," + 
			" notification, prevstamp ";
			nt += "\n-or the end of token: &gt; ";
			{
			_loop31:
			do {
				switch ( LA(1)) {
				case RELATED:
				{
					related();
					break;
				}
				case OFFSET:
				{
					offset();
					break;
				}
				case MAXNUM:
				{
					maxnum();
					break;
				}
				case NOTIFICATION:
				{
					notification();
					break;
				}
				case PREVSTAMP:
				{
					prevstamp();
					break;
				}
				default:
				{
					break _loop31;
				}
				}
			} while (true);
			}
			match(GT);
			
						at += "&gt;";
					    if ( cnt_related>1 || cnt_offset>1 || cnt_maxnum>1 ||
			cnt_notification>1 || cnt_prevstamp>1 ) throw new RecognitionException();
					
		}
		catch (RecognitionException e) {
			
					  sqlError = e.getMessage() + "\n" ;
					  if (cnt_related > 1) sqlError += manyAttr("related","fetch") ;
					  if (cnt_offset > 1)  sqlError += manyAttr("offset","fetch") ;
					  if (cnt_maxnum > 1)  sqlError += manyAttr("maxnum","fetch") ;
					  if (cnt_notification > 1) sqlError += manyAttr("notification","fetch") ;
					  if (cnt_prevstamp > 1) sqlError += manyAttr("prevstamp","fetch") ;
					  throw new RecognitionException( sqlError, "", a.getLine() );
					
		}
	}
	
	public final void union(
		 int compareNr 
	) throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			
					int intersectNr = 1;
					if (compareNr > 1) toSQLfinal += " INTERSECT ";
					
			ounion();
			if (compareNr > 1) toSQLfinal += " ";
			{
			int _cnt14=0;
			_loop14:
			do {
				if ((LA(1)==LT)) {
					intersect(intersectNr++);
				}
				else {
					if ( _cnt14>=1 ) { break _loop14; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt14++;
			} while (true);
			}
			cunion();
			if (compareNr > 1) toSQLfinal += " ";
		}
		catch (RecognitionException e) {
			throw new RecognitionException( e.getMessage(), "", e.getLine() );
		}
	}
	
	public final void ordering() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			oordering();
			{
			int _cnt11=0;
			_loop11:
			do {
				if ((LA(1)==LT)) {
					path();
				}
				else {
					if ( _cnt11>=1 ) { break _loop11; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt11++;
			} while (true);
			}
			cordering();
		}
		catch (RecognitionException e) {
			throw new RecognitionException( e.getMessage(), "", e.getLine() );
		}
	}
	
	public final void cfetch() throws RecognitionException, TokenStreamException {
		
		Token  l = null;
		Token  a = null;
		
		try {      // for error handling
			nt = "&lt;/";
			l = LT(1);
			match(ET);
			at += nt; nt = "fetch";
			a = LT(1);
			match(FETCH);
			at += a.getText(); nt = "&gt;";
			match(GT);
			at += nt;
		}
		catch (RecognitionException e) {
			throw new RecognitionException( e.getMessage(), "", l.getLine() );
		}
	}
	
	public final void oordering() throws RecognitionException, TokenStreamException {
		
		Token  l = null;
		Token  a = null;
		
		try {      // for error handling
			nt = "&lt;";
			l = LT(1);
			match(LT);
			at += nt; nt = "ordering";
			a = LT(1);
			match(ORDERING);
			at += a.getText(); nt = "&gt;";
			match(GT);
			at += nt;
		}
		catch (RecognitionException e) {
			throw new RecognitionException( e.getMessage(), "", l.getLine() );
		}
	}
	
	public final void path() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			opath();
			{
			switch ( LA(1)) {
			case SL:
			{
				{
				match(SL);
				at += "/";
				match(GT);
				at += "&gt;";
				}
				break;
			}
			case GT:
			{
				{
				match(GT);
				at += "&gt;";
				{
				_loop25:
				do {
					if ((LA(1)==LT)) {
						element();
					}
					else {
						break _loop25;
					}
					
				} while (true);
				}
				cpath();
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
			
					if (attrib != null) sqlPath += ";" + attrib;
					sqlIsPath = handler.isPath(sqlPath);
					if (!sqlIsPath)
						throw new RecognitionException( "ERROR " + handler.getErrorMessage() , "", 0 );
				
		}
		catch (RecognitionException e) {
			throw new RecognitionException( e.getMessage(), "", e.getLine() );
		}
	}
	
	public final void cordering() throws RecognitionException, TokenStreamException {
		
		Token  l = null;
		Token  a = null;
		
		try {      // for error handling
			nt = "&lt;/";
			l = LT(1);
			match(ET);
			at += nt; nt = "ordering";
			a = LT(1);
			match(ORDERING);
			at += a.getText(); nt = "&gt;";
			match(GT);
			at += nt;
		}
		catch (RecognitionException e) {
			throw new RecognitionException( e.getMessage(), "", l.getLine() );
		}
	}
	
	public final void ounion() throws RecognitionException, TokenStreamException {
		
		Token  a = null;
		Token  b = null;
		
		try {      // for error handling
			a = LT(1);
			match(UNION);
			at += a.getText(); nt = "&gt;";
			b = LT(1);
			match(GT);
			at += nt;
		}
		catch (RecognitionException e) {
			throw new RecognitionException( e.getMessage(), "", a.getLine() );
		}
	}
	
	public final void intersect(
		int intersectNr
	) throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			
					subtree   = "";
					sqlCsens  = true;
					sqlApprox = false;
					sqlTreeID = 0;
					sqlDocumentID = -1;
					sqlOp     = "eq";
					sqlValue  = "";
			
					int compareNr = 1;
					if (intersectNr > 1) toSQLfinal += " UNION "; else toSQLfinal +=" ";
					
			ointersect();
			nt = "&lt;";
			{
			int _cnt19=0;
			_loop19:
			do {
				if ((LA(1)==LT)) {
					match(LT);
					at += nt; nt = "union or compare";
					{
					switch ( LA(1)) {
					case UNION:
					{
						union(compareNr++);
						break;
					}
					case COMPARE:
					{
						compare(compareNr++);
						break;
					}
					default:
					{
						throw new NoViableAltException(LT(1), getFilename());
					}
					}
					}
				}
				else {
					if ( _cnt19>=1 ) { break _loop19; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				
				_cnt19++;
			} while (true);
			}
			cintersect();
			toSQLfinal += " ";
		}
		catch (RecognitionException e) {
			throw new RecognitionException( e.getMessage(), "",  e.getLine() );
		}
	}
	
	public final void cunion() throws RecognitionException, TokenStreamException {
		
		Token  l = null;
		Token  a = null;
		
		try {      // for error handling
			nt = "&lt;/";
			l = LT(1);
			match(ET);
			at += nt; nt = "union";
			a = LT(1);
			match(UNION);
			at += a.getText(); nt = "&gt;";
			match(GT);
			at += nt;
		}
		catch (RecognitionException e) {
			throw new RecognitionException( e.getMessage(), "", l.getLine() );
		}
	}
	
	public final void compare(
		int compareNr
	) throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			
					attrib    = null;
					order     = "ascending";
					property  = null;
					sqlPath   = "";
					sqlIsPath = false;
			
					if (compareNr > 1) toSQLfinal += " INTERSECT ";
				
			ocompare();
			
				    if ( !subtree.trim().startsWith("_admin.") ) {
					   sqlTreeID = handler.getTreeID(subtree);
					   if (sqlTreeID == -1)
						  throw new RecognitionException("ERROR " + handler.getErrorMessage(), "", 0);
					   sqlDocumentID = handler.getDocumentID(subtree);
				    }
				
			path();
			value();
			ccompare();
			
					if ( !subtree.trim().startsWith("_admin.") ) {
					    ret.scanTree = sqlPath.trim().length() > 0 || sqlValue.trim().length() > 0;
					    toSQLfinal += handler.toSQL(sqlPath, sqlValue, sqlOp, sqlApprox, sqlCsens, sqlTreeID, sqlDocumentID, sqlBlockNr++, sqlAscDesc, subtree);
					}
					else {
					    String tree = null;
					    int     poz = -1;
					    if ( subtree.indexOf(".") != -1 ) {
						   poz = subtree.indexOf(".", subtree.indexOf(".") + 1 );
						   if ( poz != -1 ) tree = subtree.substring(subtree.indexOf(".")+1, poz);
						   else tree = subtree.substring(subtree.indexOf(".")+1);
					    }
					    if ( poz == -1 ) {
						   String result = admHandler.toSQL(tree, null);
						   if ( result == null )
						      throw new RecognitionException("ERROR " + admHandler.getErrorMSG(), "", 0);
						   else
						      throw new RecognitionException(subtree + ":" + result, "", 0);
					    }
					    else {
						   String result = admHandler.toSQL( tree, subtree.substring(poz + 1) );
						   if ( result == null )
						      throw new RecognitionException("ERROR " + admHandler.getErrorMSG(), "", 0);
						   else
						      throw new RecognitionException(subtree.substring( 0, poz ) + ":" + result, "", 0);
					    }
					}
				
		}
		catch (RecognitionException e) {
			throw new RecognitionException( e.getMessage(), "", e.getLine() );
		}
	}
	
	public final void ocompare() throws RecognitionException, TokenStreamException {
		
		Token  a = null;
		
		try {      // for error handling
			cnt_subtree=0; cnt_operator=0; cnt_casesens=0; cnt_approx=0;
			a = LT(1);
			match(COMPARE);
			
						at += a.getText();
			nt  = "\n-the needed atribute: subtree ";
			nt += "\n-or some of the optional atributes: operator, casesensitive, approximate ";
					
			{
			int _cnt41=0;
			_loop41:
			do {
				switch ( LA(1)) {
				case SUBTREE:
				{
					subtree();
					break;
				}
				case OPERATOR:
				{
					operator();
					break;
				}
				case CASESENSITIVE:
				{
					casesensitive();
					break;
				}
				case APPROXIMATE:
				{
					approximate();
					break;
				}
				default:
				{
					if ( _cnt41>=1 ) { break _loop41; } else {throw new NoViableAltException(LT(1), getFilename());}
				}
				}
				_cnt41++;
			} while (true);
			}
			match(GT);
			
						at += "&gt;";
					    if (cnt_subtree==0 || cnt_subtree>1 || cnt_operator>1 || cnt_casesens>1 || cnt_approx>1)
						   throw new RecognitionException();
					
		}
		catch (RecognitionException e) {
			
					  sqlError = e.getMessage() + "\n";
					  if (cnt_subtree == 0)	sqlError += missingAttr("subtree","compare") ;
					  if (cnt_subtree > 1)	sqlError += manyAttr("subtree","compare") ;
					  if (cnt_operator > 1)	sqlError += manyAttr("operator","compare") ;
					  if (cnt_casesens > 1)	sqlError += manyAttr("casesensitive","compare");
					  if (cnt_approx > 1)	sqlError += manyAttr("approximate","compare");
					  throw new RecognitionException( sqlError, "", a.getLine() );
					
		}
	}
	
	public final void value() throws RecognitionException, TokenStreamException {
		
		Token  l = null;
		Token  t = null;
		
		try {      // for error handling
			nt = "&lt;";
			l = LT(1);
			match(LT);
			at += nt; nt = "value&gt;...&lt;/value";
			t = LT(1);
			match(XVALUE);
			at += "value&gt;" + t.getText() + "&lt;/value"; nt = "&gt;";
			match(GT);
			at += nt;  sqlValue = t.getText();
		}
		catch (RecognitionException e) {
			throw new RecognitionException( e.getMessage(), "", l.getLine() );
		}
	}
	
	public final void ccompare() throws RecognitionException, TokenStreamException {
		
		Token  l = null;
		Token  a = null;
		
		try {      // for error handling
			nt = "&lt;/";
			l = LT(1);
			match(ET);
			at += nt; nt = "compare";
			a = LT(1);
			match(COMPARE);
			at += a.getText(); nt = "&gt;";
			match(GT);
			at += nt;
		}
		catch (RecognitionException e) {
			throw new RecognitionException( e.getMessage(), "", l.getLine() );
		}
	}
	
	public final void ointersect() throws RecognitionException, TokenStreamException {
		
		Token  l = null;
		Token  a = null;
		
		try {      // for error handling
			nt = "&lt;";
			l = LT(1);
			match(LT);
			at += nt; nt = "intersect";
			a = LT(1);
			match(INTERSECT);
			at += a.getText(); nt = "&gt;";
			match(GT);
			at += nt;
		}
		catch (RecognitionException e) {
			throw new RecognitionException( e.getMessage(), "", l.getLine() );
		}
	}
	
	public final void cintersect() throws RecognitionException, TokenStreamException {
		
		Token  l = null;
		Token  a = null;
		
		try {      // for error handling
			nt = "&lt;/";
			l = LT(1);
			match(ET);
			at += nt; nt = "intersect";
			a = LT(1);
			match(INTERSECT);
			at += a.getText(); nt = "&gt;";
			match(GT);
			at += nt;
		}
		catch (RecognitionException e) {
			throw new RecognitionException( e.getMessage(), "", l.getLine() );
		}
	}
	
	public final void opath() throws RecognitionException, TokenStreamException {
		
		Token  l = null;
		Token  a = null;
		
		try {      // for error handling
			nt = "&lt;"; cnt_attribute=0; cnt_order=0;
			l = LT(1);
			match(LT);
			at += nt; nt = "path";
			a = LT(1);
			match(PATH);
			
						at += a.getText();
			nt  = "\n-some of the optional atributes: order, attribute ";
			nt += "\n-or the end of token: &gt; ";
			nt += "\n-or the end of element: /&gt; ";
					
			{
			_loop45:
			do {
				switch ( LA(1)) {
				case ATTRIBUTE:
				{
					attribute();
					break;
				}
				case ORDER:
				{
					order();
					break;
				}
				default:
				{
					break _loop45;
				}
				}
			} while (true);
			}
			if ( cnt_attribute>1 || cnt_order>1 ) throw new RecognitionException();	
		}
		catch (RecognitionException e) {
			
					  sqlError = e.getMessage() + "\n";
					  if (cnt_attribute > 1)	sqlError += manyAttr("attribute","path");
					  if (cnt_operator  > 1)	sqlError += manyAttr("operator" ,"path");
					  throw new RecognitionException( sqlError, "", l.getLine() );
					
		}
	}
	
	public final void element() throws RecognitionException, TokenStreamException {
		
		
		try {      // for error handling
			oelement();
			{
			switch ( LA(1)) {
			case SL:
			{
				{
				match(SL);
				at += "/"; nt = "&gt;";
				match(GT);
				at += "&gt;";
				}
				break;
			}
			case GT:
			{
				{
				match(GT);
				at += "&gt;";
				celement();
				}
				break;
			}
			default:
			{
				throw new NoViableAltException(LT(1), getFilename());
			}
			}
			}
		}
		catch (RecognitionException e) {
			throw new RecognitionException( e.getMessage(), "", e.getLine() );
		}
	}
	
	public final void cpath() throws RecognitionException, TokenStreamException {
		
		Token  l = null;
		Token  a = null;
		
		try {      // for error handling
			nt = "&lt;/";
			l = LT(1);
			match(ET);
			at += nt; nt = "path";
			a = LT(1);
			match(PATH);
			at += a.getText(); nt = "&gt;";
			match(GT);
			at += nt;
		}
		catch (RecognitionException e) {
			throw new RecognitionException( e.getMessage(), "", l.getLine() );
		}
	}
	
	public final void reqno() throws RecognitionException, TokenStreamException {
		
		Token  a = null;
		Token  b = null;
		Token  t = null;
		
		try {      // for error handling
			a = LT(1);
			match(REQNO);
			at += " " + a.getText(); nt = "=";
			b = LT(1);
			match(EQ);
				at += b.getText(); nt = "Value of attribute (reqno='...')!";
			t = LT(1);
			match(STRING);
			
						try {
							String gt = (t.getText()).replace( (t.getText()).charAt(0), ' ' ).trim();
							ret.reqno = Integer.parseInt(gt);
						}
						catch ( Exception e) { throw new RecognitionException( 
							                   LogManager.getReference().getMessage("sep_parser_reqno") +
			" " + t.getText(), "", t.getLine());
						}
						at += t.getText();
						nt  = "&gt;";
						
		}
		catch (RecognitionException e) {
			
						throw new RecognitionException(errorInAttr("reqno",e.getMessage()),"",e.getLine()); 
						
		}
	}
	
	public final void related() throws RecognitionException, TokenStreamException {
		
		Token  a = null;
		Token  b = null;
		Token  t = null;
		
		try {      // for error handling
			a = LT(1);
			match(RELATED);
			at += " " + a.getText(); nt = "=";
			b = LT(1);
			match(EQ);
				at += b.getText(); nt = "Value of attribute (related='...')!";
			t = LT(1);
			match(STRING);
			
						String gt = t.getText();
						related = gt.replace( gt.charAt(0), ' ' ).trim();
						cnt_related++;
						at += t.getText();
			nt  = "\n-some of the optional atributes: offset, maxnum, notification, prevstamp ";
			nt += "\n-or the end of token: &gt; ";
						
		}
		catch (RecognitionException e) {
			
						throw new RecognitionException(errorInAttr("related",e.getMessage()),"",e.getLine()); 
						
		}
	}
	
	public final void offset() throws RecognitionException, TokenStreamException {
		
		Token  a = null;
		Token  b = null;
		Token  t = null;
		
		try {      // for error handling
			a = LT(1);
			match(OFFSET);
			at += " " + a.getText(); nt = "=";
			b = LT(1);
			match(EQ);
				at += b.getText(); nt = "Value of attribute (offset='...')!";
			t = LT(1);
			match(STRING);
			
						String gt = t.getText();
						offset = gt.replace( gt.charAt(0), ' ' ).trim();
						cnt_offset++;
						at += t.getText();
			nt  = "\n-some of the optional atributes: related, maxnum, notification, prevstamp ";
			nt += "\n-or the end of token: &gt; ";
					
		}
		catch (RecognitionException e) {
			
						throw new RecognitionException(errorInAttr("offset",e.getMessage()),"",e.getLine()); 
						
		}
	}
	
	public final void maxnum() throws RecognitionException, TokenStreamException {
		
		Token  a = null;
		Token  b = null;
		Token  t = null;
		
		try {      // for error handling
			a = LT(1);
			match(MAXNUM);
			at += " " + a.getText(); nt = "=";
			b = LT(1);
			match(EQ);
				at += b.getText(); nt = "Value of attribute (maxnum='...')!";
			t = LT(1);
			match(STRING);
			
						String gt = t.getText();
						maxnum = gt.replace( gt.charAt(0), ' ' ).trim();
						cnt_maxnum++;
						at += t.getText();
			nt  = "\n-some of the optional atributes: related, offset, notification, prevstamp ";
			nt += "\n-or the end of token: &gt; ";
					
		}
		catch (RecognitionException e) {
			
						throw new RecognitionException(errorInAttr("maxnum",e.getMessage()),"",e.getLine()); 
						
		}
	}
	
	public final void notification() throws RecognitionException, TokenStreamException {
		
		Token  a = null;
		Token  b = null;
		Token  t = null;
		
		try {      // for error handling
			a = LT(1);
			match(NOTIFICATION);
			at += " " + a.getText(); nt = "=";
			b = LT(1);
			match(EQ);
				at += b.getText(); nt = "Value of attribute (notification='...')!";
			t = LT(1);
			match(STRING);
			
						String gt = t.getText();
						notifi = gt.replace( gt.charAt(0), ' ' ).trim();
						cnt_notification++;
						at += t.getText();
			nt  = "\n-some of the optional atributes: related, offset, maxnum, prevstamp ";
			nt += "\n-or the end of token: &gt; ";
					
		}
		catch (RecognitionException e) {
			
						throw new RecognitionException(errorInAttr("notification",e.getMessage()),"",e.getLine()); 
						
		}
	}
	
	public final void prevstamp() throws RecognitionException, TokenStreamException {
		
		Token  a = null;
		Token  b = null;
		Token  t = null;
		
		try {      // for error handling
			a = LT(1);
			match(PREVSTAMP);
			at += " " + a.getText(); nt = "=";
			b = LT(1);
			match(EQ);
				at += b.getText(); nt = "Value of attribute (prevstamp='...')!";
			t = LT(1);
			match(STRING);
			
						String gt = t.getText();
						prevstmp = gt.replace( gt.charAt(0), ' ' ).trim();
						cnt_prevstamp++;
						at += t.getText();
			nt  = "\n-some of the optional atributes: related, offset, maxnum, notification ";
			nt += "\n-or the end of token: &gt; ";
					
		}
		catch (RecognitionException e) {
			
						throw new RecognitionException(errorInAttr("prevstamp",e.getMessage()),"",e.getLine()); 
						
		}
	}
	
	public final void subtree() throws RecognitionException, TokenStreamException {
		
		Token  a = null;
		Token  b = null;
		Token  t = null;
		
		try {      // for error handling
			a = LT(1);
			match(SUBTREE);
			at += " " + a.getText(); nt = "=";
			b = LT(1);
			match(EQ);
				at += b.getText(); nt = "Value of attribute (subtree='...')!";
			t = LT(1);
			match(STRING);
			
						String gt = t.getText();
						subtree = gt.replace( gt.charAt(0), ' ' ).trim();
						cnt_subtree++;
						at += t.getText();
			nt  = "\n-some of the optional atributes: operator, casesensitive, approximate ";
			nt += "\n-or the end of token: &gt; ";
					
		}
		catch (RecognitionException e) {
			
						throw new RecognitionException(errorInAttr("subtree",e.getMessage()),"",e.getLine());
						
		}
	}
	
	public final void operator() throws RecognitionException, TokenStreamException {
		
		Token  a = null;
		Token  b = null;
		Token  t = null;
		
		try {      // for error handling
			a = LT(1);
			match(OPERATOR);
			at += " " + a.getText(); nt = "=";
			b = LT(1);
			match(EQ);
				at += b.getText(); nt = "Value of attribute (operator='...')!";
			t = LT(1);
			match(STRING);
			
						String gt = t.getText();
						sqlOp = gt.replace( gt.charAt(0), ' ' ).trim();
						cnt_operator++;
						at += t.getText();
			nt  = "\n-the needed atribute: subtree ";
			nt += "\n-or some of the optional atributes: casesensitive, approximate ";
			nt += "\n-or the end of token: &gt; ";
					
		}
		catch (RecognitionException e) {
			
						throw new RecognitionException(errorInAttr("operator",e.getMessage()),"",e.getLine());
						
		}
	}
	
	public final void casesensitive() throws RecognitionException, TokenStreamException {
		
		Token  a = null;
		Token  b = null;
		Token  t = null;
		
		try {      // for error handling
			a = LT(1);
			match(CASESENSITIVE);
			at += " " + a.getText(); nt = "=";
			b = LT(1);
			match(EQ);
				at += b.getText(); nt = "Value of attribute (casesensitive='...')!";
			t = LT(1);
			match(STRING);
			
						String gt = t.getText();
						if ( ("true").equals( gt.replace( gt.charAt(0), ' ' ).trim() ) ) sqlCsens = true;
						else sqlCsens = false;
						cnt_casesens++;
						at += t.getText();
			nt  = "\n-the needed atribute: subtree ";
			nt += "\n-or some of the optional atributes: operator, approximate ";
			nt += "\n-or the end of token: &gt; ";
					
		}
		catch (RecognitionException e) {
			
						throw new RecognitionException(errorInAttr("casesensitive",e.getMessage()),"",e.getLine());
						
		}
	}
	
	public final void approximate() throws RecognitionException, TokenStreamException {
		
		Token  a = null;
		Token  b = null;
		Token  t = null;
		
		try {      // for error handling
			a = LT(1);
			match(APPROXIMATE);
			at += " " + a.getText(); nt = "=";
			b = LT(1);
			match(EQ);
				at += b.getText(); nt = "Value of attribute (approximate='...')!";
			t = LT(1);
			match(STRING);
			
						String gt = t.getText();
						if ( ("true").equals( gt.replace( gt.charAt(0), ' ' ).trim() ) ) sqlApprox = true;
						else sqlApprox = false;
						cnt_approx++;
						at += t.getText();
			nt  = "\n-the needed atribute: subtree ";
			nt += "\n-or some of the optional atributes: operator, casesensitive ";
			nt += "\n-or the end of token: &gt; ";
					
		}
		catch (RecognitionException e) {
			
						throw new RecognitionException(errorInAttr("approximate",e.getMessage()),"",e.getLine());
						
		}
	}
	
	public final void attribute() throws RecognitionException, TokenStreamException {
		
		Token  a = null;
		Token  b = null;
		Token  t = null;
		
		try {      // for error handling
			a = LT(1);
			match(ATTRIBUTE);
			at += " " + a.getText(); nt = "=";
			b = LT(1);
			match(EQ);
				at += b.getText(); nt = "Value of attribute (attribute='...')!";
			t = LT(1);
			match(STRING);
			
						String gt = t.getText();
					    attrib = gt.replace( gt.charAt(0), ' ' ).trim();
						cnt_attribute++;
						at += t.getText();
			nt  = "\n-the atribute: order ";
			nt += "\n-or the end of token: &gt; ";
					
		}
		catch (RecognitionException e) {
			
						throw new RecognitionException(errorInAttr("attribute",e.getMessage()),"",e.getLine());
						
		}
	}
	
	public final void order() throws RecognitionException, TokenStreamException {
		
		Token  a = null;
		Token  b = null;
		Token  t = null;
		
		try {      // for error handling
			a = LT(1);
			match(ORDER);
			at += " " + a.getText(); nt = "=";
			b = LT(1);
			match(EQ);
				at += b.getText(); nt = "Value of attribute (order='...')!";
			t = LT(1);
			match(STRING);
			
						String gt = t.getText();
						if ( ("ascendent").equals( gt.replace( gt.charAt(0), ' ' ).trim() ) ) sqlAscDesc = "ASC";
						else sqlAscDesc = "DESC";
			cnt_order++;
						at += t.getText();
			nt  = "\n-the atribute: attribute ";
			nt += "\n-or the end of token: &gt; ";
					
		}
		catch (RecognitionException e) {
			
						throw new RecognitionException(errorInAttr("order",e.getMessage()),"",e.getLine());
						
		}
	}
	
	public final void oelement() throws RecognitionException, TokenStreamException {
		
		Token  l = null;
		Token  a = null;
		
		try {      // for error handling
			nt = "&lt;";
			l = LT(1);
			match(LT);
			at += nt; nt = "element or /path";
			a = LT(1);
			match(ELEMENT);
			at += a.getText(); nt = "property";
			property();
		}
		catch (RecognitionException e) {
			throw new RecognitionException( e.getMessage(), "", l.getLine() );
		}
	}
	
	public final void celement() throws RecognitionException, TokenStreamException {
		
		Token  l = null;
		Token  a = null;
		
		try {      // for error handling
			nt = "&lt;/";
			l = LT(1);
			match(ET);
			at += nt; nt = "element";
			a = LT(1);
			match(ELEMENT);
			at += a.getText(); nt = "&gt";
			match(GT);
			at += nt;
		}
		catch (RecognitionException e) {
			throw new RecognitionException( e.getMessage(), "", l.getLine() );
		}
	}
	
	public final void property() throws RecognitionException, TokenStreamException {
		
		Token  a = null;
		Token  b = null;
		Token  t = null;
		
		try {      // for error handling
			a = LT(1);
			match(PROPERTY);
			at += " " + a.getText(); nt = "=";
			b = LT(1);
			match(EQ);
				at += b.getText(); nt = "Value of attribute (property='...')!";
			t = LT(1);
			match(STRING);
			
						String gt = t.getText();
						property = gt.replace( gt.charAt(0), ' ' ).trim();
						if (sqlPath.trim().length() < 1 ) sqlPath = property;
						else sqlPath += ":" + property;
						cnt_property++;
						at += t.getText();
			nt  = "&gt; or /&gt; ";
					
		}
		catch (RecognitionException e) {
			
						throw new RecognitionException(errorInAttr("property",e.getMessage()),"",e.getLine());
						
		}
	}
	
	
	public static final String[] _tokenNames = {
		"<0>",
		"EOF",
		"<2>",
		"NULL_TREE_LOOKAHEAD",
		"&lt;",
		"STORE",
		"&gt;",
		"/",
		"&lt;value&gt;TEXT value&lt;/value&gt;",
		"REQUEST",
		"&lt;/",
		"FETCH",
		"ORDERING",
		"UNION",
		"INTERSECT",
		"COMPARE",
		"PATH",
		"ELEMENT",
		"ACTION",
		"=",
		"attribute string type value",
		"REQNO",
		"RELATED",
		"OFFSET",
		"MAXNUM",
		"NOTIFICATION",
		"PREVSTAMP",
		"SUBTREE",
		"OPERATOR",
		"CASESENSITIVE",
		"APPROXIMATE",
		"ATTRIBUTE",
		"ORDER",
		"PROPERTY",
		"VALUE",
		"WS"
	};
	
	
	}
