/*
 * $COPYRIGHT$
 * $Id: DBWriter.java,v 1.24 2002/04/26 17:07:44 crow Exp $
 *
 * Date         Author            Changes
 * May 31 2001  Szabo Csaba       Created
 */
                                                                                                                                   
package org.media.datastore.sepengine.util;

import java.sql.Connection;
import java.sql.Statement;
import java.sql.ResultSet;

import java.util.Vector;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.io.InputStream;

import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.SAXParser;
                                                                                                        
import org.xml.sax.*;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

import org.media.datastore.sepengine.LogManager;
import org.media.datastore.sepengine.SepInterpreter;
import org.media.datastore.sepengine.RDBInfo;
 
/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.24 $ $Date: 2001/08/21 15:00:00
 * @see java.lang.String
 * @see java.io.InputStream
 * @see java.sql.Connection
 * @see org.media.datastore.sepengine.RDBInfo
 * @see org.xml.sax.HandlerBase 
 */
      
public class DBWriter extends DefaultHandler implements LexicalHandler {

    private static final String TABLEPREFIX = "ds";

    private Connection con;
    private RDBInfo    info;
    private int        treeID;
    private int        docID;
    private Vector     parents;
    private String     errorMsg;
    
    public DBWriter() {
    }

    
    protected DBWriter( Connection con, int tID, int dID, RDBInfo info )
        throws Exception {

        this.con      = con;
        this.parents  = new Vector();
        this.treeID   = tID;
        this.docID    = dID;
        this.info     = info;
        this.errorMsg = null;
    }


    public String write( Connection con, InputStream istream, int tID, int dID, RDBInfo info ) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        
	try {
            DefaultHandler handler = new DBWriter(con, tID, dID, info);
            SAXParser parser = factory.newSAXParser();
            parser.parse(istream, handler);
            errorMsg = null;
        } 
        catch ( Exception _saxex ) {
            errorMsg = LogManager.getReference().getMessage("xml.parse_exception") + "\n" + _saxex.getMessage();
            LogManager.getReference().message("warn", "xml.parse_exception",
					      ": " + _saxex.getMessage() );
        }
        return errorMsg;
    } 


    public void startDocument() throws SAXException {
        parents.removeAllElements();
        parents.addElement( new Integer(-1) );
    } 

    public void endElement( String uri, String name, String qname ) throws SAXException {
        parents.removeElementAt( parents.size() - 1 );
    }


    public void startElement( String uri, String name, String qname, Attributes attrs ) throws SAXException  {
        int pID = ( (Integer)parents.elementAt( parents.size() - 1 ) ).intValue();
        int sID = -1;
        
        if ( (sID = getPathID(pID, qname, "ELEMENT")) != -1) {
            pID = sID;
            parents.addElement( new Integer( sID ) );
        }
        else {
	    throw new SAXException( LogManager.getReference().getMessage("path_error") + qname );
        }       
        if( attrs != null ) {
            for ( int i = 0; i < attrs.getLength(); i++ ) {
                String attr_name = attrs.getQName(i);
                String attr_value = attrs.getValue(i);
                
		attr_value = removeSpecialIgnorableKeys( removeIgnorableKeys( attr_value, info.getIgnoredKeys() ), 
		                                         info.getSpecialKeys() ).trim();
		if ( (sID = getPathID( pID, attr_name, "ATTLIST")) != -1 ) {
		    if ( attr_value.length() > 0 ) writeToLexicon( attr_value, sID, docID, treeID); 
                }
		else throw new SAXException( LogManager.getReference().getMessage("path_error") + qname + "." + attr_name);
            }
        }
    } 
    

    public void characters( char ch[], int start, int length ) throws SAXException {
	String str = new String(ch, start, length);    
        if ( str.trim().length() < 1 ) return;
        int pID = ((Integer)parents.elementAt( parents.size() - 1 ) ).intValue();

	str = removeSpecialIgnorableKeys( 
	    removeIgnorableKeys( str , info.getIgnoredKeys() ), 
		                 info.getSpecialKeys() ).trim();
	
        if ( str.length() > 0 ) writeToLexicon( str, pID, docID, treeID);
    }


    public void ignorableWhitespace( char ch[], int start, int length ) throws SAXException  {
        characters( ch, start, length );
    }
    

    public void comment( char ch[], int start, int length ) throws SAXException {
    }
                     

    public void startCDATA() throws SAXException {
    }
                             

    public void endCDATA() throws SAXException {
    }


    public void startDTD( String name, String pId, String sId ) throws SAXException {
    }
                             

    public void endDTD() throws SAXException {
    }
                                     

    public void startEntity( String name ) throws SAXException {
    }
                                             

    public void endEntity( String name ) throws SAXException {
    }
    

    private int getPathID( int pID, String name, String type ) {
        int  newID = -1;
        String sql = "SELECT struct_id FROM " + TABLEPREFIX + "structs WHERE tree_id=" + treeID + " AND struct_parent=" + pID +
		     " AND UPPER(struct_name)='" + name.toUpperCase() + "' AND struct_type='" + type +"'";
	
        try {
            Statement stmt = con.createStatement();
	    ResultSet rs = stmt.executeQuery( sql );
            
            if ( !rs.next() ) {  //if attribute or element not found but can create
                if( ( newID = nextID("struct_id") ) != -1 ) { 
                    sql = "INSERT INTO " + TABLEPREFIX + "structs VALUES(" + newID + ", '" + name + "', " + treeID + ", " + pID + ", '" + type +"')";
                    con.prepareStatement( sql ).execute();
                }
            }
            else newID = rs.getInt("struct_id");
	    rs.close(); stmt.close();
        }
        catch ( Exception _ex ) {
            errorMsg = LogManager.getReference().getMessage("query_failed") + "\nSQL = " + sql + "\n";
            LogManager.getReference().message("error", "query_failed", "\nSQL = " + sql + "\n" + _ex.getMessage());                                         
        }
        
        return newID;
    }
    

    private int nextID( String name ) throws Exception {
        int newID = -1;
             
        try {
	    Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery("SELECT next_id FROM " + TABLEPREFIX + "sequences WHERE seq_name='" + name + "'");
            if ( rs.next() ) {
                newID = rs.getInt(1);
                con.prepareStatement("UPDATE " + TABLEPREFIX + "sequences SET next_id=next_id+1 WHERE seq_name='"+name+"'").execute();
            }
            rs.close(); stmt.close();
        }
        catch( Exception e ) {
            throw e;
        }
                                                                     
        return newID;
    }
    

    private void writeToLexicon( String str, int sID, int dID, int tID ) throws SAXException {
        int pozition = 1;
        StringTokenizer st = new StringTokenizer( str.replace('\\',' ').replace('\'', ' ') );
        
	try {
    	    while ( st.hasMoreTokens() ) {
        	String word = st.nextToken();
               
	        if ( word.trim().length() > 0 ) {
	    	    int     wID = -1;
		    String _sql = "SELECT word_id FROM " + TABLEPREFIX + "lexicon WHERE word_name='" + word + "'";
		    
		    Statement stmt = con.createStatement();			        
                    ResultSet rs = stmt.executeQuery( _sql );
		    if ( rs.next() ) {
			wID = rs.getInt(1);
			con.prepareStatement("UPDATE " + TABLEPREFIX + "lexicon SET word_hit=word_hit+1 WHERE word_id=" + wID).execute();
		    }
		    else {
		        if ( ( wID = nextID("lex_id") ) == -1 ) return;
			con.prepareStatement("INSERT INTO " + TABLEPREFIX + "lexicon VALUES(" + wID + ", '" + word + "', 1)").execute();
		    } rs.close(); stmt.close();
		    _sql = "INSERT INTO " + TABLEPREFIX + "barrels VALUES(" + tID + "," + dID + "," + sID + "," + wID + ", " + pozition++ +")";
		    con.prepareStatement( _sql ).execute();
		}
            }
        }
	catch ( Exception _sqle ) {
    	    errorMsg = LogManager.getReference().getMessage("lexicon_failed");
            LogManager.getReference().message("error", "lexicon_failed", _sqle.getMessage());                                         
            throw new SAXException ( errorMsg );
        }
    }
    
    
    private String removeIgnorableKeys ( String str, Vector keys ) {
	StringBuffer sb = new StringBuffer( str );
	 
	for ( Enumeration e = keys.elements(); e.hasMoreElements(); ) {
	    String key = ( String )e.nextElement();
	    int    poz = -1;
						 
	    while ( ( poz = sb.toString().indexOf( key ) ) != -1 )
		sb = sb.replace ( poz, poz + key.length(), " " );
	}
	
	return sb.toString();
    }

		 
    private String removeSpecialIgnorableKeys( String str, Vector keys ) {
        StringBuffer sb = new StringBuffer ( str );
									     
        for ( Enumeration e = keys.elements(); e.hasMoreElements(); ) {
	    String key = ( String )e.nextElement();
	    int    poz = -1;
															     
	    if ( sb.toString().startsWith( key ) ) sb.setCharAt(0, ' ');
	    if ( sb.toString().endsWith( key ) ) sb.setCharAt(sb.length() -1 , ' ');
	    while ( ( poz = sb.toString().indexOf( " " + key ) ) != -1 )
	        sb = sb.replace ( poz, poz + key.length() + 1 , " " );
	    while ( ( poz = sb.toString().indexOf( key + " " ) ) != -1 )
	        sb = sb.replace ( poz, poz + key.length() + 1, " " );
	}
	
	return sb.toString();
    }
} 
