/*
 * $COPYRIGHT$
 * $Id: DTDRegister.java,v 1.3 2001/11/01 13:40:37 crow Exp $
 *
 * Date        Author            Changes
 * SEP 20 2001 Szabo Csaba       Created
 */
       
package org.media.datastore.sepengine.util;

import java.util.Vector;
import java.util.Hashtable;
import java.util.Enumeration; 
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.BufferedWriter;
import java.io.FileInputStream; 
import java.io.BufferedInputStream;

import org.media.datastore.sepengine.LogManager; 

/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.3 $ $Date: 2001/09/20 15:00:00
 * @see java.lang.String
 * @see java.util.Vector
 * @see java.util.Hashtable
 */
 
public class DTDRegister {
    protected static DTDRegister dtdRegister = new DTDRegister();
    private   static Hashtable   dtdDef      = new Hashtable();
    
    
    private DTDRegister() {
    }
    
    
    public static DTDRegister getReference() {
	return dtdRegister;    
    }
    
    
    public void loadDTD ( String name, String dtdName ) 
	throws Exception {
	
	if ( !dtdDef.containsKey( name ) ) {
	    Vector dtd = getDTD ( dtdName );
	    
	    if ( dtd != null ) {
		dtdDef.put ( name, dtd );
	        if ( !dtdValid ( name, dtdName ) ) throw new Exception ( 
		    LogManager.getReference().getMessage("dtd.load_error") + " " + dtdName );	    
	    }
	    else throw new Exception ( 
		LogManager.getReference().getMessage("dtd.load_error") + " " + dtdName );
	}
    }
    
    
    public void saveDTD ( String name , String filename ) 
	throws Exception {
	Vector elements = getDTDElements ( name ); 
	
	if ( elements == null ) throw new Exception (
	    LogManager.getReference().getMessage("dtd.save_error") + " " + filename );
	
	try {
	    PrintWriter writer = new PrintWriter( new BufferedWriter( new FileWriter( filename ) ) );
								  
	     for ( Enumeration e = elements.elements(); e.hasMoreElements(); ) {
	         MyElement elem = ( MyElement )e.nextElement();
	
	         if ( elem.getValue().toUpperCase().indexOf("{SPECIAL}") != -1 ) 
		    elem.addElements("#PCDATA");
	         writer.print ( "<!" + elem.getType() + " " + elem.getName() + " " );
	         if ( elem.getType().equalsIgnoreCase("ATTLIST") )
	             writer.println( "\n\t" + elem.getValue().trim() + ">" );
	         else
	             writer.println ( elem.getValue() + ">" );
	     }
	     writer.close();
	}
	catch ( Exception ex ) {
	    LogManager.getReference().message("error", "dtd.save_error", ex.getMessage() );
	    throw new Exception ( "\n" + LogManager.getReference().getMessage("dtd.save_error") + ex.getMessage() );
	}
    }
    
    
    public Vector getDTDElements( String name ) {
	return (Vector)dtdDef.get( name );
    }
    

    public boolean inDTD( String name, String ename ) {
	boolean found   = false;
	Vector elements = getDTDElements ( name ); 
	
	if ( elements == null ) return false;
	
	for ( Enumeration e = elements.elements(); e.hasMoreElements() && !found; ) {
	    MyElement elem = (MyElement)e.nextElement();
	    
	    if ( elem.getType().equals("ELEMENT") &&  elem.getName().equals( ename ) ) found = true;
	}
	return found;
    }    


    private boolean dtdValid( String name, String dtdName ) {
	boolean   found = false;
	String     root = dtdName.substring( dtdName.lastIndexOf( java.io.File.separatorChar ) + 1 );
	Vector elements = getDTDElements ( name ); 
	
	if ( elements == null ) return false;
	
	if ( root.indexOf(".") != -1 ) root = root.substring(0, root.indexOf(".") );
				 
	for ( Enumeration e = elements.elements(); e.hasMoreElements() && !found; )
	    found = ( (MyElement)e.nextElement() ).getChildren().contains( root );
						     
	return !found;
    }


    private Vector getDTD( String filename ) {
	Vector result = new Vector();
	int    ch;
	String buffer = "";
				 
	try {
	    BufferedInputStream in = new BufferedInputStream( new FileInputStream( filename ) );
				     
	    while ( ( ch = in.read() ) != -1 ) {
		buffer += (char)ch;
		if ( ch == '>' ) {
		    try {
			result.addElement( new MyElement( buffer.replace('\n','$').replace('\t', '@') ) );
		    }
		    catch ( Exception _e ) {
			LogManager.getReference().message("error", "dtd_attr_error", " " + filename + "\n" + buffer);
			return null;
		    }
		    buffer = "";
	        }
		else {
		    if( ch == '<' ) buffer = "<";
		}
	    }
            in.close();
	    return result;
	}
	catch ( Exception e ) {
	    LogManager.getReference().message("error", "dtd.load_error", " " + filename );
	    return null;
	}
    }
} 
