/*
 * $COPYRIGHT$
 * $Id: MyElement.java,v 1.8 2001/10/12 18:29:34 crow Exp $
 *
 *  Date        Author            Changes
 * May 28 2001  Szabo Csaba       Created
 */                                                                                                                                                    
package org.media.datastore.sepengine.util;

import java.util.StringTokenizer;
import java.util.Vector;
import org.media.datastore.sepengine.LogManager;
 
/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.8 $ $Date: 2001/08/21 15:00:00
 * @see java.lang.String
 * @see java.util.Vector
 */
      
public class MyElement {
    

    public MyElement ( String str ) throws Exception {
        StringTokenizer    st = new StringTokenizer( normalizeToken( str ) );
        int             state = 0;
        
        while ( st.hasMoreTokens() ) {
            String token = st.nextToken().trim();
            
            switch ( state ) {
	    case  0 : type = token; 
		state++;
		break;
                
	    case  1 : name = token; 
		state++;
		break;
                          
	    default : value.append( token + " " );
            }
        } 
        value = new StringBuffer ( value.toString().replace('$', '\n').replace('@', '\t') ); 
        
        if ( type.equalsIgnoreCase( "ELEMENT" ) ) 
            addToChildrenAsElement( normalizeElementValue( value.toString() ) );
        
        if ( type.equalsIgnoreCase( "ATTLIST" ) && !addToChildrenAsAttribute( value.toString() ) )    
            throw new Exception("Can't parse " + str );
    }

    
    public String getType() {
        return type;
    }

    
    public String getName() {
        return name;
    }

    
    public String getValue() {
        return value.toString();
    }

    
    public Vector getChildren() {
        return children;
    }

    
    public int addAttr ( String attrName, boolean validate ) {
        if ( !children.contains( attrName ) ) {
            if ( validate ) return -1;
            value.append ( "\n\t" + attrName + " CDATA #IMPLIED" );
            children.addElement( attrName );
            return 1;
        }
        return 0;
    }
    

    public boolean addElements ( String name ) {

        if ( children.contains( normalizeElementValue( name ) ) ) return false;

        children.addElement( normalizeElementValue( name ) );
        if( value.toString().toUpperCase().indexOf("{SPECIAL}") >= 0 )
            value = new StringBuffer( "(" + name + ")" );
        else {
            value = new StringBuffer ( value.substring( 0, value.toString().lastIndexOf( ")" ) ) );
            if ( value.toString().indexOf("#PCDATA") != -1 ) 
                value.append( ") | (" + name + ")" );
            else
                value.append( ", " + name + ")" );
        }
	return true;
    }

    
    public void addPCData( ) {
        value = new StringBuffer( "(#PCDATA) | " + value );
    }

    
    /*
     * Set default values for this object.
     * Remove "<!" and ">" strings from both sides of the string named 'str'.
     */
    private String normalizeToken( String str ) {
        type     = "";
        name     = "";
        value    = new StringBuffer( );
        children = new Vector();
        
        return str.replace('<', ' ').replace('>', ' ').replace('!', ' ').trim();
    }

    
    /*
     * Remove optional character following a name of element '?', '+', '*'.
     * Remove '(', ')', '|' and ',' characters from name of element.
     */
    private String normalizeElementValue( String value ) {
        String val = value.replace('?', ' ').replace('+', ' ').replace('*', ' ');

        return val.replace('(', ' ').replace(')', ' ').replace('|', ' ').replace(',', ' ').trim();
    }


    /*
     * Add childern of current element in vector.
     */
    private void addToChildrenAsElement( String value ) {
        StringTokenizer st = new StringTokenizer( value );
        
        while ( st.hasMoreTokens() ) {
            String token = st.nextToken().trim();
            
            if ( !token.equalsIgnoreCase("#PCDATA") &&
                 !token.equalsIgnoreCase("ANY")     &&
                 !token.equalsIgnoreCase("EMPTY")   && 
                 !children.contains( token ) ) children.addElement( token );
        }
    }
    

    /*
     * Verify if attribute type is stringType that is 'CDATA'.
     */
    private boolean isStringType( String token ) {
        return token.equalsIgnoreCase("CDATA");
    }


    /* 
     *   Verify is attribute type is tokenizedType that is :
     * ID, IDREF, IDREFS, ENTITY, ENTITIES, NMTOKEN or NMTOKENS.
     */
    private boolean isTokenizedType( String token ) {
        return token.equalsIgnoreCase("ID")       ||
	    token.equalsIgnoreCase("IDREF")    ||
	    token.equalsIgnoreCase("IDREFS")   ||
	    token.equalsIgnoreCase("ENTITY")   ||
	    token.equalsIgnoreCase("ENTITIES") ||
	    token.equalsIgnoreCase("NMTOKEN")  ||
	    token.equalsIgnoreCase("NMTOKENS");
    }

    
    /* 
     * Verify is attribute type is enumeratedType.
     */
    private boolean isEnumeratedType ( String token ) {
        return token.equalsIgnoreCase("NOTATION") ||
	    token.indexOf("(") != -1 ||
	    token.indexOf(")") != -1;
    }
    

    /*
     * Add attribute name in vector.
     */
    private boolean addToChildrenAsAttribute( String value ) {
        StringTokenizer st = new StringTokenizer( value.replace('"', ' ') );
        boolean isName = true;
        boolean isType = false;
        boolean isDecl = false;
        
        while ( st.hasMoreTokens() ) {
            String token = st.nextToken().trim();
            
            if ( isName ) {
                if ( !children.contains( value ) )
                    children.addElement( token );
                isName = false;
                isType = true;
                continue;
            } 
            
            if ( isType ) {
                if ( isStringType( token ) || 
                     isTokenizedType( token ) ) {
                    isType = false;
                    isDecl = true;
                    continue;
                } 
                if ( isEnumeratedType( token ) && 
                     token.indexOf(")") != -1 ) {
		    isType = false;
		    isDecl = true;
		    continue;
                }
            }
            
            if ( isDecl ) {
                if ( !token.equalsIgnoreCase("#FIXED") ) {
                    isName = true;
                    isDecl = false;
                    continue;
                }
            }
        }
        
        return isName;
    }


    private String       type;
    private String       name;
    private StringBuffer value;
    private Vector       children;
}
