/*
 * $COPYRIGHT$
 * $Id: ProgressBar.java,v 1.2 2001/08/21 17:29:30 crow Exp $
 *
 *  Date        Author            Changes
 * JUL 20 2001  Szabo Csaba       Created
 */
package org.media.datastore.sepengine.util;

import java.lang.String;
 
/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.2 $ $Date: 2001/08/21 15:00:00
 */
      
public class ProgressBar {
    private  int barLength  = 0;
    private long barMaxSize = 0;
    private long barCurSize = 0;
    private  int  barStatus = 0;
    private int  procStatus = 0;
    private boolean firstInstance = true;


    public ProgressBar() {
    }


    public void setBarLength( int _barLength ) {
        barLength = _barLength;
    }


    public void setMaxSize( long _barMaxSize ) {
        barMaxSize = _barMaxSize;
    }


    public void setCurrentSize( long _barCurSize ) {
        barCurSize = _barCurSize;
    }


    public void getBar() {
        int prevProcStatus = procStatus;
        int  prevBarStatus = barStatus;
        String     procent = ( new Integer( prevProcStatus ) ).toString();
        
        if ( firstInstance ) {
            System.out.print( "(" );
            firstInstance = false;
        } 
        else {
            for ( int cx = 0; cx <= ( procent.length() + 2 ); cx++ ) 
                System.out.print( (char)8 );
        }
        float floatProcentStatus = barCurSize * 100 / barMaxSize;
        float     floatBarStatus = barCurSize * barLength / barMaxSize;

        procStatus = ( new Float( floatProcentStatus ) ).intValue();
        barStatus  = ( new Float( floatBarStatus ) ).intValue();
        
        for ( int cx = 0; cx <= ( barStatus - prevBarStatus ); cx++ )
            System.out.print( "=" );
        
        System.out.print( procStatus + "%)" );    
    }
}
