/* $COPYRIGHT$
 * $Id: SepDBHandler.java,v 1.54 2002/05/24 14:07:14 crow Exp $
 *
 * Date         Author           Changes
 * May 21 2001  Szabo Csaba      Created
 */
 
package org.media.datastore.sepengine.util;

import java.sql.DriverManager;
import java.sql.Connection;
import java.sql.Statement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.sql.SQLException;

import java.util.Vector;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

import java.io.FileOutputStream;
import java.io.DataOutputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.File;

import org.xml.sax.InputSource;
import org.media.datastore.sepengine.LogManager;
import org.media.datastore.sepengine.SepInterpreter;
import org.media.datastore.beepserver.SEPprofile;
import org.media.datastore.sepengine.RDBInfo;
import org.media.datastore.sepengine.util.StringInputStream;
import org.media.datastore.sepengine.util.DBWriter;


/**
 * This class .....
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba</a>
 * @version $Revision: 1.54 $ $Date: 2001/05/21 22:30:30
 * @see java.lang.String
 * @see org.media.datastore.sepengine.RDBInfo
 * @see org.media.datastore.sepengine.util.StringInputStream
 */

public class SepDBHandler {
    
    private static final String TABLE_PREFIX = "ds";
    private static final int WORD_NUMBER = 100;
    
    private int         docID;
    private String      errorMsg;
    private RDBInfo     rdbInfo;
    private int         user_id;
    private int         group_id;
    private String      tempTable;

    private Connection    con;
    private SepInterpreter si;
    

    public SepDBHandler( RDBInfo info, String uname, SepInterpreter si ) {
        this.si   = si;
        docID     = -1;
        errorMsg  = null;
        rdbInfo   = info;
        tempTable = "temp" + SEPprofile.getSessionNr(); 

        if ( uname.equals("root") ) {
            user_id = -1;
            group_id = -1;
        }
        else {
            if ( connect() ) {
                String sql = "SELECT user_id FROM " + TABLE_PREFIX+ "users WHERE user_name='" + uname + "'";
                
                try {
                    Statement stmt = con.createStatement();
                    ResultSet   rs = stmt.executeQuery( sql );
                    if ( rs.next()  ) {
                        user_id = rs.getInt("user_id");
                        group_id = getGroupID(uname);
                    }
                    rs.close();stmt.close();
                }
                catch ( Exception e ) {}
	

                disconnect();
            }
        }
    }


    public String getErrorMessage() {
        return errorMsg;
    }

    
    public void setUserID(int id) {
        user_id = id;
    }

    
    public void setGroupID(int id) {
        group_id = id;
    }

        
    public boolean isReady() {
        con = rdbInfo.getConnection();
        return con != null;
    }
    
    
    public boolean authenticate( String user, String passwd ) {
        boolean found = false;
        String    sql = "SELECT user_id, user_passwd FROM " + TABLE_PREFIX+ "users WHERE user_name='" + user + "' AND upper(blocked)='F'";
        
        if ( connect() ) {
            try {
                Statement stmt = con.createStatement();
                ResultSet   rs = stmt.executeQuery( sql );
                if ( rs.next() ) {
                    String _pwd = si.getPasswdHash( rs.getString("user_passwd") );
                    found = _pwd.equals( passwd );
                }
                rs.close();stmt.close();
            }
            catch ( Exception e ) {
                LogManager.getReference().message("error", "query_failed", "\nSQL = " + sql + "\n" + e.getMessage() );
                return false;
            }
    	    
            disconnect();
        }
        
        return found;
    }
    

    public int getTreeID( String subtree ) {
        int        dID;
        int rootParent = 0;
        int     treeID = -1;
        String   stree = " /";
        
        if ( connect() ) {    

            treeID = 0;
            docID  = -1;

            StringTokenizer st = new StringTokenizer(subtree, "/");
        
            while( st.hasMoreTokens() ) {
                String name = (String)st.nextToken("/");

                if ( name.trim().length() < 1 ) continue;

                if ( ( rootParent = isTree(name, rootParent) ) == -1 && st.hasMoreTokens() ) {
                    if( subtree.indexOf(name) > 0 ) 
                        stree = " " + subtree.substring(0, subtree.indexOf(name)-1);
                    errorMsg = name + " " +  LogManager.getReference().getMessage("invalid_subtree") + stree;
                    
                    return -1;
                }
         

                if ( rootParent == -1 && !st.hasMoreTokens() ) { 
                    try {
                        docID = new Integer( name ).intValue();
                        dID = docID;
                        if ( (docID = isDocument(docID, treeID)) == -1 ) {
                            if( subtree.indexOf(name) > 0 ) 
                                stree = subtree.substring(0, subtree.indexOf(name)-1);
                            errorMsg = "This ID " + dID + " " + 
                                LogManager.getReference().getMessage("invalid_document") + stree;
                            return -1;
                        }
                    } 
                    catch ( Exception e ) {
                        if ( (docID = getDocumentID( treeID, name)) == -1 ) {
                            
                            if( subtree.indexOf(name) > 0 ) 
                                stree = subtree.substring(0, subtree.indexOf(name)-1);
                            errorMsg = "This document name " + name + " " + 
                                LogManager.getReference().getMessage("invalid_document") + stree;
                            return -1;
                        }
                    }
                    break;
                }

                if( rootParent != -1 ) treeID = rootParent;
            }
            disconnect();
        }
        return treeID;
    }

    
    public int getDocumentID(String subtree){
        return docID;
    }


    public boolean isPath( String path ) {
        if ( path.trim().length() < 1 ) return true;    
    
        int nr_art = 0, x  = 0;
        
        while( ( x = path.indexOf(";", x) + 1) != 0 ) nr_art ++;
        
        if ( nr_art > 1 ) {
            errorMsg = LogManager.getReference().getMessage("many_attribut") + " " + 
                path.substring(path.indexOf(";")+1).replace(';', ',');
            return false;
        }
        connect();

        boolean ispath = getPathID( path.replace(';',':'), -1, path.indexOf(";") != -1 );
        
        if ( !ispath ) {
            errorMsg = LogManager.getReference().getMessage("invalid_path") + " " + 
                path.replace(':','.').replace(';','-');
        }
        
        disconnect();
        
        return ispath;
    }


    public String toSQL(String path, String value, String op, boolean app, 
                        boolean cs, int tID, int dID, int bNr, String or, String subtree) {
        
        Vector words = new Vector(); words.addElement("");
        StringTokenizer st = new StringTokenizer(value);        
        
        int ii = 0;
        while( st.hasMoreTokens() ) {
            if( ii == 0 ) words.removeAllElements();
            words.addElement(st.nextToken()); ii++;
        }
        
        if ( or.length() > 0 ) 
            SEPprofile.setOrder( or ); 
        else 
            SEPprofile.setOrder( "ASC" );
    
        if( connect() ) {
            String SQL1 = "CREATE TABLE " + tempTable + " (" +
                "doc_id INTEGER NOT NULL, tree_id INTEGER NOT NULL," +
                "pozition INTEGER NOT NULL, block_nr INTEGER NOT NULL," +
                "tree_name VARCHAR(250) NOT NULL)";
    
            try {
                con.prepareStatement( SQL1 ).execute();
            }
            catch ( Exception ex ) {}
            
            treeScanner (path, words, op, app, cs, tID, dID, bNr, subtree, path.trim().length() > 0 || value.trim().length() > 0 );
            disconnect();
        }
        
        return "SELECT doc_id, tree_id, tree_name FROM " + tempTable + " WHERE block_nr=" + bNr;
    }
     
    
    public InputStream execute ( String sql , boolean scanTree ) {
        StringBuffer   buffer = new StringBuffer();
        StringInputStream sis = new StringInputStream();
        Vector      ignoredKeys = si.ignoredKeys;
        Vector     deniedTree = new Vector();
	
        int  nrBlock = 0;
        int  docID   = -1, 
	      treeID = -1;
        String  _doc = null;
        String bName = "";

        if ( connect() ) {
            String SQL = sql + " GROUP BY tree_name, doc_id, tree_id " + 
                " ORDER BY 3, 1 " + SEPprofile.getOrder();
            
            try { 
                Statement stmt = con.createStatement();
                ResultSet   rs = stmt.executeQuery( SQL );
		
                sis.write("<response reqno='" + si.getRequestNr() + "'>\n<additional>");

                if ( ignoredKeys.size() > 0 ) {
                    for ( Enumeration e = ignoredKeys.elements(); e.hasMoreElements(); ) {
                        String key = (String)e.nextElement();
                        sis.write("\n<warning code=\"0\">");
                        sis.write("\"" + key + "\" " + LogManager.getReference().getMessage("ignored_item") );
                        sis.write("</warning>");
                    }
                }
                
                if ( scanTree ) { 
                    boolean   deniedDoc = false;
                    String  deniedTrees = "";
                    
                    while ( rs.next() ) {
                        docID  = rs.getInt("doc_id");
                        treeID = rs.getInt("tree_id");
                        if ( deniedTree.contains( treeID + "" ) ) continue;
			
                        _doc   = treeID + "/" + docID;
                        bName  = getDocumentName( rs.getString("tree_name"), docID );
		    
                        if ( !inBuffer( buffer, _doc + "," ) ) { 
                            if ( !hasReadRights( treeID ) ) {
                                deniedTree.addElement( treeID + "" );
                                deniedTrees += "\nFetch : " + bName.substring(0, bName.lastIndexOf(".") ) + ". " +
                                    LogManager.getReference().getMessage("permission_denied"); 
                            }
                            else if ( !hasReadRights( treeID, docID ) ) {
                                deniedDoc = true;
                            }
                            else {
                                buffer.append(_doc + ", ");
                                sis.write( "\n<block name=\"" + bName + "\" />");
                                nrBlock ++;
                            }
                        }
                    }
                    if ( deniedTrees.trim().length() > 0 ) {
                        sis.write("\n<warning code=\"0\">");
                        sis.write( deniedTrees );
                        sis.write("</warning>");
                    }
                    if ( deniedDoc ) {
                        sis.write("\n<warning code=\"0\">");
                        sis.write( LogManager.getReference().getMessage("alldoc_rights") );
                        sis.write("</warning>");
                    }
                    if ( nrBlock == 0 ) {
                        sis.write("\n<warning code=\"0\">");
                        sis.write( LogManager.getReference().getMessage("no_match") );
                        sis.write("</warning>");
                    }
                    sis.write("\n</additional>");
                }
                else if ( rs.next() ) {
                    boolean deniedDoc = false;
                    docID  = rs.getInt("doc_id");
                    treeID = rs.getInt("tree_id");
                    if ( !hasReadRights( treeID, docID ) ) deniedDoc = true;
                    bName  = getDocumentName( rs.getString("tree_name"), docID );

                    if ( deniedDoc ) {
                        sis.write("\n<warning code=\"0\">");
                        sis.write( LogManager.getReference().getMessage("doc_rights") );
                        sis.write("</warning>");
                    }
                    sis.write("\n</additional>");
                    if ( !deniedDoc ) {
                        sis.write("\n<block name=\"" + bName + "\" >");
                        if ( getMode(treeID).startsWith("free") ) sis.write("<![CDATA[");
		    
                        String sql1 = "SELECT block, order_nr FROM " + TABLE_PREFIX+ "repository WHERE ( status='S' OR upper(status)='W' OR upper(status)='U' ) " + 
                            " AND doc_id=" + docID + " AND tree_id=" + treeID + " ORDER BY 2 ASC";
                        Statement stmt1 = con.createStatement();
                        ResultSet rs1 = stmt1.executeQuery( sql1 );
                        while ( rs1.next() ) sis.write( rs1.getString("block") );
                        rs1.close();stmt1.close();
		    
                        if ( getMode(treeID).startsWith("free") ) sis.write("]]>");
                        sis.write("\n</block>");
                        nrBlock ++;
                    }
                } 
                else {
                    sis.write("\n<warning code=\"0\">");
                    sis.write( LogManager.getReference().getMessage("no_match") );
                    sis.write("</warning>");
                    sis.write("\n</additional>");
                }
                sis.write("\n</response>");
                rs.close();stmt.close();
            }
            catch ( Exception e) {
                errorMsg = LogManager.getReference().getMessage("fetch_error");
                sis.flush();
                sis.write( si.getResponse("error", 0, errorMsg ) );
                LogManager.getReference().message("error", "query_failed", 
						  "\nSQL = " + SQL + "\n" + e.getMessage()); 
            }   
            finally {
                try {
                    con.prepareStatement("DROP TABLE " + tempTable ).execute();
                } catch ( Exception e ) {}
            }
            disconnect();
        }
        
        LogManager.getReference().message("info", "fetch_successfull", nrBlock + " matches.");
                
        return sis.getInputStream();
    }    


    public boolean writeToRepository(String dName, String xml, int bNr, int tID, int dID) {
        if ( connect() ) {
            try {
                PreparedStatement ps = con.prepareStatement("INSERT INTO " + TABLE_PREFIX+ "repository VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                ps.setInt      ( 1, dID );
                if ( dName != null ) 
                    ps.setString   ( 2, dName );
                else
                    ps.setString   ( 2, dID + "");
                ps.setInt      ( 3, tID );
                ps.setInt      ( 4, bNr );
                ps.setString   ( 5, xml );
                ps.setString   ( 6, "W" );
                ps.setInt      ( 7, user_id == -1 ? 0 : user_id);
                ps.setInt      ( 8, group_id == -1 ? 0 : group_id);
                ps.setTimestamp( 9, new Timestamp ( System.currentTimeMillis() ) ); 
                ps.setString   (10, "t" );
                ps.setString   (11, "t" );
                ps.setString   (12, "t" );
                ps.setString   (13, "f" );
                ps.setString   (14, "f" );
                ps.setString   (15, "f" );
                ps.executeUpdate();ps.close();
            } 
            catch ( Exception _ex ) {
                errorMsg = LogManager.getReference().getMessage("write_document_error");
                LogManager.getReference().message("error", "query_failed", _ex.getMessage()); 
                return false;
            }

            disconnect();
        }
        return true;
    }
    

    public boolean markDocument(int tID, int dID, String action) {
        if( connect() ) {
            try {
                PreparedStatement ps = con.prepareStatement(
				       "UPDATE " + TABLE_PREFIX+ "repository SET status = ? , modify_time = ? WHERE tree_id = ? AND doc_id = ?");
                ps.setString   ( 1, action);
                ps.setTimestamp( 2, new Timestamp ( System.currentTimeMillis() ) );
                ps.setInt      ( 3, tID);
                ps.setInt      ( 4, dID);
                ps.executeUpdate();ps.close();
            }
            catch( Exception e ) {
                LogManager.getReference().message("error", "delete_failed", e.getMessage());
                disconnect();
                return false; 
            }
            disconnect();
            return true;
        }
        return false;
    }


    public boolean deleteDocument( int tID, int dID, boolean all ) {
        if( connect() ) {
            try {
                con.prepareStatement("DELETE FROM " + TABLE_PREFIX+ "repository WHERE tree_id=" + tID + " AND doc_id=" + dID).execute();
                if ( all ) {
                    Statement stmt = con.createStatement(); 
                    ResultSet   rs = stmt.executeQuery("SELECT doc_id FROM " + TABLE_PREFIX+ "repository WHERE tree_id=" + tID);
                    if( !rs.next() ) {
                        con.prepareStatement("UPDATE " + TABLE_PREFIX+ "dockeys SET next_id=1 WHERE tree_id=" + tID).execute();
                    }
                    rs.close();stmt.close();
                }
            }
            catch( Exception e ) {
                LogManager.getReference().message("error", "delete_failed", e.getMessage());
                return false; 
            }
            disconnect();
            return true;
        }
        return false;
    }

    
    public boolean deleteTree( int tID ) {
        if ( connect() ) {
            try {
                con.prepareStatement("DELETE FROM " + TABLE_PREFIX+ "trees   WHERE tree_id=" + tID).execute();
                con.prepareStatement("DELETE FROM " + TABLE_PREFIX+ "dockeys WHERE tree_id=" + tID).execute();
            }
            catch( Exception e ) {
                return false; 
            }
            disconnect();
            return true;
        }
        return false;
    }
    

    public void removeEntries( boolean full) {
        String sql = "SELECT doc_id, tree_id FROM " + TABLE_PREFIX+ "repository WHERE ( UPPER(status)='D' OR UPPER(status)='U' ) AND order_nr = 1";

        if ( connect() ) {
            try {
                Statement stmt = con.createStatement();
                ResultSet   rs = stmt.executeQuery( sql );
		
                if ( rs.next() ) {
                    int tID = rs.getInt("tree_id");
                    int dID = rs.getInt("doc_id");
                    
                    removeEntry(tID, dID);
                    con.setAutoCommit (true);
                    if ( full ) {
                        Statement stmt1 = con.createStatement();
                        ResultSet   rs1 = stmt1.executeQuery("SELECT doc_id FROM " + TABLE_PREFIX+ "repository WHERE tree_id=" + tID);
                        if ( !rs1.next() ) {
                            con.prepareStatement("DELETE FROM " + TABLE_PREFIX+ "trees   WHERE tree_id=" + tID).execute();
                            con.prepareStatement("DELETE FROM " + TABLE_PREFIX+ "dockeys WHERE tree_id=" + tID).execute();
                        }
                        rs1.close();stmt1.close();
                    }
                    markDocument( tID, dID, "W" );
                    rs.close();stmt.close();disconnect();removeEntries( full );return;
                } 
                rs.close();stmt.close(); 
            } 
            catch ( Exception e ) {
                LogManager.getReference().message("error", "delete_failed", e.getMessage());
            } 
            disconnect();
        }
    }

    
    public boolean isEmptyTree( int tID ) {
        boolean empty = false;
        
        if ( connect() ) {
            try {
                Statement stmt = con.createStatement();
                ResultSet   rs = stmt.executeQuery("SELECT doc_id FROM " + TABLE_PREFIX+ "repository WHERE order_nr=1 AND tree_id=" + tID);
                empty = !rs.next(); rs.close(); stmt.close();
                if ( empty ) {
                    stmt = con.createStatement();
                    rs = stmt.executeQuery("SELECT tree_id FROM " + TABLE_PREFIX+ "trees WHERE tree_parent=" + tID);
                    empty = !rs.next(); rs.close(); stmt.close();
                }
            }
            catch ( Exception e ) {
                empty = false;
            }
            disconnect();
        }
        
        return empty;
    }

    
    public int getOwnerID( int tID ) {
        int id = -1;
        
        if ( connect() ) {
            try {
                Statement stmt = con.createStatement();
                ResultSet   rs = stmt.executeQuery("SELECT user_id FROM " + TABLE_PREFIX+ "trees WHERE tree_id=" + tID);
                if ( rs.next() ) id = rs.getInt("user_id");
                rs.close(); stmt.close();
            }
            catch ( Exception e ) {}
            disconnect();
        }
        
        return id;
    }

    
    public int _messageID( int treeID ) {
        int _id = -1;
        
        if ( connect() ) {
            try {
                Statement stmt = con.createStatement();
                ResultSet   rs = stmt.executeQuery("SELECT next_id FROM " + TABLE_PREFIX+ "dockeys WHERE tree_id=" + treeID);
            	if ( rs.next() ) _id = rs.getInt( 1 ); 
            	rs.close();stmt.close();
            	if ( _id != -1 ) {    
                  while ( hasTree ( "" + _id, treeID ) ) _id++;
                  con.prepareStatement("UPDATE " + TABLE_PREFIX+ "dockeys SET next_id = " + ( _id + 1 )  + " WHERE tree_id=" + treeID ).execute();
              }
            } catch ( Exception _ex ) {
                try {
                    con.rollback();
                } catch ( Exception re ){}
                _id = -1;
            }
            disconnect();
        }
	
        return _id; 
    }


    private boolean hasTree(String tname, int parent) throws Exception {
        boolean found = false;
        String    SQL = "SELECT tree_id FROM " + TABLE_PREFIX+ "trees WHERE tree_name='" + tname + "' AND tree_parent=" + parent;
        
        try {
            Statement stmt = con.createStatement();
            ResultSet   rs = stmt.executeQuery( SQL );
            if ( rs.next() ) found = true;
            rs.close(); stmt.close();
        } 
        catch ( Exception e ) {
            LogManager.getReference().message("error", "query_failed", "\nSQL = " + SQL + "\n" + e.getMessage() );
            throw e;
        }
        
        return found;
    }

    
    public int _treeID( String path ) {
        int _id = -1;
        
        if ( connect() ) {
            _id = getTreeID( path, 0 );
            disconnect();
        }    
        
        return _id;
    }


    public void writeEntries() {
        String sql = "SELECT doc_id, tree_id, status FROM " + TABLE_PREFIX+ "repository WHERE ( status='W' OR status='U' ) AND order_nr=1";
        
        if ( connect() ) {
            try {
                Statement stmt = con.createStatement();
                ResultSet   rs = stmt.executeQuery( sql );
                
                if ( rs.next() ) {
                    int        tID = rs.getInt("tree_id");
                    int        dID = rs.getInt("doc_id");
                    String  status = rs.getString("status");
                    String    mode = getMode( tID );
                    InputStream is = getDocument( tID, dID );
		
                    if ( markDocument( tID, dID,  status.toLowerCase() ) ) {
                        if ( mode != null && is != null ) {
                            if ( mode.equalsIgnoreCase("flexible") || mode.equalsIgnoreCase("strict") ) {
                                if ( ( errorMsg = (new DBWriter()).write( con, si.getValidBlock(is), tID, dID, rdbInfo) ) != null )
                                    deleteDocument(tID, dID, true);
                            }
                        
                            if ( mode.equalsIgnoreCase("free_tag") ) { //free mode with TAG
                                if ( !writeToLexicon(is, tID, dID, true) ) 
                                    deleteDocument(tID, dID, true);
                            }
                        
                            if ( mode.equalsIgnoreCase("free") ) { //free mode without TAG
                                if ( !writeToLexicon(is, tID, dID, false) ) 
                                    deleteDocument(tID, dID, true);
                            }
                            markDocument(tID, dID, "S");
                        }       
                    }
                    rs.close();stmt.close();disconnect();writeEntries();return;
                }
                rs.close();stmt.close();
            }
            catch( Exception e ) {
                LogManager.getReference().message("error", "query_failed", "\nSQL = " + sql + "\n" + e.getMessage() );
            }
            disconnect();
        }
    }    
    

    public void validateEntries() {
        String sql = "SELECT doc_id, tree_id, status FROM " + TABLE_PREFIX+ "repository WHERE order_nr=1 AND (status='w' OR status='u')";
    
        if ( connect() ) {
            try {
                Statement stmt = con.createStatement();
                ResultSet   rs = stmt.executeQuery( sql );
                if ( rs.next() ) {
                    int tID = rs.getInt("tree_id");
                    int dID = rs.getInt("doc_id");
                    
                    removeEntry ( tID, dID );
                    markDocument( tID, dID, rs.getString("status").toUpperCase() );
                    rs.close();stmt.close();disconnect();validateEntries();return;
                }
                rs.close();stmt.close();
            } 
            catch ( Exception e) {
                LogManager.getReference().message("error", "validate_error", "\nSQL = " + sql + "\n" + e.getMessage() );
            }
            disconnect();
        }
    }
    

    public String getMode (int tID) {
        String mode = "flexible";
	
        if ( rdbInfo.getDTDDirInfo().getStoreMode() != null )
            mode = rdbInfo.getDTDDirInfo().getStoreMode();
	
        String  sql = "SELECT store_mode FROM " + TABLE_PREFIX+ "trees WHERE tree_id=" + tID;
	
        try {
            Statement stmt = con.createStatement();
            ResultSet   rs = stmt.executeQuery( sql );
            if ( rs.next() ) mode = rs.getString("store_mode");
            rs.close();stmt.close();
        }
        catch ( Exception e ) {
            LogManager.getReference().message("error", "query_failed", "\nSQL = " + sql + "\n" + e.getMessage() );
        }
        
        return mode;    
    }


    public String getNaming( int tID ) {
        String naming = "Auto";
        String    sql = "SELECT naming FROM " + TABLE_PREFIX + "trees WHERE tree_id=" + tID;
      
        try {
            Statement stmt = con.createStatement();
            ResultSet   rs = stmt.executeQuery( sql );
            if ( rs.next() ) 
                if ( rs.getString("naming").equalsIgnoreCase("M") ) naming = "Manual";
            rs.close();stmt.close();
        }
        catch ( Exception e ) {
            LogManager.getReference().message("error", "query_failed", "\nSQL = " + sql + "\n" + e.getMessage() );
        }
        
        return naming;
    }


    public boolean hasDocumentRights( String right, String blockName ) {
        int tID = getTreeID( blockName );
        int dID = getDocumentID( "" );
        
        if ( tID != -1 && dID != -1 ) {
            if ( user_id == -1 ) return true;
            if ( !userHasRights (tID, dID, right) ) {
                if ( isUserDoc(tID, dID) ) {
                    return false;
                }
                else {
                    if ( !groupHasRights(tID, dID, right) ) {
                        if ( isGroupDoc(tID, dID) ) {
                            return false;
                        }
                        else {
                            return otherHasRights(tID, dID, right);
                        }
                    }
                    else {
                        return true;
                    
                    }
                }
            }
            else {
                return true;
            }
        }
        
        return false;
    }
    

    public boolean hasTreeRights( String right, String blockName , boolean create ) {
        int tID = getTreeID( blockName );

        if ( tID != -1 ) {
            if ( user_id == -1 ) return true;
            if ( !userHasRights (tID, right) ) {
                if ( isUserTree(tID) ) {
                    return false;
                }
                else {
                    if ( !groupHasRights(tID, right) ) {
                        if ( isGroupTree(tID) ) {
                            return false;
                        }
                        else {
                            return otherHasRights(tID, right);
                        }
                    }
                    else {
                        return true;
                    
                    }
                }
            }
            else {
                return true;
            }
        }
        else {
            if ( create )
                return createNewTree( blockName, false );
            else
                return false;
        }
    }

    
    public boolean createNewTree( String blockName , boolean flag) {
        int       parentID = 0, pID;
        StringTokenizer st = new StringTokenizer( blockName, "/" );
        String       tName = "";
        boolean      first = true;
        
        while ( st.hasMoreTokens() ) {
            String str = st.nextToken();
            
            if ( ( pID = getTreeID( tName + str ) ) != -1 ) {
                parentID = pID;
                tName += str + "/";
                continue;
            }
            
            if ( first ) 
                if ( hasTreeRights("write", tName, false) ) first = false; 
                else {
                    errorMsg = LogManager.getReference().getMessage("permission_denied") + "!";
                    return false;
                }
                
            if ( ( pID = nextID("tree_id") ) != -1 ) 
                parentID = saveTree( pID, str, parentID);

        }
        
        if ( flag && first ) {
            errorMsg = "Subtree " + LogManager.getReference().getMessage("exist");
            return false; 
        } else return true;
    }


    public InputStream getDocument(int tID, int dID) {
        StringInputStream sis = new StringInputStream();
        String sql = "SELECT block, order_nr FROM " + TABLE_PREFIX+ "repository WHERE ( status='S' OR status='W' OR status='U' ) " + 
            " AND  tree_id=" + tID + " AND doc_id=" + dID + " ORDER BY 2 ASC";
        
        try {
            Statement stmt = con.createStatement();
            ResultSet   rs = stmt.executeQuery( sql );
            while( rs.next() ) sis.write( rs.getString("block") + " ");
            rs.close();stmt.close();
        }
        catch ( Exception e ) {
            LogManager.getReference().message("error", "query_failed", "\nSQL = " + sql + "\n" + e.getMessage() );
            return null;
        }
        
        return sis.getInputStream();
    }


    public int getDocumentID( int tID, String docName ) {
        int   _dID = -1;
        String sql = "SELECT doc_id FROM " + TABLE_PREFIX + "repository WHERE tree_id=" + tID + " AND doc_name='" + docName.trim() + "'";
        
        try {
            Statement stmt = con.createStatement();
            ResultSet   rs = stmt.executeQuery( sql );
            if ( rs.next() ) _dID = rs.getInt("doc_id");
            rs.close();stmt.close();
        }
        catch ( Exception e ) {
            LogManager.getReference().message("error", "query_failed", "\nSQL = " + sql + "\n" + e.getMessage() );
        }
        
        return _dID;
    }
    

    public String getDocumentName( int tID, int dID ) {
        String _dName = null;
        String sql = "SELECT doc_name FROM " + TABLE_PREFIX + "repository WHERE tree_id=" + tID + " AND doc_id=" + dID;
        
        try {
            Statement stmt = con.createStatement();
            ResultSet   rs = stmt.executeQuery( sql );
            if ( rs.next() ) _dName = rs.getString("doc_name");
            rs.close();stmt.close();
        }
        catch ( Exception e ) {
            LogManager.getReference().message("error", "query_failed", "\nSQL = " + sql + "\n" + e.getMessage() );
        }
        
        return _dName;    
    }

    
    private boolean inBuffer( StringBuffer buffer, String key ) {
        return buffer.toString().indexOf( key ) != -1;
    }


    private String getDocumentName( String tName, int docID ) {
        do {
            int tId = getTreeID( tName );
            int dId = getDocumentID( tName );
	    
            if ( ( tId != -1 && dId == -1 ) || tName.trim().length() < 1 ) break;
            tName = tName.substring(0, tName.lastIndexOf("/") );
        } while ( false );
        
        return tName.endsWith("/") ? (tName + docID) : (tName + "/" + docID);
    }


    private void removeUser(int uID, int gID) {
        String sql;
        try {
            sql = "DELETE FROM " + TABLE_PREFIX+ "users WHERE user_id=" + uID;
            con.prepareStatement(sql).execute();
            sql = "DELETE FROM " + TABLE_PREFIX+ "groups WHERE group_id=" + gID;
            con.prepareStatement(sql).execute();
            sql = "DELETE FROM " + TABLE_PREFIX+ "trees WHERE group_id=" + gID + " AND user_id=" + uID;
            con.prepareStatement(sql).execute();
            sql = "DELETE FROM " + TABLE_PREFIX+ "ug_realation WHERE user_id=" + uID;
            con.prepareStatement(sql).execute();
        } 
        catch ( Exception ex ){
            LogManager.getReference().message("error", "remove_user_error", ex.getMessage() );
        }
    }


    private boolean userExist( String uname ) {
        boolean found = false;  
    
        try {
            Statement stmt = con.createStatement();
            ResultSet   rs = stmt.executeQuery("SELECT * FROM " + TABLE_PREFIX+ "users WHERE user_name='" + uname + "'");
            found = rs.next(); 
            rs.close();stmt.close();
        }
        catch ( Exception e ) {
            LogManager.getReference().message("error", "user_exist_error", uname ); 
        }
        
        return found;
    }


    private int getGroupID( String gname ) {
        int id = -1;
    
        try {
            Statement stmt = con.createStatement();
            ResultSet   rs = stmt.executeQuery("SELECT * FROM " + TABLE_PREFIX+ "groups WHERE group_name='" + gname + "'");
            if ( rs.next() ) id = rs.getInt("group_id");  
            rs.close();stmt.close();
        }
        catch ( Exception e ) {
            LogManager.getReference().message("error", "group_error", gname );
        }
        
        return id;
    }

    
    private boolean hasReadRights( int tID, int dID ) {
        if ( user_id == -1 ) return true;
        if ( !userHasRights (tID, dID, "read") ) {
            if ( isUserDoc(tID, dID) ) {
                return false;
            }
            else {
                if ( !groupHasRights(tID, dID, "read") ) {
                    if ( isGroupDoc(tID, dID) ) {
                        return false;
                    }
                    else {
                        return otherHasRights(tID, dID, "read");
                    }
                }
                else {
                    return true;
                    
                }
            }
        }
        else {
            return true;
        }    
    }


    private boolean hasReadRights( int tID ) {
        if ( user_id == -1 ) return true;
        if ( !userHasRights (tID,  "read") ) {
            if ( isUserTree(tID) ) {
                return false;
            }
            else {
                if ( !groupHasRights(tID, "read") ) {
                    if ( isGroupTree(tID) ) {
                        return false;
                    }
                    else {
                        return otherHasRights(tID, "read");
                    }
                }
                else {
                    return true;
                    
                }
            }
        }
        else {
            return true;
        }    
    }

    
    private boolean isUserDoc( int tID, int dID ) {
        String sql = "SELECT doc_id FROM " + TABLE_PREFIX+ "repository WHERE doc_id="+dID+" AND tree_id="+tID+" AND order_nr=1 AND user_id="+user_id;
        return executeSQL( sql );    
    }


    private boolean isGroupDoc( int tID, int dID ) {
        String sql = "SELECT doc_id FROM " + TABLE_PREFIX+ "repository WHERE doc_id="+dID+" AND tree_id="+tID+" AND order_nr=1 AND group_id="+group_id;
        return executeSQL( sql );    
    }


    private boolean isUserTree( int tID ) {
        String sql = "SELECT tree_id FROM " + TABLE_PREFIX+ "trees WHERE tree_id="+tID+" AND user_id="+user_id;
        return executeSQL( sql );    
    }


    private boolean isGroupTree( int tID ) {
        String sql = "SELECT tree_id FROM " + TABLE_PREFIX+ "trees WHERE tree_id="+tID+" AND group_id="+group_id;
        return executeSQL( sql );    
    }

    
    private boolean userHasRights( int tID, int dID, String right ) {
        String sql = "SELECT doc_id FROM " + TABLE_PREFIX+ "repository WHERE doc_id="+dID+" AND tree_id="+tID+
	    " AND order_nr=1 AND user_id="+user_id+" AND upper(user_"+right+")='T'";
        return executeSQL( sql );    
    }
    

    private boolean userHasRights( int tID, String right ) {
        String sql = "SELECT tree_id FROM " + TABLE_PREFIX+ "trees WHERE tree_id="+tID+" AND user_id="+user_id+" AND upper(user_"+right+")='T'";
        return executeSQL( sql );
    }
    

    private boolean groupHasRights( int tID, int dID, String right ) {
        String sql = "SELECT doc_id FROM " + TABLE_PREFIX+ "repository, " + TABLE_PREFIX+ "ug_relation WHERE doc_id=" + dID + " AND tree_id=" + tID + " AND order_nr=1 " + 
	    " AND " + TABLE_PREFIX+ "repository.group_id=" + TABLE_PREFIX+ "ug_relation.group_id AND " + TABLE_PREFIX+ "ug_relation.user_id=" + user_id + " AND upper(group_"+right+")='T'";
        return executeSQL( sql );    
    }

    
    private boolean groupHasRights( int tID, String right ) {
        String sql = "SELECT tree_id FROM " + TABLE_PREFIX+ "trees, " + TABLE_PREFIX+ "ug_relation WHERE " + TABLE_PREFIX+ "trees.group_id=" + TABLE_PREFIX+ "ug_relation.group_id AND " + TABLE_PREFIX+ "ug_relation.user_id="+user_id+ 
	    " AND tree_id="+tID+" AND upper(group_"+right+")='T'";
        return executeSQL( sql );    
    }

    
    private boolean otherHasRights( int tID, int dID, String right ) {
        String sql = "SELECT doc_id FROM " + TABLE_PREFIX+ "repository WHERE doc_id=" + dID + " AND tree_id=" + tID + " AND upper(other_"+right+")='T'";
        return executeSQL( sql );
    }


    private boolean otherHasRights( int tID, String right ) {
        String sql = "SELECT tree_id FROM " + TABLE_PREFIX+ "trees WHERE tree_id="+tID+" AND upper(other_"+right+")='T'";
        return executeSQL( sql );
    }

    
    private boolean executeSQL( String sql ) {
        boolean rights = false;

        if ( connect() ) {
            try {
                Statement stmt = con.createStatement();
                ResultSet   rs = stmt.executeQuery( sql );
                rights = rs.next();                                             
                rs.close();stmt.close();
            }
            catch ( Exception e ) {
                LogManager.getReference().message("error", "query_failed", "SQL: " + sql );
            }
            disconnect();
        }

        return rights; 
    }
    

    private boolean writeToLexicon( InputStream xml, int tID, int dID, boolean withTag ) {
        StringBuffer sb = new StringBuffer();
        try {
            int ch;
            int wordNr = 0;
            int poz = 1;
            while ( ( ch = xml.read() ) != -1 ) {
                if ( !withTag && (char)ch == '<' ) {
                    ignoreTag( xml );
                    continue;
                }
                if ( (char)ch == ' ' ) wordNr++;
                sb.append( (char)ch );
                if ( wordNr > WORD_NUMBER ) {
                    wordNr = 0;
                    if ( ( poz = LexiconWriter(sb.toString().replace('\'', '`').trim(), tID, dID, poz) ) == -1 )
                        return false;
                    sb = sb.delete(0, sb.length());
                }       
            }
            
            if ( ( poz = LexiconWriter(sb.toString().trim(), tID, dID, poz) ) == -1 )
                return false;
            return true;
        } 
        catch ( Exception e ) {
	    LogManager.getReference().message("error", "lexicon_write_error", e.getMessage() );
            return false;
        }
    }

    
    private String normalizeString( String str ) {
        return si.removeSpecialIgnorableKeys( si.removeIgnorableKeys( 
						str.replace('\\', ' '),	rdbInfo.getIgnoredKeys() ), 
					      rdbInfo.getSpecialKeys() );
    }
    

    private int LexiconWriter ( String str, int tID, int dID, int poz ) {
        if ( str.length() < 1 ) return poz;
        StringTokenizer st = new StringTokenizer( normalizeString( str ) );
        
        while ( st.hasMoreTokens() ) {
            String word = st.nextToken();
                                             
            if ( word.trim().length() > 0 ) {
                int     wID = -1;
                String _sql = "SELECT word_id, word_name FROM " + TABLE_PREFIX+ "lexicon WHERE word_name='" + word + "' ORDER BY 2 ASC";
        
                try {
                    Statement stmt = con.createStatement();
                    ResultSet   rs = stmt.executeQuery(_sql);
                    if ( rs.next() ) {
                        wID = rs.getInt(1);
                        con.prepareStatement("UPDATE " + TABLE_PREFIX+ "lexicon SET word_hit=word_hit+1 WHERE word_id=" + wID).execute();
                    }
                    else {
                        if ( ( wID = nextID("lex_id") ) == -1 ) return -1;
                        con.prepareStatement("INSERT INTO " + TABLE_PREFIX+ "lexicon VALUES(" + wID + ", '" + word + "', 1)").execute();
                    }
                    _sql = "INSERT INTO " + TABLE_PREFIX+ "barrels VALUES(" + tID + "," + dID + ", -1," + wID + ", " + poz++ +")";
                    con.prepareStatement(_sql).execute();
                    rs.close();stmt.close();
                }
                catch ( Exception _sqle ) {
                    errorMsg = LogManager.getReference().getMessage("lexicon_failed");
                    LogManager.getReference().message("error", "lexicon_failed", _sqle.getMessage());
                    return -1;
                }
            }
        }
        
        return poz; 
    }

    
    private void ignoreTag( InputStream xml ) {
        try {
            int ch;
            int tagNr = 1;
            while ( ( ch = xml.read() ) != -1 ) {
                if ( (char)ch == '<' ) {
                    tagNr++;        
                    continue;
                }
                if ( (char)ch == '>' ) {
                    if ( tagNr < 2 )
                        break;
                    else 
                        tagNr--;
                }
            }
        } 
        catch ( Exception e ) {
            LogManager.getReference().message("error", "inputstream_error", e.getMessage()); 
        }
    }
    

    private int getSubtreeNr(int tID) {
        String sql    = "SELECT tree_id FROM " + TABLE_PREFIX+ "trees WHERE tree_parent=" + tID;
        int subtreeNr = -1;
        
        try {
            Statement stmt = con.createStatement();
            ResultSet   rs = stmt.executeQuery( sql );
            subtreeNr = 0;
            while ( rs.next() ) subtreeNr++;
            rs.close();stmt.close();
        } 
        catch ( Exception e ) {
	    LogManager.getReference().message("error", "query_failed", "SQL: " + sql ); 
	}
        
        return subtreeNr;
    }


    private String getHome( int tID ) throws Exception {
        String  path = "";
        Statement stmt = con.createStatement();
        ResultSet   rs = stmt.executeQuery("SELECT * FROM " + TABLE_PREFIX+ "trees WHERE tree_id=" + tID );
             
        if ( rs.next () ) {
            int   pID = rs.getInt("tree_parent");
            if ( pID > 0 ) path = getHome( pID ) + "/";
            path += rs.getString("tree_name");
        }
        rs.close();stmt.close();
         
        return path;
    }


    private void removeEntry(int tID, int dID) {
        String DTDDir = rdbInfo.getDTDDirInfo().getDTDPath() +  File.separator;
        String fName  = null;
        
        try {
            String homeDir = getHome( tID ).trim();
	    
            if ( homeDir.length() > 0 ) {
                DTDDir += homeDir.replace( '/', File.separatorChar );
                fName   = si.getFileName( new File( DTDDir ) ); 
            }
            con.setAutoCommit( false );     
	    
            Statement stmt = con.createStatement();
            ResultSet   rs = stmt.executeQuery("SELECT doc_id FROM " + TABLE_PREFIX+ "repository WHERE tree_id=" + tID + " AND status<>'D'");
            if( !rs.next() ) {
                con.prepareStatement("DELETE FROM " + TABLE_PREFIX+ "structs WHERE tree_id=" + tID).execute();
                con.prepareStatement("UPDATE " + TABLE_PREFIX+ "dockeys SET next_id=1 WHERE tree_id=" + tID).execute();
                if ( fName != null )
                    if ( !( new File( DTDDir + File.separator + fName + ".dtd" ) ).delete() )
                        LogManager.getReference().message("error", "delete_file_failed", DTDDir + File.separator + fName + ".dtd");
            }
            rs.close();stmt.close();
            
            stmt = con.createStatement();
            rs   = stmt.executeQuery("SELECT word_id FROM " + TABLE_PREFIX+ "barrels where tree_id=" + tID + " AND doc_id=" + dID);
            while ( rs.next() ) 
                con.prepareStatement("UPDATE " + TABLE_PREFIX+ "lexicon SET word_hit=word_hit-1 WHERE word_id=" + rs.getInt("word_id")).execute();
            rs.close();stmt.close(); 
	    
            con.prepareStatement("DELETE FROM " + TABLE_PREFIX+ "lexicon WHERE word_hit < 1" ).execute();
            
            con.prepareStatement("DELETE FROM " + TABLE_PREFIX+ "barrels WHERE tree_id=" + tID + " AND doc_id=" + dID).execute();
            con.prepareStatement("DELETE FROM " + TABLE_PREFIX+ "repository WHERE status='D' AND tree_id=" + tID + " AND doc_id=" + dID).execute();
            con.commit(); con.setAutoCommit( true );
        } 
        catch( Exception e ) { 
            try { con.rollback(); con.setAutoCommit( true ); } catch ( Exception _ex ) { }
        }
    }


    private boolean removeTree(int tID) {
        int subtreeNr = getSubtreeNr(tID);
                
        if ( subtreeNr == -1 ) return false;    
        if ( subtreeNr > 0 )   return true;

        String sql = "SELECT " + TABLE_PREFIX+ "trees.tree_id, " + TABLE_PREFIX+ "trees.tree_parent FROM " + TABLE_PREFIX+ "trees, " + TABLE_PREFIX+ "dockeys " +
	    "WHERE " + TABLE_PREFIX+ "trees.tree_id=" + TABLE_PREFIX+ "dockeys.tree_id AND " + TABLE_PREFIX+ "trees.tree_id=" + tID + " AND " + TABLE_PREFIX+ "dockeys.next_id < 2";
        try {
            Statement stmt = con.createStatement();
            ResultSet   rs = stmt.executeQuery(sql);
            if ( rs.next() ) {
                int parent = rs.getInt(2);rs.close();
                if( tID > 0 ) {
                    con.prepareStatement("DELETE FROM " + TABLE_PREFIX+ "trees   WHERE tree_id=" + tID).execute();
                    con.prepareStatement("DELETE FROM " + TABLE_PREFIX+ "dockeys WHERE tree_id=" + tID).execute();
                } rs.close(); stmt.close();
                return removeTree(parent);
            } rs.close(); stmt.close();
        } 
        catch ( Exception e ) {
            LogManager.getReference().message("error", "query_failed", "SQL: " + sql ); 
            return false;
        }
        return true;
    }

    
    private int getTreeID(String path, int root) {
        
        if ( path.trim().startsWith("/") ) 
            path = path.substring( path.indexOf("/") + 1 );

        int _id = -1;
        int poz = path.length();
        String lpath = "";

        if ( path.indexOf("/") != -1) 
            poz = path.indexOf("/");
      
        String name = path.substring(0, poz);   
    
        if( poz < path.trim().length() ) 
            lpath = path.substring(poz+1);
        
        if( ( _id = isTree(name, root) ) == -1 )  //if subtree not exist 
            if ( ( _id = nextID("tree_id") ) != -1 )   //get valid new subtree ID
                _id = saveTree(_id, name, root);
                
        if(_id != -1 && lpath.trim().length() > 0 )
	    _id = getTreeID(lpath, _id);
        
        return _id;
    }
    

    private int nextID( String name ) {
        int newID = -1;
        
        if ( connect() ) {
            try {
                Statement stmt = con.createStatement();
                ResultSet   rs = stmt.executeQuery("SELECT next_id FROM " + TABLE_PREFIX+ "sequences WHERE seq_name='" + name + "'");
                if ( rs.next() ) {
                    newID = rs.getInt(1);
                    con.prepareStatement("UPDATE " + TABLE_PREFIX+ "sequences SET next_id=next_id+1 WHERE seq_name='"+name+"'").execute();
                }
                rs.close();stmt.close();
            }    
            catch( Exception e ){
                LogManager.getReference().message("error", "sequences_error", e.getMessage()); 
            }
        
        }
        
        return newID;
    }

    
    private int saveTree( int _id, String name, int root ) {
        String   mode = "flexible";
        String naming = "auto";

        if ( rdbInfo.getDTDDirInfo().getStoreMode() != null )
            mode = rdbInfo.getDTDDirInfo().getStoreMode();

        if ( rdbInfo.getDTDDirInfo().getNamingFlag() != null )
            naming = rdbInfo.getDTDDirInfo().getNamingFlag();
        
        if ( naming.trim().equalsIgnoreCase("auto") ) naming ="A"; else naming = "M"; 

        String SQL = "INSERT INTO " + TABLE_PREFIX+ "dockeys VALUES(" + _id + ", 1)"; 
        try {
            PreparedStatement ps = con.prepareStatement("INSERT INTO " + TABLE_PREFIX+ "trees VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            ps.setInt      ( 1, _id );
            ps.setString   ( 2, name );
            ps.setInt      ( 3, root );
            ps.setString   ( 4, mode );
            ps.setString   ( 5, naming );
            ps.setInt      ( 6, user_id == -1 ? 0 : user_id );
            ps.setInt      ( 7, group_id == -1 ? 0 : group_id );
            ps.setTimestamp( 8, new Timestamp ( System.currentTimeMillis() ) ); 
            ps.setString   ( 9, "t" );
            ps.setString   (10, "t" );
            ps.setString   (11, "t" );
            ps.setString   (12, "f" );
            ps.setString   (13, "f" );
            ps.setString   (14, "f" );
            ps.executeUpdate();ps.close();
            con.prepareStatement( SQL ).execute();
        } 
        catch ( Exception e ) {
            LogManager.getReference().message("error", "write_subtree_error", e.getMessage()); 
            return -1;
        }
        
        return _id;
    }
    

    private boolean connect() {
        boolean connected = false;
        
        try {
            if ( con == null ) con = rdbInfo.getConnection();
            connected = true;
        }
        catch ( Exception e ) {
            errorMsg = LogManager.getReference().getMessage("connection_failed");
            LogManager.getReference().message("error", "statement_failed", e.getMessage());
        }
        
        return connected;
    }

    
    private void disconnect() {
    }


    private String match( String key, String value, String op, boolean app, boolean cs ) {
        if ( value.length() < 1 ) return null;
        StringBuffer cond = new StringBuffer();
        String  oper = " = '";
        boolean need = true;
        
        if ( !cs ) cond.append( "UPPER(" ); cond.append( key ); if ( !cs ) cond.append( ")" );
        if ( app && op.equals("eq") ) oper = " LIKE '";
        if ( app && op.equals("ne") ) oper = " NOT LIKE '";
        if ( !app && op.equals("eq") ) {
            oper = " = '";
            need = false;
        }
        if ( !app && op.equals("ne") ) {
            oper = " <> '";
            need = false;
        }
        if ( op.equals("contains") ) oper = " LIKE '";
        if ( op.equals("excludes") ) oper = " NOT LIKE '";
        cond.append(oper);
        if ( !cs ) cond.append(value.toUpperCase()); 
        else cond.append(value);
        
        String ret = cond.toString();
        if(need) ret += "%";
        
        return ret+"'"; 
    }


    private int isTree(String name, int parent) {
        int id = -1;
        String SQL = "SELECT tree_id FROM " + TABLE_PREFIX+ "trees WHERE tree_name='" + name + "' AND tree_parent=" + parent;
        
        try {
            Statement stmt = con.createStatement();
            ResultSet   rs = stmt.executeQuery( SQL );
            while ( rs.next() ) id = rs.getInt("tree_id");
            rs.close(); stmt.close(); 
        } 
        catch (SQLException e) {
            errorMsg = LogManager.getReference().getMessage("subtree_error") + name;
            LogManager.getReference().message("error", "query_failed", "\nSQL = " + SQL + "\n" + e.getMessage()); 
        }
        
        return id;
    }


    private int isDocument(int doc_ID, int parent) {
        int id = -1;
        String SQL = "SELECT doc_id FROM " + TABLE_PREFIX+ "repository WHERE ( status='S' OR status='W' OR status='U' ) AND doc_id=" + 
            doc_ID + " AND tree_id=" + parent;
        
        try {
            Statement stmt = con.createStatement();
            ResultSet   rs = stmt.executeQuery(SQL);
            while ( rs.next() ) id = rs.getInt("doc_id");
            rs.close();stmt.close(); 
        } 
        catch (SQLException e) {
            errorMsg = LogManager.getReference().getMessage("document_error") + doc_ID;
            LogManager.getReference().message("error", "query_failed", "\nSQL = " + SQL + "\n" + e.getMessage()); 
        }
        
        return id;
    }


    private int getStructID(String name, int root, int treeID, String type) {
        int structID = -1;
        String sql = "SELECT *  FROM " + TABLE_PREFIX+ "structs WHERE UPPER(struct_type) ='" + type.toUpperCase() + "'" +
	    " AND UPPER(struct_name) ='" + name.toUpperCase() + "'" +
	    " AND tree_id = " + treeID;
        
        if ( root >= 0 ) {
            if ( type.toUpperCase().equals("ATTLIST") ) {
                sql += " AND struct_parent = " + root;
            }
            else {
                try {
                    Statement stmt = con.createStatement();
                    ResultSet   rs = stmt.executeQuery( sql );
                    boolean found = false;
                    
                    while ( rs.next() && !found ) {
                        structID = rs.getInt("struct_id");
                        found = isChildren( root, rs.getInt("struct_parent") );
                        if ( !found ) structID = -1;
                    }
                    rs.close();stmt.close();
                    return structID;
                }
                catch ( Exception e ) {
                    errorMsg = LogManager.getReference().getMessage("struct_error") + name;
                    LogManager.getReference().message("error", "query_failed", "\nSQL = " + sql + "\n" + e.getMessage()); 
                    return -1;
                }
            }
        }

        try {
            Statement stmt = con.createStatement();
            ResultSet   rs = stmt.executeQuery( sql );
            while ( rs.next() ) structID = rs.getInt("struct_id");
            rs.close();stmt.close();
        }
        catch( Exception e ) {
            errorMsg = LogManager.getReference().getMessage("struct_error") + name;
            LogManager.getReference().message("error", "query_failed", "\nSQL = " + sql + "\n" + e.getMessage()); 
        } 
        
        return structID;
    }


    private int getPathID (String path, int root, int tID, boolean hasAttr) {
        int    id = -1;
        String type = "ELEMENT";
        String lpath = null;
        int poz = path.indexOf(":");
        
        if ( poz == -1 ) {
            poz = path.length();
            if ( hasAttr ) type = "ATTLIST";
        }
        if ( poz < path.length() ) lpath = path.substring( poz + 1 );
        id = getStructID(path.substring(0, poz), root, tID, type);
        if( id != -1 && lpath != null)
            id = getPathID(lpath, id, tID, hasAttr);
        
        return id;                                          
    }


    private void treeScanner( String path, Vector values, String op, boolean app, boolean cs, 
			      int tID, int dID, int bNr, String subtree, boolean scan) {        
        String sqlx = "SELECT tree_id, tree_name FROM " + TABLE_PREFIX+ "trees WHERE tree_parent="+tID; 
        
        String SQL2 = "INSERT INTO "  + tempTable;
        String SQL  = "";
        int poz = 0;
        int sID = -2;
        boolean onlyAttr = false;
        
        if ( !scan ) {
	    if ( ( poz = subtree.lastIndexOf(".") ) != -1 ) subtree = subtree.substring( 0, poz );
            SQL += " SELECT doc_id, tree_id, 1 AS pozition, " + bNr + " AS block_nr, lower('" + subtree +"') AS tree_name"+
		   " FROM " + TABLE_PREFIX+ "repository WHERE tree_id=" + tID + " AND doc_id=" + dID +" AND order_nr=1 AND upper(status)<>'D'";
        }
        else { 
            if ( path.trim().length() > 0) {
                if( path.trim().startsWith(";") ) { //only attribute specified
                    int nr_art = 0, x  = 0;
                    while ((x = path.indexOf(";", x) + 1) != 0) nr_art ++;
                    if ( nr_art == 1 ) onlyAttr = true;
                }
                else {
                    sID = getPathID( path.replace(';',':'), -1, tID, path.indexOf(";") != -1);
                }
            }
        
            try {
                Statement stmt = con.createStatement();
                ResultSet   rs = stmt.executeQuery( sqlx );
                while( rs.next() ) {
                    String tname = rs.getString("tree_name");
                    int tid = rs.getInt("tree_id");
                    if( subtree.trim().length() > 1 && !subtree.endsWith(".") ) subtree += ".";
                    treeScanner( path, values, op, app, cs, tid, dID, bNr, subtree + tname, scan);
                } rs.close();stmt.close();    
            }
            catch ( Exception e ) {
                errorMsg = LogManager.getReference().getMessage("sep_to_sql_error");
                LogManager.getReference().message("error", "query_failed", "\nSQL = " + sqlx + "\n" + e.getMessage()); 
            }
        
            if ( sID == -1 ) return;
            if ( sID == -2 ) sID = -1;
            
            Vector result = new Vector();
            Vector ignoredKeys = si.ignoredKeys;
            for( Enumeration e = values.elements(); e.hasMoreElements(); ) {
                String  src = (String)e.nextElement();
                String dest = normalizeString( src );
                String  key = "";
                boolean end = false;
                
                for ( int i = 0; i < src.length() && i < dest.length() && !end; i++ ) {
                    while ( !end && (src.charAt(i) != dest.charAt(i)) ) {
                        key += src.charAt( i++ );
                        if ( ( i >= src.length() ) || ( i >= dest.length() ) ) end = true;
                    }
                    if ( key.trim().length() > 0 ) {
                        ignoredKeys.addElement( key );
                        key = "";
                    }
                }
                
                StringTokenizer st = new StringTokenizer( dest );
                while ( st.hasMoreTokens() ) result.addElement( st.nextToken() );
            } 
            values = result;
        
            for( int i = values.size() - 1; i >= 0; i--) {
                SQL += " SELECT " + TABLE_PREFIX+ "barrels.doc_id, " + TABLE_PREFIX+ "barrels.tree_id, " + TABLE_PREFIX+ "barrels.pozition+" + poz + " AS pozition, " + 
                    bNr + " AS block_nr, lower('" + subtree + "') AS tree_name FROM " + TABLE_PREFIX+ "barrels, " + TABLE_PREFIX+ "lexicon";
                if ( sID != -1 || onlyAttr ) SQL += ", " + TABLE_PREFIX+ "structs ";
                SQL += " WHERE " + TABLE_PREFIX+ "barrels.word_id=" + TABLE_PREFIX+ "lexicon.word_id";
                if ( onlyAttr || sID != -1 ) SQL += " AND " + TABLE_PREFIX+ "barrels.struct_id=" + TABLE_PREFIX+ "structs.struct_id";
                if ( sID != -1 ) SQL += " AND " + TABLE_PREFIX+ "barrels.struct_id=" + sID;
                if (  onlyAttr ) SQL += " AND struct_name='" + path.trim().substring(1) + "'";
                SQL += " AND " + TABLE_PREFIX+ "barrels.tree_id=" + tID;
                if ( dID != -1 ) SQL += " AND " + TABLE_PREFIX+ "barrels.doc_id=" + dID;
                String _value = match("word_name", "" + values.elementAt(i), op, app, cs);
                if ( _value != null ) SQL += " AND " + _value;
                op = "eq"; app = false; poz++;
                if( i > 0 ) SQL += " INTERSECT";
            }
        }

        try {
            // insert SELECT result to "temp" table
            con.prepareStatement( SQL2 + SQL ).execute();
        }
        catch ( Exception ex ) {
            errorMsg = LogManager.getReference().getMessage("sep_to_sql_error");
            LogManager.getReference().message("error", "query_failed", 
	                                      "\nSQL = " + SQL2 + SQL + "\n" + ex.getMessage() ); 
        }
    }


    private boolean getPathID ( String path, int root, boolean hasAttr ) {
        if ( path == null ) return true;
    
        boolean found = false;
        boolean  only = false;
        String   type = "ELEMENT";
        int       poz = path.indexOf(":"), 
            start = 0;
        
        if ( poz == -1 ) {
            poz = path.length();
            if ( hasAttr ) type = "ATTLIST";
        }
        
        if ( path.trim().startsWith(":")) {
            type  = "ATTLIST";
            poz   = path.length();
            only  = true;
            start = 1;
        } 

        String lpath = null;
        if ( poz < path.length() ) lpath = path.substring( poz + 1 );
        String sname = path.substring(start, poz);
        String sql = "SELECT *  FROM " + TABLE_PREFIX+ "structs WHERE UPPER(struct_type) ='"+ type + "'" +
            " AND UPPER(struct_name) ='" + sname.toUpperCase() + "'";
        
        if ( !only && root != -1 ) {
            if ( type.equals("ATTLIST") ) 
                sql += " AND struct_parent = " + root;
            else {
                try {
                    Statement stmt = con.createStatement();
                    ResultSet   rs = stmt.executeQuery( sql );
                    found = false;
                 
                    while ( rs.next() && !found ) 
                        found = isChildren( root, rs.getInt("struct_parent") );
                    rs.close();stmt.close();
            	    
                    if ( found ) sql += " AND 1=1"; else sql += " AND 1=0";
                }
                catch ( Exception e ) {
                    sql += " AND 1=0"; 
                }
            }
        }
	
        try {
            found = false;
            Statement stmt = con.createStatement();
            ResultSet   rs = stmt.executeQuery( sql );
            while ( rs.next() && !found )
                found = getPathID(lpath, rs.getInt("struct_id"), hasAttr);
            rs.close();stmt.close();
        }
        catch ( Exception e ) {
            e.printStackTrace();
            errorMsg = LogManager.getReference().getMessage("path_error") + path;
            LogManager.getReference().message("error", "query_failed", "\nSQL = " + sql + "\n" + e.getMessage()); 
        }

        return found;
    }

    
    private boolean isChildren( int root, int sID ) {   
        boolean found = false;
        String    sql = "SELECT * FROM " + TABLE_PREFIX+ "structs WHERE struct_id=" + sID;

        if ( root == -1  ) return false;
        if ( root == sID ) return true; 
        
        try {
            Statement stmt = con.createStatement();
            ResultSet   rs = stmt.executeQuery( sql );
            while ( rs.next() || !found )
                found = isChildren( root, rs.getInt("struct_parent") );         
            rs.close();stmt.close();
        }
        catch ( Exception e ) {
            LogManager.getReference().message("error", "query_failed", "\nSQL = " + sql + "\n" + e.getMessage()); 
            return false;
        }
        
        return found;
    }
}
