/* $COPYRIGHT$
 * $Id: SepInputStream.java,v 1.3 2001/08/21 17:29:33 crow Exp $
 *
 * Date         Author           Changes
 * May 21 2001  Szabo Csaba      Created
 */
      
package org.media.datastore.sepengine.util;

import java.io.InputStream;
import java.io.IOException;

/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.3 $ $Date: 2001/08/21 15:00:00
 * @see java.lang.String
 * @see java.io.InputStream
 */
     
public class SepInputStream extends InputStream {

    private InputStream istream;
    private String      header;
    private String      footer;
    private int         headerPos;
    private int         footerPos;
    

    public SepInputStream(InputStream istream, String header, String footer) {
        this.istream = istream;
        this.header  = header;
        this.footer  = footer;
        headerPos    = 0;
        footerPos    = 0;
    }

    
    public int read() throws IOException {
        int i = -1;
        
        if ( headerPos < header.length() )
            return (int)header.charAt( headerPos++ );
        else
            if ( (i = istream.read()) != -1 ) return i;
            else
                if ( footerPos < footer.length() )
                    return (int)footer.charAt( footerPos++ );
                else
                    return -1;
    }
}
