/*
 * $COPYRIGHT$
 * $Id: StringInputStream.java,v 1.4 2001/08/21 17:29:33 crow Exp $
 *
 *  Date        Author            Changes
 * May 28 2001  Szabo Csaba       Created
 */

package org.media.datastore.sepengine.util;

import java.io.StringWriter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.4 $ $Date: 2001/08/21 15:00:00
 * @see java.lang.String
 * @see java.io.InputStream
 */

public class StringInputStream {
    
    private StringWriter  writer;
    

    public StringInputStream() {
        writer = new StringWriter();
    }

    
    public void write( String str ) {
        writer.write(str);
    }

    
    public void flush() {
        close();
        writer = new StringWriter();
    }

    
    public InputStream getInputStream() {
        close();
        return new ByteArrayInputStream( writer.toString().getBytes() );
    
    }

    
    private void close() {
        try {
            writer.close();
        } 
        catch ( Exception e ) {
        }
    }
}
