/*
 * $COPYRIGHT$
 * $Id: TreeAnalyzer.java,v 1.9 2001/10/31 21:38:58 crow Exp $
 *
 *  Date        Author            Changes
 * JUL 27 2001  Szabo Csaba       Created
 */

package org.media.datastore.sepengine.util;

import java.io.InputStream;

import org.media.datastore.sepengine.TreeInfo;
import org.media.datastore.sepengine.LogManager;

import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.SAXParser;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
 
/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.9 $ $Date: 2001/08/21 15:00:00
 * @see java.lang.String
 * @see java.io.InputStream
 * @see org.media.datastore.sepengine.TreeInfo
 * @see org.xml.sax.HandlerBase 
 */

public class TreeAnalyzer extends DefaultHandler {
    
    private TreeInfo tInfo;
    private String   errorMsg;
    private String   parent;
    

    public TreeAnalyzer() {
    }
    
    
    protected TreeAnalyzer( TreeInfo info ) {
        tInfo    = info;
        errorMsg = null;
        parent   = "";
    }
        

    public String getErrorMSG() {
        return errorMsg;
    }
    

    public TreeInfo getTreeInfo ( InputStream src, TreeInfo info) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        DefaultHandler handler = new TreeAnalyzer ( info );
        
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(src, handler);
            return info;
        } 
        catch ( Exception _saxex ) {
            errorMsg = LogManager.getReference().getMessage("xml.parse_exception") + "\n" + _saxex.getMessage();
            LogManager.getReference().message("error","xml.parse_exception",
					      ": "+_saxex.getMessage(), "Tree Analyzer: ");
            return null;
        }
    }
    

    public void startElement(String uri, String name, String qname, Attributes attrs) throws SAXException {
        if ( attrs != null ) {
            for ( int i = 0; i < attrs.getLength(); i++ ) {
                if ( qname.equalsIgnoreCase("tree") ) {
                    if ( attrs.getQName(i).equalsIgnoreCase("action") )
                        tInfo.setAction( attrs.getValue(i) );
                    if ( attrs.getQName(i).equalsIgnoreCase("force") )
                        tInfo.setForced( (new Boolean(attrs.getValue(i))).booleanValue() );
                    if ( attrs.getQName(i).equalsIgnoreCase("long") )
                        tInfo.setLongFormat( (new Boolean(attrs.getValue(i))).booleanValue() );
                    if ( attrs.getQName(i).equalsIgnoreCase("tree") )
                        tInfo.setTreeList( (new Boolean(attrs.getValue(i))).booleanValue() );
                    if ( attrs.getQName(i).equalsIgnoreCase("recursive") )
                        tInfo.setRecursive( (new Boolean(attrs.getValue(i))).booleanValue() );
                    if ( attrs.getQName(i).equalsIgnoreCase("verbose") )
                        tInfo.setVerboseMode( (new Boolean(attrs.getValue(i))).booleanValue() );
                }
            }
        }
        parent = qname;
    }
    

    public void endElement(String uri, String name, String qname) throws SAXException  {
    }
    

    public void characters(char ch[], int start, int length) throws SAXException  {
        String str = new String(ch, start, length);
        
        if ( str.trim().length() > 0 ) {
            if ( parent.equalsIgnoreCase("subtree") )
                tInfo.setSubtreeName(str);
            if ( parent.equalsIgnoreCase("src") )
                tInfo.setSource(str);
            if ( parent.equalsIgnoreCase("dest") )
                tInfo.setDestination(str);
        }
    }

    
    public void ignorableWhitespace(char ch[], int start, int length) throws SAXException  {
        characters(ch, start, length);
    }
}                                                                                                                                                       
