/*
 * $COPYRIGHT$
 * $Id: UserAnalyzer.java,v 1.10 2001/10/31 21:38:58 crow Exp $
 *
 *  Date        Author            Changes
 * JUL 12 2001  Szabo Csaba       Created
 */

package org.media.datastore.sepengine.util;

import java.io.InputStream;
import java.util.Vector;

import org.media.datastore.sepengine.UserInfo;
import org.media.datastore.sepengine.LogManager;

import javax.xml.parsers.SAXParserFactory;
import javax.xml.parsers.SAXParser;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException; 

/**
 * @author <a href="mailto:crow@nolimits.ro">Szabo Csaba </a>
 * @version $Revision: 1.10 $ $Date: 2001/08/21 15:00:00
 * @see java.lang.String
 * @see java.io.InputStream
 * @see org.media.datastore.sepengine.UserInfo
 * @see org.xml.sax.HandlerBase
 */
      
public class UserAnalyzer extends DefaultHandler {
    
    private UserInfo userInfo;
    private String   errorMsg;
    private String   parent;
    

    public UserAnalyzer( ) {
    }
    
    
    protected UserAnalyzer( UserInfo info ) {
        userInfo = info;
        errorMsg = null;
        parent   = "";
    }

        
    public String getErrorMSG() {
        return errorMsg;
    }

    
    public UserInfo getUserInfo ( InputStream src, UserInfo info ) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        DefaultHandler handler = new UserAnalyzer ( info );
        
        try {
            SAXParser parser = factory.newSAXParser();
            parser.parse(src, handler);
            return info;
        } 
        catch ( Exception _saxex ) {
            errorMsg = LogManager.getReference().getMessage("xml.parse_exception") + "\n" + _saxex.getMessage();
            LogManager.getReference().message("error","xml.parse_exception",
					      ": "+_saxex.getMessage(), "User Analyzer: ");

            return null;
        }
    }
    

    public void startElement(String uri, String name, String qname, Attributes attrs) throws SAXException {
        if ( attrs != null ) {
            for ( int i = 0; i < attrs.getLength(); i++ ) {
                if ( parent.equalsIgnoreCase("groups") )
                    userInfo.addGroup( attrs.getValue(i) );
                if ( qname.equalsIgnoreCase("user") )
                    userInfo.setAction(attrs.getValue(i) );
            }
        }
        if ( !parent.equalsIgnoreCase("groups") ) parent = qname;
    }

    
    public void endElement(String uri, String name, String qname) throws SAXException {
    }
    

    public void characters(char ch[], int start, int length) throws SAXException {
        String str = new String(ch, start, length);
        if ( str.trim().length() > 0 ) {
            if ( parent.equalsIgnoreCase("username") )
                userInfo.setUsername(str);
            if ( parent.equalsIgnoreCase("loginname") )
                userInfo.setLoginname(str);
            if ( parent.equalsIgnoreCase("password") )
                userInfo.setPassword(str);
            if ( parent.equalsIgnoreCase("homedir") )
                userInfo.setHomedir(str);
            if ( parent.equalsIgnoreCase("group") )
                userInfo.setInitialgroup(str);
        }
    }

    
    public void ignorableWhitespace(char ch[], int start, int length) throws SAXException {
        characters(ch, start, length);
    }
}                                                                                                                                                       
